      SUBROUTINE OUCARD
C***********************************************************************
C                 OUCARD Module of ISC Model
C
C        PURPOSE: To process OUtput Pathway card images
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To add subroutine call for TOXXFILE option - 9/29/92
C
C        INPUTS:  Pathway (OU) and Keyword
C
C        OUTPUTS: Output Option Switches
C                 Output Setup Status Switches
C
C        CALLED FROM:   SETUP
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'OUCARD'

      IF (KEYWRD .EQ. 'STARTING') THEN
C        Set Status Switch
         IOSTAT(1) = IOSTAT(1) + 1
      ELSE IF (KEYWRD .EQ. 'RECTABLE') THEN
         IF (IOSTAT(2) .NE. 0) THEN
C           WRITE Error Message:  Duplicate Non-Repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process High Value Output Option                ---   CALL OURECP
            CALL OURECP
         END IF
C        Set Status Switch
         IOSTAT(2) = IOSTAT(2) + 1
      ELSE IF (KEYWRD .EQ. 'MAXTABLE') THEN
         IF (IOSTAT(3) .NE. 0) THEN
C           WRITE Error Message:  Duplicate Non-Repeatable Keyword
            CALL ERRHDL(PATH,MODNAM,'E','135',KEYWRD)
         ELSE
C           Process Maximum Value Option                    ---   CALL OUMXVL
            CALL OUMXVL
         END IF
         IOSTAT(3) = IOSTAT(3) + 1
      ELSE IF (KEYWRD .EQ. 'PLOTFILE') THEN
C        Process Plotting File Output Option                ---   CALL OUPLOT
         CALL OUPLOT
C        Set Status Switch
         IOSTAT(4) = IOSTAT(4) + 1
      ELSE IF (KEYWRD .EQ. 'TOXXFILE') THEN
C        Process TOXXFILE Output Option                     ---   CALL OUTOXX
         CALL OUTOXX
C        Set Status Switch
         IOSTAT(5) = IOSTAT(5) + 1
      ELSE IF (KEYWRD .EQ. 'FINISHED') THEN
C        Check If Missing Mandantory Keyword
         IF (IOSTAT(1) .EQ. 0) THEN
            CALL ERRHDL(PATH,MODNAM,'E','130','STARTING')
         END IF
C        Set Status Switch
         IOSTAT(20) = IOSTAT(20) + 1

      ELSE
C        Write Error Message:  Invalid Keyword for This Pathway
         CALL ERRHDL(PATH,MODNAM,'E','110',KEYWRD)
      END IF

      RETURN
      END

      SUBROUTINE OURECP
C***********************************************************************
C                 OURECP Module of ISC Model
C
C        PURPOSE: To Process Values-by-Receptor Output Selections
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Parameters
C
C        OUTPUTS: Output Option Switches
C
C        CALLED FROM:   OUCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'OURECP'

C     Check If Enough Field
      IF (IFC .EQ. 2) THEN
C        Error Message: No Field
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 4) THEN
C        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     Retrieve Output by Receptor Options
      DO 20 I = 3, IFC
         IF (FIELD(I) .EQ. 'SRCGRP') THEN
C           Go For All Source Groups
            RSCGRP = .TRUE.
         ELSE IF (FIELD(I) .EQ. 'INDSRC') THEN
C           Go For All Individual Sources
            RINDSC = .TRUE.
         ELSE
C           Error Message: Invalid Data Field
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
            GO TO 999
         END IF
  20  CONTINUE

 999  RETURN
      END

      SUBROUTINE OUMXVL
C***********************************************************************
C                 OUMXVL Module of ISC Model
C
C        PURPOSE: To Process Maximum Value Output Selections
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Parameters
C
C        OUTPUTS: Output Option Switches
C
C        CALLED FROM:   OUCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'

C     Variable Initializations
      MODNAM = 'OUMXVL'

C     Check If Enough Field
      IF (IFC .EQ. 2) THEN
C        Error Message: No Field
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 6) THEN
C        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     Retrieve Averaging Period
      CALL STONUM(FIELD(3),40,FNUM,IMIT)
      IF (IMIT .NE. 1) THEN
C        Write Error Message:Invalid Numerical Field
         CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
         GO TO 999
      END IF

      NUMMAX = INT(FNUM)

C     Check the Value Input for NUMMAX Against Parameter NMAX
      IF (NUMMAX .GT. NMAX) THEN
C        WRITE Error Message: NUMMAX Too Large
         WRITE(DUMMY,'(I8)') NMAX
         CALL ERRHDL(PATH,MODNAM,'E','280',DUMMY)
      END IF

C     Retrieve Maximum Value Output Options
      DO 20 I = 4, IFC
         IF (FIELD(I) .EQ. 'SRCGRP') THEN
C           Go For Source Group Maxima
            MSCGRP = .TRUE.
         ELSE IF (FIELD(I) .EQ. 'INDSRC') THEN
C           Go For Individual Source Maxima
            MINDSC = .TRUE.
         ELSE IF (FIELD(I) .EQ. 'SOCONT') THEN
C           Go For Source Contributions to Group Maxima
            SOCONT = .TRUE.
         ELSE
C           Error Message: Invalid Data Field
            CALL ERRHDL(PATH,MODNAM,'E','203',KEYWRD)
            GO TO 999
         END IF
  20  CONTINUE

C     Set Logical Switch to Controlling Sorting of Values
      SORT = .TRUE.

 999  RETURN
      END

      SUBROUTINE OUPLOT
C***********************************************************************
C                 OUPLOT Module of ISC Model - Long Term
C
C        PURPOSE: To Process Plot File Output Selections
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Parameters
C
C        OUTPUTS: Output Option Switches
C
C        CALLED FROM:   OUCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      CHARACTER INAVE*6, INPGRP*8
      LOGICAL FOUND

C     Variable Initializations
      MODNAM = 'OUPLOT'

C     Check If Enough Field
      IF (IFC .EQ. 2) THEN
C        Error Message: No Fields
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .LT. 5) THEN
C        Error Message: Not Enough Fields
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 6) THEN
C        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     Retrieve Averaging Period
      IF (FIELD(3) .EQ. 'PERIOD' .AND. PERIOD) THEN
C        Plot File is for PERIOD Averages                   ---   CALL PERPLT
         CALL PERPLT
C        Exit to End
         GO TO 999
      ELSE IF (FIELD(3) .EQ. 'PERIOD') THEN
C        Period Plot File Selected But No PERIOD Averages Calculated
C        WRITE Error Message: Invalid Averaging Period Selected for PLOTFILE
         CALL ERRHDL(PATH,MODNAM,'E','203',' AVEPER ')
         GO TO 999
      ELSE
         INAVE = FIELD(3)
      END IF

C     Check Averaging Period Against AVEPER Array
      FOUND = .FALSE.
      J = 0
      DO WHILE (.NOT.FOUND .AND. J.LE.NAVE)
         J = J + 1
         IF (INAVE .EQ. AVEPER(J) .AND. KAVE(J) .EQ. 1) THEN
            FOUND = .TRUE.
            INDAVE = J
         END IF
      END DO
      IF (.NOT. FOUND) THEN
C        Error Message:E203 KAVE Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
         GO TO 999
      END IF

C     Retrieve Source Group ID
      INPGRP = FIELD(4)
C     Check Source Group ID
      FOUND = .FALSE.
      J = 1
      DO WHILE (.NOT.FOUND .AND. J.LE.NUMGRP)
         IF (INPGRP .EQ. GRPID(J)) THEN
            FOUND = .TRUE.
            INDGRP = J
         END IF
         J = J + 1
      END DO
      IF (.NOT. FOUND) THEN
C        Error Message: E203 GRPID Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','GRPID')
         GO TO 999
      END IF

C     Set Switch and Check for Previous PLOTFILE Card
C     for This Averaging Period & Group ID
      IPLTFL(INDGRP,INDAVE) = IPLTFL(INDGRP,INDAVE) + 1
      IF (IPLTFL(INDGRP,INDAVE) .GT. 1) THEN
C        WRITE Error Message
         CALL ERRHDL(PATH,MODNAM,'E','211',KEYWRD)
         GO TO 999
      END IF

      IF ((LOCE(5)-LOCB(5)) .LE. 39) THEN
C        Retrieve Filename as Character Substring to Maintain Original Case
C        Also Check for Filename Larger Than 40 Characters
         PLTFIL(INDGRP,INDAVE) = RUNST1(LOCB(5):LOCE(5))
      ELSE
C        WRITE Error Message:  PLTFIL Field is Too Long
         CALL ERRHDL(PATH,MODNAM,'E','203',' FILNAM ')
      END IF

C     Retrieve File Unit If Input, or Assign File Unit and OPEN File
      IF (IFC .EQ. 6) THEN
         CALL STONUM(FIELD(6),40,FNUM,IMIT)
C        Check for Valid File Unit Value
         IF (IMIT .NE. 1) THEN
C           Write Error Message:Invalid Numerical Field
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GO TO 999
         END IF
C        Check for Conflict With System Files
         IF (FNUM .LT. 20.) THEN
C           WRITE Error Message:  Invalid File Unit Specified
            CALL ERRHDL(PATH,MODNAM,'E','560',KEYWRD)
            GO TO 999
         ELSE IF (FNUM .GT. 100) THEN
C           WRITE Warning Message:  Suspect File Unit Specified
C           Unit May Conflict With Dynamically Allocated File Units
            CALL ERRHDL(PATH,MODNAM,'W','565',KEYWRD)
            IPLUNT(INDGRP,INDAVE) = INT(FNUM)
         ELSE
            IPLUNT(INDGRP,INDAVE) = INT(FNUM)
         END IF
      ELSE
C        Dynamically Allocate File Unit (>100)
         IPLUNT(INDGRP,INDAVE) = 100 + INDAVE*10 + INDGRP
         IF (INDGRP .GE. 10) THEN
C           WRITE Warning Message: Dynamic FUnit Allocation May Have Conflict
            CALL ERRHDL(PATH,MODNAM,'W','565',KEYWRD)
         END IF
      END IF

C     Check for Earlier Use of This Filename and File Unit
      FOUND = .FALSE.
      DO 200 J = 1, NAVE
         DO 100 I = 1, NUMGRP
            IF (I .NE. INDGRP .OR. J .NE. INDAVE) THEN
               IF (PLTFIL(INDGRP,INDAVE) .EQ. PLTFIL(I,J) .AND.
     &             IPLUNT(INDGRP,INDAVE) .EQ. IPLUNT(I,J)) THEN
                  FOUND = .TRUE.
               ELSE IF (PLTFIL(INDGRP,INDAVE) .EQ. PLTFIL(I,J) .AND.
     &                  IPLUNT(INDGRP,INDAVE) .NE. IPLUNT(I,J)) THEN
C                 Write Error Message: Conflicting Inputs
                  CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
                  GO TO 999
               ELSE IF (PLTFIL(INDGRP,INDAVE) .NE. PLTFIL(I,J) .AND.
     &                  IPLUNT(INDGRP,INDAVE) .EQ. IPLUNT(I,J)) THEN
C                 Write Error Message: Conflicting Inputs
                  CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
                  GO TO 999
               END IF
            END IF
 100     CONTINUE
 200  CONTINUE

      IF (.NOT. FOUND) THEN
C        First Time File is Identified - OPEN File
         OPEN(IPLUNT(INDGRP,INDAVE),ERR=99,FILE=PLTFIL(INDGRP,INDAVE),
     &        IOSTAT=IOERRN,STATUS='UNKNOWN')
      END IF

C     Set Logical Switch Indicating That Plot File(s) Are Generated
      PLFILE = .TRUE.

      GO TO 999

C     WRITE Error Message for Error Opening File
 99   WRITE(DUMMY,'(5HPLTFL,I3.3)') IPLUNT(INDGRP,INDAVE)
      CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)

 999  RETURN
      END

      SUBROUTINE PERPLT
C***********************************************************************
C                 PERPLT Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: To Process Plot File Output Selection for PERIOD
C                 Averages
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Input Runstream Parameters
C
C        OUTPUTS: Output Option Switches
C
C        CALLED FROM:   OUPLOT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      CHARACTER INPGRP*8
      LOGICAL FOUND

C     Variable Initializations
      MODNAM = 'PERPLT'

C     Retrieve Source Group ID
      INPGRP = FIELD(4)
C     Check Source Group ID
      FOUND = .FALSE.
      J = 1
      DO WHILE (.NOT.FOUND .AND. J.LE.NUMGRP)
         IF (INPGRP .EQ. GRPID(J)) THEN
            FOUND = .TRUE.
            INDGRP = J
         END IF
         J = J + 1
      END DO
      IF (.NOT. FOUND) THEN
C        Error Message: E203 GRPID Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','GRPID')
         GO TO 999
      END IF

C     Set Switch and Check for Previous PLOTFILE Card
C     for This Averaging Period & Group ID
      IANPLT(INDGRP) = IANPLT(INDGRP) + 1
      IF (IANPLT(INDGRP) .GT. 1) THEN
C        WRITE Error Message
         CALL ERRHDL(PATH,MODNAM,'E','211',KEYWRD)
         GO TO 999
      END IF

      IF ((LOCE(5)-LOCB(5)) .LE. 39) THEN
C        Retrieve Filename as Character Substring to Maintain Original Case
C        Also Check for Filename Larger Than 40 Characters
         ANNPLT(INDGRP) = RUNST1(LOCB(5):LOCE(5))
      ELSE
C        WRITE Error Message:  ANNPLT Field is Too Long
         CALL ERRHDL(PATH,MODNAM,'E','203',' FILNAM ')
      END IF

C     Retrieve File Unit If Input, or Assign File Unit and OPEN File
      IF (IFC .EQ. 6) THEN
         CALL STONUM(FIELD(6),40,FNUM,IMIT)
C        Check for Valid Threshold Value
         IF (IMIT .NE. 1) THEN
C           Write Error Message: Invalid Numerical Field
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GO TO 999
         END IF
C        Check for Conflict With System Files
         IF (FNUM .LT. 20.) THEN
C           WRITE Error Message: Invalid File Unit Specified
            CALL ERRHDL(PATH,MODNAM,'E','560',KEYWRD)
            GO TO 999
         ELSE IF (FNUM .GT. 100) THEN
C           WRITE Warning Message:  Suspect File Unit Specified
C           Unit May Conflict With Dynamically Allocated File Units
            CALL ERRHDL(PATH,MODNAM,'W','565',KEYWRD)
            IPPUNT(INDGRP) = INT(FNUM)
         ELSE
            IPPUNT(INDGRP) = INT(FNUM)
         END IF
      ELSE
C        Dynamically Allocate File Unit (300's)
         IPPUNT(INDGRP) = 300 + INDGRP*10
      END IF
C     Check for Earlier Use of This Filename and File Unit
      FOUND = .FALSE.
      DO 100 I = 1, NUMGRP
         IF (I .NE. INDGRP) THEN
            IF (ANNPLT(INDGRP) .EQ. ANNPLT(I) .AND.
     &          IPPUNT(INDGRP) .EQ. IPPUNT(I)) THEN
              FOUND = .TRUE.
            ELSE IF (ANNPLT(INDGRP) .EQ. ANNPLT(I) .AND.
     &               IPPUNT(INDGRP) .NE. IPPUNT(I)) THEN
C             Write Error Message: Conflicting Inputs
              CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
              GO TO 999
            ELSE IF (ANNPLT(INDGRP) .NE. ANNPLT(I) .AND.
     &               IPPUNT(INDGRP) .EQ. IPPUNT(I)) THEN
C             Write Error Message: Conflicting Inputs
              CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
              GO TO 999
            END IF
         END IF
 100  CONTINUE

C     Check Against PLOTFILEs for Short Term Averages
      DO 400 J = 1, NUMAVE
         DO 300 I = 1, NUMGRP
            IF (ANNPLT(INDGRP) .EQ. PLTFIL(I,J) .AND.
     &          IPPUNT(INDGRP) .EQ. IPLUNT(I,J)) THEN
               FOUND = .TRUE.
            ELSE IF (ANNPLT(INDGRP) .EQ. PLTFIL(I,J) .AND.
     &               IPPUNT(INDGRP) .NE. IPLUNT(I,J)) THEN
C              Write Error Message: Conflicting Inputs
               CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
               GO TO 999
            ELSE IF (ANNPLT(INDGRP) .NE. PLTFIL(I,J) .AND.
     &               IPPUNT(INDGRP) .EQ. IPLUNT(I,J)) THEN
C              Write Error Message: Conflicting Inputs
               CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
               GO TO 999
            END IF
 300     CONTINUE
 400  CONTINUE

      IF (.NOT. FOUND) THEN
C        First Time File is Identified - OPEN File
         OPEN(IPPUNT(INDGRP),ERR=99,FILE=ANNPLT(INDGRP),
     &        IOSTAT=IOERRN,STATUS='UNKNOWN')
      END IF

C     Set Logical Switch Indicating That Plot File(s) Are Generated
      ANPLOT = .TRUE.

      GO TO 999

C     WRITE Error Message for Error Opening File
 99   WRITE(DUMMY,'(5HPLTFL,I3.3)') IPPUNT(INDGRP)
      CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)

 999  RETURN
      END

      SUBROUTINE OUTOXX
C***********************************************************************
C                 OUTOXX Module of ISC2 Short Term Model - ISCLT2
C
C        PURPOSE: To Process TOXXFILE Output Selections
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 29, 1992
C
C        INPUTS:  Input Runstream Parameters
C
C        OUTPUTS: Output Option Switches
C
C        CALLED FROM:   OUCARD
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      CHARACTER INAVE*6, INPGRP*8
      LOGICAL FOUND

C     Variable Initializations
      MODNAM = 'OUTOXX'

C     Check If Enough Field
      IF (IFC .EQ. 2) THEN
C        Error Message: No Fields
         CALL ERRHDL(PATH,MODNAM,'E','200',KEYWRD)
         GO TO 999
      ELSE IF (IFC .LT. 5) THEN
C        Error Message: Not Enough Fields
         CALL ERRHDL(PATH,MODNAM,'E','201',KEYWRD)
         GO TO 999
      ELSE IF (IFC .GT. 6) THEN
C        Error Message: Too Many Fields
         CALL ERRHDL(PATH,MODNAM,'E','202',KEYWRD)
         GO TO 999
      END IF

C     Retrieve Averaging Period
      IF (FIELD(3) .EQ. 'PERIOD' .AND. PERIOD) THEN
C        TOXX-FILE is for PERIOD Averages                   ---   CALL PERTOX
         CALL PERTOX
C        Exit to End
         GO TO 999
      ELSE IF (FIELD(3) .EQ. 'PERIOD') THEN
C        Period TOXX-FILE Selected But No PERIOD Averages Calculated
C        WRITE Error Message: Invalid Averaging Period Selected for TOXXFILE
         CALL ERRHDL(PATH,MODNAM,'E','203',' AVEPER ')
         GO TO 999
      ELSE
         INAVE = FIELD(3)
      END IF

C     Check Averaging Period Against AVEPER Array
      FOUND = .FALSE.
      J = 0
      DO WHILE (.NOT.FOUND .AND. J.LE.NAVE)
         J = J + 1
         IF (INAVE .EQ. AVEPER(J) .AND. KAVE(J) .EQ. 1) THEN
            FOUND = .TRUE.
            INDAVE = J
         END IF
      END DO
      IF (.NOT. FOUND) THEN
C        Error Message:E203 KAVE Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','AVEPER')
         GO TO 999
      END IF

C     Retrieve Source Group ID
      INPGRP = FIELD(4)
C     Check Source Group ID
      FOUND = .FALSE.
      J = 1
      DO WHILE (.NOT.FOUND .AND. J.LE.NUMGRP)
         IF (INPGRP .EQ. GRPID(J)) THEN
            FOUND = .TRUE.
            INDGRP = J
         END IF
         J = J + 1
      END DO
      IF (.NOT. FOUND) THEN
C        Error Message: E203 GRPID Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','GRPID')
         GO TO 999
      END IF

C     Set Switch and Check for Previous TOXXFILE Card
C     for This Averaging Period & Group ID
      ITOXFL(INDGRP,INDAVE) = ITOXFL(INDGRP,INDAVE) + 1
      IF (ITOXFL(INDGRP,INDAVE) .GT. 1) THEN
C        WRITE Error Message
         CALL ERRHDL(PATH,MODNAM,'E','211',KEYWRD)
         GO TO 999
      END IF

      IF ((LOCE(5)-LOCB(5)) .LE. 39) THEN
C        Retrieve Filename as Character Substring to Maintain Original Case
C        Also Check for Filename Larger Than 40 Characters
         TOXFIL(INDGRP,INDAVE) = RUNST1(LOCB(5):LOCE(5))
      ELSE
C        WRITE Error Message:  TOXFIL Field is Too Long
         CALL ERRHDL(PATH,MODNAM,'E','203',' FILNAM ')
      END IF

C     Retrieve File Unit If Input, or Assign File Unit and OPEN File
      IF (IFC .EQ. 6) THEN
         CALL STONUM(FIELD(6),40,FNUM,IMIT)
C        Check for Valid File Unit Value
         IF (IMIT .NE. 1) THEN
C           Write Error Message:Invalid Numerical Field
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GO TO 999
         END IF
C        Check for Conflict With System Files
         IF (FNUM .LT. 20.) THEN
C           WRITE Error Message:  Invalid File Unit Specified
            CALL ERRHDL(PATH,MODNAM,'E','560',KEYWRD)
            GO TO 999
         ELSE IF (FNUM .GT. 100) THEN
C           WRITE Warning Message:  Suspect File Unit Specified
C           Unit May Conflict With Dynamically Allocated File Units
            CALL ERRHDL(PATH,MODNAM,'W','565',KEYWRD)
            ITXUNT(INDGRP,INDAVE) = INT(FNUM)
         ELSE
            ITXUNT(INDGRP,INDAVE) = INT(FNUM)
         END IF
      ELSE
C        Dynamically Allocate File Unit (>500)
         ITXUNT(INDGRP,INDAVE) = 500 + INDAVE*10 + INDGRP
         IF (INDGRP .GE. 10) THEN
C           WRITE Warning Message: Dynamic FUnit Allocation May Have Conflict
            CALL ERRHDL(PATH,MODNAM,'W','565',KEYWRD)
         END IF
      END IF

C     Check for Earlier Use of This Filename and File Unit
      FOUND = .FALSE.
      DO 200 J = 1, NAVE
         DO 100 I = 1, NUMGRP
            IF (I .NE. INDGRP .OR. J .NE. INDAVE) THEN
               IF (TOXFIL(INDGRP,INDAVE) .EQ. TOXFIL(I,J) .AND.
     &             ITXUNT(INDGRP,INDAVE) .EQ. ITXUNT(I,J)) THEN
                  FOUND = .TRUE.
               ELSE IF (TOXFIL(INDGRP,INDAVE) .EQ. TOXFIL(I,J) .AND.
     &                  ITXUNT(INDGRP,INDAVE) .NE. ITXUNT(I,J)) THEN
C                 Write Error Message: Conflicting Inputs
                  CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
                  GO TO 999
               ELSE IF (TOXFIL(INDGRP,INDAVE) .NE. TOXFIL(I,J) .AND.
     &                  ITXUNT(INDGRP,INDAVE) .EQ. ITXUNT(I,J)) THEN
C                 Write Error Message: Conflicting Inputs
                  CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
                  GO TO 999
               END IF
            END IF
 100     CONTINUE
 200  CONTINUE

      IF (.NOT. FOUND) THEN
C        First Time File is Identified - OPEN File
         OPEN(ITXUNT(INDGRP,INDAVE),ERR=99,FILE=TOXFIL(INDGRP,INDAVE),
     &        IOSTAT=IOERRN,STATUS='UNKNOWN')
      END IF

C     Set Logical Switch Indicating That TOXXFILE(s) Are Generated
      TXFILE = .TRUE.

      GO TO 999

C     WRITE Error Message for Error Opening File
 99   WRITE(DUMMY,'(5HTOXFL,I3.3)') ITXUNT(INDGRP,INDAVE)
      CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)

 999  RETURN
      END

      SUBROUTINE PERTOX
C***********************************************************************
C                 PERTOX Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: To Process TOXXFILE Output Selection for PERIOD
C                 Averages
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 29, 1992
C
C        INPUTS:  Input Runstream Parameters
C
C        OUTPUTS: Output Option Switches
C
C        CALLED FROM:   OUTOXX
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      CHARACTER INPGRP*8
      LOGICAL FOUND

C     Variable Initializations
      MODNAM = 'PERTOX'

C     Retrieve Source Group ID
      INPGRP = FIELD(4)
C     Check Source Group ID
      FOUND = .FALSE.
      J = 1
      DO WHILE (.NOT.FOUND .AND. J.LE.NUMGRP)
         IF (INPGRP .EQ. GRPID(J)) THEN
            FOUND = .TRUE.
            INDGRP = J
         END IF
         J = J + 1
      END DO
      IF (.NOT. FOUND) THEN
C        Error Message: E203 GRPID Not Match With Pre-Defined One
         CALL ERRHDL(PATH,MODNAM,'E','203','GRPID')
         GO TO 999
      END IF

C     Set Switch and Check for Previous TOXXFILE Card
C     for This Group ID
      IANTOX(INDGRP) = IANTOX(INDGRP) + 1
      IF (IANTOX(INDGRP) .GT. 1) THEN
C        WRITE Error Message
         CALL ERRHDL(PATH,MODNAM,'E','211',KEYWRD)
         GO TO 999
      END IF

      IF ((LOCE(5)-LOCB(5)) .LE. 39) THEN
C        Retrieve Filename as Character Substring to Maintain Original Case
C        Also Check for Filename Larger Than 40 Characters
         ANNTOX(INDGRP) = RUNST1(LOCB(5):LOCE(5))
      ELSE
C        WRITE Error Message:  ANNTOX Field is Too Long
         CALL ERRHDL(PATH,MODNAM,'E','203',' FILNAM ')
      END IF

C     Retrieve File Unit If Input, or Assign File Unit and OPEN File
      IF (IFC .EQ. 6) THEN
         CALL STONUM(FIELD(6),40,FNUM,IMIT)
C        Check for Valid Threshold Value
         IF (IMIT .NE. 1) THEN
C           Write Error Message: Invalid Numerical Field
            CALL ERRHDL(PATH,MODNAM,'E','208',KEYWRD)
            GO TO 999
         END IF
C        Check for Conflict With System Files
         IF (FNUM .LT. 20.) THEN
C           WRITE Error Message: Invalid File Unit Specified
            CALL ERRHDL(PATH,MODNAM,'E','560',KEYWRD)
            GO TO 999
         ELSE IF (FNUM .GT. 100) THEN
C           WRITE Warning Message:  Suspect File Unit Specified
C           Unit May Conflict With Dynamically Allocated File Units
            CALL ERRHDL(PATH,MODNAM,'W','565',KEYWRD)
            IPXUNT(INDGRP) = INT(FNUM)
         ELSE
            IPXUNT(INDGRP) = INT(FNUM)
         END IF
      ELSE
C        Dynamically Allocate File Unit (700's)
         IPXUNT(INDGRP) = 700 + INDGRP*10
      END IF
C     Check for Earlier Use of This Filename and File Unit
      FOUND = .FALSE.
      DO 100 I = 1, NUMGRP
         IF (I .NE. INDGRP) THEN
            IF (ANNTOX(INDGRP) .EQ. ANNTOX(I) .AND.
     &          IPXUNT(INDGRP) .EQ. IPXUNT(I)) THEN
              FOUND = .TRUE.
            ELSE IF (ANNTOX(INDGRP) .EQ. ANNTOX(I) .AND.
     &               IPXUNT(INDGRP) .NE. IPXUNT(I)) THEN
C             Write Error Message: Conflicting Inputs
              CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
              GO TO 999
            ELSE IF (ANNTOX(INDGRP) .NE. ANNTOX(I) .AND.
     &               IPXUNT(INDGRP) .EQ. IPXUNT(I)) THEN
C             Write Error Message: Conflicting Inputs
              CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
              GO TO 999
            END IF
         END IF
 100  CONTINUE

C     Check Against TOXXFILEs for Short Term Averages
      DO 400 J = 1, NUMAVE
         DO 300 I = 1, NUMGRP
            IF (ANNTOX(INDGRP) .EQ. TOXFIL(I,J) .AND.
     &          IPXUNT(INDGRP) .EQ. ITXUNT(I,J)) THEN
               FOUND = .TRUE.
            ELSE IF (ANNTOX(INDGRP) .EQ. TOXFIL(I,J) .AND.
     &               IPXUNT(INDGRP) .NE. ITXUNT(I,J)) THEN
C              Write Error Message: Conflicting Inputs
               CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
               GO TO 999
            ELSE IF (ANNTOX(INDGRP) .NE. TOXFIL(I,J) .AND.
     &               IPXUNT(INDGRP) .EQ. ITXUNT(I,J)) THEN
C              Write Error Message: Conflicting Inputs
               CALL ERRHDL(PATH,MODNAM,'E','550',KEYWRD)
               GO TO 999
            END IF
 300     CONTINUE
 400  CONTINUE

      IF (.NOT. FOUND) THEN
C        First Time File is Identified - OPEN File
         OPEN(IPXUNT(INDGRP),ERR=99,FILE=ANNTOX(INDGRP),
     &        IOSTAT=IOERRN,STATUS='UNKNOWN')
      END IF

C     Set Logical Switch Indicating That PERIOD TOXXFILE(s) Are Generated
      ANTOXX = .TRUE.

      GO TO 999

C     WRITE Error Message for Error Opening File
 99   WRITE(DUMMY,'(5HTOXFL,I3.3)') IPXUNT(INDGRP)
      CALL ERRHDL(PATH,MODNAM,'E','500',DUMMY)

 999  RETURN
      END
