      SUBROUTINE LTOUT(SEACHR)
C***********************************************************************
C                 LTOUT Module of ISC Model
C
C        PURPOSE: Output of Printed Model Results by Receptors
C
C        PROGRAMMER: JEFF WANG, ROGER BRODE
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTPER, LTMSA
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER SEACHR*6

C     Variable Initializations
      MODNAM = 'LTOUT'

C     Print Out RECTABLE Keyword Options
      IF (RINDSC) THEN
C        Print Results By Receptor And Individual Source    ---   CALL SPRTLT
         CALL SPRTLT(SEACHR)
      END IF
      IF (RSCGRP) THEN
C        Print Results By Receptor And Source Group         ---   CALL GPRTLT
         CALL GPRTLT(SEACHR)
      END IF

C     Print Out MAXTABLE Keyword Options
      IF (MINDSC) THEN
C        Print Individual Source Maximum Values             ---   CALL SLTMAX
         CALL SLTMAX(SEACHR)
      END IF
      IF (MSCGRP) THEN
C        Print Source Group Array for Maximum Values        ---   CALL GLTMAX
         CALL GLTMAX(SEACHR)
      END IF
      IF (SOCONT) THEN
C        Print Ind. Source Contributions for Group Max.    ---    CALL CLTMAX
         CALL CLTMAX(SEACHR)
      END IF

      RETURN
      END

      SUBROUTINE SPRTLT(SEACHR)
C***********************************************************************
C                 SPRTLT Module of ISC Model
C
C        PURPOSE: Print Out The Model Result Values by Source
C
C        PROGRAMMER: ROGER BRODE, JEFF WANG
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To adjust format statement 9082 for BOUNDARY receptors
C                    to better accommodate UTM coordinates - 9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTOUT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER SEACHR*6, BUF132*132

C     Variable Initializations
      MODNAM = 'SPRTLT'

      DO 1000 ISRC = 1, NUMSRC

C        Print Receptor Network Coordinates.
C        Set Number of Columns Per Page, NCPP
         NCPP = 9
C        Set Number of Rows Per Page, NRPP
         NRPP = 40
C        Begin LOOP Through Networks
         DO 50 I = 1, INNET
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO 40 NX = 1, NPPX
               DO 30 NY = 1, NPPY
                  CALL HEADER
                  WRITE(IOUNIT,9032) SEACHR, (CHIDEP(II),II=1,6),
     &                  SRCID(ISRC)
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
C                 Print The Values By Source Group
                  WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO 20 K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (SRCVAL(INDZ+J-1,ISRC),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (SRCVAL(INDZ+J-1,ISRC),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
 20                  CONTINUE
                  ELSE
                     DO 25 K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (SRCVAL(INDZ+J-1,ISRC),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (SRCVAL(INDZ+J-1,ISRC),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
 25                  CONTINUE
                  END IF
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE

         IF (IRSTAT(4) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Cart Receptors
            INDC = 0
            DO 1030 IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DC') THEN
                  INDC = INDC + 1
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) SEACHR,(CHIDEP(II),
     &                 II=1,6),SRCID(ISRC)
                     WRITE(IOUNIT,9043)
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                     WRITE(IOUNIT,9048) CHIDEP(3), CHIDEP(3)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:60),9045) AXR(IREC), AYR(IREC),
     &                     SRCVAL(IREC,ISRC)
                  ELSE
                     WRITE(BUF132(61:120),9045) AXR(IREC), AYR(IREC),
     &                     SRCVAL(IREC,ISRC)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
 1030       CONTINUE
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(5) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Polar Receptors
            INDC = 0
            DO 1040 IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DP') THEN
                  INDC = INDC + 1
                  XRMS = AXR(IREC) - AXS(IREF(IREC))
                  YRMS = AYR(IREC) - AYS(IREF(IREC))
                  DIST = SQRT(XRMS*XRMS + YRMS*YRMS)
                  DIR  = ATAN2(XRMS, YRMS) * RTODEG
                  IF (DIR .LE. 0.0) DIR = DIR + 360.
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) SEACHR,(CHIDEP(II),
     &                 II=1,6),SRCID(ISRC)
                     WRITE(IOUNIT,9044)
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                     WRITE(IOUNIT,9049) CHIDEP(3), CHIDEP(3)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:65),9047) SRCID(IREF(IREC)), DIST,
     &                                        DIR, SRCVAL(IREC,ISRC)
                  ELSE
                     WRITE(BUF132(66:130),9047) SRCID(IREF(IREC)), DIST,
     &                                          DIR, SRCVAL(IREC,ISRC)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
 1040       CONTINUE
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(6) .NE. 0) THEN
C           Write Out The Boundary Receptors For The Sources
            INDC = 0
            IREC = 1
            DO WHILE (IREC .LE. NUMREC)
               IF (RECTYP(IREC) .EQ. 'BD') THEN
                  INDC = INDC + 1
                  ISRF = IREF(IREC)
                  IF (MOD(INDC-1,3) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) SEACHR,(CHIDEP(II),
     &               II=1,6),SRCID(ISRC)
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                  END IF
                  WRITE(IOUNIT,9082) SRCID(ISRF), SRCTYP(ISRF),
     &                AXS(ISRF), AYS(ISRF), AZS(ISRF), CHIDEP(3),
     &                CHIDEP(3), CHIDEP(3), (J, AXR(IREC+J-1),
     &                AYR(IREC+J-1), SRCVAL(IREC+J-1,ISRC),J=1,36)
                  IREC = IREC + 36
               ELSE
                  IREC = IREC + 1
               END IF
            END DO
         END IF

 1000 CONTINUE

 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9010 FORMAT(66(' -')/)
 9013 FORMAT(2X,F10.2,1X,'|',1X,9(F13.6))
 9016 FORMAT(3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT(3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT(3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT(3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9032 FORMAT(30X,'*** THE ',A6,1X,6A4,
     &       'VALUES FOR SOURCE: ',A8,' ***')
 9037 FORMAT(/35X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',
     &       A8,' ***')
 9043 FORMAT(/45X,'*** DISCRETE CARTESIAN RECEPTOR POINTS ***')
 9044 FORMAT(/47X,'*** DISCRETE POLAR RECEPTOR POINTS ***')
 9045 FORMAT(6X,2(F12.2,2X),F14.6)
 9047 FORMAT(4X,A8,': ',2(F12.2,2X),F14.6)
 9048 FORMAT(6X,' X-COORD (M)   Y-COORD (M)         ',A4,
     &      22X,' X-COORD (M)   Y-COORD (M)         ',A4,/65(' -'))
 9049 FORMAT(5X,'ORIGIN',59X,'ORIGIN',
     &      /5X,' SRCID       DIST (M)     DIR (DEG)         ',A4,
     &      18X,' SRCID       DIST (M)     DIR (DEG)         ',A4,
     &      /65(' -'))
 9082 FORMAT(' BOUNDARY RECEPTOR NETWORK OF SOURCE ID: ',A8,/,5X,
     &       ' OF SOURCE TYPE: ',A8,'; WITH ORIGIN AT (',2(F10.2,', '),
     &       F10.2,')'/3(' (SEC.)  X-COORD    Y-COORD        ',A4,6X),/,
     &       12(3(1X,I4,2X,F9.1,',',F10.1,',',F14.6,' ',2X),/),/)
 9090 FORMAT(A132)
 9095 FORMAT(132(' '))

      RETURN
      END

      SUBROUTINE GPRTLT(SEACHR)
C***********************************************************************
C                 GPRTLT Module of ISC Model
C
C        PURPOSE: Print Out The Model Result Values by Group
C
C        PROGRAMMER: ROGER BRODE, JEFF WANG
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To adjust format statement 9082 for BOUNDARY receptors
C                    to better accommodate UTM coordinates - 9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTOUT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER SEACHR*6, BUF132*132

C     Variable Initializations
      MODNAM = 'GPRTLT'

      DO 1000 IGRP = 1, NUMGRP

C        Fill Work Array With SRCIDs For This Group
         INDGRP = 0
         DO 210 ISRC = 1, NUMSRC
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               INDGRP = INDGRP + 1
               WORKID(INDGRP) = SRCID(ISRC)
            END IF
 210     CONTINUE
C        Check for More Than 31 Sources Per Group
         IF (INDGRP .GT. 31) THEN
            WORKID(31) = ' . . . '
            INDGRP = 31
         END IF

C        Print Receptor Network Coordinates.
C        Set Number of Columns Per Page, NCPP
         NCPP = 9
C        Set Number of Rows Per Page, NRPP
         NRPP = 40
C        Begin LOOP Through Networks
         DO 50 I = 1, INNET
C           Calculate Number of Pages Per X-Group, NPPX, & Per Y-Group, NPPY
            NPPX = 1 + INT((NUMXPT(I)-1)/NCPP)
            NPPY = 1 + INT((NUMYPT(I)-1)/NRPP)
            DO 40 NX = 1, NPPX
               DO 30 NY = 1, NPPY
                  CALL HEADER
                  WRITE(IOUNIT,9032) SEACHR, (CHIDEP(II),II=1,6),
     &                  GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                  WRITE(IOUNIT,9037) NTID(I), NTTYP(I)
C                 Print The Values By Source Group
                  WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                  IF (NX .EQ. NPPX) THEN
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NUMXPT(I))
                     END IF
                  ELSE
                     IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                        WRITE(IOUNIT,9016)
                        WRITE(IOUNIT,9017) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                        WRITE(IOUNIT,9018)
                        WRITE(IOUNIT,9019) (XCOORD(J,I),J=1+NCPP*(NX-1),
     &                                                    NCPP*NX)
                     END IF
                  END IF
                  WRITE(IOUNIT,9010)
                  IF (NY .EQ. NPPY) THEN
                     DO 20 K = 1+NRPP*(NY-1), NUMYPT(I)
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (GRPVAL(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (GRPVAL(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
 20                  CONTINUE
                  ELSE
                     DO 25 K = 1+NRPP*(NY-1), NRPP*NY
                        IF (NTTYP(I) .EQ. 'GRIDCART') THEN
                           INDZ = NETEND(I) - K*NUMXPT(I) + 1
                           YCOVAL = YCOORD(NUMYPT(I)-K+1,I)
                        ELSE IF (NTTYP(I) .EQ. 'GRIDPOLR') THEN
                           INDZ = NETSTA(I) + (K-1)*NUMXPT(I)
                           YCOVAL = YCOORD(K,I)
                        END IF
                        IF (NX .EQ. NPPX) THEN
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (GRPVAL(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NUMXPT(I))
                        ELSE
                           WRITE(IOUNIT,9013) YCOVAL,
     &                 (GRPVAL(INDZ+J-1,IGRP),J=1+NCPP*(NX-1),NCPP*NX)
                        END IF
 25                  CONTINUE
                  END IF
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE

         IF (IRSTAT(4) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Cart Receptors
            INDC = 0
            DO 1030 IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DC') THEN
                  INDC = INDC + 1
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) SEACHR,(CHIDEP(II),
     &                 II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     WRITE(IOUNIT,9043)
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                     WRITE(IOUNIT,9048) CHIDEP(3), CHIDEP(3)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:60),9045) AXR(IREC), AYR(IREC),
     &                     GRPVAL(IREC,IGRP)
                  ELSE
                     WRITE(BUF132(61:120),9045) AXR(IREC), AYR(IREC),
     &                     GRPVAL(IREC,IGRP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
 1030       CONTINUE
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(5) .NE. 0) THEN
C           Print Out The Coord. & Concentrations For Discrete Polar Receptors
            INDC = 0
            DO 1040 IREC = 1, NUMREC
               IF (RECTYP(IREC) .EQ. 'DP') THEN
                  INDC = INDC + 1
                  XRMS = AXR(IREC) - AXS(IREF(IREC))
                  YRMS = AYR(IREC) - AYS(IREF(IREC))
                  DIST = SQRT(XRMS*XRMS + YRMS*YRMS)
                  DIR  = ATAN2(XRMS, YRMS) * RTODEG
                  IF (DIR .LE. 0.0) DIR = DIR + 360.
                  IF (MOD(INDC-1,80) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) SEACHR,(CHIDEP(II),
     &                 II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     WRITE(IOUNIT,9044)
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                     WRITE(IOUNIT,9049) CHIDEP(3), CHIDEP(3)
                  END IF
                  IF (MOD(INDC,2) .NE. 0) THEN
                     WRITE(BUF132(1:65),9047) SRCID(IREF(IREC)), DIST,
     &                                        DIR, GRPVAL(IREC,IGRP)
                  ELSE
                     WRITE(BUF132(66:130),9047) SRCID(IREF(IREC)), DIST,
     &                                          DIR, GRPVAL(IREC,IGRP)
                     WRITE(IOUNIT,9090) BUF132
                     WRITE(BUF132,9095)
                  END IF
               END IF
 1040       CONTINUE
            IF (MOD(INDC,2) .NE. 0) THEN
               WRITE(IOUNIT,9090) BUF132
               WRITE(BUF132,9095)
            END IF
         END IF

         IF (IRSTAT(6) .NE. 0) THEN
C           Write Out The Boundary Receptors For The Source Groups
            INDC = 0
            IREC = 1
            DO WHILE (IREC .LE. NUMREC)
               IF (RECTYP(IREC) .EQ. 'BD') THEN
                  INDC = INDC + 1
                  ISRF = IREF(IREC)
                  IF (MOD(INDC-1,3) .EQ. 0) THEN
                     CALL HEADER
                     WRITE(IOUNIT,9032) SEACHR,(CHIDEP(II),
     &               II=1,6),GRPID(IGRP),(WORKID(K),K = 1,INDGRP)
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                  END IF
                  WRITE(IOUNIT,9082) SRCID(ISRF), SRCTYP(ISRF),
     &                AXS(ISRF), AYS(ISRF), AZS(ISRF), CHIDEP(3),
     &                CHIDEP(3), CHIDEP(3), (J, AXR(IREC+J-1),
     &                AYR(IREC+J-1), GRPVAL(IREC+J-1,IGRP),J=1,36)
                  IREC = IREC + 36
               ELSE
                  IREC = IREC + 1
               END IF
            END DO
         END IF

 1000 CONTINUE

 9011 FORMAT(/40X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9010 FORMAT(66(' -')/)
 9013 FORMAT(2X,F10.2,1X,'|',1X,9(F13.6))
 9016 FORMAT(3X,' Y-COORD  |',48X,'X-COORD (METERS)')
 9017 FORMAT(3X,' (METERS) |',1X,9(1X,F12.2,:))
 9018 FORMAT(3X,'DIRECTION |',48X,'DISTANCE (METERS)')
 9019 FORMAT(3X,'(DEGREES) |',1X,9(1X,F12.2,:))
 9032 FORMAT(30X,'*** THE ',A6,1X,6A4,
     &       'VALUES FOR SOURCE GROUP:',1X,A8,' ***'/34X,
     &       'INCLUDING SOURCE(S):      ',7(A8,', ',:),
     &       /10X,12(A8,', ',:)/10X,12(A8,', ',:))
 9037 FORMAT(/35X,'*** NETWORK ID: ',A8,' ;  NETWORK TYPE: ',
     &       A8,' ***')
 9043 FORMAT(/45X,'*** DISCRETE CARTESIAN RECEPTOR POINTS ***')
 9044 FORMAT(/47X,'*** DISCRETE POLAR RECEPTOR POINTS ***')
 9045 FORMAT(6X,2(F12.2,2X),F14.6)
 9047 FORMAT(4X,A8,': ',2(F12.2,2X),F14.6)
 9048 FORMAT(6X,' X-COORD (M)   Y-COORD (M)         ',A4,
     &      22X,' X-COORD (M)   Y-COORD (M)         ',A4,/65(' -'))
 9049 FORMAT(5X,'ORIGIN',59X,'ORIGIN',
     &      /5X,' SRCID       DIST (M)     DIR (DEG)         ',A4,
     &      18X,' SRCID       DIST (M)     DIR (DEG)         ',A4,
     &      /65(' -'))
 9082 FORMAT(' BOUNDARY RECEPTOR NETWORK OF SOURCE ID: ',A8,/,5X,
     &       ' OF SOURCE TYPE: ',A8,'; WITH ORIGIN AT (',2(F10.2,', '),
     &       F10.2,')'/3(' (SEC.)  X-COORD    Y-COORD        ',A4,6X),/,
     &       12(3(1X,I4,2X,F9.1,',',F10.1,',',F14.6,' ',2X),/),/)
 9090 FORMAT(A132)
 9095 FORMAT(132(' '))

      RETURN
      END

      SUBROUTINE SLTMAX(SEACHR)
C***********************************************************************
C                 SLTMAX Module of ISC Model
C
C        PURPOSE: Print Out The Maximum N values by Source
C
C        PROGRAMMER: JEFF WANG, ROGER BRODE
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTOUT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER NID1*8, NID2*8, NTY1*2, NTY2*2, SEACHR*6

C     Variable Initializations
      MODNAM = 'SLTMAX'

C     Calculate Number of Sources to Print Per Page, NUMPPG
      NUMPPG = INT(48/(NUMMAX/2+7))

C     Begin Source LOOP
      DO 1000 ISRC = 1, NUMSRC

         IF (MOD(ISRC-1,NUMPPG) .EQ. 0) THEN
            CALL HEADER
         END IF
         IF (NUMMAX .GE. 2) THEN
C           Determine Number of Pages @ 80 Per Page, NPG
            NPG = 1 + INT((NUMMAX-1)/80)
            DO 800 L = 1, NPG
C              Determine Number of Rows for This Page, NROWS
               IF (L .EQ. NPG) THEN
                  NROWS = (NUMMAX-80*(L-1))/2
               ELSE
                  NROWS = 40
               END IF
C              Write Out Header Information for This Page
               IF (L .GT. 1) THEN
                  CALL HEADER
               END IF
               WRITE(IOUNIT,9032) NUMMAX, SEACHR,
     &               (CHIDEP(II),II=1,6), SRCID(ISRC)
               IF (MOD(ISRC-1,NUMPPG) .EQ. 0) THEN
                  WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
               ELSE
                  WRITE(IOUNIT,9099)
               END IF
               WRITE(IOUNIT,1) CHIDEP(3), CHIDEP(3)
C              Set Start Row of Loop for This Page, JSTRT
               JSTRT = 1 + 80*(L-1)
               DO 500 J = JSTRT, JSTRT+NROWS-1
                  J1 = J + NROWS
                  IF (L.EQ.NPG .AND. MOD(NUMMAX,2).NE.0) THEN
                     J1 = J1 + 1
                  END IF
                  KMAX1 = ISMLOC(J,ISRC)
                  KMAX2 = ISMLOC(J1,ISRC)
                  IF (KMAX1 .EQ. 0) THEN
                     XR1 = 0.
                     YR1 = 0.
                     NID1 = ' '
                     NTY1 = ' '
                  ELSE
                     XR1 = AXR(KMAX1)
                     YR1 = AYR(KMAX1)
                     NID1 = NETID(KMAX1)
                     NTY1 = RECTYP(KMAX1)
                  END IF
                  IF (KMAX2 .EQ. 0) THEN
                     XR2 = 0.
                     YR2 = 0.
                     NID2 = ' '
                     NTY2 = ' '
                  ELSE
                     XR2 = AXR(KMAX2)
                     YR2 = AYR(KMAX2)
                     NID2 = NETID(KMAX2)
                     NTY2 = RECTYP(KMAX2)
                  END IF
                  WRITE(IOUNIT,2) J, SRCMAX(J,ISRC),
     &                 XR1, YR1, NTY1, J1, SRCMAX(J1,ISRC),
     &                 XR2, YR2, NTY2
 500           CONTINUE
 800        CONTINUE
            IF (MOD(NUMMAX,2) .NE. 0) THEN
C              Odd Number of Max Values - Print Out Last Value
               J = INT(NUMMAX/2) + 1 + 40*(NPG-1)
               KMAX1 = ISMLOC(J,ISRC)
               XR1 = AXR(KMAX1)
               YR1 = AYR(KMAX1)
               NTY1 = RECTYP(KMAX1)
               WRITE(IOUNIT,3) J, SRCMAX(J,ISRC),
     &                         XR1, YR1, NTY1
            END IF
         ELSE
            J = 1
            KMAX1 = ISMLOC(J,ISRC)
            XR1 = AXR(KMAX1)
            YR1 = AYR(KMAX1)
            NTY1 = RECTYP(KMAX1)
            WRITE(IOUNIT,9032) NUMMAX, SEACHR,
     &            (CHIDEP(II),II=1,6), SRCID(ISRC)
            IF (MOD(ISRC-1,NUMPPG) .EQ. 0) THEN
               WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
            ELSE
               WRITE(IOUNIT,9099)
            END IF
            WRITE(IOUNIT,1) CHIDEP(3), CHIDEP(3)
            WRITE(IOUNIT,3) J, SRCMAX(J,ISRC),
     &                      XR1, YR1, NTY1
         END IF

         IF (MOD(ISRC,NUMPPG).EQ.0 .OR. ISRC.EQ.NUMSRC) THEN
C           WRITE Out Explanation of Receptor Types
            WRITE(IOUNIT,9050)
         END IF

 1000 CONTINUE
C     End Source LOOP

 1    FORMAT(1X,'RANK',7X,A4,4X,' AT',7X,
     &           'RECEPTOR (XR,YR) OF TYPE ',6X,
     &           'RANK',7X,A4,4X,' AT',7X,
     &           'RECEPTOR (XR,YR) OF TYPE ',
     &           /65(' -'))
 2    FORMAT(1X,I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2,8X,
     &          I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2)
 3    FORMAT(1X,I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2)
 9011 FORMAT(/26X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9032 FORMAT(/20X,'*** THE MAXIMUM ',I4,2X,A6,2X,6A4,
     &       ' VALUES FOR SOURCE: ',1X,A8,' ***')
 9050 FORMAT(/1X,' *** RECEPTOR TYPES:  GC = GRIDCART',
     &                            /23X,'GP = GRIDPOLR',
     &                            /23X,'DC = DISCCART',
     &                            /23X,'DP = DISCPOLR',
     &                            /23X,'BD = BOUNDARY')
 9099 FORMAT(' ')

      RETURN
      END

      SUBROUTINE GLTMAX(SEACHR)
C***********************************************************************
C                 GLTMAX Module of ISC Model
C
C        PURPOSE: Print Out The Maximum N values by Group
C
C        PROGRAMMER: JEFF WANG, ROGER BRODE
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTOUT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER NID1*8, NID2*8, NTY1*2, NTY2*2, SEACHR*6

C     Variable Initializations
      MODNAM = 'GLTMAX'

C     Calculate Number of Sources to Print Per Page, NUMPPG
      NUMPPG = INT(48/(NUMMAX/2+8))

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP

C        Fill Work Array With SRCIDs For This Group
         INDGRP = 0
         DO 210 ISRC = 1, NUMSRC
            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               INDGRP = INDGRP + 1
               WORKID(INDGRP) = SRCID(ISRC)
            END IF
 210     CONTINUE
C        Check for More Than 31 Sources Per Group
         IF (INDGRP .GT. 31) THEN
            WORKID(31) = ' . . . '
            INDGRP = 31
         END IF

         IF (MOD(IGRP-1,NUMPPG) .EQ. 0) THEN
            CALL HEADER
         END IF

         IF (NUMMAX .GE. 2) THEN
C           Determine Number of Pages @ 80 Per Page, NPG
            NPG = 1 + INT((NUMMAX-1)/80)
            DO 800 L = 1, NPG
C              Determine Number of Rows for This Page, NROWS
               IF (L .EQ. NPG) THEN
                  NROWS = (NUMMAX-80*(L-1))/2
               ELSE
                  NROWS = 40
               END IF
C              Write Out Header Information for This Page
               IF (L .GT. 1) THEN
                  CALL HEADER
               END IF
               WRITE(IOUNIT,9032) NUMMAX, SEACHR,
     &           (CHIDEP(II),II=1,6), GRPID(IGRP),(WORKID(K),K=1,INDGRP)
               IF (MOD(IGRP-1,NUMPPG) .EQ. 0) THEN
                  WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
               ELSE
                  WRITE(IOUNIT,9099)
               END IF
               WRITE(IOUNIT,1) CHIDEP(3), CHIDEP(3)
C              Set Start Row of Loop for This Page, JSTRT
               JSTRT = 1 + 80*(L-1)
               DO 500 J = JSTRT, JSTRT+NROWS-1
                  J1 = J + NROWS
                  IF (L.EQ.NPG .AND. MOD(NUMMAX,2).NE.0) THEN
                     J1 = J1 + 1
                  END IF
                  KMAX1 = IGMLOC(J,IGRP)
                  KMAX2 = IGMLOC(J1,IGRP)
                  IF (KMAX1 .EQ. 0) THEN
                     XR1 = 0.
                     YR1 = 0.
                     NID1 = ' '
                     NTY1 = ' '
                  ELSE
                     XR1 = AXR(KMAX1)
                     YR1 = AYR(KMAX1)
                     NID1 = NETID(KMAX1)
                     NTY1 = RECTYP(KMAX1)
                  END IF
                  IF (KMAX2 .EQ. 0) THEN
                     XR2 = 0.
                     YR2 = 0.
                     NID2 = ' '
                     NTY2 = ' '
                  ELSE
                     XR2 = AXR(KMAX2)
                     YR2 = AYR(KMAX2)
                     NID2 = NETID(KMAX2)
                     NTY2 = RECTYP(KMAX2)
                  END IF
                  WRITE(IOUNIT,2) J, GRPMAX(J,IGRP),
     &                 XR1, YR1, NTY1, J1, GRPMAX(J1,IGRP),
     &                 XR2, YR2, NTY2
 500           CONTINUE
 800        CONTINUE
            IF (MOD(NUMMAX,2) .NE. 0) THEN
C              Odd Number of Max Values - Print Out Last Value
               J = INT(NUMMAX/2) + 1 + 40*(NPG-1)
               KMAX1 = IGMLOC(J,IGRP)
               XR1 = AXR(KMAX1)
               YR1 = AYR(KMAX1)
               NTY1 = RECTYP(KMAX1)
               WRITE(IOUNIT,3) J, GRPMAX(J,IGRP),
     &                         XR1, YR1, NTY1
            END IF
         ELSE
            J = 1
            KMAX1 = IGMLOC(J,IGRP)
            XR1 = AXR(KMAX1)
            YR1 = AYR(KMAX1)
            NTY1 = RECTYP(KMAX1)
            WRITE(IOUNIT,9032) NUMMAX, SEACHR,
     &        (CHIDEP(II),II=1,6), GRPID(IGRP),(WORKID(K),K=1,INDGRP)
            IF (MOD(IGRP-1,NUMPPG) .EQ. 0) THEN
               WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
            ELSE
               WRITE(IOUNIT,9099)
            END IF
            WRITE(IOUNIT,1) CHIDEP(3), CHIDEP(3)
            WRITE(IOUNIT,3) J, GRPMAX(J,IGRP),
     &            XR1, YR1, NTY1
         END IF

         IF (MOD(IGRP,NUMPPG).EQ.0 .OR. IGRP.EQ.NUMGRP) THEN
C           WRITE Out Explanation of Receptor Types
            WRITE(IOUNIT,9050)
         END IF

 1000 CONTINUE
C     End Source Group LOOP

 1    FORMAT(1X,'RANK',7X,A4,4X,' AT',7X,
     &           'RECEPTOR (XR,YR) OF TYPE ',6X,
     &           'RANK',7X,A4,4X,' AT',7X,
     &           'RECEPTOR (XR,YR) OF TYPE ',
     &           /65(' -'))
 2    FORMAT(1X,I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2,8X,
     &          I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2)
 3    FORMAT(1X,I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2)
 9011 FORMAT(/26X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9032 FORMAT(/20X,'*** THE MAXIMUM ',I4,2X,A6,2X,6A4,
     &       ' VALUES FOR GROUP: ',1X,A8,' ***',
     &       /24X,'INCLUDING SOURCE(S):      ',7(A8,', ',:),
     &       /8X,12(A8,', ',:)/8X,12(A8,', ',:))
 9050 FORMAT(/1X,' *** RECEPTOR TYPES:  GC = GRIDCART',
     &                            /23X,'GP = GRIDPOLR',
     &                            /23X,'DC = DISCCART',
     &                            /23X,'DP = DISCPOLR',
     &                            /23X,'BD = BOUNDARY')
 9099 FORMAT(' ')

      RETURN
      END

      SUBROUTINE CLTMAX(SEACHR)
C***********************************************************************
C                 CLTMAX Module of ISC Model
C
C        PURPOSE: Print Out The Maximum N values by Source Contribution
C
C        PROGRAMMER: JEFF WANG, ROGER BRODE
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To correct output of explanation of receptor type -
C                    9/29/92
C
C        INPUTS:  Arrays of Source Parameters
C                 Arrays of Receptor Locations
C                 Arrays of Model Results
C
C        OUTPUTS: Printed Model Outputs
C
C        CALLED FROM:   LTOUT
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER NID1*8, NID2*8, NTY1*2, NTY2*2, SEACHR*6
      LOGICAL RECMSG

C     Variable Initializations
      MODNAM = 'CLTMAX'

C     Calculate Number of Sources to Print Per Page, NUMPPG
      NUMPPG = INT(48/(NUMMAX/2+7))

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
         INDGRP = 0
         RECMSG = .FALSE.

C        Begin Source LOOP
         DO 900 ISRC = 1, NUMSRC

            IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
               INDGRP = INDGRP + 1
               IF (MOD(INDGRP-1,NUMPPG) .EQ. 0) THEN
                  CALL HEADER
               END IF
               IF (NUMMAX .GE. 2) THEN
C                 Determine Number of Pages @ 80 Per Page, NPG
                  NPG = 1 + INT((NUMMAX-1)/80)
                  DO 800 L = 1, NPG
C                    Determine Number of Rows for This Page, NROWS
                     IF (L .EQ. NPG) THEN
                        NROWS = (NUMMAX-80*(L-1))/2
                     ELSE
                        NROWS = 40
                     END IF
C                    Write Out Header Information for This Page
                     IF (L .GT. 1) THEN
                        CALL HEADER
                     END IF
                     WRITE(IOUNIT,9032) SRCID(ISRC), NUMMAX, SEACHR,
     &                    (CHIDEP(II),II=1,6), GRPID(IGRP)
                     IF (MOD(INDGRP-1,NUMPPG) .EQ. 0) THEN
                        WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                     ELSE
                        WRITE(IOUNIT,9099)
                     END IF
                     WRITE(IOUNIT,1) CHIDEP(3), CHIDEP(3)
C                    Set Start Row of Loop for This Page, JSTRT
                     JSTRT = 1 + 80*(L-1)
                     DO 500 J = JSTRT, JSTRT+NROWS-1
                        J1 = J + NROWS
                        IF (L.EQ.NPG .AND. MOD(NUMMAX,2).NE.0) THEN
                           J1 = J1 + 1
                        END IF
                        KMAX1 = IGMLOC(J,IGRP)
                        KMAX2 = IGMLOC(J1,IGRP)
                        IF (KMAX1 .EQ. 0) THEN
                           XR1 = 0.
                           YR1 = 0.
                           NID1 = ' '
                           NTY1 = ' '
                        ELSE
                           XR1 = AXR(KMAX1)
                           YR1 = AYR(KMAX1)
                           NID1 = NETID(KMAX1)
                           NTY1 = RECTYP(KMAX1)
                        END IF
                        IF (KMAX2 .EQ. 0) THEN
                           XR2 = 0.
                           YR2 = 0.
                           NID2 = ' '
                           NTY2 = ' '
                        ELSE
                           XR2 = AXR(KMAX2)
                           YR2 = AYR(KMAX2)
                           NID2 = NETID(KMAX2)
                           NTY2 = RECTYP(KMAX2)
                        END IF
                        WRITE(IOUNIT,2)  J, SRCONT(J,ISRC,IGRP),
     &                    XR1, YR1, NTY1, J1, SRCONT(J1,ISRC,IGRP),
     &                    XR2, YR2, NTY2
 500                 CONTINUE
 800              CONTINUE
                  IF (MOD(NUMMAX,2) .NE. 0) THEN
C                    Odd Number of Max Values - Print Out Last Value
                     J = INT(NUMMAX/2) + 1 + 40*(NPG-1)
                     KMAX1 = IGMLOC(J,IGRP)
                     XR1 = AXR(KMAX1)
                     YR1 = AYR(KMAX1)
                     NTY1 = RECTYP(KMAX1)
                     WRITE(IOUNIT,3) J, SRCONT(J,ISRC,IGRP),
     &                               XR1, YR1, NTY1
                  END IF
               ELSE
                  J = 1
                  KMAX1 = IGMLOC(J,IGRP)
                  XR1 = AXR(KMAX1)
                  YR1 = AYR(KMAX1)
                  NTY1 = RECTYP(KMAX1)
                  WRITE(IOUNIT,9032) SRCID(ISRC), NUMMAX, SEACHR,
     &                 (CHIDEP(II),II=1,6), GRPID(IGRP)
                  IF (MOD(INDGRP-1,NUMPPG) .EQ. 0) THEN
                     WRITE(IOUNIT,9011) CHIDEP(3), POLLUT, OUTLBL
                  ELSE
                     WRITE(IOUNIT,9099)
                  END IF
                  WRITE(IOUNIT,1) CHIDEP(3), CHIDEP(3)
                  WRITE(IOUNIT,3) J, SRCONT(J,ISRC,IGRP),
     &                            XR1, YR1, NTY1
               END IF

               IF (MOD(INDGRP,NUMPPG).EQ.0 .OR. ISRC.EQ.NUMSRC) THEN
C                 WRITE Out Explanation of Receptor Types at End of Page
                  WRITE(IOUNIT,9050)
                  RECMSG = .TRUE.
               END IF

            END IF

 900     CONTINUE
C        End Source LOOP

         IF (.NOT. RECMSG) THEN
C           WRITE Out Explanation of Receptor Types If No Message For Group
            WRITE(IOUNIT,9050)
         END IF

 1000 CONTINUE
C     End Source Group LOOP

 1    FORMAT(1X,'RANK',7X,A4,4X,' AT',7X,
     &           'RECEPTOR (XR,YR) OF TYPE ',6X,
     &           'RANK',7X,A4,4X,' AT',7X,
     &           'RECEPTOR (XR,YR) OF TYPE ',
     &           /65(' -'))
 2    FORMAT(1X,I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2,8X,
     &          I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2)
 3    FORMAT(1X,I3,'.',1X,F14.6,' AT',1X,
     &          '( ',F10.2,', ',F10.2,')  ',A2)
 9011 FORMAT(/26X,'** ',A4,' OF ',A8,' IN ',A40,' **'/)
 9032 FORMAT(/8X,'*** SOURCE ',A8,' CONTRIBUTIONS TO THE MAXIMUM ',
     &       I4,2X,A6,2X,6A4,' VALUES FOR GROUP: ',1X,A8,' ***')
 9050 FORMAT(/1X,' *** RECEPTOR TYPES:  GC = GRIDCART',
     &                            /23X,'GP = GRIDPOLR',
     &                            /23X,'DC = DISCCART',
     &                            /23X,'DP = DISCPOLR',
     &                            /23X,'BD = BOUNDARY')
 9099 FORMAT(' ')

      RETURN
      END

      SUBROUTINE PLOTFL
C***********************************************************************
C                 PLOTFL Module of ISC Model - Long Term
C
C        PURPOSE: Process Files To Plot
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    March 2, 1992
C
C        MODIFIED:   To correct model name in PLOTFILE header - 9/29/92
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Plotting
C
C        CALLED FROM:   LTMSA
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'PLOTFL'

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
C        Decide if we should go through the processing
         IF (IPLTFL(IGRP,IAVE) .EQ. 1) THEN
C           Write Header Information
            WRITE(IPLUNT(IGRP,IAVE),9005) VERSN, TITLE1
            WRITE(IPLUNT(IGRP,IAVE),9007) (MODOPS(I),I=1,12)
            WRITE(IPLUNT(IGRP,IAVE),9010) AVEPER(IAVE),
     &                  GRPID(IGRP), NUMREC, PLTFRM
            WRITE(IPLUNT(IGRP,IAVE),9020) CHIDEP(3)
C           Begin Receptor LOOP
            DO 250 IREC = 1, NUMREC
               WRITE(IPLUNT(IGRP,IAVE),PLTFRM,ERR=99) AXR(IREC),
     &               AYR(IREC), GRPVAL(IREC,IGRP), AZELEV(IREC),
     &               AVEPER(IAVE), GRPID(IGRP), NETID(IREC)
 250        CONTINUE
C           End Receptor LOOP
         END IF
 1000 CONTINUE
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to Plot File
 99   WRITE(DUMMY,'(5HPLTFL,I3.3)') IPLUNT(IGRP,IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCLT3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',12(1X,A6))
 9010 FORMAT('*',9X,'PLOT FILE OF ',A6,
     &       ' VALUES FOR SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ',I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('*',8X,'X',13X,'Y',11X,A4,7X,'ZELEV',5X,'AVE',4X,
     &       'GROUP',5X,'NET ID',/'*',1X,2('____________',2X),
     &       '_____________',2X,'_______  ______  ________  ________')

 999  RETURN
      END

      SUBROUTINE PLTANN
C***********************************************************************
C                 PLTANN Module of ISC2 Long Term Model - ISCLT2
C
C        PURPOSE: Process Files To Plot Annual (i.e. PERIOD) Results
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    March 2, 1992
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Plotting
C
C        CALLED FROM:   LTPER
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER PERCHR*6

C     Variable Initializations
      MODNAM = 'PLTANN'
      PERCHR = 'PERIOD'

C     Begin Source Group LOOP
      DO 500 IGRP = 1, NUMGRP
C        Check for Selection of PERIOD PLOTFILE for This Group
         IF (IANPLT(IGRP) .EQ. 1) THEN
C           Write Header Information
            WRITE(IPPUNT(IGRP),9005) VERSN, TITLE1
            WRITE(IPPUNT(IGRP),9007) (MODOPS(I),I=1,12)
            WRITE(IPPUNT(IGRP),9010) GRPID(IGRP), NUMREC, PLTFRM
            WRITE(IPPUNT(IGRP),9020) CHIDEP(3)
C           Begin Receptor LOOP
            DO 300 IREC = 1, NUMREC
               WRITE(IPPUNT(IGRP),PLTFRM,ERR=99)
     &            AXR(IREC), AYR(IREC), GRPVAL(IREC,IGRP),
     &            AZELEV(IREC), PERCHR, GRPID(IGRP), NETID(IREC)
 300        CONTINUE
C           End Receptor LOOP
         END IF
 500  CONTINUE
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to Plot File
 99   WRITE(DUMMY,'(5HPLTFL,I3.3)') IPPUNT(IGRP)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCLT3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',12(1X,A6))
 9010 FORMAT('*',9X,'PLOT FILE OF PERIOD VALUES FOR ',
     &       'SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ', I5,' RECEPTORS.',
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('*',8X,'X',13X,'Y',11X,A4,7X,'ZELEV',5X,'AVE',4X,
     &       'GROUP',5X,'NET ID',/'*',1X,2('____________',2X),
     &       '_____________',2X,'_______  ______  ________  ________')

 999  RETURN
      END

      SUBROUTINE TOXXFL
C***********************************************************************
C                 TOXXFL Module of ISC Model - Long Term
C
C        PURPOSE: Process Files To Plot
C
C        PROGRAMMER: Roger Brode, Jeff Wang
C
C        DATE:    September 29, 1992
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Plotting
C
C        CALLED FROM:   LTMSA
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'TOXXFL'

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
C        Decide if we should go through the processing
         IF (ITOXFL(IGRP,IAVE) .EQ. 1) THEN
C           Write Header Information
            WRITE(ITXUNT(IGRP,IAVE),9005) VERSN, TITLE1
            WRITE(ITXUNT(IGRP,IAVE),9007) (MODOPS(I),I=1,12)
            WRITE(ITXUNT(IGRP,IAVE),9010) AVEPER(IAVE),
     &                  GRPID(IGRP), NUMREC, ITAB, NXTOX, NYTOX, PLTFRM
            WRITE(ITXUNT(IGRP,IAVE),9020) CHIDEP(3)
C           Begin Source LOOP
            DO 500 ISRC = 1, NUMSRC
C              Check for This Source Being Part of Group
               IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
C                 Begin Receptor LOOP
                  DO 250 IREC = 1, NUMREC
                     WRITE(ITXUNT(IGRP,IAVE),PLTFRM,ERR=99) AXR(IREC),
     &                     AYR(IREC), SRCVAL(IREC,ISRC), AZELEV(IREC),
     &                     AVEPER(IAVE), SRCID(ISRC), NETID(IREC)
 250              CONTINUE
C                 End Receptor LOOP
               END IF
 500        CONTINUE
C           End Source LOOP
         END IF
 1000 CONTINUE
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to TOXXFILE
 99   WRITE(DUMMY,'(5HTOXFL,I3.3)') ITXUNT(IGRP,IAVE)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCLT3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',12(1X,A6))
 9010 FORMAT('*',9X,'TOXXFILE OF ',A6,
     &       ' VALUES FOR SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ',I5,' RECEPTORS.',
     &      /'*',9X,'ITAB = ',I2,';  NXTOX = ',I3,';  NYTOX = ',I3,
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('*',8X,'X',13X,'Y',11X,A4,7X,'ZELEV',5X,'AVE',4X,
     &       'GROUP',5X,'NET ID',/'*',1X,2('____________',2X),
     &       '_____________',2X,'_______  ______  ________  ________')

 999  RETURN
      END

      SUBROUTINE TOXANN
C***********************************************************************
C                 TOXANN Module of ISC Model - Long Term
C
C        PURPOSE: Process TOXXFILEs for PERIOD Averages
C
C        PROGRAMMER: Roger Brode
C
C        DATE:    September 29, 1992
C
C        INPUTS:  Array of High Values
C
C        OUTPUTS: File of High Values for Plotting
C
C        CALLED FROM:   LTPER
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'
      CHARACTER PERCHR*6

C     Variable Initializations
      MODNAM = 'TOXANN'
      PERCHR = 'PERIOD'

C     Begin Source Group LOOP
      DO 1000 IGRP = 1, NUMGRP
C        Decide if we should go through the processing
         IF (IANTOX(IGRP) .EQ. 1) THEN
C           Write Header Information
            WRITE(IPXUNT(IGRP),9005) VERSN, TITLE1
            WRITE(IPXUNT(IGRP),9007) (MODOPS(I),I=1,12)
            WRITE(IPXUNT(IGRP),9010) PERCHR,
     &                  GRPID(IGRP), NUMREC, ITAB, NXTOX, NYTOX, PLTFRM
            WRITE(IPXUNT(IGRP),9020) CHIDEP(3)
C           Begin Source LOOP
            DO 500 ISRC = 1, NUMSRC
C              Check for This Source Being Part of Group
               IF (IGROUP(ISRC,IGRP) .EQ. 1) THEN
C                 Begin Receptor LOOP
                  DO 250 IREC = 1, NUMREC
                     WRITE(IPXUNT(IGRP),PLTFRM,ERR=99) AXR(IREC),
     &                     AYR(IREC), SRCVAL(IREC,ISRC), AZELEV(IREC),
     &                     PERCHR, SRCID(ISRC), NETID(IREC)
 250              CONTINUE
C                 End Receptor LOOP
               END IF
 500        CONTINUE
C           End Source LOOP
         END IF
 1000 CONTINUE
C     End Source Group LOOP

      GO TO 999

C     WRITE Error Message for Problem Writing to TOXXFILE
 99   WRITE(DUMMY,'(5HTOXFL,I3.3)') IPXUNT(IGRP)
      CALL ERRHDL(PATH,MODNAM,'E','520',DUMMY)

 9005 FORMAT('* ISCLT3 (',A5,'): ',A68)
 9007 FORMAT('* MODELING OPTIONS USED:',/'* ',12(1X,A6))
 9010 FORMAT('*',9X,'TOXXFILE OF ',A6,
     &       ' VALUES FOR SOURCE GROUP: ',A8,
     &      /'*',9X,'FOR A TOTAL OF ',I5,' RECEPTORS.',
     &      /'*',9X,'ITAB = ',I2,';  NXTOX = ',I3,';  NYTOX = ',I3,
     &      /'*',9X,'FORMAT: ',A60)
 9020 FORMAT('*',8X,'X',13X,'Y',11X,A4,7X,'ZELEV',5X,'AVE',4X,
     &       'GROUP',5X,'NET ID',/'*',1X,2('____________',2X),
     &       '_____________',2X,'_______  ______  ________  ________')

 999  RETURN
      END

      SUBROUTINE FLUSH
C***********************************************************************
C                 Module FLUSH of ISC Model - Long Term
C
C        PURPOSE: To Flush Result Arrays
C
C        PROGRAMMER: Jeff Wang
C
C        DATE:    March 2, 1992
C
C        INPUTS:
C
C        OUTPUTS:
C
C        CALLED FROM:  LTMSA
C***********************************************************************

C     Variable Declarations
      INCLUDE 'MAIN1LT.INC'
      INCLUDE 'MAIN2LT.INC'
      INCLUDE 'MAIN3LT.INC'

C     Variable Initializations
      MODNAM = 'FLUSH'

C     Initialize the Results Arrays
      DO 80 I = 1, NREC
         DO 60 J = 1, NSRC
            SRCVAL(I,J) = 0.0
 60      CONTINUE
         DO 70 J = 1, NGRP
            GRPVAL(I,J) = 0.0
 70      CONTINUE
 80   CONTINUE

      DO 120 I = 1, NMAX
         DO 100 J = 1, NSRC
            SRCMAX(I,J) = 0.0
            ISMLOC(I,J) = 0
            DO 90 K = 1, NGRP
               SRCONT(I,J,K) = 0.0
 90         CONTINUE
 100     CONTINUE
         DO 110 J = 1, NGRP
            GRPMAX(I,J) = 0.0
            IGMLOC(I,J) = 0
 110     CONTINUE
 120  CONTINUE

      RETURN
      END
