rem ####         runtests_AERMOD.bat           ####
rem ####  Standard Test Cases for AERMOD model #### 
rem ####           May 10, 2022                #### 

rem basedir: path to base directory
set basedir="%~dp0"

rem #### End of User Input ####


rem indir: path to directory containing inputs for first test case for this run
set casedir=%basedir%inputs
rem outdir: path to output directory where first test case output files will be moved
set outdir=%basedir%Outputs
rem metdir: path to directory containing first case AERMET .SFC and .PFL files
set metdir=%basedir%meteorology
rem plotdir: path to output directory where first case AERMOD plot files will be moved
set plotdir=%basedir%plotfiles
rem postdir: path to output directory where first case AERMOD post files will be moved
set postdir=%basedir%postfiles


rem run default test cases
call :run_test_suite

rem Go back to initial working directory and exit batch file
exit /b


:run_test_suite
echo %date% %time% > start.txt

rem ### create Outputs, postfiles, and plotfiles directories if not previously created
if not exist %outdir% mkdir %outdir%
if not exist %plotdir% mkdir %plotdir%
if not exist %postdir% mkdir %postdir%
 
rem store current working directory
pushd %cd%

rem ####  Clean the output directory of files downloaded from SCRAM
if exist %outdir% call :run_preclean_test_suite

cd %casedir%

rem #### Delete duplicate "aermet2 test met" AERMET files from meteorology directory, if they exist
cd %metdir%
if exist "aermet2 test met.pfl" del "aermet2 test met.pfl"
if exist "aermet2 test met.sfc" del "aermet2 test met.sfc"
cd %casedir%

rem #### Run aertest test case
copy aertest.inp  aermod.inp
aermod
move aermod.out  aertest.out
rem move aertest_evt.inp  aermod.inp
rem aermod
rem move aermod.out  aertest_evt.out
rem set fil1=aertest_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp


rem #### Run allsrcs test case
copy allsrcs.inp  aermod.inp
aermod
move aermod.out  allsrcs.out
rem move allsrcs_evt.inp  aermod.inp
rem aermod
rem move aermod.out allsrcs_evt.out
rem set fil1=allsrcs_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 ARM2 BACKUNIT PPB test case
copy bg_no2_arm2_ppb.inp  aermod.inp
aermod
move aermod.out  bg_no2_arm2_ppb.out
rem move bg_no2_arm2_ppb_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_arm2_ppb_evt.out
rem set fil1=bg_no2_arm2_ppb_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 ARM2 BACKUNIT UGM3 test case
copy bg_no2_arm2_ugm3.inp  aermod.inp
aermod
move aermod.out  bg_no2_arm2_ugm3.out
rem move bg_no2_arm2_ugm3_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_arm2_ugm3_evt.out
rem set fil1=bg_no2_arm2_ugm3_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 GRSM BACKUNIT PPB test case
copy bg_no2_grsm_ppb.inp  aermod.inp
aermod
move aermod.out  bg_no2_grsm_ppb.out
rem move bg_no2_grsm_ppb_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_grsm_ppb_evt.out
rem set fil1=bg_no2_grsm_ppb_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 GRSM BACKUNIT UGM3 test case
copy bg_no2_grsm_ugm3.inp  aermod.inp
aermod
move aermod.out  bg_no2_grsm_ugm3.out
rem move bg_no2_grsm_ugm3_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_grsm_ugm3_evt.out
rem set fil1=bg_no2_grsm_ugm3_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 OLM BACKUNIT PPB test case
copy bg_no2_olm_ppb.inp  aermod.inp
aermod
move aermod.out  bg_no2_olm_ppb.out
rem move bg_no2_olm_ppb_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_olm_ppb_evt.out
rem set fil1=bg_no2_olm_ppb_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 OLM BACKUNIT UGM3 test case
copy bg_no2_olm_ugm3.inp  aermod.inp
aermod
move aermod.out  bg_no2_olm_ugm3.out
rem move bg_no2_olm_ugm3_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_olm_ugm3_evt.out
rem set fil1=bg_no2_olm_ugm3_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 PVMRM BACKUNIT PPB test case
copy bg_no2_pvmrm_ppb.inp  aermod.inp
aermod
move aermod.out  bg_no2_pvmrm_ppb.out
rem move bg_no2_pvmrm_ppb_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_pvmrm_ppb_evt.out
rem set fil1=bg_no2_pvmrm_ppb_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 PVMRM BACKUNIT UGM3 test case
copy bg_no2_pvmrm_ugm3.inp  aermod.inp
aermod
move aermod.out  bg_no2_pvmrm_ugm3.out
rem move bg_no2_pvmrm_ugm3_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_pvmrm_ugm3_evt.out
rem set fil1=bg_no2_pvmrm_ugm3_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 TTRM BACKUNIT PPB test case
copy bg_no2_ttrm_ppb.inp  aermod.inp
aermod
move aermod.out  bg_no2_ttrm_ppb.out
rem move bg_no2_ttrm_ppb_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_ttrm_ppb_evt.out
rem set fil1=bg_no2_ttrm_ppb_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Background NO2 TTRM BACKUNIT UGM3 test case
copy bg_no2_ttrm_ugm3.inp  aermod.inp
aermod
move aermod.out  bg_no2_ttrm_ugm3.out
rem move bg_no2_ttrm_ugm3_evt.inp  aermod.inp
rem aermod
rem move aermod.out bg_no2_ttrm_ugm3_evt.out
rem set fil1=bg_no2_ttrm_ugm3_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run urban option for bouyant line source
copy blp_urban.inp  aermod.inp
aermod
move aermod.out  blp_urban.out
rem move blp_urban_evt.inp  aermod.inp
rem aermod
rem move aermod.out  blp_urban_evt.out
rem set fil1=blp_urban_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run capped test case
copy capped.inp  aermod.inp
aermod
move aermod.out  capped.out
rem move capped_evt.inp  aermod.inp
rem aermod
rem move aermod.out  capped_evt.out
rem set fil1=capped_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run capped_nostd test case
copy capped_nostd.inp  aermod.inp
aermod
move aermod.out  capped_nostd.out
rem move capped_nostd_evt.inp  aermod.inp
rem aermod
rem move aermod.out  capped_nostd_evt.out
rem set fil1=capped_nostd_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run flatelev test case
copy flatelev.inp  aermod.inp
aermod
move aermod.out  flatelev.out
rem move flatelev_evt.inp  aermod.inp
rem aermod
rem move aermod.out  flatelev_evt.out
rem set fil1=flatelev_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run hrdow test case
copy hrdow.inp  aermod.inp
aermod
move aermod.out  hrdow.out
rem move hrdow_evt.inp  aermod.inp
rem aermod
rem move aermod.out  hrdow_evt.out
rem set fil1=hrdow_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run indianapolis urban  test case
copy in_urban.inp  aermod.inp
aermod
move aermod.out  in_urban.out
rem move in_urban_evt.inp  aermod.inp
rem aermod
rem move aermod.out  in_urban_evt.out
rem set fil1=in_urban_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run lovett test case
copy lovett.inp  aermod.inp
aermod
move aermod.out  lovett.out
rem move lovett_evt.inp  aermod.inp
rem aermod
rem move aermod.out  lovett_evt.out
rem set fil1=lovett_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run mcr test case
copy mcr.inp  aermod.inp
aermod
move aermod.out   mcr.out
rem move mcr_evt.inp  aermod.inp
rem aermod
rem move aermod.out   mcr_evt.out
rem set fil1=mcr_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run multurb test case
copy multurb.inp  aermod.inp
aermod
move aermod.out  multurb.out
rem move multurb_evt.inp  aermod.inp
rem aermod
rem move aermod.out  multurb_evt.out
rem set fil1=multurb_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run olm test case
copy olm.inp  aermod.inp
aermod
move aermod.out  olm.out
rem move olm_evt.inp  aermod.inp
rem aermod
rem move aermod.out  olm_evt.out
rem set fil1=olm_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run olmgrp test case
copy olmgrp.inp  aermod.inp
aermod
move aermod.out  olmgrp.out
rem move olmgrp_evt.inp  aermod.inp
rem aermod
rem move aermod.out  olmgrp_evt.out
rem set fil1=olmgrp_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run openpits test case
copy openpits.inp  aermod.inp
aermod
move aermod.out  openpits.out
rem move openpits_evt.inp  aermod.inp
rem aermod
rem move aermod.out  openpits_evt.out
rem set fil1=openpits_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run psdcred test case
copy psdcred.inp  aermod.inp
aermod
move aermod.out   psdcred.out
del aermod.inp

rem #### Run pvmrm test case
copy pvmrm.inp  aermod.inp
aermod
move aermod.out  pvmrm.out
rem move pvmrm_evt.inp  aermod.inp
rem aermod
rem move aermod.out  pvmrm_evt.out
rem set fil1=pvmrm_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run scimtest test case
copy scimtest.inp  aermod.inp
aermod
move aermod.out    scimtest.out
del aermod.inp

rem #### Run surfcoal test case
copy surfcoal.inp  aermod.inp
aermod
move aermod.out  surfcoal.out
rem move surfcoal_evt.inp  aermod.inp
rem aermod
rem move aermod.out  surfcoal_evt.out
rem set fil1=surfcoal_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run testgas test case
copy testgas.inp  aermod.inp
aermod
move aermod.out   testgas.out
set fil1=testgas.out
move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run testgas2 test case
copy testgas2.inp  aermod.inp
aermod
move aermod.out  testgas2.out
rem move testgas2_evt.inp  aermod.inp
rem aermod
rem move aermod.out  testgas2_evt.out
rem set fil1=testgas2_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run testpart test case
copy testpart.inp aermod.inp
aermod
move aermod.out   testpart.out
del aermod.inp

rem #### Run PM10 test case with 5-yr data file
copy testpm10.inp aermod.inp
aermod
move aermod.out testpm10.out
rem move testpm10_evt.inp aermod.inp
rem aermod
rem move aermod.out testpm10_evt.out
rem set fil1=testpm10_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run MULTYEAR PM10 test case with 5-yr data file
copy testpm10_1986.inp aermod.inp
aermod
move aermod.out testpm10_1986.out
copy testpm10_1987.inp aermod.inp
aermod
move aermod.out testpm10_1987.out
copy testpm10_1988.inp aermod.inp
aermod
move aermod.out testpm10_1988.out
copy testpm10_1989.inp aermod.inp
aermod
move aermod.out testpm10_1989.out
copy testpm10_1990.inp aermod.inp
aermod
move aermod.out testpm10_1990.out
rem move testpm10_multyr_evt.inp aermod.inp
rem aermod
rem move aermod.out testpm10_multyr_evt.out
rem set fil1=testpm10_multyr_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run PM2.5 test case with 5-yr data file
copy testpm25.inp  aermod.inp
aermod
move aermod.out  testpm25.out
rem move testpm25_evt.inp  aermod.inp
rem aermod
rem move aermod.out  testpm25_evt.out
rem set fil1=testpm25_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run testprt2 test case
copy testprt2.inp  aermod.inp
aermod
move aermod.out  testprt2.out
rem move testprt2_evt.inp  aermod.inp
rem aermod
rem move aermod.out  testprt2_evt.out
rem set fil1=testprt2_evt.out
rem move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Baldwin TSD 45-degree test case
copy aermod-baldwin45.inp aermod.inp
aermod
move aermod.out aermod-baldwin45.out
set fil1=aermod-baldwin45.out
move %fil1% %outdir%\%fil1%
del aermod.inp


rem #### Run Baldwin TSD Horizontal test case
copy aermod-baldwinHoriz.inp aermod.inp
aermod
move aermod.out aermod-baldwinHoriz.out
set fil1=aermod-baldwinHoriz.out
move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Baldwin TSD Vertical test case
copy aermod-baldwinVert.inp aermod.inp
aermod
move aermod.out aermod-baldwinVert.out
set fil1=aermod-baldwinVert.out
move %fil1% %outdir%\%fil1%
del aermod.inp

rem #### Run Test1_base_cart_3cond_SNC - RLINE test case
copy Test1_Base_cart_3cond_SNC.inp aermod.inp
aermod
move aermod.out Test1_Base_cart_3cond_SNC.out 
set fill=Test1_Base_cart_3cond_SNC.out
move %fil1% %outdir%\%fil1% 
del aermod.inp

rem #### Run Test3_Base_cart_3cond_SNC_bar - RLINE test case
copy Test3_Base_cart_3cond_SNC_bar.inp aermod.inp
aermod
move aermod.out Test3_Base_cart_3cond_SNC_bar.out 
set fill=Test3_Base_cart_3cond_SNC_bar.out
move %fil1% %outdir%\%fil1% 
del aermod.inp

rem #### Run Test4_Base_cart_3cond_SNC_dep - RLINE test case
copy Test4_Base_cart_3cond_SNC_dep.inp aermod.inp
aermod
move aermod.out Test4_Base_cart_3cond_SNC_dep.out 
set fill=Test4_Base_cart_3cond_SNC_dep.out
move %fil1% %outdir%\%fil1% 
del aermod.inp

rem #### Run Test20_Urban_cart_3cond_SNC - RLINE test case
copy Test20_Urban_cart_3cond_SNC.inp aermod.inp
aermod
move aermod.out Test20_Urban_cart_3cond_SNC.out 
set fill=Test20_Urban_cart_3cond_SNC.out
move %fil1% %outdir%\%fil1% 
del aermod.inp

rem ##############################################################################

rem ####  Move test case output files to output directory
set fil1=aertest.out
move %fil1% %outdir%\%fil1%
set fil2=allsrcs.out
move %fil2% %outdir%\%fil2%
set fil3=capped.out
move %fil3% %outdir%\%fil3%
set fil4=capped_nostd.out
move %fil4% %outdir%\%fil4%
set fil5=flatelev.out
move %fil5% %outdir%\%fil5%
set fil6=hrdow.out
move %fil6% %outdir%\%fil6%
set fil7=lovett.out
move %fil7% %outdir%\%fil7%
set fil8=mcr.out
move %fil8% %outdir%\%fil8%
set fil9=multurb.out
move %fil9% %outdir%\%fil9%
set fil10=olm.out
move %fil10% %outdir%\%fil10%
set fil11=olmgrp.out
move %fil11% %outdir%\%fil11%
set fil12=openpits.out
move %fil12% %outdir%\%fil12%
set fil13=psdcred.out
move %fil13% %outdir%\%fil13%
set fil14=pvmrm.out
move %fil14% %outdir%\%fil14%
set fil15=scimtest.out
move %fil15% %outdir%\%fil15%
set fil16=surfcoal.out
move %fil16% %outdir%\%fil16%
set fil17=testgas.out 
move %fil17% %outdir%\%fil17%
set fil18=testgas2.out
move %fil18% %outdir%\%fil18%
set fil19=testpart.out
move %fil19% %outdir%\%fil19%
set fil20=testpm10.out
move %fil20% %outdir%\%fil20%
set fil21=testpm10_1986.out
move %fil21% %outdir%\%fil21%
set fil22=testpm10_1987.out
move %fil22% %outdir%\%fil22%
set fil23=testpm10_1988.out
move %fil23% %outdir%\%fil23%
set fil24=testpm10_1989.out
move %fil24% %outdir%\%fil24%
set fil25=testpm10_1990.out
move %fil25% %outdir%\%fil25%
set fil26=testpm25.out
move %fil26% %outdir%\%fil26%
set fil27=testprt2.out
move %fil27% %outdir%\%fil27%
set fil28=aermod-baldwin45.out
move %fil28% %outdir%\%fil28%
set fil29=aermod-baldwinHoriz.out
move %fil29% %outdir%\%fil29%
set fil30=aermod-baldwinVert.out
move %fil30% %outdir%\%fil30%
set fil31=Test1_Base_cart_3cond_SNC.out 
move %fil31% %outdir%\%fil31%
set fil32=Test3_Base_cart_3cond_SNC_bar.out 
move %fil32% %outdir%\%fil32%
set fil33=Test4_Base_cart_3cond_SNC_dep.out 
move %fil33% %outdir%\%fil33%
set fil34=Test20_Urban_cart_3cond_SNC.out 
move %fil34% %outdir%\%fil34%
set fil35=bg_no2_arm2_ppb.out
move %fil35% %outdir%\%fil35%
set fil36=bg_no2_arm2_ugm3.out
move %fil36% %outdir%\%fil36%
set fil37=bg_no2_grsm_ppb.out
move %fil37% %outdir%\%fil37%
set fil38=bg_no2_grsm_ugm3.out
move %fil38% %outdir%\%fil38%
set fil39=bg_no2_olm_ppb.out
move %fil39% %outdir%\%fil39%
set fil40=bg_no2_olm_ugm3.out
move %fil40% %outdir%\%fil40%
set fil41=bg_no2_pvmrm_ppb.out
move %fil41% %outdir%\%fil41%
set fil42=bg_no2_pvmrm_ugm3.out
move %fil42% %outdir%\%fil42%
set fil43=bg_no2_ttrm_ppb.out
move %fil43% %outdir%\%fil43%
set fil43=bg_no2_ttrm_ugm3.out
move %fil43% %outdir%\%fil43%
set fil44=blp_urban.out
move %fil44% %outdir%\%fil44%
set fil45=in_urban.out
move %fil45% %outdir%\%fil45%

rem ####  Clean .sav files and final aermod control file
call :clean_other

rem Go back to initial working directory and exit batch file
popd
echo %date% %time% > end.txt


goto :eof

:run_preclean_test_suite
cd %outdir%
del /Q *
Y

goto :eof

:clean_other
del pm10*.sav
del aermod.inp

goto :eof
