      REAL FUNCTION ANGINT( A1, B1, TH1, X1, A2, B2, TH2, X2, X )
C-----------------------------------------------------------------------
C PURPOSE: INTERPOLATE BETWEEN TWO ELLIPSE ORIENTATION ANGLES. THE
C       VALUES ARE SCALED BY THE ECCENTRICITY OF THE ELLIPSES.
C
C LIMITATIONS: NONE
C
C ARGUMENTS:
C  PASSED
C       A1, B1  REAL    MAJOR AND MINOR AXIS LENGTHS OF LOWER ELLIPSE
C       TH1     REAL    ORIENTATION ANGLE [DEG] OF LOWER ELLIPSE
C       X1      REAL    HEIGHT OF LOWER ELLIPSE
C       A2, B2  REAL    MAJOR AND MINOR AXIS LENGTHS OF UPPER ELLIPSE
C       TH2     REAL    ORIENTATION ANGLE [DEG] OF UPPER ELLIPSE
C       X2      REAL    HEIGHT OF UPPER ELLIPSE
C       X       REAL    HEIGHT AT WHICH ANGLE IS DESIRED
C RETURNED FUNCTION VALUE
C       ANGINT  REAL    INTERPOLATED ANGLE [DEG] BETWEEN A1 AND A2
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES:
C       DELWD - FUNCTION RETURNS DIFFERENCE BETWEEN TWO WIND DIRECTIONS
C       UVWD -  FUNCTION WHICH RETURNS METEOROLOGICAL ANGLE GIVEN U, V
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C     DEFINE ARGUMENTS
      REAL A1, B1, TH1, X1, A2, B2, TH2, X2, X
C     DEFINE LOCAL VARIABLES
      REAL ARG1, ARG2, D2R, DA, DX, DX1, DX2, E1, E2, T1, T2, U, V
      DATA D2R/0.01745329/
C     START
      ARG1 = A1*A1 - B1*B1
      IF(ARG1 .LT. 0.0) ARG1 = 0.0
      ARG2 = A2*A2 - B2*B2
      IF(ARG2 .LT. 0.0) ARG2 = 0.0
C
C     ECCENTRICITIES ARE DEFINED IN EQN 7 OF THE TERRAIN PREPROCESSOR
C     USER'S GUIDE
C
      E1 = SQRT(ARG1) / A1
      E2 = SQRT(ARG2) / A2
      DX = X2 - X1
      DX1 = X - X1
      DX2 = X2 - X
      T1 = TH1 * D2R
      T2 = TH2 * D2R
C
C     SEE EQN 11 OF THE TERRAIN PREPROCESSOR USER'S GUIDE
C
      U = (DX2 * E1 * SIN(T1) + DX1 * E2 * SIN(T2)) / DX
      V = (DX2 * E1 * COS(T1) + DX1 * E2 * COS(T2)) / DX
      ANGINT = UVWD(U,V)
C     CHECK FOR U=V=0
      IF( ANGINT .LT. 0.0 ) THEN
          DA = DELWD( TH1, TH2 )
          IF( DX .NE. 0.0 ) THEN
                ANGINT = TH1 + DX1*DA/DX
           ELSE
                ANGINT = TH1 + DA*0.5
          ENDIF
          IF( ANGINT .LT. 0.0 ) THEN
                ANGINT = 360.0 + ANGINT
           ELSE IF( ANGINT .GT. 360.0 ) THEN
                ANGINT = ANGINT - 360.0
          ENDIF
      ENDIF
      RETURN
      END
