      SUBROUTINE FLOW(X,Y,Z,ETA,DEL,THI,TLI,TU,ALF,FR)
C-----------------------------------------------------------------------
C  DESCRIPTION:
C     COMPUTES THE PERTURBATION WINDS UP,VP,WP AT (X,Y,Z) AND
C     COMPUTES THE VERTICAL AND LATERAL DEFLECTIONS (ETA,DEL) OF THE
C     STREAMLINE THAT PASSES THROUGH THE POINT (X,Y,Z) ABOVE THE
C     SURFACE OF A ROTATED GAUSSIAN HILL.
C *** THIS CODE NOW COMPUTES IDYY, AND IXXDYY TO COMPUTE T-FACTORS.
C     TLI    = 1.0 - D(DEL)/DY = 1.0 + (IDYY + BVUI2*IXXDYY)
C     THI    = 1.0 - D(ETA)/DZ = 1.0 + IDZZ
C
C *** THIS STRATIFIED FLOW CALCULATION ACCOUNTS FOR ARBITRARY
C     STRATIFICATION, N/U, (INCLUDING NEUTRAL) IN THE NEAR FIELD
C     OF THE HILL (I.E. X < LX, Y < LY, Z << LX OR LY ).
C *** LINEAR WIND SHEAR CORRECTIONS ARE ADDED IN SUCH THAT NEUTRAL
C     DEFLECTIONS ARE CORRECT TO LOWEST ORDER IN THE SHEAR GRADIENT.
C *** U''/U = 0 IS ASSUMED BUT N/U IS COMPUTED FROM FR ABOVE HC.
C
C ARGUMENTS:
C   PASSED
C       X       REAL    X COORDINATE (POSITIVE DOWNWIND OF HILL CENTER)
C       Y       REAL    Y COORDINATE (POSITIVE LEFT OF HILL CENTER)
C       Z       REAL    Z COORDINATE (POSITIVE ABOVE HILL SURFACE)
C   RETURNED
C       ETA     REAL    VERTICAL DEFL. OF STREAMLINE PASSING (X,Y,Z)
C       DEL     REAL    LATERAL DEFLECTION OF STREAMLINE PASSING (X,Y,Z)
C       TLI     REAL    1.0/(TL FACTOR) AT (X,Y,Z)
C       THI     REAL    1.0/(TH FACTOR) AT (X,Y,Z)
C       TU      REAL    TU FACTOR AT (X,Y,Z)
C
C CALLING ROUTINES: LIFT  PATH
C
C EXTERNAL ROUTINES: HILHGT
C
C INTRINSIC FUNCTIONS:
C
C INCLUDE FILES:
C
C COMMON BLOCKS:
C----------------------------------------------------------------------C
C
      INCLUDE 'PARAMS.INC'
C      INCLUDE 'PARAMS.CMN'
      INCLUDE 'CONST.CMN'
      INCLUDE 'PASL.CMN'
C      INCLUDE 'VARS.CMN'
C
C  DEFINE ARGUMENTS
      REAL   ALF, DEL, ETA, FR, THI, TLI, TU, X, Y, Z

C  DEFINE LOCAL VARIABLES
      REAL  AD0, AD1, AD2, ADD2, ADD0, ADD1, AF0, AF1, AF2, 
     1      AF2SHR, ARG, ARGRT, AST, ASTDS2, B0, B02, B0N, 
     2      B0N2, BVUI, BVUI2, CSZ, DELC, DELCOR, DELDY, DELDYY, 
     3      EFAC, EPS, EXPARG, FOUR, GAMLX, GAMLX2, GAMP, GAMP2, 
     4      G0X, G0XX, G1X, G1XX,  HALF, HASYM, HH0, HH1, HH2, 
     5      HHLX2E, HHM, HHXY, HHXYM, ONE, PII, RNLZ, QX, RTDELC, 
     6      RTPII, S, S2, SHRC, SHRF, SHRFDZ, SI, SSZ, SUM, SZ, 
     7      TERM1, TERM2, TERM3, THREE, T0, T1, T2, TI0, TI1, 
     8      TI2, TWO, TZFAC, TZFDZ, TZFDZZ, U, UI, U0, UP, UTOT, 
     9      VP, WP, WTB, XDLX, XM, XMDLX, XMDLX2, YDLY, YDLY2, 
     A      YM, YMDLY, YMDLY2, ZERO, ZFACI, ZFACDZ


      REAL*4 LXI,LYI,LXI2,LYI2,LYI3,LZ,LZI,LN,LNI
      REAL*4 I,IDY,IDZ,IDX,IDXX,IDXY,IDXZ
      REAL*4 IX,IXDY,IXX,IXXDY,IDYY,IDZZ,IXXDYY,ID3Y,IXXD3Y
      DATA ZERO/0.0/,ONE/1.0/,TWO/2.0/,THREE/3.0/,FOUR/4.0/
      DATA HALF/0.5/,B0N/1.25/,RNLZ/0.69315/
      DATA WTB/1.25/
C
C *** MOST OF THIS CODE COMPUTES I AND ITS INTEGRALS AND DERIVATIVES.
C     THE NOTATION IS SEEN IN THE EXAMPLE IXDY, WHICH IS I INTEGRATED
C     ONCE IN X (FROM -INFINITY TO X) AND DIFFERENTIATED IN Y.
C
      PII = ONE / PI
      RTPII = ONE / SQRPI
C *** COMPUTE NEEDED LENGTH SCALE FACTORS.
      LXI = ONE / LX
      LXI2 = LXI * LXI
      LYI = ONE / LY
      LYI2 = LYI * LYI
      LYI3 = LYI2 * LYI
      LZI = SQRT(HALF * (LXI2 + LYI2) ) / RNLZ
      LZ  = ONE / LZI
      LN  = HALF * SQRPI * LZ
      LNI = ONE / LN
      XDLX = X * LXI
      YDLY = Y * LYI
      YDLY2 = YDLY * YDLY
C
C *** COMPUTE THE MODIFIED COORDINATES XM,YM AND THEIR
C     DIMENSIONLESS FORMS XMDLX,YMDLY.
      XM = X + GAM*LX*LX*Y
      YM = Y + GAM*LY*LY*X
      XMDLX = XM * LXI
      XMDLX2 = XMDLX * XMDLX
      YMDLY = YM * LYI
      YMDLY2 = YMDLY * YMDLY
C
      GAMLX = GAM * LX
      GAMLX2 = GAMLX * GAMLX
      GAMP = ONE - GAMLX2*LY*LY
      GAMP2 = GAMP * GAMP
C
C     HHXY = HH * HILHGT(X,Y)   BUT COMPUTE IN CODE BELOW.
      ARG = XDLX*XDLX + YDLY*YDLY + 2.0*GAM*X*Y
      IF(ARG .GT. 30.) ARG = 30.
      EXPARG = EXP(-ARG)
      HHXY = HH * EXPARG
C
C *** OBTAIN CORRECT WIND SPEED, U, USING SPEED
C
      U = SPEED(HHXY+Z)
      UI = ONE / U
C
C     COMPUTE THE SHEAR FACTORS THAT ARE NEEDED.
C
      U0 = AMIN1(SPEED(HHXY),U)
      SHRF = SQRT(U0*UI)
      SHRFDZ = -HALF * ALF * UI
      SHRC=HALF*ALF/U0
C *** COMPUTE THE ADDITIONAL Z SUPRESSION FACTOR FROM NEUTRAL FLOW MATCH
      ZFACI = ONE / (ONE + LNI * Z)
      ZFACDZ = -TWO * LNI * ZFACI
C *** COMBINE WITH SHEAR FACTOR TO GIVE TOTAL Z ADJUSTMENT FACTOR.
      TZFAC = SHRF * ZFACI * ZFACI
      TZFDZ = SHRFDZ + ZFACDZ
      TZFDZZ = TZFDZ*TZFDZ - SHRFDZ*ALF*UI - ZFACDZ*LNI*ZFACI
C
C     COMPUTE THE HILL ASYMMETRY FACTOR HASYM. ....EQN. A-19B
      HASYM = SQRT(1.0+LX*LX*LYI2)
      IF(HASYM .GT. SQR2) HASYM = SQR2
C *** COMPUTE CORRECTED STRATIFICATION, S.
      BVUI = ONE/(FR*HH)
      IF(FR .GT. 50.) BVUI=0.
      BVUI2 = BVUI * BVUI
      S = BVUI * HASYM
      S2 = S*S
      B0N2 = B0N * B0N
      B0 = S * LZ * RTPII * B0N
      B02 = B0 * B0
C
      AST = TWO * RTPII * S2 * LZ * PII * B0N2 - SHRC
C --- ASTDS2 IS ACTUALLY AST/(S*BVUI)
      ASTDS2 = TWO * RTPII * LZ * PII * HASYM
C --- HHM IS THE COEFFICIENT OF I AT X=Y=0
      HHM = HH * LN / (ONE + B02)
C --- HHXYM IS THE COEFFICIENT OF I AWAY FROM HILL CREST
      HHXYM = HHM * EXPARG
C *** COMPUTE THE STRATIFICATION HEIGHT, SZ.
      SZ = S * Z
C
C *** COMPUTE THE VARIOUS 'ANGULAR FACTORS', AFN, AND THEIR DERIVATIVES,
C     ADN, CONDITIONED ON THE VALUE OF SZ.
      IF(SZ .LE. 0.005) THEN
         CSZ = ONE
         SSZ = SZ
         AF1 = Z
         AD1 = ONE
         ADD1 = S * SZ
      ELSE
         SI  = ONE / S
         CSZ = COS(SZ)
         SSZ = SIN(SZ)
         AF1 = SSZ * SI
         AD1 = CSZ
         ADD1 = -S * SSZ
      ENDIF
C
C     AF0 = CSZ / ZFACI
C     AD0 = LNI * CSZ  -  S * SSZ / ZFACI
C *** OVERRIDE AF0=CSZ WITH AF0=ONE. 10/8/86
      AF0 = ONE / ZFACI
      AD0 =  LNI
      ADD0 = -S2 / ZFACI
      AF2SHR = TWO * LNI + SHRC
      AF2 = S * CSZ + AF2SHR * SSZ
      AD2 = -S2 * SSZ + AF2SHR * S * CSZ
      ADD2 = -S2 * (S * CSZ + AF2SHR * SSZ)
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR I.
      T0 = ONE
      T1 = -AST
C ??? T2 = -ASTDS2*XMDLX
C ---------- TRY SETTING T2=0. FOR XM LESS THAN ZERO ------------
      T2 = 0.
      IF(XM .GE. 0.) T2 = -ASTDS2*XMDLX
C
      TI0 = T0 * AF0
      TI1 = T1 * AF1
      TI2 = T2 * AF2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE BASIC QUANTITY I.   ....EQN. A-27
      I = TZFAC * HHXYM * SUM
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDZ.
      TI0 = T0 * AD0
      TI1 = T1 * AD1
      TI2 = T2 * AD2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE DERIVATIVE OF I WITH RESPECT TO Z.  ....EQN. A-28
      TERM1 = TZFAC * HHXYM * SUM
      IDZ =  TERM1  +  TZFDZ * I
C
C *** COMPUTE THE SECOND DERIVATIVE OF I WITH RESPECT TO Z.
      TI0 = T0 * ADD0
      TI1 = T1 * ADD1
      TI2 = T2 * ADD2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE SECOND DERIVATIVE OF I WITH RESPECT TO Z. ....EQN.A-29
      IDZZ = TZFAC * HHXYM * SUM  +  TWO * TZFDZ * TERM1  +  TZFDZZ * I
C
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDX AND IDXZ.
C     T0 = ZERO
C     T1 = ZERO
      T2 = -ASTDS2 * LXI
C
C     TI0 = T0 * AF0
C     TI1 = T1 * AF1
      TI2 = T2 * AF2
C     SUM = TI0 + TI1 + TI2
      SUM = TI2
C
C *** COMPUTE THE QUANTITY IDX.    ....EQN. A-30
      TERM2 = TZFAC * HHXYM * SUM
      IDX = -TWO * XMDLX * LXI * I  +  TERM2
C
C     NOW COMPUTE THE D/DZ TERMS.
C     TI0 = T0 * AD0
C     TI1 = T1 * AD1
      TI2 = T2 * AD2
C     SUM = TI0 + TI1 + TI2
      SUM = TI2
C
C *** COMPUTE THE DERIVATIVE OF IDX WITH RESPECT TO Z.  ....EQN. A-32
      TERM3 = TZFAC*HHXYM*SUM
      IDXZ = -TWO*XMDLX*LXI*IDZ + TZFDZ*TERM2 + TERM3
C
C
C *** COMPUTE THE QUANTITIES NEEDED FOR IDXX.
C     T0 = ZERO
C     T1 = ZERO
C     T2 = ZERO
C
C     TI0 = T0 * AF0
C     TI1 = T1 * AF1
C     TI2 = T2 * AF2
C     SUM = TI0 + TI1 + TI2
      SUM = ZERO
C
C *** COMPUTE THE QUANTITY IDXX.  ....EQN. A-31
      IDXX = -TWO * LXI2 * (ONE + TWO * XMDLX2) * I  -
     X       FOUR * XMDLX * LXI * IDX  +  TZFAC * HHXYM * SUM
C
C
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IDY.
C     T0 = ZERO
C     T1 = ZERO
      T2 = -ASTDS2 * GAMLX
C
C     TI0 = T0 * AF0
C     TI1 = T1 * AF1
      TI2 = T2 * AF2
C     SUM = TI0 + TI1 + TI2
      SUM = TI2
C
C *** COMPUTE THE QUANTITY IDY.   ....EQN. A-33
      IDY = -TWO * LYI * YMDLY * I  +  TZFAC * HHXYM * SUM
C
C *** COMPUTE THE QUANTITY IDYY.  ....EQN. A-34
      IDYY = -TWO * LYI2 * (ONE + TWO * YMDLY2) * I  -
     X       FOUR * YMDLY * LYI * IDY
C
C *** COMPUTE THE QUANTITY ID3Y.  ....EQN. A-35
      ID3Y = -8.0 * LYI3 * YMDLY * I  -  FOUR * LYI * YMDLY * IDYY  -
     X       TWO * LYI2 * (THREE + TWO * YMDLY2) * IDY
C
C
C *** COMPUTE THE QUANTITIES NEEDED FOR IDXY.
C     T0 = ZERO
C     T1 = ZERO
C     T2 = ZERO
C
C     TI0 = T0 * AF0
C     TI1 = T1 * AF1
C     TI2 = T2 * AF2
C     SUM = TI0 + TI1 + TI2
      SUM = ZERO
C
C *** COMPUTE THE QUANTITY IDXY.     ....EQN. A-36
      IDXY = -TWO * (GAM  +  TWO * XM * YM * LXI2 * LYI2) * I  -
     X       TWO * XMDLX * LXI * IDY  -
     X       TWO * YMDLY * LYI * IDX  +  TZFAC * HHXYM * SUM
C
C
C ****************************************************************
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXXDY.
C     NOTE THAT IXX IS ALSO NEEDED FOR THIS.
C
C --- COMPUTE THE GNX AND GNXX FACTORS.
C $$$ G0X = HALF * SQRPI * ( ONE + ERF(XMDLX) )
C --- INSERT THE FOLLOWING FIX TO KILL LAT. DEFL. GROWTH. 10/1/86
      G0X = HALF * SQRPI * ( ONE - ERF( ABS(XMDLX) )  )
C
      IF(XMDLX2 .GT.30.) XMDLX2 = 30.
      G1X = -HALF * EXP(-XMDLX2)
      G0XX = XMDLX * G0X - G1X
      G1XX = -HALF * G0X
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXX.
      T0 = G0XX
      T1 = -G0XX
      T1 = AST * T1
      T2 = -ASTDS2*G1XX
C
      TI0 = T0 * AF0
      TI1 = T1 * AF1
      TI2 = T2 * AF2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE QUANTITY IXX.      ....EQN. A-42
C     QX = YDLY2 - GAMLX2 * Y * Y
      QX = YDLY2 * GAMP
      IF(QX .GT.30.) QX = 30.
      EFAC = EXP(-QX)
      HHLX2E = HHM * LX * LX * EFAC
      IXX = TZFAC * HHLX2E * SUM
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXXDY.
      T0 = GAMLX*G0X
      T1 = -GAMLX*G0X
      T1 = AST * T1
      T2 = -ASTDS2*GAMLX*G1X
C
      TI0 = T0 * AF0
      TI1 = T1 * AF1
      TI2 = T2 * AF2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE QUANTITY IXXDY.     ....EQN. A-44
      IXXDY = -TWO * LYI2 * Y * GAMP * IXX  +  TZFAC * HHLX2E * SUM
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IX.
      T0 = +G0X
      T1 = -G0X
      T1 = AST * T1
      T2 = -ASTDS2*G1X
C
      TI0 = T0 * AF0
      TI1 = T1 * AF1
      TI2 = T2 * AF2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE QUANTITY IX.     ....EQN. A-41
      IX = TZFAC * HHLX2E * LXI * SUM
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXDY.
C     HHJ = GAMLX * EXP(-XMDLX2) * XMDLX**J  BUT SEE G1X
      HH0 = -TWO * G1X * GAMLX
      HH1 = HH0 * XMDLX
      HH2 = HH1 * XMDLX
      T0 = HH0
      T1 = -HH0
      T1 = AST * T1
      T2 = -ASTDS2*HH1
C
      TI0 = T0 * AF0
      TI1 = T1 * AF1
      TI2 = T2 * AF2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE QUANTITY IXDY.        ....EQN. A-45
      IXDY = -TWO * LYI2 * Y * GAMP * IX  +  TZFAC * HHLX2E * LXI * SUM
C
C
C *** COMPUTE THE QUANTITY IXXDYY       ....EQN. A-46
C     (NOTE THAT IXXDYY USES THE SAME SUM AS IXDY)
      IXXDYY = -TWO * LYI2 * GAMP * IXX * (ONE + TWO*GAMP*YDLY2) -
     X          FOUR * LYI2 * Y * GAMP * IXXDY  +
     X          TZFAC * HHLX2E * GAMLX * SUM
C
C
C *** COMPUTE THE VARIOUS INTEGRAL TERMS FOR IXXD3Y.
      T0 = -TWO * HH1
      T1 = +TWO * HH1
      T1 = AST * T1
      T2 = -ASTDS2 * (HH0 - TWO*HH2)
C
      TI0 = T0 * AF0
      TI1 = T1 * AF1
      TI2 = T2 * AF2
      SUM = TI0 + TI1 + TI2
C
C *** COMPUTE THE QUANTITY IXXD3Y.        ....EQN. A-47
      IXXD3Y = -FOUR*LYI3*GAMP2*IXX*YDLY*(THREE+TWO*GAMP*YDLY2) -
     X          6.0 * LYI2 * GAMP * IXXDY * (ONE+TWO*GAMP*YDLY2)  -
     X          6.0 * LYI * GAMP * YDLY * IXXDYY  +
     X          TZFAC * HHLX2E * GAMLX2 * SUM
C
C ************************************************************
C *** COMPUTE THE STREAMLINE DEFLECTIONS.
C *** COMPUTE THE VERTICAL DEFLECTION AS -(D/DZ) I.  ....EQN. A-22A
      ETA = -IDZ
C *** NOW COMPUTE THE LATERAL DEFLECTION AS          ....EQN. A-22E
C     DEL = -(D/DY)(IDY+BVUI2*IXX) = -(IDY + BVUI2*IXXDY)
C *** AND COMPUTE ITS FIRST AND SECOND DERIVATIVES
      TERM3 = BVUI2 * IXXDY
      DEL = -(IDY + TERM3)
      DELDY = -IDYY - BVUI2*IXXDYY
      DELDYY = -ID3Y - BVUI2*IXXD3Y
C *** COMPUTE CORRECTION FACTOR FOR LATERAL DEFLECTIONS
      DELC = ONE + ABS(DELDY)
      DELCOR = DELC
      IF(ABS(DEL).LT.0.001*LY) THEN
         DELCOR = ONE
      ELSEIF(ABS(DELDYY*LY) .GT. 0.001) THEN
         EPS = WTB*DELDYY*DEL
         ARGRT = DELC*DELC-TWO*EPS
         RTDELC = 0.
         IF(ARGRT .GE. 0.) RTDELC = SQRT(ARGRT)
         IF(RTDELC .NE. DELC) DELCOR = EPS/(DELC-RTDELC)
      ENDIF
C *** APPLY CORRECTION FACTOR
      DEL = DEL / DELCOR
C
C *** COMPUTE THE RECIPROCAL OF THE T FACTORS      ....EQNS. A-22F,G
C *** NOTE THAT THE T FACTORS COULD GO TO INFINITY.
      TLI = ONE - DELDY/DELCOR
      THI = ONE + IDZZ
C
C ****************************************************************
C
C *** COMPUTE THE PERTURBATION VELOCITIES.   ...EQNS. A-22B,C,D
C
C *** NOW COMPUTE THE ALONG-WIND VELOCITY PERTURBATION AS
C     UP/U = -(IDXX + (BV*UI)**2 * I )
C     NOTE THAT THIS IS JUST THE NEGATIVE OF THE PERTURBATION
C     PRESSURE DIVIDED BY RHO(0)*U**2.
      TERM3 = BVUI2 * I
      UP = -(IDXX + TERM3)
C *** COMPUTE THE NON-LINEAR PERTURBATION ALA HUNT ET AL.
C!!!!!UPNL = ( -ONE + SQRT( ABS(ONE + TWO*UP) )  ) * U
      UP = UP * U
C
C *** NOW COMPUTE THE LATERAL VELOCITY PERTURBATION AS
C     VP/U = -(IDXY + (BV*UI)**2 * IXDY)
      TERM3 = BVUI2 * IXDY
      VP = -(IDXY + TERM3) * U
C
C *** NOW COMPUTE THE VERTICAL VELOCITY PERTURBATION AS -(D/DZ) IDX.
      WP = -IDXZ * U
C
C ***********************************************************
C
C *** COMPUTE THE "SPEED-UP" FACTOR TU
      UTOT=SQRT( (U+UP)*(U+UP) + VP*VP + WP*WP )
      TU = UTOT*UI
C
C ***********************************************************
C
      RETURN
      END
