        REAL FUNCTION GETWS(Z2)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE COMPUTES THE WIND SPEED AT HEIGHT Z2.
C
C ARGUMENTS
C  PASSED:
C       Z2      REAL    HEIGHT (M)
C  RETURNED FUNCTION VALUE:
C       GETWS   REAL    WIND SPEED (M/S)
C
C I/O: NONE
C
C CALLING ROUTINES: BULKFR GETUV HCRIT PLAVG SEQMOD SRISE URISE
C
C EXTERNAL ROUTINES: KLOSE
C
C INTRINSIC FUNCTIONS: ALOG  ATAN
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET PROFIL
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'SFCMET.CMN'
      INCLUDE   'PROFIL.CMN'
C
C       DEFINE ARGUMENTS
        REAL    Z2
C
C       DEFINE LOCAL VARIABLES
        INTEGER LEV, N, NNEW
        REAL    U1,     Z1,     Z1L,    Z2L,    Z1Z0,   Z2Z0,
     1          PSIU1,  PSIU2,  X,      WSNEW(MAXLEV), SFCLH,
     2          HTNEW(MAXLEV), WSMISS, U3, Z3, DX, DZ
        DATA    WSMISS/ 0.0/
C

C    IF THIS IS AN UNSTABLE HOUR (-100<EL<0), THEN ONLY ALLOW PROFILING
C    IN THE SURFACE LAYER,  DEFINE SURFACE LAYER (SFCLH) TO BE THE LARGER
C    OF 0.1 * Zi AND 2*ABS(L), BUT DON'T EXCEED 200 M
        IF (EL .LT. 0 .AND. EL .GT. -100) THEN
          SFCLH = AMIN1(AMAX1(2*ABS(EL),(.1*XMH)),200.0)
        ELSE
          SFCLH = XMH
        ENDIF

C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        NNEW = 0
        DO 100 N = 1,NHT
           IF(WSHR(N) .LT. WSMISS ) GO TO 100
           NNEW = NNEW + 1
           WSNEW(NNEW) = WSHR(N)
           HTNEW(NNEW) = HT(N)
100     CONTINUE
        IF(NNEW .EQ. 0) GO TO 200
        LEV=KLOSE(HTNEW,NNEW,Z2)
        IF(LEV .EQ. 0) THEN
            Z1 = HTNEW(1)
            U1 = WSNEW(1)
          ELSE
            Z1 = HTNEW(LEV)
            U1 = WSNEW(LEV)
        ENDIF
C
C       Z1 IS MEASUREMENT HEIGHT CLOSEST TO BUT LESS THAN Z2.
C       USE INTERPOLATION IF POSSIBLE; OTHERWISE, USE PROFILING.
C
        IF(LEV.GE.1 .AND. LEV.LT.NNEW) THEN
            U3 = WSNEW(LEV+1)
            Z3 = HTNEW(LEV+1)
            DX = U3 - U1
            DZ = Z3 - Z1
            GETWS = U1 + (Z2-Z1)*(DX/DZ)
            RETURN
        ENDIF


C       IF BOTH Z1 AND Z2 ARE ABOVE SURFACE LAYER, USE THE MEASUREMENT 
C       WITHOUT SCALING.
C
        IF(Z1 .GT. SFCLH .AND. Z2 .GT. SFCLH) THEN
            GETWS = U1
            RETURN
        ENDIF
C
C       USE PROFILE EQUATIONS IF EITHER Z1 OR Z2 IS BELOW SURFACE LAYER
C       (NO WIND SPEED INCREASE IS ASSUMED ABOVE SURFACE LAYER)
C
        Z1L = Z1/EL
        Z1Z0 = ALOG(Z1/Z0)
C
        IF (Z1 .GT. SFCLH) THEN
          Z1L = SFCLH/EL
          Z1Z0 = ALOG(SFCLH/Z0)
        ENDIF

        IF(Z1L .LT. 0.0) THEN
            X = (1.0 - 15.0*Z1L)**0.25
            PSIU1 = 2.0 * ALOG(0.5*(1.0+X)) + ALOG(0.5*(1.0+X*X)) -
     X          2.0*ATAN(X) + 1.5707963
          ELSE
            PSIU1 = -4.7*Z1L
        ENDIF
C
200     Z3 = AMAX1(Z0,Z2)
        Z2L = Z3/EL
        Z2Z0 = ALOG(Z3/Z0)

        IF (Z3 .GT. SFCLH) THEN
          Z2L = SFCLH/EL
          Z2Z0 = ALOG(SFCLH/Z0)
        ENDIF

        IF(Z2L .LT. 0.0) THEN
            X = (1.0 - 15.0*Z2L)**0.25
            PSIU2 = 2.0 * ALOG(0.5*(1.0+X)) + ALOG(0.5*(1.0+X*X)) -
     X          2.0*ATAN(X) + 1.5707963
          ELSE
            PSIU2 = -4.7*Z2L
        ENDIF
C
        IF(NNEW.EQ.0) THEN
            GETWS = (USTAR0/0.4) * (Z2Z0 - PSIU2)
          ELSE
            GETWS = U1 * (Z2Z0 - PSIU2)/(Z1Z0 - PSIU1)
        ENDIF
C
        RETURN
        END
