        REAL FUNCTION HCRIT(HHILL,XMH)
C-----------------------------------------------------------------------
C PURPOSE: COMPUTE CRITICAL DIVIDING STREAMLINE HEIGHT FOR CURRENT HILL
C
C LIMITATIONS:
C
C ARGUMENTS:
C   PASSED:
C       HHILL   REAL    HEIGHT OF TOP OF HILL [METERS]
C   RETURNED FUNCTION VALUE:
C       HCRIT   REAL    CRITICAL DIVIDING STREAMLINE HEIGHT [METERS]
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: KLOSE  GETTA  GETWS
C
C INTRINSIC FUNCTIONS: SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: PROFIL.CMN  SFCMET.CMN
C
C-----------------------------------------------------------------------
C
      INCLUDE 'PARAMS.INC'
      INCLUDE 'PROFIL.CMN'
C      INCLUDE 'SFCMET.CMN'

C       DEFINE ARGUMENTS
        REAL HHILL, XMH

C       DEFINE LOCAL VARIABLES
        REAL A, AC4, B, B2, C, DETER, G, HBOT, HTOP, LS(MAXLEV), 
     1       RS(MAXLEV), WSHC(MAXLEV), TAHC(MAXLEV),
     2       DTHHC(MAXLEV), ZZ(MAXLEV), XN2(MAXLEV), N2, DWS, 
     3       DWS2, ZMIX(3), ZMID
        INTEGER I, IADD, IB, IK, IT, K, NL, NLEV
        DATA G/9.8/
C
C       COMPUTE HEIGHTS WITHIN THE SURFACE LAYER FOR ADDITIONAL LAYER
C       RESOLUTION FOR COMPUTING HCRIT.  IF THE LOWEST MEASUREMENT
C       HEIGHT IS ABOVE ANY OF THESE HEIGHTS, ADD TO THE LIST OF
C       HEIGHTS FOR LAYER-BY-LAYER ANALYSIS.
C
C       ADD LAYERS AT 0.25, 0.50, AND 1.0 XMH
C
        ZMIX(1) = 0.25 * XMH
        ZMIX(2) = 0.50 * XMH
        ZMIX(3) = 1.00 * XMH
        IADD = 1
        ZZ(1) = 1.0
C
C       INSERT NEW LEVELS IN MEASUREMENT HEIGHT ARRAY
C
        DO 100 I = 1,3
            IF(ZMIX(I) .LT. HT(1)) THEN
                IADD = I + 1
                ZZ(IADD) = ZMIX(I)
            ENDIF
100     CONTINUE
        K = KLOSE(HT, NHT, HHILL)
        NLEV = K + IADD + 1
        ZZ(NLEV) = HHILL
        DO  200  IK = 1, K
                ZZ(IK+IADD) = HT(IK)
200     CONTINUE
C
C     COMPUTE LEFT SIDE OF EQN 32 IN USER'S GUIDE
C
        DO  400  NL = 1, NLEV
                WSHC(NL) = GETWS(ZZ(NL))
                LS(NL) = 0.5 * WSHC(NL) * WSHC(NL)
400     CONTINUE
C
C      COMPUTE RIGHT SIDE OF EQN 32 FOR EACH LAYER, INTEGRATING
C      DOWNWARD IN LAYERS FROM THE HILL TOP.  A LINEAR CHANGE IN
C      METEOROLOGICAL VARIABLES IS ASSUMED IN EACH LAYER.
C
        RS(NLEV) = 0.0
        DO  600  NL = NLEV-1, 1, -1
                ZMID = 0.5 * (ZZ(NL+1)+ZZ(NL))
                TAHC(NL) = GETTA(ZMID)
                DTHHC(NL) = GETDTH(ZMID,XMH)
                XN2(NL) = G / TAHC(NL) * DTHHC(NL)
                RS(NL) = RS(NL+1) +
     &                  XN2(NL) * ((HHILL-ZMID) * (ZZ(NL+1)-ZZ(NL)))
600     CONTINUE
C
C      FIND LAYERS WHERE EQN 32 IS SATISFIED; THE LOWEST SUCH LAYER IS
C      SAVED IN THE "IT" VARIABLE
C
        DO  800  NL = NLEV, 1, -1
                IF(LS(NL) .GE. RS(NL)) IT = NL
800     CONTINUE
C
C      INTERPOLATE TO GET HC, ASSUMING A LINEAR CHANGE OF VARIABLES
C      WITHIN A LAYER; RESULT IS A QUADRATIC EQN FOR HC
C
C      DWS IS WIND SPEED SHEAR; N2 IS THE BRUNT-VAISALA FREQUENCY.
C
        IF(IT .GT. 1) THEN
                IB = IT - 1
                HTOP = ZZ(IT)
                HBOT = ZZ(IB)
                DWS = (WSHC(IT)-WSHC(IB))/(HTOP-HBOT)
                DWS2 = DWS * DWS
                N2 = XN2(IB)
C
C      SOLVE QUADRATIC EQN
C
                A = 0.5 * (N2 - DWS2)
                B = (HTOP*DWS2 - WSHC(IT)*DWS - N2*HHILL)
                C = N2*HHILL*HTOP -
     &                  0.5*(N2*HTOP*HTOP) -
     &                  0.5*(DWS2*HTOP*HTOP) +
     &                  WSHC(IT)*DWS*HTOP - (LS(IT)-RS(IT))
                B2 = B * B
                AC4 = 4.0 * A * C
                DETER = SQRT(B2-AC4)
                HCRIT = (-B - DETER)/(2.*A)
          ELSE
                HCRIT = 0.0
        ENDIF
        RETURN
        END
