      SUBROUTINE HILROT( AH, BH, PSI )
C----------------------------------------------------------------------
C PURPOSE:  COMPUTES THE NEEDED LENGTH SCALES LX AND LY AND THE
C     FACTOR GAM FOR A GAUSSIAN HILL HAVING MAJOR AXIS AH, MINOR AXIS
C     BH, AND ROTATED CCW BY AN ANGLE PSI.
C     WHEN PSI=0 THE MINOR AXIS IS ORIENTED ALONG THE X-AXIS (OR FLOW
C     DIRECTION) AND THE MAJOR AXIS LIES ALONG THE Y-AXIS.
C
C ARGUMENTS:
C    PASSED:
C       AH, BH  REAL    MAJOR AND MINOR HILL SEMI-AXIS LENGTHS (M)
C       PSI     REAL    ANGLE OF ROTATION (RADIANS)
C    RETURNED: NONE
C
C I/O: NONE
C
C CALLING ROUTINES: LIFTIN
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: COS SIN SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: PASL
C
C----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'PASL.CMN'
C
C       DEFINE ARGUMENTS
      REAL      AH, BH, PSI
C
C       DEFINE LOCAL VARIABLES
      REAL      CPSI, CPSI2, LAI2, LBI2, LXI2, LYI2, SPSI, SPSI2
C
C                             ....EQN. A-25
      CPSI = COS(PSI)
      CPSI2 = CPSI*CPSI
      SPSI = SIN(PSI)
      SPSI2 = SPSI*SPSI
      LAI2 = 1.0 / (AH*AH)
      LBI2 = 1.0 / (BH*BH)
C
      GAM = (LBI2-LAI2)*CPSI*SPSI
      LXI2 = CPSI2*LBI2 + SPSI2*LAI2
      LX = 1.0 / SQRT(LXI2)
      LYI2 = CPSI2*LAI2 + SPSI2*LBI2
      LY = 1.0 / SQRT(LYI2)
C
      RETURN
      END
