        SUBROUTINE INPREC
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE IS RESPONSIBLE FOR READING THE RECEPTOR DATA
C
C LIMITATIONS:
C       A MAXIMUM OF 'MAXREC' RECEPTORS
C
C ARGUMENTS
C   PASSED: NONE
C   RETURNED: NONE
C
C I/O:
C  INPUT: UNIT=INREC
C
C       LINE  VARIABLE  COLUMNS FORMAT  DESCRIPTION
C
C         1      NAME      1-16   A16   RECEPTOR NAME
C                   X     21-30   F10.0 X-COORD (USER HORIZONTAL UNITS)
C                   Y     31-40   F10.0 Y-COORD (USER HORIZONTAL UNITS)
C                   Z     41-50   F10.0 HT ABOVE GROUND (USER VERTICAL
C                                               UNITS)
C                  GE     51-60   F10.0 GROUND ELEVATION (USER VERTICAL
C                                               UNITS)
C                  NH     61-65     I5  HILL NUMBER FOR THIS RECEPTOR
C
C  OUTPUT: UNIT=IOUT
C       PRINTOUT OF INPUT RECEPTOR DATA
C
C CALLING ROUTINES: CTDMPLUS (MAIN)
C
C EXTERNAL ROUTINES: PAGE
C
C INTRINSIC FUNCTIONS: MOD
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: IO  HEAD  PARAMS RECEPT STACKS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
C      INCLUDE   'HEAD.CMN'
      INCLUDE   'PARAMS.CMN'
      INCLUDE   'RECEPT.CMN'
      INCLUDE   'STACKS.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL    X, Y, Z, ZS, GE
        INTEGER NH, NR, NO, YES, FLAT
        CHARACTER*16    NAME
        DATA    NO/0/, YES/1/, FLAT/0/
C
        NR = 0
        NRFLAT = NO
        ZS = SOURCE(3,1)
C       LOOP ON RECEPTOR INPUT LINES, TERMINATE ON EOF
100     CONTINUE
            READ(INREC, 1010, END=900) NAME,X,Y,Z,GE,NH
            NR = NR + 1
            IF(NR .GT. MAXREC) GO TO 991
            RECPT(1,NR)=X*HORIZ
            RECPT(2,NR)=Y*HORIZ
            RECPT(3,NR)=Z*VERT
C
C           USE MINIMUM OF TOWER BASE AND LOWEST STACK BASE ELEVATION AS
C           MODEL BASE ELEVATION (ZS)
C
C           RECPT(4,NR) IS THE ELEVATION OF THE RECEPTOR ABOVE THE MODEL
C           BASE ELEVATION
C
            RECPT(4,NR)=GE*VERT - ZS
            NRHILL(NR) = NH
C           RECEPTORS ON FLAT TERRAIN FLAG
            IF(NH .EQ. FLAT) NRFLAT = YES
C           PRINTOUT SECTION
            IF(MOD(NR,40) .EQ. 1) THEN
                IF( NR .NE. 1 ) WRITE(IOUT,6030) HORIZ,VERT
C                    FOOTNOTE AND NEW PAGE
                CALL PAGE(YES)
                WRITE(IOUT,6000)
            ENDIF
            IF(MOD(NR,10) .EQ. 1) WRITE(IOUT, 6010)
            WRITE(IOUT, 6020) NR,NAME,X,Y,Z,GE,NH
        GO TO 100
C       END RECEPTOR INPUT LOOP
900     NRECPT = NR
C       FOOTNOTE
        WRITE(IOUT,6030)HORIZ,VERT
        RETURN
C
C       ERROR SECTION
C
991     WRITE(IOUT,9910) MAXREC
        STOP
C       FORMAT SECTION
1010    FORMAT(A16,4X,4F10.0,I5)
6000    FORMAT(/,27X,'      RECEPTOR INFORMATION',//,
     &  ' REC   IDENTIFICATION    EAST      NORTH  HEIGHT  ABOVE   ',
     &  'GRD LVL',/,
     &  ' NO.                     COORD     COORD  LOCAL GRD LVL  ',
     &  'ELEVATION     HILL',/,
     &  '                           (USER UNITS)    (USER UNITS) ',
     &  '(USER UNITS)  NUMBER',/,
     &  ' ---  ----------------  -------- -------- -------------  ',
     &  '----------   ------')
6010    FORMAT(' ')
6020    FORMAT(I4,2X,A16,1X,F9.2,F9.2,5X,F7.1,5X,F7.1,7X,I2)
6030    FORMAT(' ---------------------------------------------',/,
     1  '   MULTIPLY HORIZONTAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     2          'TO METERS',/,
     3  '   MULTIPLY VERTICAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     4          'TO METERS')
9910    FORMAT(//' ***** RECEPTOR INPUT ERROR *****'/' MAXIMUM ',
     1  ' NUMBER OF RECEPTORS EXCEEDED:  MAXREC=',I4)
        END
