        SUBROUTINE INPSOR
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE IS RESPONSIBLE FOR READING THE SOURCE PARAMETERS
C          (NOTE: EMISSIONS VARYING HOURLY ARE READ BY THE SUBROUTINE
C           INPEMS.  THIS ROUTINE READS THE NONVARYING PARAMETERS FOR
C           EACH SOURCE SUCH AS LOCATION, STACK HEIGHT, ETC.
C
C ASSUMPTIONS:  STACK BASES AND HEIGHTS ARE ADJUSTED TO A COMMON BASE
C               ELEVATION, (EITHER THE LOWEST STACK BASE OR THE MET
C               TOWER BASE). THIS THEN BECOMES THE MODEL BASE HEIGHT.
C               SET VARIABLE EMISSIONS FLAG IEMIS HERE
C
C LIMITATIONS:
C       A MAXIMUM OF 'MAXSOR' SOURCES (SEE PARAMS.INC)
C
C ARGUMENTS: NONE
C
C I/O:
C  INPUT: UNIT=IN
C       LINE  VARIABLE  COLUMNS FORMAT  DESCRIPTION
C         1      NAME      1-16  A16    SOURCE NAME
C                  X      17-23  F7.0   X-COORD (USER HORIZONTAL UNITS)
C                  Y      24-30  F7.0   Y-COORD (USER HORIZONTAL UNITS)
C                  Z      31-37  F7.0   BASE ELEV (USER VERTICAL UNITS)
C                 HS      38-44  F7.0   STACK HEIGHT (M)
C                 DS      45-51  F7.0   STACK DIAMETER (M)
C                 TS      51-58  F7.0   STACK GAS TEMPERATURE (DEG K)
C                 VS      59-65  F7.0   STACK GAS EXIT VELOCITY (M/S)
C                  Q      66-72  F7.0   EMISSION RATE (G/S)
C                 IQ      75-80    I5   FLAG FOR VARIABLE EMISSION RATE
C                                        IQ=0 CONSTANT RATE, =1 VARIABLE
C
C       LAST    NAME        1-4   A4    CHARACTERS 'ENDS' INDICATING END
C                                        OF SOURCE INPUT
C       REPEAT LINE 1 FOR EACH SOURCE
C
C  OUTPUT: UNIT=IOUT
C       PRINTOUT OF INPUT SOURCE PARAMETERS
C
C CALLING ROUTINES: CTDMPLUS (MAIN)
C
C EXTERNAL ROUTINES: PAGE
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: IO  HEAD  PARAMS  STACKS
C
C INTRINSIC FUNCTIONS: MOD
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
C      INCLUDE   'HEAD.CMN'
      INCLUDE   'PARAMS.CMN'
      INCLUDE   'STACKS.CMN'
      INCLUDE   'TOWER.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL    X,      Y,      Z,      HS,     DS,     TS,
     1          VS,     Q,      ZLOW
        INTEGER I, IQ,     YES,    NO, NS
        CHARACTER*1  ADJUST(MAXSOR), STAR
        CHARACTER*4  ENDS
        CHARACTER*16 NAME, SNAME(MAXSOR)
        DATA    YES/ 1/,        NO/0/
        DATA    ENDS/ 'ENDS'/,  ADJUST/ MAXSOR*' '/,    STAR/ '*'/
        DATA    ZLOW/1.E20/
C
        CALL PAGE(YES)
        IEMIS=NO
        KEMIS=0
        NSTACK=0
        WRITE(IOUT, 6000)
C       LOOP ON SOURCE INPUT LINES
10      READ(IN,1000) NAME, X, Y, Z, HS, DS, TS, VS, Q, IQ
        IF( NAME(1:4) .EQ. ENDS ) GO TO 100
        NSTACK=NSTACK+1
        IF(NSTACK .LE. MAXSOR) GO TO 20
        WRITE(IOUT, 6010) MAXSOR, NSTACK
        STOP
20      IF(HS. GT. 0.0) GO TO 30
        WRITE(IOUT, 6020) NSTACK, HS
        STOP
30      IF(DS .GT. 0.0) GO TO 40
        WRITE(IOUT, 6030) NSTACK, DS
        STOP
40      IF(IQ .GT. 0) GO TO 70
        IF(TS .GT. 0.0) GO TO 50
        WRITE(IOUT, 6040) NSTACK, TS
        STOP
50      IF(VS .GT. 0.0) GO TO 60
        WRITE(IOUT, 6050) NSTACK, VS
        STOP
C60      IF(Q .GT. 0.0) GO TO 80
C       WRITE WARNING MESSAGE IF ANY EMISSION RATES WERE NEGATIVE
60      IF(Q .LT. 0.0) WRITE(IOUT,6065) NSTACK,Q
        IF(Q .NE. 0.0) GO TO 80
        WRITE(IOUT, 6060) NSTACK, Q
        STOP
70      IQ=1
C       SET VARIABLE EMISSIONS FLAG
        IEMIS=YES
C       COUNTER
        KEMIS=KEMIS+1
        TS=0.0
        VS=0.0
        Q=0.0
80      SOURCE(1,NSTACK)=X*HORIZ
        SOURCE(2,NSTACK)=Y*HORIZ
        SOURCE(3,NSTACK)=Z*VERT
C       LOOK FOR LOWEST BASE ELEVATION
        IF( SOURCE(3,NSTACK) .LT. ZLOW ) ZLOW = SOURCE(3,NSTACK)
        SOURCE(4,NSTACK)=HS
        SOURCE(5,NSTACK)=DS
        SOURCE(6,NSTACK)=TS
        SOURCE(7,NSTACK)=VS
        SOURCE(8,NSTACK)=Q
C       RESERVED SPACE IN SOURCE ARRAY
C****** SOURCE(9,NSTACK)=BLDHT
C                         2.45154=GRAVITY/4
        SOURCE(10,NSTACK)=2.45154*VS*DS*DS
        SOURCE(11,NSTACK)=0.25*VS*VS*DS*DS
        SNAME(NSTACK) = NAME
        IVAR(NSTACK)=IQ
        GO TO 10
C       END INPUT LOOP
100     CONTINUE
C       CHECK IF MET TOWER BASE IS BELOW LOWEST STACK BASE
        IF(ZT .LT. ZLOW) ZLOW = ZT
C       SET BASE HEIGHT FOR PROFILE HEIGHT ADJUSTMENT
        BASEHT = ZT - ZLOW
C       ADJUST STACK BASE ELEVATION AND HEIGHT AND PRINT INPUTS
        DO 110 NS=1, NSTACK
            IF( MOD(NS,5) .EQ. 1) WRITE(IOUT, 6090)
                IF( NS .EQ. 46 ) THEN
C               PRINT FOOTNOTE, NEW PAGE
                WRITE(IOUT,6100) ZLOW, HORIZ, VERT
                CALL PAGE(YES)
            ENDIF
            IF( SOURCE(3,NS) .GT. ZLOW ) THEN
C               STACK BASE ELEVATION IS ABOVE COMMON BASE ELEVATION
                ADJUST(NS) = STAR
                SOURCE(4,NS) = SOURCE(4,NS) + (SOURCE(3,NS)-ZLOW)
                SOURCE(3,NS) = ZLOW
            ENDIF
            IF(IVAR(NS) .EQ. NO) THEN
                WRITE(IOUT, 6070) NS,SNAME(NS),SOURCE(8,NS),
     $                  SOURCE(1,NS),SOURCE(2,NS),
     $                  SOURCE(4,NS),ADJUST(NS),(SOURCE(I,NS),I=5,7)
             ELSE
                WRITE(IOUT, 6080) NS,SNAME(NS),SOURCE(1,NS),
     $                  SOURCE(2,NS),SOURCE(4,NS),
     $                  ADJUST(NS),SOURCE(5,NS)
             ENDIF
110      CONTINUE
C       PRINT FOOTNOTE
        WRITE(IOUT,6100) ZLOW, HORIZ, VERT
        RETURN
C
1000    FORMAT(A16,8F7.0,7X,I5)
6000    FORMAT(
     1  //' ',T17,'* * * S O U R C E   I N F O R M A T I O N * * *',///,
     2  T22,'EMISSION      LOCATION         STK   STK   GAS   EXIT',/,
     3  ' STK      NAME        RATE       X         Y      ',
     4  '  HT    DIA   TEMP  VEL ',/,'  #',T23,'(G/S)     (M)       (M',
     5  ')       (M)   (M)   (K)  (M/S)',
     6  /,' --- ---------------- -------- -------- --------- ',
     7  ' ------ ----- ----- -----')
6010    FORMAT(//' *****SOURCE INPUT ERROR*****'/
     1  ' MAXIMUM NUMBER OF SOURCES EXCEEDED: MAXSOR=',I3,' NSTACK=',I3)
6020    FORMAT(//' *****SOURCE INPUT ERROR*****'/
     1  ' STACK HEIGHT LE 0.0:  STACK NO=',I3,'   HS=',F6.2)
6030    FORMAT(//' *****SOURCE INPUT ERROR*****'/
     1  ' STACK DIAMETER LE 0.0:  STACK NO=',I3,'   DS=',F6.2)
6040    FORMAT(//' *****SOURCE INPUT ERROR*****'/
     1  ' STACK TEMPERATURE LE 0.0:  STACK NO=',I3,'   DS=',F6.1)
6050    FORMAT(//' *****SOURCE INPUT ERROR*****'/
     1  ' EXIT VELOCITY LE 0.0:  STACK NO=',I3,'   DS=',F6.2)
6060    FORMAT(//' *****SOURCE INPUT ERROR*****'/
     1  ' EMISSION RATE EQ 0.0:  STACK NO=',I3,'   Q=',F6.2)
6065    FORMAT(//' *** WARNING ! NEGATIVE EMISSION RATE INPUT ***'/
     1           '           STACK NO=',I3,'   Q=',F10.2)
6070    FORMAT(I3,1X,A16,F9.2,F9.2,1X,F9.2,1X,F6.1,A1,F6.2,F6.1,F6.2)
6080    FORMAT(I3,1X,A16,'   VAR.  ',F9.2,F9.3,1X,F6.1,A1,
     1  F6.2,'   VAR.  VAR. ')
6090    FORMAT(' ')
6100    FORMAT(/,' ------------------------------------------',//,
     1  '   COMMON BASE ELEVATION = ',F7.1,' (METERS).',/,
     2  '   THIS BASE ELEVATION IS USED FOR ALL STACKS IN THIS RUN;',/,
     3  '   ALL STACK HEIGHTS MARKED WITH  *  HAVE BEEN ADJUSTED TO ',/,
     4  '   RETAIN THE ACTUAL ELEVATION OF THE TOP OF THE STACKS.'//,
     5  '   MULTIPLY HORIZONTAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     6          'TO METERS',/,
     7  '   MULTIPLY VERTICAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     8          'TO METERS')
        END
