        SUBROUTINE INPTER
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE IS RESPONSIBLE FOR READING THE TERRAIN
C          INFORMATION FOR EACH HILL.
C
C ASSUMPTIONS: THIS FIRST CONTOUR HEIGHT IS LESS THAN OR EQUAL TO THE
C               LOWEST STACK BASE ELEVATION
C
C LIMITATIONS:
C       A MAXIMUM OF 'MAXHIL' HILLS
C       A MAXIMUM OF 'MAXZ' INTERMEDIATE HEIGHTS FOR WHICH CONTOUR
C         AND HILL SHAPE INFORMATION IS GIVEN
C
C ARGUMENTS: NONE
C
C I/O:
C  INPUT: UNIT=INTERR, IN
C
C       THE FOLLOWING INDICATE THE GROUP OF INPUT LINES EXPECTED
C       FOR EACH HILL.
C
C       LINE  VARIABLE  COLUMNS FORMAT  DESCRIPTION
C         1      NH        6- 7   I2    HILL NUMBER
C                                         FOR THIS RECEPTOR GROUP
C                NZ        9-10   I2    NUMBER OF HEIGHTS FOR WHICH
C                                         CONTOUR AND CUTOFF HILL SHAPE
C                                         INFORMATION IS GIVEN
C                HTP      21-30  F10.0  HEIGHT OF TOP OF HILL
C                                         ABOVE GRID ZERO, USER UNITS
C                HILNAM   41-80   A40   DESCRIPTION FOR THIS HILL
C
C       NEXT NZH LINES, ONE FOR EACH BEST-FIT ELLIPSE
C
C                  ZH      1-10  F10.0  ELEVATION OF BEST-FIT ELLIPSE,
C                                       USER COORDINATES
C                 XHW     11-20  F10.0  X-COORD (USER HORIZONTAL UNITS)
C                                       OF ELLIPSE CENTER
C                 YHW     21-30  F10.0  Y-COORD (USER HORIZONTAL UNITS)
C                                       OF ELLIPSE CENTER
C              MAJORW     31-40  F10.0  ORIENTATION OF MAJOR AXIS OF
C                                       ELLIPSE (DEGREES CLOCKWISE FROM
C                                       NORTH)
C              MAJAXW     41-50  F10.0  LENGTH OF MAJOR SEMIAXIS, USER
C                                       COORDINATES
C              MINAXW     51-60  F10.0  LENGTH OF MINOR SEMIAXIS, USER
C                                       COORDINATES
C
C       NEXT NZH LINES, ONE FOR EACH CUT-OFF HILL
C
C                  ZH      1-10  F10.0  ELEVATION OF BASE OF CUT-OFF
C                                       HILL, USER COORDINATES
C                 XHL     11-20  F10.0  X-COORD (USER HORIZONTAL UNITS)
C                                       OF CENTER OF CUT-OFF HILL
C                 YHL     21-30  F10.0  Y-COORD (USER HORIZONTAL UNITS)
C                                       OF CENTER OF CUT-OFF HILL
C              MAJORL     31-40  F10.0  ORIENTATION OF MAJOR AXIS OF
C                                       CUT-OFF HILL (DEGREES CLOCKWISE
C                                       FROM NORTH)
C              EXPOMA     41-50  F10.0  EXPONENT IN INVERSE POLYNOMIAL
C                                       FUNCTION FOR CUT-OFF HILL SHAPE
C                                       FOR MAJOR AXIS CROSS SECTION
C              EXPOMI     51-60  F10.0  EXPONENT IN INVERSE POLYNOMIAL
C                                       FUNCTION FOR CUT-OFF HILL SHAPE
C                                       FOR MINOR AXIS CROSS SECTION
C              SCALMA     61-70  F10.0  SCALE LENGTH IN INVERSE
C                                       POLYNOMIAL FUNCTION FOR CUT-OFF
C                                       HILL SHAPE FOR MAJOR AXIS CROSS
C                                       SECTION
C              SCALMI     71-80  F10.0  SCALE LENGTH IN INVERSE
C                                       POLYNOMIAL FUNCTION FOR CUT-OFF
C                                       HILL SHAPE FOR MINOR AXIS CROSS
C                                       SECTION
C
C
C       THIS GROUP OF INPUT LINES SHOULD BE REPEATED FOR EACH HILL.
C       AFTER THE LAST HILL, AN END-OF-FIL WILL OCCUR FOR I/O UNIT
C       INTERR.  THEN, AN ADDITIONAL LINE WILL BE READ FROM I/O UNIT IN:
C
C               Z0H     FREE FORMAT     ROUGHNESS LENGTH (M)
C                                       ONE FOR EACH HILL
C
C  OUTPUT: UNIT=IOUT
C       PRINTOUT OF INPUT TERRAIN DATA
C
C CALLING ROUTINES: CTDMPLUS (MAIN)
C
C EXTERNAL ROUTINES: LINES  PAGE
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST  IO  HILL  PARAMS  STACKS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
C      INCLUDE   'CONST.CMN'
      INCLUDE   'HILL.CMN'
      INCLUDE   'IO.CMN'
      INCLUDE   'PARAMS.CMN'
      INCLUDE   'STACKS.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL    EL, HTP, SMALL, ZH(MAXZ), ZS
        INTEGER NEWPGE, NH, NO, NZ, I, I1, I2, NG, NGR, NL, YES
C
        DATA    YES/ 1/,SMALL/0.00001/
C
        NHILLS = 0
        ZS = SOURCE(3,1)
C
        CALL PAGE(YES)
        WRITE(IOUT,6010)
        CALL LINES(2,NO,NEWPGE)
C
100     READ( INTERR, 1010, ERR=9000, END=500) NH, NZ, HTP,
     $                          (HILNAM(I,NHILLS+1),I=1,10)
1010    FORMAT(5X,I2,1X,I2,10X,F10.0,10X,10A4)
        NHILLS = NHILLS + 1
C       CHECK FOR OUT OF SEQUENCE
        IF( NH .NE. NHILLS ) THEN
            WRITE( IOUT, 1110) NHILLS, NH
1110    FORMAT(//,10X,'HILL NUMBER OF OUT SEQUENCE--',I2,' WAS ',
     1  'EXPECTED; ',I2,' WAS READ')
            STOP
        ENDIF
C       CHECK FOR ARRAY OUT OF BOUNDS
        IF( NZ .GT. MAXZ ) THEN
            WRITE(IOUT,1120) NZ,MAXZ
1120    FORMAT(//,10X,'NUMBER OF CONTOURS/CUT-OFF HILLS = ',I2,
     1      '; EXCEEDS MAXIMUM ALLOWABLE (21)')
            STOP
        ENDIF
C
C       CHECK IF HEADER PLUS WRAP HILL ELLIPSE INFO FITS ON PAGE
        NL =  6 + NZ
        CALL LINES(NL,YES,NEWPGE)
        IF( NEWPGE .EQ. YES ) THEN
C               FOOTNOTE, NEW PAGE
                WRITE( IOUT, 6100) HORIZ, VERT
                WRITE( IOUT, 6011)
                CALL LINES(2,NO,NEWPGE)
        ENDIF
        WRITE( IOUT, 6020 ) NH, (HILNAM(I,NH),I=1,10), HTP
        WRITE( IOUT, 6030 ) (HILNAM(I,NH),I=1,10)
C
C       READ VARIABLES FOR WRAP: ELLIPSE INFORMATION
C
        DO 200 I = 1,NZ
            READ(INTERR,1040,ERR=9000) ZH(I),XHW(I,NH),YHW(I,NH),
     *                          MAJORW(I,NH),MAJAXW(I,NH),MINAXW(I,NH)
1040        FORMAT(6F10.0)
            WRITE(IOUT,6040) ZH(I),XHW(I,NH),YHW(I,NH),MAJORW(I,NH),
     *                          MAJAXW(I,NH),MINAXW(I,NH)
200     CONTINUE
C
C       READ VARIABLES FOR LIFT: CUT-OFF HILL INFORMATION
C
        NL = 5 + NZ
        CALL LINES(NL,YES,NEWPGE)
        IF( NEWPGE .EQ. YES ) THEN
C              FOOTNOTE, NEW PAGE
             WRITE( IOUT, 6100) HORIZ, VERT
             WRITE(IOUT,6011)
             CALL LINES(2,NO,NEWPGE)
        ENDIF
        WRITE(IOUT,6050) (HILNAM(I,NH),I=1,10)
        DO 300 I = 1,NZ
            READ(INTERR,1050,ERR=9000) EL,XHL(I,NH),YHL(I,NH),MAJORL(I,
     1          NH),EXPOMA(I,NH),EXPOMI(I,NH),SCALMA(I,NH),SCALMI(I,NH)
1050        FORMAT(8F10.0)
            IF(ABS(EL-ZH(I)).GT.SMALL) THEN
                WRITE(IOUT,1140) I,EL,I,ZH(I)
1140            FORMAT(//,10X,'CUT-OFF HILL BASE # ',I2,' = ',F7.2,
     *                  '; DOES NOT AGREE WITH THE CORRESPONDING ',
     *                  'CONTOUR # ',I2,' HEIGHT OF ',F7.2)
                STOP
            ENDIF
            WRITE(IOUT,6060) EL,XHL(I,NH),YHL(I,NH),MAJORL(I,NH),
     *                          EXPOMA(I,NH),EXPOMI(I,NH),
     *                          SCALMA(I,NH),SCALMI(I,NH)
300     CONTINUE
C
C       CONVERT TO METERS USING HORIZ AND VERT
C
        NZH(NH) = NZ
        THS(NH) = HTP * VERT - ZS
        DO 400 I = 1,NZ
            ZHS(I,NH) = ZH(I) * VERT - ZS
            XHW(I,NH) = XHW(I,NH) * HORIZ
            YHW(I,NH) = YHW(I,NH) * HORIZ
            XHL(I,NH) = XHL(I,NH) * HORIZ
            YHL(I,NH) = YHL(I,NH) * HORIZ
            MAJAXW(I,NH) = MAJAXW(I,NH) * HORIZ
            MINAXW(I,NH) = MINAXW(I,NH) * HORIZ
            SCALMA(I,NH) = SCALMA(I,NH) * HORIZ
            SCALMI(I,NH) = SCALMI(I,NH) * HORIZ
400     CONTINUE
C       CHECK IF FIRST CONTOUR LE LOWEST STACK BASE ELEVATION
        IF( ZHS(1,NH) .GT. 0.001) GO TO 9010
C       READ NEXT HILL INFO
        GO TO 100
C       END OF TERRAIN INPUT
500     CONTINUE
        WRITE(IOUT,6100) HORIZ, VERT
C       READ HILL ROUGHNESS LENGTHS
        READ(IN,*) (Z0H(NH),NH=1,NHILLS)
        NGR = (NHILLS-1)/8 + 1
        NL = NGR * 3 + 6
        CALL LINES(NL,YES,NEWPGE)
        WRITE(IOUT,6070)
        DO 600 NG=1,NGR
                I1=(NG-1)*8+1
                I2=NG*8
                IF(I2 .GT. NHILLS) I2=NHILLS
                WRITE(IOUT,6080) (I,I=I1,I2)
                WRITE(IOUT,6090) (Z0H(I),I=I1,I2)
600             CONTINUE
        WRITE (IOUT,6091)
C
        RETURN
C
C       TERMINAL ERROR
9000    WRITE(IOUT,9005)
9005    FORMAT(//,10X,'ERROR IN DATA READ IN HILL INPUT')
        GO TO 9999
9010    WRITE(IOUT,9015) NH
9015    FORMAT(//,'  FIRST CONTOUR OF HILL',I3,' IS ABOVE COMMON ',
     *  'STACK BASE ',//,'   PROGRAM TERMINATING ',//)
        GO TO 9999
9999    STOP
C
6010    FORMAT(' TERRAIN INFORMATION (USER UNITS FOR ALL DATA)')
6011    FORMAT(' TERRAIN INFORMATION  (CONT.)')
6020    FORMAT(/' HILL #',I2,'  ',10A4,'HILL TOP:',F7.1,
     *          ' (USER UNITS)')
6030    FORMAT(/' BEST FIT ELLIPSE INFORMATION FOR WRAP: ',10A4,/
     *  '  CONTOUR  X-COORD   Y-COORD   MAJOR  AXIS   ELLIPSE AXIS ',
     *  'LENGTHS',/,
     *  '   HEIGHT    (HILL CENTER)     AZIM. FROM N    MAJOR      ',
     *  'MINOR',/,
     *  '  -------  --------  --------  ------------  --------   ',
     *  '--------')
6040    FORMAT(F9.1,2F10.3,F11.1,2X,2F11.3)
6050    FORMAT(/' Hc CUT-OFF HILL INFORMATION FOR LIFT:  ',10A4,/,
     *  '  CONTOUR  X-COORD  Y-COORD  MAJOR  AXIS  <--- INVERSE ',
     *  'POLYNOMIAL VARIABLES --->',/,
     *  '   HEIGHT    (HILL CENTER)  AZIM. FROM N  MAJ EXP MIN EXP   ',
     *  'MAJ SCALE  MIN SCALE',/,
     *  '  -------  -------- ------- ------------  ------- -------   ',
     *  '---------  ---------')
6060    FORMAT(F9.1,F10.3,F9.3,F10.1,F11.3,F8.3,F12.3,F11.3)
6070    FORMAT(/
     *  '------------------------------------------------------'/,
     *  '    SURFACE ROUGHNESS LENGTH OF EACH HILL:',/)
6080    FORMAT(' HILL # ',8I8)
6090    FORMAT(' Z0 (M) ',8F8.3,/)
6091    FORMAT(/)
6100    FORMAT(' ---------------------------------------------',/,
     1  '   MULTIPLY HORIZONTAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     2          'TO METERS',/,
     3  '   MULTIPLY VERTICAL USER UNITS BY:',1PE10.3,' TO CONVERT ',
     4          'TO METERS')
        END
