      SUBROUTINE LIFT(QS)
C-----------------------------------------------------------------------
C PURPOSE: HANDLES FLOW ABOVE HC.
C
C ARGUMENTS:
C   PASSED:
C       QS      REAL    EMISSION RATE [G/S]
C   RETURNED: NONE
C
C I/O: NONE
C   INPUT: NONE
C   OUTPUT: UNIT=IOUT  CONCENTRATION (IF ICASE=YES)
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES:  FLAT  FLOW  LVDF  MIX
C
C INTRINSIC FUNCTIONS: AMAX1  AMIN1  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST  IO  PARAMS  PASL  PASVAL  VARS
C
C-----------------------------------------------------------------------
      INCLUDE 'PARAMS.INC'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'IO.CMN'
      INCLUDE 'VARS.CMN'
      INCLUDE 'CONST.CMN'
      INCLUDE 'PASVAL.CMN'
      INCLUDE 'PASL.CMN'
C
C       DEFINE ARGUMENTS
      REAL QS
C
C       DEFINE LOCAL VARIABLES
      REAL  ARGY, AZ, BOTY, BOTZ, CO, DEL, DELH, DELS, DUM, 
     1      DUM1, DUM2, DUM3, DUM3P, DY, ETA, LXI, SLAST, SLND, 
     2      SM, SMND, SYSQ, SYOSQ, SYE, SYESQ, SYFLAT, SYPSQ, 
     3      SZO, SZOSQ, SZE, SZESQ, SZFLAT, SZP, SZPSQ, SZSQ, 
     4      TEST, TOP, TOPY, TOPZ, TOTAL, TYSQ, TZ, TZSQ, UBYN, 
     5      ULAG0, YEFF, YFAC, YTO, YTR, ZEFF, ZF, ZFAC, ZG, ZL, 
     6      ZSMHC, ZSPHC, ZTO, ZTR 

      INTEGER  K, L, NLAYER
C
      CO=500000. * QS/(TWOPI*US)
      ZSPHC=HPL+HC
      ZSMHC=HPL-HC
C  CALC DISTANCE ALONG PHIM FROM SOURCE TO RECEPTOR, CALC TRAVEL TIMES
      SM=XEPL-XSEPL
      IF(SM .GT. SO) THEN
         ZTO=SO/UV
         ZTR=(SM-SO)/UV+ZTO
         YTO=SO/UV
         YTR=SM/UV
C  CALCULATE SIGMA-Z VALUES   ....EQN. 19
         SZSQ=(SIGW*(ZTR+ZTV))**2/(1.0+0.5*(ZTR+ZTV)/TTLZ)
         SZOSQ=(SIGW*(ZTO+ZTV))**2/(1.0+0.5*(ZTO+ZTV)/TTLZ)
         SZPSQ=AMAX1(0.0,SZSQ-SZOSQ)
         SZFLAT = SQRT(SZSQ)
         SZO=SQRT(SZOSQ)
         SZP=SQRT(SZPSQ)
C  CALCULATE THE SIGMA-Y VALUES    ....EQN. 26
         SYSQ=(SIGV*(YTR+YTV))**2/(1.0+0.5*(YTR+YTV)/TTLY)
         SYOSQ=(SIGV*(YTO+YTV))**2/(1.0+0.5*(YTO+YTV)/TTLY)
         SYPSQ=SYSQ-SYOSQ
         SYFLAT = SQRT(SYSQ)
      ELSE
C  (SET SZP TO ZERO TO SIGNAL RECEPTOR UPWIND OF CUT-OFF HILL)
         SZP=0.0
      ENDIF
C  IF RECEPTOR IS UPWIND OF THE CUT-OFF HILL, DO A RECEPTOR-ON-A-POLE
      IF(SZP .EQ. 0.) THEN
         ZG = Z - ZELEV
         CALL FLAT(QS,AMIN1(HC,ZG)+ZELEV)
         RETURN
      ENDIF
C  ESTIMATE THE DEPTH OF AN INNER MIXED LAYER ABOVE HC
      HMIX=0.0
      DELS=AMAX1((SM-SO),0.)
      TEST=DELS*HC
      IF (TEST .GT. 0.) THEN
C**********************************************************************
C        UBYN=FR*HH
C  AVOID NEAR-NEUTRAL EST. : SET U/N TO HC IF HC BECOMES SMALLER
         UBYN=AMIN1(FR*HH,HC)
C**********************************************************************
         CALL MIX(DELS,UBYN,HMIX,Z0HILL)
      ENDIF
C  FIND THE INDEX FOR THE TY,TZ VALUES AT XEPL
      SLAST=SG(MXDPTS)
C  SCALE DISTANCE BY LX TO AVOID DIFFERENCING SQUARES OF LARGE NUMBERS
      LXI=1./LX
      SLND=SLAST*LXI
      SMND=SM*LXI
      IF(SM .LE. SO) THEN
         K=0.
      ELSEIF(SM .GT. SLAST) THEN
         K=MXDPTS+1
C  ULAG0 IS THE LAGRANGIAN LENGTH SCALE BASED ON THE TIME SCALE TLO
C                                               ....EQN. A-8
         ULAG0=UV*TTLZ
         TOPZ=ULAG0*(SLAST-SO+ULAG0*ALOG((ULAG0+SO)/
     *                                       (ULAG0+SLAST)))
         BOTZ=TOPZ/ATZSQ(MXDPTS)
         TOPY=SLND*SLND-1.
         BOTY=TOPY/ATYSQ(MXDPTS)
      ELSE
         DO 5 K=1,MXDPTS
            IF(SM .LT. SG(K)) GO TO 6
5        CONTINUE
6     CONTINUE
      ENDIF
C  COMPUTE TERRAIN EFFECTS FACTORS
C  USE INTERPOLATION FOR POINTS WITHIN THE GRID (POINTS ON THE HILL)
      IF(K .EQ. 0) THEN
         TZSQ=1.
         TYSQ=1.
      ELSEIF(K .EQ. 1) THEN
         DUM=(SM-SO)/DELTAX
         TZSQ=1.+DUM*(ATZSQ(K)-1.)
         TYSQ=1.+DUM*(ATYSQ(K)-1.)
      ELSEIF(K .LT. MXDPTS+1) THEN
         DUM=(SM-SG(K-1))/DELTAX
         TZSQ=ATZSQ(K-1)+DUM*(ATZSQ(K)-ATZSQ(K-1))
         TYSQ=ATYSQ(K-1)+DUM*(ATYSQ(K)-ATYSQ(K-1))
      ELSE
C  FOR POINTS DOWNWIND OF GRID, INTEGRATE DIFFUSIVITY APPROXIMATED AS
C                       KZ=SIGW**2 * T / (1 + T/TL )
C                       KY=SIGV**2 * T
         TOP=ULAG0*(SM-SO+ULAG0*ALOG((ULAG0+SO)/
     *                                        (ULAG0+SM)))
         TZSQ=TOP/(BOTZ+ULAG0*(SM-SLAST+ULAG0*ALOG((ULAG0+SLAST)/
     *                                        (ULAG0+SM))))
         TOP=SMND*SMND-1.
         TYSQ=TOP/(BOTY+SMND*SMND-SLND*SLND)
      ENDIF
      TZ=SQRT(TZSQ)
C  CALCULATE THE EFFECTIVE SIGMAS   ....EQN. 38
      SZESQ=SZOSQ+SZPSQ/TZSQ
      SYESQ=SYOSQ+SYPSQ/TYSQ
      SZE=SQRT(SZESQ)
      SYE=SQRT(SYESQ)
C  COMPUTE EFFECTIVE RECEPTOR LOCATION RELATIVE TO THE UNDEFLECTED
C  PLUME CENTERLINE. NOTE THAT ZELEV IS THE ELEVATION OF THE RECEPTOR
C  ABOVE THE SURFACE OF THE HILL.
      CALL FLOW(XEPL,YEPL,ZELEV,ETA,DEL,DUM1,DUM2,DUM3,ALF,FR)
      ZEFF=ZELEV+HH*HILHGT(XEPL,YEPL)-ETA
      YEFF=YEPL-DEL
      IF(HMIX .LE. ZEFF) HMIX=0.
      DY=YSEPL-YEFF
C  COMPUTE THE CONCENTRATION AS CHI/Q IN MICROSECONDS PER M**3
C                                       ....EQN. 39
      ARGY=0.5*DY*DY/SYESQ
      IF (ARGY .GT. 30.) THEN
         C=0.0
      ELSE
         YFAC=EXP(-ARGY)
         AZ=TZ/(SQR2*SZO*SZP*SZE)
         DUM1=AZ*ZSMHC*SZPSQ/TZSQ
         DUM2=AZ*ZSPHC*SZPSQ/TZSQ
         DUM3P=AZ*SZOSQ
         DUM=0.5/SZESQ
         IF(HMIX .GT. 0.) THEN
C  WHEN MIXING LAYER IS PRESENT, MIX MATERIAL WITHIN THE LAYER...
C (SAMPLE VERTICAL PROFILE AND THEN AVERAGE)
            DELH=SZE*0.5
            NLAYER=1+HMIX/DELH
            DELH=HMIX/NLAYER
            TOTAL=0.0
            DO 8 L=1,NLAYER+1
               ZL=(L-1)*DELH
               CALL LVDF(ZL,DUM,DUM1,DUM2,DUM3P,ZSMHC,ZSPHC,ZF)
               IF(L .EQ. 1 .OR. L .EQ. NLAYER+1) ZF=0.5*ZF
8              TOTAL=TOTAL+ZF
            ZFAC=TOTAL/NLAYER
         ELSE
            CALL LVDF(ZEFF,DUM,DUM1,DUM2,DUM3P,ZSMHC,ZSPHC,
     *                  ZFAC)
         ENDIF
         C=CO*YFAC*ZFAC/(SZE*SYE)
      ENDIF
      IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) WRITE(IOUT,101)
     $                   NR,SM,DY,Z,ZSMHC-ZEFF,SYFLAT,SZFLAT,SYE,SZE,C
      RETURN
C
101   FORMAT(/1X,I3,' L',F8.0,3X,F8.1,2X,F7.1,2X,F7.1,1X,2F6.1,1X,
     1  2F6.1,1X,1PE10.4)
      END
