      SUBROUTINE LVDF(Z,DUM,DUM1,DUM2,DUM3P,ZSMHC,ZSPHC,ZFAC)
C-----------------------------------------------------------------------
C PURPOSE: COMPUTES THE VERTICAL DISTRIBUTION FACTOR (VDF) FOR LIFT
C
C ARGUMENTS:
C    PASSED:
C       Z       REAL    HEIGHT ABOVE THE SURFACE  (M)
C       DUM     REAL    1/(2*SIGZE**2)  (M**-2)
C     DUM1,2,3P REAL    TERMS IN ARGUMENT OF ERFS IN VDF EXPRESSION
C       ZSMHC   REAL    ZS - HC  (M)
C       ZSPHC   REAL    ZS + H   (M)
C    RETURNED:
C       ZFAC    REAL    VERTICAL DISTRIBUTION FACTOR
C
C I/O: NONE
C
C CALLING ROUTINE: LIFT
C
C EXTERNAL ROUTINES: ERF
C
C INTRINSIC FUNCTIONS: EXP
C
C INCLUDE FILES: NONE
C
C COMMON BLOCKS: NONE
C
C----------------------------------------------------------------------C
C
C       DEFINE ARGUMENTS
      REAL      Z, DUM, DUM1, DUM2, DUM3P, ZSMHC, ZSPHC, ZFAC
C
C       DEFINE LOCAL VARIABLES
      REAL      ARG1, ARG2, ARG3, ARG4, DUM3, ERF1, ERF2, ERF3, ERF4,
     *          T1, T2, T3, T4
C
C                               ....EQN. 39B
      DUM3=DUM3P*Z
      ERF1=1.-ERF(-DUM1-DUM3)
      ERF2=1.-ERF(-DUM1+DUM3)
      ERF3=1.-ERF(DUM2-DUM3)
      ERF4=1.-ERF(DUM2+DUM3)
      ARG1=DUM*(Z-ZSMHC)**2
      ARG2=DUM*(Z+ZSMHC)**2
      ARG3=DUM*(Z+ZSPHC)**2
      ARG4=DUM*(Z-ZSPHC)**2
      T1=0.
      T2=0.
      T3=0.
      T4=0.
      IF(ARG1 .LT. 30.) T1=ERF1*EXP(-ARG1)
      IF(ARG2 .LT. 30.) T2=ERF2*EXP(-ARG2)
      IF(ARG3 .LT. 30.) T3=ERF3*EXP(-ARG3)
      IF(ARG4 .LT. 30.) T4=ERF4*EXP(-ARG4)
      ZFAC=T1+T2+T3+T4
      RETURN
      END
