      SUBROUTINE MIX(DELS,UBYN,H2,Z0HILL)
C----------------------------------------------------------------------
C PURPOSE: ESTIMATES THE DEPTH OF A MIXED LAYER THAT DEVELOPS
C               AT THE HILL SURFACE ABOVE HC
C
C  ARGUMENTS:
C    PASSED:
C       DELS    REAL    DISTANCE ALONG THE FLOW FROM THE UPWIND EDGE
C                       OF THE CUT-OFF HILL ("DELTA S")  (M)
C       UBYN    REAL    WIND SPEED / BRUNT-VAISALA FREQUENCY  (M)
C    RETURNED:
C       H2      REAL    HEIGHT OF TOP OF MIXING LAYER ABOVE THE
C                       SURFACE OF THE HILL  (M)
C
C I/O: NONE
C
C CALLING ROUTINE: LIFT
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: ABS  ALOG  AMAX1  AMIN1
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST  PASVAL  SFCMET
C
C-----------------------------------------------------------------------
C
        PARAMETER(      MAXITR  =       500)
C
      INCLUDE   'PARAMS.INC'
C      INCLUDE   'PASVAL.CMN'
C      INCLUDE   'CONST.CMN'
C      INCLUDE   'SFCMET.CMN'
C
C       DEFINE ARGUMENTS
      REAL      DELS, UBYN, H2, Z0HILL
C
C       DEFINE LOCAL VARIABLES
      REAL      AVG, AVGOLD, DUM, H1, H1Z0I, HLOG, HLOG2,  
     &          HLOG3, SDELS, TEST, THIRD, UBYNI, Z0H1I3
      INTEGER   NITER
C
      THIRD=1./3.
      AVGOLD = 0.0
      UBYNI=1./UBYN
C  SCALE THE DISTANCE BY THE LENGTH SCALE U/N
      SDELS=DELS*UBYNI
C  ITERATE TO FIND HEIGHT OF MIXED LAYER AT DELS
      H1=0.1*DELS
      NITER = 0
C
C                              	....EQN. A-14
10    H1Z0I = AMAX1(H1/Z0HILL,2.0)
      Z0H1I3=0.
      IF(H1Z0I .LT. 10.) Z0H1I3=1./(H1Z0I*H1Z0I*H1Z0I)
      HLOG=ALOG(H1Z0I)
      HLOG2=HLOG*HLOG
      HLOG3=HLOG*HLOG2
      DUM=HLOG3-HLOG2+THIRD*2.*(HLOG-THIRD*(1.-Z0H1I3))
      H2=((SDELS/DUM)**THIRD)*UBYN
C
C     ASSUME CONVERGENCE IF WITHIN Z0 OF PREVIOUS GUESS
C     IF CHANGE OF AVERAGES OF PRESENT AND PREVIOUS GUESSES IS LESS THAN
C     Z0, USE AVERAGE TO SET NEW GUESS.
C
      TEST = ABS(H1-H2)
      IF(TEST .LE. Z0HILL) GO TO 20
      AVG = 0.5 * (H1 + H2)
      IF(ABS(AVG - AVGOLD) .LT. Z0HILL) THEN
          IF(AVG .GE. DELS) THEN
              H2 = DELS
              RETURN
          ENDIF
          H1 = AVG
        ELSE
          H1=H2
      ENDIF
      AVGOLD = AVG
      NITER = NITER + 1
      IF(NITER .GT. MAXITR) STOP 'NO CONVERGENCE IN MIX ROUTINE'
      GO TO 10
C
C  DO NOT ALLOW GROWTH OF MIXED LAYER TO EXCEED DELTA-S
C
20    H2=AMIN1(H2,DELS)
      RETURN
      END
