      SUBROUTINE MUNU(X,Y,A,B,MU,NU)
C-----------------------------------------------------------------------
C PURPOSE: COMPUTES THE ELLIPTIC COORDINATES ASSOCIATED WITH THE
C               POINT(X,Y) WHERE THE X-AXIS IS ALIGNED WITH THE MAJOR
C               AXIS OF THE ELLIPSE. (INVERT EQNS. A-48)
C
C ARGUMENTS:
C    PASSED:
C       X, Y    REAL    CARTESIAN COORDINATES (M)
C       A, B    REAL    MAJOR, MINOR SEMI-AXIS LENGTHS (M)
C    RETURNED:
C       MU, NU  REAL    ELLIPTIC COORDINATES
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTRINSIC FUNCTIONS: ABS  ALOG  ASIN  COS  SIN  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: CONST
C
C-----------------------------------------------------------------------
C
C      INCLUDE   'PARAMS.INC'
      INCLUDE   'CONST.CMN'
C
C       DEFINE ARGUMENTS
      REAL      A, B, MU, NU, X, Y
C
C       DEFINE LOCAL VARIABLES
      REAL      ABSX, ABSY, AR, ARG, ARSQ, BI, COSNU, DUM1, DUM2, DUM3,
     *          R, RSQ, SINNU, XP, XPSQ, YP, YPSQ
C
      BI=1./B
      AR=A*BI
      ARSQ=AR*AR
C  SCALE LENGTHS BY THE MINOR SEMI-AXIS LENGTH
      XP=X*BI
      YP=Y*BI
      ABSX=ABS(XP)
      ABSY=ABS(YP)
      XPSQ=XP*XP
      YPSQ=YP*YP
C  IF POINT(X,Y) LIES VERY NEAR AN AXIS, PLACE IT ON THE AXIS
      IF(ABSX .LT. SMALL) THEN
        XP=0.
        ABSX=0.
      ENDIF
      IF(ABSY .LT. SMALL) THEN
        YP=0.
        ABSY=0.
      ENDIF
      IF(XP .EQ. 0. .AND. YP .EQ. 0.) THEN
         NU=PIBY2
C  BECAUSE MU IS NOT USED FOR POINTS ON THE HILL,
C  RETURN A NULL AT THE CREST
         MU=0.
         RETURN
      ENDIF
      RSQ=XPSQ+YPSQ
      R=SQRT(RSQ)
C  CALCULATE NU
      DUM1=ARSQ-1.
      IF(DUM1 .LT. SMALL) THEN
         NU=ASIN(ABSY/R)
      ELSE
         DUM2=1.-RSQ/DUM1
         DUM3=0.5*(DUM2+SQRT(DUM2**2+4.*YPSQ/DUM1))
         IF(DUM3 .LT. 0. .AND. DUM3 .GE. -SMALL) THEN
           NU=0.
         ELSE
           ARG=SQRT(DUM3)
           IF((ARG-1.) .GT. 0. .AND. (ARG-1.).LE. SMALL) ARG=1.
           NU=ASIN(ARG)
         ENDIF
      ENDIF
      IF(XP .LT. 0.) NU=PI-NU
      IF(YP .LT. 0.) NU=-NU
      COSNU=COS(NU)
      SINNU=SIN(NU)
C  CALCULATE MU
      IF(ABS(SINNU) .LE. SMALL) THEN
         MU=ALOG((ABSX+SQRT(XPSQ+1.-ARSQ))/(AR+1.))
      ELSEIF(ABS(COSNU) .LE. SMALL) THEN
         MU=ALOG((ABSY+SQRT(YPSQ+ARSQ-1.))/(AR+1.))
      ELSE
         MU=ALOG((XP/COSNU+YP/SINNU)/(AR+1.))
      ENDIF
      RETURN
      END
