       SUBROUTINE PAGE( IFLAG)
C-----------------------------------------------------------------------
C   PURPOSE:
C       THIS ROUTINE SKIPS TO A NEW PAGE AND WRITES A PAGE HEADER.
C
C   LIMITATIONS:
C       PROGRAM VERSION NUMBER AND REVISION DATE ARE SPECIFIED HERE.
C
C   ARGUMENTS:
C     PASSED:
C       IFLAG   INT     FLAG INDICATING WHETHER RUN TITLE IS PRINTED
C                               0=NO, 1=YES
C     RETURNED: NONE
C
C   I/O:
C     INPUT: NONE
C
C     OUTPUT: PAGE HEADER OF MODEL VERSION ID AND TITLE OF RUN.
C
C   CALLING PROGRAMS: CTDMPLUS (MAIN), INPSOR, INPREC, MAP
C
C   EXTERNAL ROUTINES: NONE
C
C   INCLUDE FILES: PARAMS.INC
C
C   COMMON BLOCKS: IO HEAD
C--------------------------------------------------------------------
C
C      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
      INCLUDE   'HEAD.CMN'
C
C       DEFINE ARGUMENTS
         INTEGER         IFLAG
C       DEFINE LOCAL VARIABLES
         INTEGER         YES
        DATA YES/ 1/
C
        NPAGE = NPAGE + 1
        NLINES = 2
        WRITE(IOUT,6010) NPAGE
        IF(IFLAG .EQ. YES) THEN
            WRITE(IOUT,6020) TITLE
            NLINES = NLINES + 2
        ENDIF
        RETURN
C
6010   FORMAT('1','CTDMPLUS Dated (93228)',T72,'PAGE',1X,I3/)
6020   FORMAT(' ',20A4/)
       END
