      SUBROUTINE SOURCES
C *****************************************************************
C  THIS PROGRAM CREATES THE SOURCE CONTRIBUTION TABLE WHICH LISTS
C  THE HOURLY CONCENTRATIONS FOR EACH RECEPTOR, FOR EACH SOURCE
C *****************************************************************
      INCLUDE   'PARAMS.INC'
      INCLUDE   'PARAMS.CMN'
      INCLUDE   'PASVAL.CMN'
      INCLUDE   'RECEPT.CMN'
      INCLUDE   'STACKS.CMN'
      INCLUDE   'IO.CMN'
      INCLUDE   'TIME.CMN'

      INTEGER CNTR, CNTR2
      DIMENSION TOTCONC(MAXREC)

C     WRITE THE HEADER FOR THE TABLE
      IF (ISOR .EQ. 1) WRITE(IOSRC,2) KMO,KDY,KYR,KHR
2     FORMAT(//,25X,'SOURCE CONTRIBUTION TABLE',/,2X,
     *  'DATE ',I2,'/',I2,'/',I2,' HOUR ',I2)

      DO 8 J = 1,NRECPT
        TOTCONC(J) = 0
        DO 7 K = 1,NSTACK
          TOTCONC (J) = TOTCONC(J) + SCONC(J,K)
7       CONTINUE
8     CONTINUE

      I = (NSTACK - 1)/5 + 1
      DO 30 K = 1, I
        CNTR = (K-1) * 5 + 1
        CNTR2 = CNTR + 4
         IF(CNTR2 .GT. NSTACK) CNTR2 = NSTACK
        IF (ISOR .EQ. 1) WRITE(IOSRC,21) (KK, KK = CNTR,CNTR2)
21       FORMAT(//,2X,'REC #',4X,'TOTAL',3X,5(3X,'STACK # ',I2,:))
        DO 20 J = 1, NRECPT
          IF (ISOR .EQ. 1) THEN
            WRITE(IOSRC,25) J, TOTCONC(J),(SCONC(J,L), L = CNTR,CNTR2)
25          FORMAT(3X,I3,6(3X,E10.4,:))
          ELSE          
            WRITE(IOSRC) KYR, KMO, KDY, KHR,J, TOTCONC(J),
     &                           (SCONC(J,L), L = 1,NSTACK)
          ENDIF
20      CONTINUE
30    CONTINUE

      RETURN
      END
