      REAL FUNCTION UVWD( U, V )
C-----------------------------------------------------------------------
C FUNCTION: UVWD
C
C PURPOSE: COMPUTE WIND DIRECTION FROM U,V COMPONENTS. ALSO GOOD FOR
C               METEOROLOGICAL DIRECTION GIVEN A DX AND DY.
C
C ASSUMPTIONS: 0/360 DEGREES POINTS NORTH,
C
C LIMITATIONS:A CALM WIND DIRECTION (U=V=0) RETURNS A -1.
C
C ARGUMENTS:
C  PASSED
C       U       REAL    U WIND COMPONENT
C       V       REAL    V WIND COMPONENT
C RETURNED FUNCTION VALUE
C       UVWD    REAL    WIND DIRECTION IN DEGREES
C
C CALLING ROUTINES: ANGINT
C
C EXTERNAL ROUTINES: NONE
C
C COMMON BLOCKS: NONE
C
C INTRINSIC FUNCTIONS: ABS  ATAN2
C
C-----------------------------------------------------------------------
C
C     DEFINE ARGUMENTS
      REAL U, V
C     DEFINE LOCAL VARIABLES
      REAL EPS, R2D, CALM
      DATA R2D/ 57.295779 /
      DATA EPS/ 5.0E-6 /
      DATA CALM/ -1.0 /
C     START
      IF( ABS(U) .LE. EPS  .AND.  ABS(V) .LE. EPS ) THEN
          UVWD = CALM
       ELSE
C                ATAN2 RETURNS VALUE BETWEEN -PI <= ANGLE <= +PI
          UVWD = ATAN2(U,V) * R2D
C         CONVERT TO NORMAL WIND DIRECTION [DEGREES]
          IF( UVWD .LT. 0.0 ) THEN
              UVWD = 360.0 + UVWD
           ELSE IF( UVWD .EQ. 0.0 ) THEN
C             NORTH IS RETURNED AS 360 NOT 0
              UVWD = 360.0
          ENDIF
      ENDIF
      RETURN
      END
