      SUBROUTINE WPDF(ZS,BOUNCE,WPRIME,Y,ZELEV,U)
c       Given a hill shape and a receptor position (xr,yr,zelev) near it,
c       program computes backward trajectory to the point (xs,y,zs)
c       by iteration on w' values.  This is done for a direct path
c       or a reflected path from the ground.  Reflections from the mixed
c       layer must be accounted for by the use of an image source, as
c       specified by hpl in the input file INDAT.
c       Two slopes are calculated for comparison with w'/U values:
c             (xs,zs) to (xr,zr) is denoted "pole", and
c             (xs,zs) to (xr,0) is denoted "flat".
c       Differences among w'/U, pole, and flat quantify effects of
c       alternate terrain adjustment assumptions.

      INCLUDE 'PARAMS.INC'
C      INCLUDE 'CONST.CMN'
      INCLUDE 'IO.CMN'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'PASL.CMN'
C      INCLUDE 'PASVAL.CMN'
      INCLUDE 'TIME.CMN'
      INCLUDE 'VARS.CMN'
C      INCLUDE 'FLVAR.CMN'

      REAL ABSDIF, ABSWP, BOUNCE, DELTA, DISTI, DX, DXI, DX0, 
     *      F1, F2, FLAT, HF, HH0, HILL, IHILL, IREFL, ITER, 
     *      LXI, LXI2, PERT, POLE, SMALL, TOL, UTI, VSLP, 
     *      WPRIME, WPRIM1, WPRIM2, WPRIMEI, WSLP, XMID, 
     *      XPOS2, X, Y, Z, Z0, ZELEV, ZR, ZS, ZST, ZT

      DATA TOL/.01/,SMALL/0.00001/
      DATA DELTA/0.05/

C	LARGE CHUNK OF VARIABLE DEFINITIONS ARE IN GETHILL, CALLED
C	BEFORE RECEPTOR LOOP

C      SET DISTANCE INCREMENT IN THE X-DIRECTION FOR MAPPING TRAJECTORY
        DX0 = -LX * DELTA
C      SUBSTITUTE THIS FOR FLVAR COMMON BLOCK
        LXI = 1.0/LX
        LXI2 = LXI * LXI

c  Find the height of the receptor above the zero-plane
      hill=hilhgt(XEPL,YEPL)*hh
      zr=zelev+hill

c  Compute flat and pole slopes
         disti=1./(XEPL-XSEPL)
         pole=(bounce*zr-zs)*disti
         flat=(-zs)*disti

c  For receptors in the lee, check influence of hill at x=0
c  Parameter ihill=1 sets flag for calling FLOWSP
         if(XEPL .GT. 0.) then
            ihill=0
            z0=zs-pole*XSEPL
            hh0=hilhgt(0.,YEPL)*hh
            if(z0 .LE. 1.5*hh0) then
               ihill=1
            else
               z=z0-hh0
               call FLOWSP(0.,YEPL,z,uti,vslp,wslp,pert,ALF,u)
               if(pert .GE. 0.01) ihill=1
            endif
         endif

c  Iterate to find w'/U (slope)
c  First guess is set equal to mean of flat and pole result
         wprime=0.5*(flat+pole)*u
         if(bounce .EQ. -1.) wprime=pole*u
         wprimei = wprime
         iter=0

c  Enter iteration section and initialize

9        iter=iter+1
c  Stop the search if the number of iterations exceeds 30
         if(iter .GT. 30) then
            if (icase .gt.1) write(IOUT,22) NR,KYR,KMO,KDY,KHR
22          FORMAT(' WARNING Non-convergence in WPDF for receptor # ',
     *      I4,' on ',I2,'/',I2,'/',I2,' HR ',I2,/,
     *       ' Interpret results with caution!')
            goto 5
         endif

c  Reset the initial values
         x=XEPL
         y=YEPL
         zt=zr

c  Reset sign of wprime for trajectory at receptor (reflection)
         wprime=wprime*bounce

c  Reset reflection flag for the new trajectory
         irefl = 0

c  Loop over increments along x
10          hf=hilhgt(x,y)
            z=zt-hf*hh
c  Protect against round-off errors
            if ((z .lt. 0.0) .and. (z .gt. -0.01*tol)) z = 0.0
            if(z .LT. 0.) then
c  Path is reflected from the ground; sign reversed on wprime
c  Set reflection flag to 1
               irefl = 1
               z=-z
               zt=z+hf*hh
               wprime=-wprime
            endif
c  Set distance increment for this position
            xpos2=x*x*lxi2
            dx=dx0
            if(xpos2 .GT. 1.44) then
               dx=-0.2*LX
               dxi=(hf*xpos2)/(dx0*.3412)
               if(dxi .LE. 1./dx) dx=1./dxi
c  (note that dx<0 so that test assures that |dx0| < |dx| < lx/2 )
            endif
c  Obtain flow trajectory at midpoint of interval dx
            xmid=x+0.5*dx
            
            call FLOWSP(xmid,y,z,uti,vslp,wslp,pert,ALF,u)

            x=x+dx
            y=y+dx*vslp
            zt=zt+dx*(wslp+wprime*uti)

            if(x .GT. 0. .AND. ihill .EQ. 1) goto 10
            if(pert .GE. .01 .AND. x .GT. XSEPL) goto 10
c  End loop over x increments

c  Back up to previous position
         x=x-dx
         y=y-dx*vslp
         zt=zt-dx*(wslp+wprime*uti)

c  Use  slope to find intercept with source plane
        If (pert .ge. 0.01) then
          zst = zt + (xsepl-x)*(wslp+wprime*uti)
        else
          zst = zt + (xsepl-x)*(wprime/u)
        endif

c  Check to see if the trajectory reflected off the ground 
c  for cases where bounce = -1.  If it didn't bounce reset sign of
c  wprime and check zst value. Adjust initial or second guess wprime
c  if necessary (zst > 0), back up on iterations and try again.
        if (bounce .eq. -1.0 .and. irefl .eq. 0) then
          if (zst .lt. 0.0) then
            zst = -zst
            wprime = -wprime
          else
            if (iter .eq. 1) then
              wprime = -wprime*(1.1*zs/(zs-zst))
            endif
            if (iter .GE. 2) then
              wprime = (wprimei - wprime)/2.0
            endif
            iter = iter - 1
            go to 9
          endif
        endif
              

c  Estimating new slope by trying to minimize zst-zs
         if(iter .GE. 2) then
            wprim1=wprim2
            f1=f2
            wprim2=wprime
            f2=zst-zs
            IF (F1.EQ.F2) GO TO 5
            wprime=(f1*wprim2-f2*wprim1)/(f1-f2)
         else
            wprim2=wprime
            f2=zst-zs

c  Calculate the second guess for wprime  by one of the following
c  methods. Use method 1 for ground bounces.
           if(ABS(wprim2) .LT. small .or. bounce .eq. -1.) then
c  Method 1: average slopes
             wprime=(u*(zt-zs)+wprim2*(XEPL-x))*disti
            else
c  Method 2: intercept
               wprime=zs*u/(XSEPL-x+zt*u/wprim2)
            endif
         endif

c  Check for convergence
         absdif=ABS(wprime-wprim2)
         abswp=ABS(wprime)
c  Protect against wprime going to zero
         if(abswp .LT. .01*TOL) then
            if(absdif .GT. TOL) goto 9
         elseif(absdif/abswp .GT. TOL) then
            goto 9
         endif
    
5     RETURN

      end
 
