      SUBROUTINE WRAP(QS)
C-----------------------------------------------------------------------
C PURPOSE: HANDLES FLOW BELOW HC
C
C ARGUMENTS:
C   PASSED:
C       QS      REAL    EMISSION RATE [G/S]
C   RETURNED: NONE
C
C I/O:
C   INPUT: NONE
C   OUTPUT: UNIT=IOUT  WRAP CONCENTRATION (IF ICASE = YES)
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: ERF
C
C INTRINSIC FUNCTIONS: ABS  AMAX1  EXP  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: PARAMS  IO  CONST  PASVAL  PASW  VARS
C
C-----------------------------------------------------------------------
C
      INCLUDE 'PARAMS.INC'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'IO.CMN'
      INCLUDE 'CONST.CMN'
      INCLUDE 'PASVAL.CMN'
      INCLUDE 'PASW.CMN'
      INCLUDE 'VARS.CMN'
C
        REAL QS
C
C       DEFINE LOCAL VARIABLES
      REAL      ARG1SQ, ARG2SQ, ARGY, ARGYSQ, B1, B2, B3, BRAC1, 
     *          BRAC2, CLIFT, CO, CTOTAL, CWRAP, DENOM, ERFY, 
     *          EXP1, EXP2, FAC1, FAC2, SBETA, SIGVSQ, SIGWSQ, 
     *          SY, SYO, SYOSQ, SYP, SYPSQ, SYSQ, 
     *          SZ, SZO, SZOSQ, SZP, SZPSQ, SZSQ, UVBETI,
     *          YTO, YTR, ZTO, ZTR
C      INTEGER   ICASE 
C
        CWRAP = 0.0
        CLIFT = C
      UVBETI=1./UVBETA
      SIGWSQ=SIGW*SIGW
      SIGVSQ=SIGV*SIGV
C  DISTANCE TO RECEPTOR AND IMPING. PT. ALONG BETA
      SBETA=XRBETA-XSBETA
C  TEST FOR RECEPTOR UPWIND OF SOURCE IN BETA COORDINATE SYSTEM
      IF(SBETA*UVBETI .LE. 0.) THEN
         IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) WRITE(IOUT,105) NR
         RETURN
      ENDIF
C  TEST FOR SOURCES DOWNWIND OF STAGNATION POINT
      IF(SOBETA*UVBETI .LE. 0.) SOBETA = 0.
C  SECTION FOR RECS. AND SOURCES UPWIND OF PRIMARY IMPINGEMENT POINT
      IF(SOBETA .NE. 0.0) THEN
         IF(SBETA/SOBETA .LE. 1.0) THEN
            IF(Z .GT. HC) THEN
               IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) WRITE(IOUT,107) NR
               RETURN
            ENDIF
C  COMPUTE TRAVEL TIME
            ZTR=SBETA*UVBETI
            YTR=ABS(SBETA*UVBETI)
            IF((ZTR+ZTV) .LT. 0.) THEN
                SZ=SZS
            ELSE
C  COMPUTE SIGMAS               ....EQNS. 19,26
                SZSQ=SIGWSQ*(ZTR+ZTV)**2/(1.+.5*(ZTR+ZTV)/TTLZ)
                SZ=SQRT(SZSQ)
            ENDIF
            SYSQ=SIGVSQ*(YTR+YTV)**2/(1.+.5*(YTR+YTV)/TTLY)
            SY=SQRT(SYSQ)
C  COMPUTE CONCENTRATION AS CHI/Q IN MICROSECONDS PER M**3
C                       ....EQN. 47
            ARGYSQ=0.5*D*D/SYSQ
            IF(ARGYSQ .LT. 30.) THEN
               ARG1SQ=0.5*(HPL-Z)**2/SZSQ
               ARG2SQ=0.5*(HPL+Z)**2/SZSQ
               EXP1=0.
               EXP2=0.
               IF(ARG1SQ .LT. 30.) EXP1=EXP(-ARG1SQ)
               IF(ARG2SQ .LT. 30.) EXP2=EXP(-ARG2SQ)
               CO=1000000. * QS/(TWOPI*US*SY*SZ)
               CWRAP=CO*EXP(-ARGYSQ)*(EXP1+EXP2)
            ENDIF
         ELSE
C  SECTION FOR RECS. DOWNWIND OF PRIMARY IMPINGEMENT POINT
C  COMPUTE TRAVEL TIME TO IMPINGEMENT POINT AND RECEPTOR
            ZTO=SOBETA*UVBETI
            YTO=ABS(SOBETA*UVBETI)
            ZTR=(SBETA-SOBETA)*UVBETI+ZTO
            YTR=ABS(SBETA*UVBETI)
C   COMPUTE THE SIGMA-Z VALUES          ....EQN. 19
            SZSQ=SIGWSQ*(ZTR+ZTV)**2/(1.0+0.5*(ZTR+ZTV)/TTLZ)
            SZOSQ=SIGWSQ*(ZTO+ZTV)**2/(1.0+0.5*(ZTO+ZTV)/TTLZ)
C
C   DO NOT ALLOW SZO TO BE ZERO
C
            SZOSQ = AMAX1(SZOSQ,SMALL*SMALL*SZSQ)
            SZ=SQRT(SZSQ)
            SZO=SQRT(SZOSQ)
C                                       ....EQN. 46
            SZPSQ=SZSQ-SZOSQ
C  PROTECT AGAINST ROUNDOFF ERRORS
            IF (SZPSQ .LE. 0) THEN
              SZP = 0.
            ELSE
              SZP=SQRT(SZPSQ)
            ENDIF
C  COMPUTE THE SIGMA-Y VALUES           ....EQN. 26
            SYSQ=SIGVSQ*(YTR+YTV)**2/(1.+0.5*(YTR+YTV)/TTLY)
            SYOSQ=SIGVSQ*(YTO+YTV)**2/(1.+0.5*(YTO+YTV)/TTLY)
            SY=SQRT(SYSQ)
            SYO=SQRT(SYOSQ)
C                                       ....EQN. 46
            SYPSQ=SYSQ-SYOSQ
            IF (SYPSQ .LE. 0) THEN
              SYP = 0.
            ELSE
              SYP=SQRT(SYPSQ)
            ENDIF
C   COMPUTE THE CONCENTRATION AS CHI/Q IN MICROSECONDS PER M**3
C                                       ....EQNS. 44,45
            ARGYSQ=0.5*D*D/SYSQ
            ARGY=SQRT(ARGYSQ)
            IF(ARGYSQ .LT. 30.) THEN
               CO=(1000000.*QS/(TWOPI*US*SY))*EXP(-ARGYSQ)
               ERFY = 1.0
               IF(SYO.GT.SMALL) ERFY = ERF(ARGY*SYP/SYO)
               CO=CO*(1.+SIGNYE*ERFY)
               ARG1SQ=0.5*(HPL-Z)**2/SZSQ
               ARG2SQ=0.5*(HPL+Z)**2/SZSQ
               IF(ARG1SQ .LT. 30.) THEN
                  DENOM=SQR2*SZ*SZO*SZP
                  B1=HC*SZSQ
                  B2=Z*SZOSQ
                  B3=HPL*SZPSQ
                  IF(DENOM.GE.SMALL) THEN
                      BRAC1=ERF((B1-B2-B3)/DENOM)+ERF((B1+B2+B3)/DENOM)
                      IF(BRAC1 .LT. 0.) BRAC1=0.
                      BRAC2=ERF((B1+B2-B3)/DENOM)+ERF((B1-B2+B3)/DENOM)
                      IF(BRAC2 .LT. 0.) BRAC2=0.
                    ELSE
                      IF(B2.GT.B1) THEN
                          BRAC1 = 0.0
                          BRAC2 = 0.0
                        ELSE
                          BRAC1 = 2.0
                          BRAC2 = 2.0
                      ENDIF
                  ENDIF
                  FAC1=EXP(-ARG1SQ)
                  IF(ARG2SQ .GT. 30.) THEN
                     FAC2=0.
                  ELSE
                    FAC2=EXP(-ARG2SQ)
                  ENDIF
                  CWRAP =  (CO/(2.*SZ))*(FAC1*BRAC1+FAC2*BRAC2)
               ENDIF
            ENDIF
         ENDIF
      ENDIF
      CTOTAL = CLIFT + CWRAP
      IF(SOBETA.EQ.0.0) THEN
          IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) WRITE(IOUT,106) NR
        ELSE
          IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3)
     1      WRITE(IOUT,101)NR,ABS(SBETA),D,Z,HPL-Z,SY,SZ,SY,SZ,
     2                  CWRAP,NR,CTOTAL
      ENDIF
C     SET C TO TOTAL CONCENTRATION
      C = CTOTAL
      RETURN
C
101   FORMAT(1X,I3,' W',F8.0,3X,F8.1,2X,F7.1,2X,F7.1,1X,2F6.1,1X,
     &  2F6.1,1X,1PE10.4,/,1X,I3,' TOTAL',T71,1PE10.4)
105   FORMAT(1X,I3,20X,'RECEPTOR LIES UPWIND OF SOURCE IN ',
     *        'BETA COORD. SYS')
106   FORMAT(1X,I3,' WRAP N/A (PLUME MISSES HILL)')
107   FORMAT(1X,I3,' WRAP N/A (REC. UPWIND OF HILL OR ABOVE HC)')
C
      END
