        SUBROUTINE WRITIT(TIME, CONC, NREC, IOCONC)
C-----------------------------------------------------------------------
C SUBROUTINE: WRITIT
C
C PURPOSE:  WRITE HOURLY CONCENTRATIONS TO DISK FILE.
C
C ASSUMPTIONS: SWITCH ICONC IN "PARAMS.CMN" CONTROLS THE OUTPUT FORMAT.
C
C ARGUMENTS:
C    PASSED:
C       TIME    INT     ARRAY OF LENGTH 5 CONTAINING YEAR, MONTH,
C                            DAY, HOUR AND MAX CONCENTRATION HOUR 
C                            INFORMATION
C       CONC    REAL    ARRAY OF MODELED CONCENTRATIONS FOR THIS HOUR
C       NREC    INT     NUMBER OF RECEPTORS
C       IOCONC  INT     UNIT NUMBER USED FOR OUTPUT OF CONCENTRATIONS
C
C    RETURNED: NONE
C
C I/O:
C   INPUT: NONE
C
C   OUTPUT    UNIT=IOCONC   ARRAYS MET AND CONC (FOR NREC RECEPTORS)
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNALS: NONE
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: PARAMS.CMN  RECEPT.CMN
C
C-----------------------------------------------------------------------
C
      INCLUDE 'PARAMS.INC'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'RECEPT.CMN'
C       DEFINE ARGUMENTS, LOCAL VARIABLES
        INTEGER         I, NREC,   IOCONC
        REAL            CONC(NREC)
        INTEGER*2       TIME(5)
        INTEGER         NR
        CHARACTER*20 UNITS
C       SET CONCENTRATION UNITS
        IF (ICHIQ .EQ. 0) THEN
           UNITS = '  MICROGRAMS/M**3'
        ELSE
           UNITS = '  MICROSECONDS/M**3'
        END IF
C       TEST ON SWITCH
        IF(ICONC .EQ. 1) THEN
C           BINARY OUTPUT FILE
            WRITE(IOCONC) (TIME(I),I=1,5),NREC,CONC
        ELSE IF(ICONC .EQ. 2) THEN
C           TEXT FILE, CONCENTRATIONS ONLY
            WRITE(IOCONC,61) (TIME(I),I=1,5),NREC,UNITS
            WRITE(IOCONC,62) CONC
        ELSE
C           TEXT FILE, RECEPTOR INFO PLUS CONCENTRATIONS
            IF(ICONC .LT. 0) THEN
C               FIRST TIME THROUGH WRITE HEADER
                ICONC = IABS(ICONC)
                WRITE(IOCONC,64) NREC
                DO 110 NR=1,NREC
                    WRITE(IOCONC,65) NR, (RECPT(I,NR),I=1,4), NRHILL(NR)
110             CONTINUE
            ENDIF
            WRITE(IOCONC,61) (TIME(I),I=1,5),NREC,UNITS
            DO 120 NR=1, NREC
                WRITE(IOCONC,63) NR, CONC(NR)
120         CONTINUE
        ENDIF
        RETURN
C
61      FORMAT(6I5,A20)
62      FORMAT(8E10.3)
63      FORMAT(I4, 1X, E10.4)
64      FORMAT(I5)
65      FORMAT(I4,1X,F8.0,1X,F8.0,1X,F7.1,1X,F6.1,1X,I4)
        END

