C-----------------------------------------------------------------------CUB00010
C SUBROUTINE: CUBIC                                                     CUB00020
C                                                                       CUB00030
C PURPOSE:  SOLVES A CUBIC EQUATION: Z**3 + A*Z**2 + B*Z + C = 0        CUB00040
C                                                                       CUB00050
C ARGUMENTS                                                             CUB00060
C  PASSED:                                                              CUB00070
C       A       REAL    COEFFICIENT OF Z**2                             CUB00080
C       B       REAL    COEFFICIENT OF Z**1                             CUB00090
C       C       REAL    COEFFICIENT OF Z**0                             CUB00100
C                                                                       CUB00110
C  RETURNED:                                                            CUB00120
C       Z       REAL    SOLUTION OF CUBIC EQUATION                      CUB00130
C                                                                       CUB00140
C INTRINSIC FUNCTIONS: DSQRT, DSIGN, DABS, DACOS, DCOS                  CUB00150
C                                                                       CUB00160
C-----------------------------------------------------------------------CUB00170
C                                                                       CUB00180
      SUBROUTINE CUBIC(A,B,C,Z)                                         CUB00190
C                                                                       CUB00200
C     SOLVES FOR ONE ROOT OF THE CUBIC EQUATION:                        CUB00210
C     Z**3 + A*Z**2 + B*Z + C = 0                                       CUB00220
C                                                                       CUB00230
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)                               CUB00240
      REAL A,B,C,Z                                                      CUB00250
      DATA ONE/1.0/                                                     CUB00260
      A3=A/3.                                                           CUB00270
      AP=B-A*A3                                                         CUB00280
      BP=2.*A3**3-A3*B+C                                                CUB00290
      AP3=AP/3.                                                         CUB00300
      BP2=BP/2.                                                         CUB00310
      TROOT=BP2*BP2+AP3*AP3*AP3                                         CUB00320
      IF(TROOT.LE.0.0)GO TO 50                                          CUB00330
      TR=DSQRT(TROOT)                                                   CUB00340
      APP=(-BP2+TR)**0.333333                                           CUB00350
      BSV=-BP2-TR                                                       CUB00360
      IF(BSV.EQ.0.0)GO TO 45                                            CUB00370
      SGN=DSIGN(ONE,BSV)                                                CUB00380
      BPP=SGN*(DABS(BSV))**0.333333                                     CUB00390
      Z=APP+BPP-A3                                                      CUB00400
      RETURN                                                            CUB00410
45    CONTINUE                                                          CUB00420
C     BSV (& BPP) = 0.0                                                 CUB00430
      Z=APP-A3                                                          CUB00440
      RETURN                                                            CUB00450
50    CM=2.*DSQRT(-AP3)                                                 CUB00460
      ALPHA=DACOS(BP/(AP3*CM))/3.                                       CUB00470
      Z=CM*DCOS(ALPHA)-A3                                               CUB00480
      RETURN                                                            CUB00490
      END                                                               CUB00500
                                                                        CUB00510
