C-----------------------------------------------------------------------HVV00010
C SUBROUTINE: HV                                                        HVV00020
C                                                                       HVV00030
C PURPOSE: COMPUTES THE SENSIBLE HEAT FLUX FROM THE NET RADIATION       HVV00040
C                                                                       HVV00050
C METHOD: HOLTSLAG-VAN ULDEN                                            HVV00060
C                                                                       HVV00070
C ARGUMENTS PASSED: I     INTEGER     HOUR                              HVV00080
C                   P     REAL        PRESSURE                          HVV00090
C                   BOWEN REAL        BOWEN RATIO FOR THIS HOUR         HVV00100
C                                                                       HVV00110
C COMMON: TEMP  RNET                                                    HVV00120
C                                                                       HVV00130
C INTRINSIC FUNCTIONS: ALOG10                                           HVV00140
C-----------------------------------------------------------------------HVV00150
      SUBROUTINE HV(I,P,BOWEN)                                          HVV00160
C                                                                       HVV00170
      REAL PRESS                                                        HVV00180
      COMMON/TEMP/T(24)                                                 HVV00190
      COMMON/RNET/RN(24),QS(24)                                         HVV00200
C                                                                       HVV00210
C     SET UP CONSTANTS                                                  HVV00220
C                                                                       HVV00230
C     XLV IS LATENT HEAT OF VAPORIZATION FOR WATER (J/KG)               HVV00240
C     RV IS THE SPECIFIC GAS CONSTANT FOR WATER VAPOR (J/KG-K)          HVV00250
C     EPI IS RATIO OF DRY AIR AND WATER VAPOR GAS CONSTANTS             HVV00260
C     GAMMA IS SPECIFIC HEAT (CP) DIVIDED BY LATENT HEAT OF VAPORIZATIONHVV00270
C     CG IS THE FRACTION OF NET RADIATION LOST TO THE SOIL              HVV00280
C                                                                       HVV00290
      DATA XLV/2.501E6/                                                 HVV00300
      DATA RV/461.51/                                                   HVV00310
      DATA EPI/0.622/                                                   HVV00320
      DATA GAMMA/4.01808E-4/                                            HVV00330
      DATA CG/0.1/                                                      HVV00340
      DATA BETAP/20./                                                   HVV00350
C                                                                       HVV00360
C     CONVERT PRESSURE TO PASCALS                                       HVV00370
C     COMPUTE SATURATION VAPOR PRESS (PASCALS) AT TEMP T (K)            HVV00380
C     COMPUTE SLOPE OF SATURATION VAPOR PRESS CURVE (CLAUSIUS-CLAPEYRON)HVV00390
C     (FROM STANDARD TEXTS ON METEOROLOGY SUCH AS HESS, 1959:           HVV00400
C     INTRODUCTION TO THEORETICAL METEOROLOGY, P 94.                    HVV00410
C                                                                       HVV00420
      PRESS=P*100.                                                      HVV00430
      ES=100.*10.**(-2937.4/T(I)-4.9283*ALOG10(T(I))+23.5518)           HVV00440
      DESDT=XLV*ES/RV/T(I)**2                                           HVV00450
      S=(PRESS*EPI*DESDT)/(PRESS-ES)**2                                 HVV00460
C                                                                       HVV00470
C     COMPUTE ALPHA FROM BOWEN RATIO, GAMMA/S, CG, AND RN               HVV00480
C                                                                       HVV00490
      Z = 1.0 + GAMMA/S                                                 HVV00500
      QUP = (1.0 - CG) * RN(I)                                          HVV00510
C                                                                       HVV00520
C     ALPHA IS USED IN EQN 11 OF USER'S GUIDE                           HVV00530
C                                                                       HVV00540
      ALPHA = (Z*QUP)/((1.0+BOWEN) * (QUP + BETAP*Z))                   HVV00550
C                                                                       HVV00560
C     SEE EQN 8 OF USER'S GUIDE FOR EQUATIONS LISTED BELOW              HVV00570
C                                                                       HVV00580
      BETA = ALPHA*BETAP                                                HVV00590
C                                                                       HVV00600
C     COMPUTE SENSIBLE HEAT FLUX                                        HVV00610
C                                                                       HVV00620
      QS(I) = (Z-ALPHA)/Z * QUP - BETA                                  HVV00630
      RETURN                                                            HVV00640
      END                                                               HVV00650
