C-----------------------------------------------------------------------HVN00010
C SUBROUTINE: HVNET                                                     HVN00020
C                                                                       HVN00030
C PURPOSE: COMPUTES NET RADIATION FROM TOTAL INCOMING SOLAR RADIATION   HVN00040
C                                                                       HVN00050
C METHOD: HOLTSLAG-VAN ULDEN                                            HVN00060
C                                                                       HVN00070
C ARGUMENTS PASSED: I         INTEGER     HOUR                          HVN00080
C                   ALBEDO    REAL        SURFACE ALBEDO FOR THIS HOUR  HVN00090
C                                                                       HVN00100
C COMMON: TEMP  INIT    CVR     RNET                                    HVN00110
C-----------------------------------------------------------------------HVN00120
      SUBROUTINE HVNET(I,ALBEDO)                                        HVN00130
C                                                                       HVN00140
      INTEGER I,CC                                                      HVN00150
      REAL ALBEDO                                                       HVN00160
      COMMON/TEMP/T(24)                                                 HVN00170
      COMMON/INIT/QR(24)                                                HVN00180
      COMMON/CVR/CC(24)                                                 HVN00190
      COMMON/RNET/RN(24),QS(24)                                         HVN00200
C                                                                       HVN00210
C     SET CONSTANTS: C1, C2, AND C3 FROM HOLTSLAG - VAN ULDEN           HVN00220
C                    SB = STEFAN-BOLTZMANN CONSTANT                     HVN00230
C                                                                       HVN00240
      DATA C1/5.31E-13/                                                 HVN00250
      DATA C2/60./                                                      HVN00260
      DATA C3/0.12/                                                     HVN00270
      DATA SB/5.67E-8/                                                  HVN00280
C                                                                       HVN00290
C     COMPUTE NET RAD (WATTS/M**2) FROM ALBEDO, SOLAR INSOLATION        HVN00300
C     SFC TEMP (K) AND SKY COVER (TENTHS)                               HVN00310
C                                                                       HVN00320
C     EQN 6 FROM USER'S GUIDE                                           HVN00330
C                                                                       HVN00340
      RN(I)=((1.-ALBEDO)*QR(I)+C1*T(I)**6-SB*T(I)**4+C2*(CC(I)/10.))/   HVN00350
     *   (1.+C3)                                                        HVN00360
      RETURN                                                            HVN00370
      END                                                               HVN00380
