C-----------------------------------------------------------------------INI00010
C SUBROUTINE: INITT                                                     INI00020
C                                                                       INI00030
C PURPOSE: COMPUTES INTEGRATED SENSIBLE HEAT FLUX, JOULES/M**2          INI00040
C	   (RIGHT SIDE OF EQN 27 IN USER'S GUIDE)                       INI00050
C                                                                       INI00060
C ARGUMENTS PASSED: ITFST     INTEGER     FIRST INSOLATION HOUR         INI00070
C                   ITLST     INTEGER     LAST INSOLATION HOUR          INI00080
C                   ITIMM     INTEGER     TIME 0                        INI00090
C                                                                       INI00100
C EXTERNAL ROUTINES: SENSE                                              INI00110
C-----------------------------------------------------------------------INI00120
        SUBROUTINE INITT(ITFST,ITLST,ITIMM)                             INI00130
C                                                                       INI00140
        REAL QST(24)                                                    INI00150
        COMMON/RNET/RN(24),QS(24)                                       INI00160
        COMMON/US/USTAR(24)                                             INI00170
        COMMON/SUMH/SQR(24)                                             INI00180
        COMMON/INIT/QR(24)                                              INI00190
        COMMON/WIND/WSL(24),A(24)                                       INI00200
        ITFST=9999                                                      INI00210
C                                                                       INI00220
C       CONVERT QS FROM W/M**2 TO LY/MIN                                INI00230
C                                                                       INI00240
        DO 100 IHR=1,24                                                 INI00250
        QST(IHR)=QS(IHR)/697.8                                          INI00260
100     CONTINUE                                                        INI00270
C                                                                       INI00280
C       DEFINE ITFST AS FIRST INSOLATION HOUR (I.E., HOUR BEFORE HOUR   INI00290
C       THAT QS.GT.0.001 LY/HR)                                         INI00300
C       DEFINE ITLST AS LAST INSOLATION HOUR (I.E., HOUR AFTER ITFST    INI00310
C       WHEN QS.LT.0.001 LY/HR FOR 2 CONSECUTIVE HOURS)                 INI00320
C                                                                       INI00330
        DO 110 IHR=2,24                                                 INI00340
        IF(QST(IHR).GT.0.001.AND.QST(IHR-1).LT.0.001) ITFST=IHR-1       INI00350
        IF(IHR.GT.ITFST.AND.(QST(IHR).LT.0.001.AND.QST(IHR-1).LT.0.001))INI00360
     *  GO TO 120                                                       INI00370
C                                                                       INI00380
C       COMPUTE AREA UNDER US**3 CURVE WRT TIME (M**3/S**2) FOR EACH    INI00390
C       HOUR USING TRAPEZOIDS                                           INI00400
C                                                                       INI00410
        A(IHR-1)=1800.*(USTAR(IHR-1)**3+USTAR(IHR)**3)                  INI00420
  110   CONTINUE                                                        INI00430
  120   ITLST=IHR-1                                                     INI00440
C                                                                       INI00450
C       DETERMINE TIME (IN MINUTES FROM MIDNIGHT) WHEN SENSIBLE HEAT    INI00460
C       FLUX FIRST BECOMES POSITIVE.                                    INI00470
C       THIS TIME IS T=0 FOR ALL TIME INTEGRATIONS.                     INI00480
C       GET WHOLE HOUR OF START TIME                                    INI00490
C                                                                       INI00500
        CALL SENSE(ITIMM)                                               INI00510
        ISTART=ITIMM/60+1                                               INI00520
C                                                                       INI00530
C       COMPUTE INTEGRATED SENSIBLE HEAT FLUX (JOULES/M**2)             INI00540
C       MULTIPLY LY/MIN TIMES 697.8 * 3600. = 2512080. TO GET J/M**2    INI00550
C                                                                       INI00560
        DO 130 IHR=1,ITLST                                              INI00570
        IF(IHR.LT.ISTART) SQR(IHR)=0.                                   INI00580
        IF(IHR.EQ.ISTART) SQR(IHR)=QST(IHR)*2512080.                    INI00590
        IF(IHR.GT.ISTART) SQR(IHR)=QST(IHR)*2512080.+SQR(IHR-1)         INI00600
130     CONTINUE                                                        INI00610
        RETURN                                                          INI00620
        END                                                             INI00630
