C---------------------------------------------------------------------- MET00010
C MAIN PROGRAM: METPRO                                                  MET00020
C                                                                       MET00030
C PURPOSE: PROGRAM CREATES THE FILE "SURFACE" FOR USE IN CTDM           MET00040
C                                                                       MET00050
C METHODS: DURING THE DAY, COMPUTES USTAR AND L USING THE HOLTSLAG-VAN  MET00060
C          ULDEN METHOD AND ZI USING 1) THE CARSON METHOD IF UPPER AIR  MET00070
C          DATA ARE PROVIDED FOR AN CONTIGUOUS HOUR RUN, OR 2) USER-    MET00080
C          PROVIDED VALUES OF MIXED LAYER HEIGHT FOR A RUN OF SELECTED  MET00090
C          HOURS.  AT NIGHT, COMPUTES USTAR AND L USING THE VENKATRAM   MET00100
C          METHOD AND MIXING HEIGHT USING THE ZILITINKEVICH METHOD.     MET00110
C                                                                       MET00120
C I/O: UNIT  5    INPUT     OPTIONS (PROGRAM OPTIONS)                   MET00130
C      UNIT  6    OUTPUT    OUTPUT  (LIST OF PROGRAM OPTIONS USED)      MET00140
C      UNIT  7    OUTPUT    SURFACE (INPUT FILE TO CTDM)                MET00150
C      UNIT  9    INPUT     RAWIN   (UPPER AIR DATA)                    MET00160
C      UNIT 10    INPUT     SURF1   (ONSITE MET DATA)                   MET00170
C      UNIT 11    INPUT     SURF2   (NWS SURFACE DATA)                  MET00180
C      UNIT 12    INPUT     PROFILE (ONSITE MET PROFILE)                MET00190
C                                                                       MET00200
C COMMON: PTEMP XSUMI   WIND    US      RNET    MONIN   CVR     TEMP    MET00210
C         NCC   HMI     INIT    ZILIT   THS     IO                      MET00220
C                                                                       MET00230
C EXTERNAL ROUTINES: DEFAUL     HOUR    HV      HVNET   INITT   MINUTE  MET00240
C                    SENSE      SUMHH   SUMI    SUMVV   TT      ZZI     MET00250
C                    HDAYUS     TOTAL   SUN     WNUS    JULIAN  RHOO    MET00260
C                    ZILL                                               MET00270
C                                                                       MET00280
C INTRINSIC FUNCTIONS: SIN SQRT MIN EXP                                 MET00290
C                                                                       MET00300
C-----------------------------------------------------------------------MET00310
C                                                                       MET00320
C       GLOSSARY OF IMPORTANT VARIABLES (MKS SYSTEM USED FOR UNITS)     MET00330
C                                                                       MET00340
C       CH:      CLOUD HEIGHT                                           MET00350
C       CC:      CLOUD COVER                                            MET00360
C       NLEV:    NUMBER OF SOUNDING LEVELS                              MET00370
C       WDSEC:   WIND DIRECTION BOUNDARIES OF UPWIND FETCH SECTORS      MET00380
C       WD:      HOURLY WIND DIRECTION (NEAR 10 M) USED TO GET UPWIND   MET00390
C                   CHARACTERISTICS                                     MET00400
C       RN:      NET RADIATION                                          MET00410
C       QR:      TOTAL INCOMING RADIATION                               MET00420
C       THSTAR:  THETA-STAR, THE TEMPERATURE SCALE FOR PROFILING        MET00430
C       VONK:    VON KARMAN CONSTANT                                    MET00440
C       ZIOBS:   OBSERVED (MEASURED) MIXED LAYER HEIGHT                 MET00450
C       Z0:      SURFACE ROUGHNESS LENGTH                               MET00460
C       ALB:     SURFACE ALBEDO                                         MET00470
C       BOW:     BOWEN RATIO                                            MET00480
C       SAI:     AREA UNDER Z-THETA CURVE (LEFT SIDE OF EQN 27 IN       MET00490
C                   USER GUIDE)                                         MET00500
C       SAI2:    AREA UNDER Z**2-THETA CURVE (LEFT SIDE OF EQN 28       MET00510
C                   IN USER GUIDE)                                      MET00520
C       L:       MONIN-OBUKHOV LENGTH                                   MET00530
C       USTAR:   SURFACE FRICTION VELOCITY                              MET00540
C       ZIL:     COMPUTED (ESTIMATED) MIXED LAYER HEIGHT                MET00550
C       T:       AMBIENT TEMPERATURE (NEAR 10 METERS)                   MET00560
C       WSL:     WIND SPEED AT 10 METERS                                MET00570
C       Z0DAY:   HOURLY SURFACE ROUGHNESS LENGTH VALUES                 MET00580
C       ZHR:     HEIGHTS OF DATA FROM FILE "PROFILE"                    MET00590
C       WDHR:    WIND DIRECTION VALUES FROM FILE "PROFILE"              MET00600
C       WSHR:    WIND SPEED VALUES FROM FILE "PROFILE"                  MET00610
C       TAHR:    AMBIENT TEMPERATURE VALUES FROM FILE "PROFILE"         MET00620
C       PRS:     PRESSURE VALUES AT SOUNDING LEVELS                     MET00630
C       TMP:     AMBIENT TEMPERATURE VALUES AT SOUNDING LEVELS          MET00640
C       PTMP:    POTENTIAL TEMPERATURE (THETA) VALUES AT SOUNDING LEVELSMET00650
C       HT:      GEOPOTENTIAL HEIGHTS AT SOUNDING LEVELS                MET00660
C       AI:      15-MINUTE PORTION OF SUM OVER TIME OF AREA UNDER Z-    MET00670
C                   THETA CURVE                                         MET00680
C       AI2:     15-MINUTE PORTION OF SUM OVER TIME OF AREA UNDER Z**2- MET00690
C                   THETA CURVE                                         MET00700
C                                                                       MET00710
        CHARACTER*1 NWSCC                                               MET00720
        INTEGER Y,M,D,JUL,H,I,YUP,Y1,M1,D1,H1                           MET00730
        INTEGER CH(24),IHR,CC,MUP,DUP,ITIME,NLEV                        MET00740
        INTEGER MODE,Y2,M2,D2,H2                                        MET00750
        INTEGER WDSEC(8,2),IDIFF,MISS(24)                               MET00760
        REAL WD(24),RN,RHOCP,QR,THSTAR                                  MET00770
        REAL LAT,LONG,ZONE,RHO                                          MET00780
        REAL ZIOBS(24),Z0(12,8),ALB(12,8),BOW(12,8),SAI,SAI2,L,USTAR    MET00790
        REAL ZIL,T,WSL,Z0DAY(24)                                        MET00800
        REAL ZHR(51),WDHR(51),WSHR(51),TAHR(51)                         MET00810
        COMMON/PTEMP/PRS(80),TMP(80),PTMP(80)                           MET00820
        COMMON/XSUMI/HT(80),AI(80),AI2(80)                              MET00830
        COMMON/WIND/WSL(24),A(24)                                       MET00840
        COMMON/US/USTAR(24)                                             MET00850
        COMMON/RNET/RN(24),QS(24)                                       MET00860
        COMMON/MONIN/L(24)                                              MET00870
        COMMON/CVR/CC(24)                                               MET00880
        COMMON/TEMP/T(24)                                               MET00890
        COMMON/NCC/NWSCC(24)                                            MET00900
        COMMON/HM1/SAI(80),SAI2(80)                                     MET00910
        COMMON/INIT/QR(24)                                              MET00920
        COMMON/ZILIT/ZIL(24)                                            MET00930
        COMMON/THS/THSTAR(24)                                           MET00940
        COMMON/IO/IOPT,IOUT,ISURF,IRAWIN,ISURF1,ISURF2                  MET00950
        COMMON/SOLANG/ANGLE(24)                                         MET00960
C                                                                       MET00970
C       ASSIGN VALUES OF WIND, TEMP IN CASE OF MISSING DATA FOR HOUR #1 MET00980
C                                                                       MET00990
        WD(24) = 360.                                                   MET01000
        WSL(24) = 5.0                                                   MET01010
        T(24) = 293.                                                    MET01020
C                                                                       MET01030
C       ASSIGN PROGRAM CONSTANTS (MKS UNITS)                            MET01040
C                                                                       MET01050
C       CP = SPECIFIC HEAT OF AIR AT CONSTANT PRESSURE                  MET01060
C       G = ACCELERATION DUE TO GRAVITY                                 MET01070
C       A1 AND B = CONSTANTS USED IN THE MODIFIED CARSON MODEL          MET01080
C       DEGRAD = CONSTANT TO CONVERT FROM DEGREES TO RADIANS            MET01090
C                                                                       MET01100
        CP=1004.                                                        MET01110
        G=9.80655                                                       MET01120
        A1=0.2                                                          MET01130
        B=2.5                                                           MET01140
        DEGRAD=57.29578                                                 MET01150
        PRES = 1013.25                                                  MET01160
C                                                                       MET01170
C       OPEN INPUT FILES                                                MET01180
C                                                                       MET01190
        IOPT = 5                                                        MET01200
        IOUT = 6                                                        MET01210
        ISURF = 7                                                       MET01220
        IRAWIN = 9                                                      MET01230
        ISURF1 = 10                                                     MET01240
        ISURF2 = 11                                                     MET01250
        INPROF = 12                                                     MET01260
C                                                                       MET01270
        OPEN(ISURF1,FILE='SURF1',STATUS='OLD')                          MET01280
        OPEN(IOPT,FILE='OPTIONS',STATUS='OLD')                          MET01290
        OPEN(INPROF,FILE='PROFILE',STATUS='OLD')                        MET01300
C                                                                       MET01310
C       OPEN OUTPUT FILES; ASSIGN DEFAULT I/O UNIT NUMBERS              MET01320
C                                                                       MET01330
        OPEN(ISURF,FILE='SURFACE',STATUS='UNKNOWN')                     MET01340
        OPEN(IOUT,FILE='OUTPUT',STATUS='UNKNOWN')                       MET01350
C                                                                       MET01360
C       READ IN OPTIONS                                                 MET01370
C                                                                       MET01380
C       MODE:   IF 0, DO NOT READ NWS SURFACE DATA NOR UPPER AIR DATA,  MET01390
C                     ASSUME CONSTANT SITE CHARACTERISTICS.             MET01400
C               IF 1, DO NOT READ NWS SURFACE DATA NOR UPPER AIR DATA,  MET01410
C                     BUT ASSUME VARIABLE SITE CHARACTERISTICS.         MET01420
C               IF 2, READ NWS SURFACE DATA, BUT NOT UPPER AIR DATA.    MET01430
C               IF 3, READ NWS SURFACE DATA AND UPPER AIR DATA.         MET01440
C                                                                       MET01450
        READ(IOPT,*) MODE                                               MET01460
        WRITE(IOUT,8010) MODE                                           MET01470
        IF(MODE.GT.1) THEN                                              MET01480
            OPEN(ISURF2,FILE='SURF2',STATUS='OLD')                      MET01490
        ENDIF                                                           MET01500
        IF(MODE.GT.2)                                                   MET01510
     1      OPEN(IRAWIN,FILE='RAWIN',STATUS='OLD')                      MET01520
C                                                                       MET01530
C       READ ADDITIONAL SITE-SPECIFIC INFORMATION (IF MODE=0, INPUT     MET01540
C               PROVIDED IS LESS DETAILED):                             MET01550
C       1) LATITUDE, LONGITUDE, TIME ZONE                               MET01560
C            TIME ZONES: 5 EASTERN, 6=CENTRAL, 7=MOUNTAIN, 8=PACIFIC    MET01570
C            FOR STANDARD TIME (SUBTRACT 1 HOUR FOR DAYLIGHT SAVINGS)   MET01580
C       2) NUMBER OF WIND DIRECTION SECTORS FOR SURFACE CHARACTERISTICS MET01590
C       3) DEFINITION OF THE SECTORS (IF MORE THAN ONE)                 MET01600
C       4) SURFACE CHARACTERISTICS (MONTHLY VALUES FOR EACH SECTOR):    MET01610
C               SURFACE ROUGHNESS LENGTHS                               MET01620
C               ALBEDO                                                  MET01630
C               BOWEN RATIO                                             MET01640
C                                                                       MET01650
C       NOTE: INPUT DATA FOR WIND DIRECTION SECTORS USES THE CONVENTION MET01660
C             THAT THE WIND DIRECTION IS THAT FROM WHICH THE WIND IS    MET01670
C             BLOWING, AND THE UPWIND CHARACTERISTICS ARE THAT WHICH AREMET01680
C             IMPORTANT. FOR EXAMPLE, CHARACTERISTICS TO THE SOUTH OF A MET01690
C             STACK WOULD BE ASSOCIATED WITH A SOUTHERLY WIND.          MET01700
C                                                                       MET01710
        IF(MODE.GT.0) GO TO 90                                          MET01720
        READ(IOPT,*) LAT,LONG,ZONE,Z0CASE,ALBD,BOWEN                    MET01730
        WRITE(IOUT,8015) LAT,LONG,ZONE,Z0CASE,ALBD,BOWEN                MET01740
        WRITE(IOUT,8082)                                                MET01750
        LAT = LAT/DEGRAD                                                MET01760
        GO TO 104                                                       MET01770
C                                                                       MET01780
90      READ(IOPT,*) LAT,LONG,ZONE                                      MET01790
        WRITE(IOUT,8020) LAT,LONG,ZONE                                  MET01800
C                                                                       MET01810
C       READ DATA FOR DIRECTION SECTORS (SITE CHARACTERISTICS)          MET01820
C                                                                       MET01830
        READ(IOPT,*) NSEC                                               MET01840
        IF(NSEC.GT.8 .OR.NSEC.LT.1) THEN                                MET01850
            WRITE(IOUT,7095) NSEC                                       MET01860
            STOP                                                        MET01870
        ENDIF                                                           MET01880
        WRITE(IOUT,8090) NSEC                                           MET01890
        IF(NSEC.GT.1) THEN                                              MET01900
            DO 100 I = 1,NSEC                                           MET01910
                READ(IOPT,*) WDSEC(I,1),WDSEC(I,2)                      MET01920
                IF(I.EQ.1) GO TO 100                                    MET01930
                IDIFF = WDSEC(I,1) - WDSEC(I-1,2)                       MET01940
                IF(IDIFF.LT.0) IDIFF = IDIFF + 360                      MET01950
                IF(IDIFF.NE.1) THEN                                     MET01960
                    WRITE(IOUT,7110)                                    MET01970
                    STOP                                                MET01980
                ENDIF                                                   MET01990
                IF(I.EQ.NSEC) THEN                                      MET02000
                    IDIFF = WDSEC(1,1) - WDSEC(NSEC,2)                  MET02010
                    IF(IDIFF.LT.0) IDIFF = IDIFF + 360                  MET02020
                    IF(IDIFF.NE.1) THEN                                 MET02030
                        WRITE(IOUT,7110)                                MET02040
                        STOP                                            MET02050
                    ENDIF                                               MET02060
                ENDIF                                                   MET02070
100         CONTINUE                                                    MET02080
          ELSE                                                          MET02090
            WDSEC(1,1) = 1                                              MET02100
            WDSEC(1,2) = 360                                            MET02110
        ENDIF                                                           MET02120
        WRITE(IOUT,8100) (J,WDSEC(J,1),WDSEC(J,2),J=1,NSEC)             MET02130
        WRITE(IOUT,8110)                                                MET02140
        DO 102 J = 1,NSEC                                               MET02150
            READ(IOPT,*) (Z0(I,J),I=1,12)                               MET02160
            READ(IOPT,*) (ALB(I,J),I=1,12)                              MET02170
            READ(IOPT,*) (BOW(I,J),I=1,12)                              MET02180
            WRITE(IOUT,8080) (Z0(I,J),I=1,12),(ALB(I,J),I=1,12),        MET02190
     1                   (BOW(I,J),I=1,12),J                            MET02200
102     CONTINUE                                                        MET02210
        IF(MODE.LT.3) WRITE(IOUT,8082)                                  MET02220
        WRITE(IOUT,8085)                                                MET02230
C                                                                       MET02240
C       CONVERT LAT FROM DEGREES TO RADIANS                             MET02250
        LAT=LAT/DEGRAD                                                  MET02260
C                                                                       MET02270
104     CONTINUE                                                        MET02280
C                                                                       MET02290
C       START HOUR LOOP.                                                MET02300
C       CHECK FOR DATE CONSISTENCY BETWEEN ONSITE AND OFFSITE DATA IF   MET02310
C       MODE > 1.                                                       MET02320
C                                                                       MET02330
        H = 1                                                           MET02340
105     CONTINUE                                                        MET02350
C                                                                       MET02360
C       READ FROM SURF1: YEAR, MONTH, DAY, HOUR, TOTAL INCOMING SOLAR   MET02370
C       RADIATION, NET RADIATION, OBSERVED MIXED LAYER HT (M), CLOUD    MET02380
C       HEIGHT (100'S OF FEET), CLOUD COVER (TENTHS)                    MET02390
C                                                                       MET02400
        READ(ISURF1,*,END=900) Y,M,D,IHR,QRHR,RNHR,ZIOHR,CHHR,CCHR      MET02410
        IF(MODE.GT.2 .AND. IHR.NE.H) THEN                               MET02420
            WRITE(IOUT,7135) Y,M,D,IHR,H                                MET02430
            STOP                                                        MET02440
        ENDIF                                                           MET02450
        MISS(IHR) = 0                                                   MET02460
        QR(IHR) = QRHR                                                  MET02470
        RN(IHR) = RNHR                                                  MET02480
        ZIOBS(IHR) = ZIOHR                                              MET02490
C                                                                       MET02500
C       CH (CLOUD HT) IS READ BUT NOT USED IN THIS VERSION OF METPRO    MET02510
C                                                                       MET02520
        CH(IHR) = CHHR                                                  MET02530
        CC(IHR) = CCHR                                                  MET02540
        IF(MODE.EQ.0) THEN                                              MET02550
            Z0DAY(IHR) = Z0CASE                                         MET02560
            IF(CC(IHR).LT.0) THEN                                       MET02570
                WRITE(IOUT,7145) Y,M,D,IHR                              MET02580
                STOP                                                    MET02590
            ENDIF                                                       MET02600
        ENDIF                                                           MET02610
C                                                                       MET02620
C       READ PROFILE TO GET WD, WS, T FROM 10 METERS                    MET02630
C                                                                       MET02640
        WD(IHR) = -999.                                                 MET02650
        WSL(IHR) = -999.                                                MET02660
        T(IHR) = -999.                                                  MET02670
        WDB10 =-999.                                                    MET02680
        WSB10 =-999.                                                    MET02690
        TAB10 =-999.                                                    MET02700
        DO 110 IHT = 1,51                                               MET02710
            READ(INPROF, *) Y1,M1,D1,H1,ZHR(IHT),JFLAG,                 MET02720
     1          WDHR(IHT),WSHR(IHT),TAHR(IHT)                           MET02730
            IF(Y.NE.Y1.OR.M.NE.M1.OR.D.NE.D1.OR.IHR.NE.H1)              MET02740
     1          THEN                                                    MET02750
                WRITE(IOUT,7125) Y,M,D,IHR,Y1,M1,D1,H1                  MET02760
                STOP                                                    MET02770
            ENDIF                                                       MET02780
C                                                                       MET02790
C       SEARCH FOR 10-M VALUES OF:                                      MET02800
C         WIND DIRECTION TO ASSIGN SURFCE ROUGHNESS LENGTH (FUNCTION OF MET02810
C               DIRECTION) FOR THIS HOUR;                               MET02820
C         WIND SPEED FOR COMPUTING L, U*;                               MET02830
C         TEMPERATURE TO ASSIGN "SURFACE" AMBIENT TEMPERATURE           MET02840
C                                                                       MET02850
C         USE INTERPOLATION WHERE POSSIBLE                              MET02860
C                                                                       MET02870
            IF(ZHR(IHT) .LT. 10.0 .AND. JFLAG .LT. 1) GO TO 108         MET02880
C                                                                       MET02890
C         NOW HAVE FOUND THE 10-M LEVEL OR THE FIRST LEVEL ABOVE 10 M   MET02900
C                                                                       MET02910
            IF(WDHR(IHT).GT.0.0 .AND. WD(IHR).LT.0.0) THEN              MET02920
                IF(ABS(ZHR(IHT) - 10.0) .LT. 0.5) THEN                  MET02930
                    WD(IHR) = WDHR(IHT)                                 MET02940
                  ELSE IF(WDB10 .LT. 0.0) THEN                          MET02950
                    WD(IHR) = WDHR(IHT)                                 MET02960
                  ELSE                                                  MET02970
                    FRAC = (10. - WDB10H)/(ZHR(IHT) - WDB10H)           MET02980
                    WD(IHR) = (1.0-FRAC) * WDB10 + FRAC * WDHR(IHT)     MET02990
                ENDIF                                                   MET03000
            ENDIF                                                       MET03010
            IF(WSHR(IHT).GT.0.0 .AND. WSL(IHR).LT.0.0) THEN             MET03020
                IF(ABS(ZHR(IHT) - 10.0) .LT. 0.5) THEN                  MET03030
                    WSL(IHR) = WSHR(IHT)                                MET03040
                    ANEM = 10.0                                         MET03050
                  ELSE IF(WSB10 .LT. 0.0) THEN                          MET03060
                    WSL(IHR) = WSHR(IHT)                                MET03070
                    ANEM = ZHR(IHT)                                     MET03080
                  ELSE                                                  MET03090
                    FRAC = (10. - WSB10H)/(ZHR(IHT) - WSB10H)           MET03100
                    WSL(IHR) = (1.0-FRAC) * WSB10 + FRAC * WSHR(IHT)    MET03110
                    ANEM = 10.0                                         MET03120
                ENDIF                                                   MET03130
            ENDIF                                                       MET03140
            IF(TAHR(IHT).GT.0.0 .AND. T(IHR).LT.0.0) THEN               MET03150
                IF(ABS(ZHR(IHT) - 10.0) .LT. 0.5) THEN                  MET03160
                    T(IHR) = TAHR(IHT)                                  MET03170
                  ELSE IF(TAB10 .LT. 0.0) THEN                          MET03180
                    T(IHR) = TAHR(IHT)                                  MET03190
                  ELSE                                                  MET03200
                    FRAC = (10. - TAB10H)/(ZHR(IHT) - TAB10H)           MET03210
                    T(IHR) = (1.0-FRAC) * TAB10 + FRAC * TAHR(IHT)      MET03220
                ENDIF                                                   MET03230
            ENDIF                                                       MET03240
108         IF(JFLAG.EQ.1) GO TO 112                                    MET03250
C                                                                       MET03260
C       IF BELOW 10 METERS, STORE VALUES FOR POSSIBLE INTERPOLATION     MET03270
C                                                                       MET03280
            IF(WDHR(IHT) .GT. 0.0) THEN                                 MET03290
                WDB10 = WDHR(IHT)                                       MET03300
                WDB10H = ZHR(IHT)                                       MET03310
            ENDIF                                                       MET03320
            IF(WSHR(IHT) .GE. 0.0) THEN                                 MET03330
                WSB10 = WSHR(IHT)                                       MET03340
                WSB10H = ZHR(IHT)                                       MET03350
            ENDIF                                                       MET03360
            IF(TAHR(IHT) .GT. 0.0) THEN                                 MET03370
                TAB10 = TAHR(IHT)                                       MET03380
                TAB10H = ZHR(IHT)                                       MET03390
            ENDIF                                                       MET03400
110     CONTINUE                                                        MET03410
112     IF(MODE.GE.2) THEN                                              MET03420
            READ(ISURF2,7030) Y2,M2,D2,H2,NWSCC(IHR)                    MET03430
            IF(Y.NE.Y2.OR.M.NE.M2.OR.D.NE.D2.OR.IHR.NE.H2+1)            MET03440
     1          THEN                                                    MET03450
                WRITE(IOUT,7130) Y,M,D,IHR,Y2,M2,D2,H2+1                MET03460
                STOP                                                    MET03470
            ENDIF                                                       MET03480
        ENDIF                                                           MET03490
C                                                                       MET03500
C       IF MISSING DATA, PREPARE TO WRITE NEGATIVE VALUES IN SURFACE;   MET03510
C       PERSIST WIND DIRECTION TO GET SITE CHARACTERISTICS FOR MODE 3   MET03520
C                                                                       MET03530
        IF(WD(IHR).LT.0.0 .OR. WSL(IHR).LT.0.0 .OR. T(IHR).LT.0.0) THEN MET03540
            WRITE(IOUT,7140) Y,M,D,IHR                                  MET03550
            IF(MODE .LE. 2) THEN                                        MET03560
                WRITE(ISURF,6020) Y,M,D,JUL,IHR                         MET03570
                GO TO 105                                               MET03580
              ELSE                                                      MET03590
C                                                                       MET03600
C       STORE DATA FOR 24 HOURS BEFORE PRINTING FOR MODE 3              MET03610
C                                                                       MET03620
                MISS(IHR) = 1                                           MET03630
                IF(IHR.EQ.1) THEN                                       MET03640
                    LHR = 24                                            MET03650
                  ELSE                                                  MET03660
                    LHR = IHR-1                                         MET03670
                ENDIF                                                   MET03680
                IF(WD(IHR).LT.0.0) WD(IHR) = WD(LHR)                    MET03690
                IF(WSL(IHR).LT.0.0) WSL(IHR) = WSL(LHR)                 MET03700
                IF(T(IHR).LT.0.0) T(IHR) = T(LHR)                       MET03710
            ENDIF                                                       MET03720
        ENDIF                                                           MET03730
C                                                                       MET03740
C       INITIALIZE SENSIBLE HEAT FLUX TO ZERO FOR MODE 3                MET03750
C                                                                       MET03760
        QS(IHR)=0.0                                                     MET03770
C                                                                       MET03780
        IF(IHR.GT.1 .AND. MODE.GT.2) GO TO 115                          MET03790
        CALL JULIAN(Y,M,D,JUL)                                          MET03800
        JD = JUL                                                        MET03810
        IF(JD.EQ.366) JD = 1                                            MET03820
C                                                                       MET03830
C       CALCULATE SOLAR ELEVATION ANGLES                                MET03840
C                                                                       MET03850
        CALL SUN(LAT,LONG,ZONE,JD,TSR,TSS)                              MET03860
C                                                                       MET03870
C       FOR MODE 0, ALREADY HAVE HOURLY SITE CHARACTERISTICS            MET03880
C                                                                       MET03890
        IF(MODE.EQ.0) GO TO 128                                         MET03900
115     DO 120 J = 1,NSEC                                               MET03910
        IF(WD(IHR).LT.WDSEC(J,2)+0.1.AND.WD(IHR).GT.WDSEC(J,1)-0.1)     MET03920
     1    GO TO 125                                                     MET03930
        IF(WD(IHR).LT.WDSEC(J,2)+0.1.AND.WDSEC(J,1).GT.WDSEC(J,2))      MET03940
     1    GO TO 125                                                     MET03950
        IF(WD(IHR).GT.WDSEC(J,1)-0.1.AND.WDSEC(J,1).GT.WDSEC(J,2))      MET03960
     1    GO TO 125                                                     MET03970
120     CONTINUE                                                        MET03980
125     ISEC = MIN(J,NSEC)                                              MET03990
        Z0DAY(IHR) = Z0(M,ISEC)                                         MET04000
C                                                                       MET04010
C       CALCULATE ALBEDO FOR THIS HOUR, ACCOUNTING FOR SOLAR            MET04020
C       ELEVATION ANGLE                                                 MET04030
C                                                                       MET04040
        ALBD = ALB(M,ISEC)                                              MET04050
128     C = 1.0 - ALBD                                                  MET04060
        BB = -0.5 * C*C                                                 MET04070
        ANG = ANGLE(IHR) * 57.29578                                     MET04080
        IF(ANG.LE.0.0) THEN                                             MET04090
            ALBEDO = 1.0                                                MET04100
          ELSE                                                          MET04110
C                                                                       MET04120
C       EQN 7 FROM USERS GUIDE                                          MET04130
C                                                                       MET04140
            ALBEDO = ALBD + C*EXP(-0.1*ANG + BB)                        MET04150
        ENDIF                                                           MET04160
C                                                                       MET04170
C       SUBSTITUTE NWS CLOUD COVER IF NECESSARY AND COMPUTE HEAT FLUX   MET04180
C                                                                       MET04190
        CALL DEFAUL(MODE,M,D,Y,IHR,ALBEDO)                              MET04200
C                                                                       MET04210
C       CALCULATE THE DENSITY OF AIR FOR THE HOUR IN KG/M**3            MET04220
C                                                                       MET04230
        CALL RHOO(PRES,T(IHR),RHO)                                      MET04240
C                                                                       MET04250
C       DO NIGHTTIME OR DAYTIME TASKS:                                  MET04260
C       COMPUTE NIGHTTIME USTAR & L VALUES USING THE VENKATRAM METHOD.  MET04270
C       OTHERWISE, COMPUTE NET RADIATION IF DERIVED FROM TOTAL INCOMING MET04280
C       SOLAR RADIATION.  COMPUTE THE SENSIBLE HEAT FLUX FROM THE NET   MET04290
C       RADIATION.  QR IS THE NET RADIATION, QS THE SENSIBLE HEAT FLUX. MET04300
C       IF NIGHTTIME, SENSIBLE HEAT FLUX IS NOT NEEDED TO COMPUTE Z0,L. MET04310
C       COMPUTE DAYTIME USTAR & L VALUES USING HOLTSLAG-VAN ULDEN METHODMET04320
C                                                                       MET04330
        IF(RN(IHR).LE.0 .OR. IHR.GT.TSS+1. .OR. IHR.LT.TSR) THEN        MET04340
            CALL WNUS(IHR,ANEM,Z0DAY(IHR))                              MET04350
          ELSE                                                          MET04360
            IF(MODE .GT. 0) BOWEN = BOW(M,ISEC)                         MET04370
            CALL HV(IHR,PRES,BOWEN)                                     MET04380
            IF(QS(IHR).LE.0.0) THEN                                     MET04390
                CALL WNUS(IHR,ANEM,Z0DAY(IHR))                          MET04400
              ELSE                                                      MET04410
                CALL HDAYUS(IHR,RHO,ANEM,Z0DAY(IHR))                    MET04420
            ENDIF                                                       MET04430
        ENDIF                                                           MET04440
C                                                                       MET04450
C       CHECK FOR L VALUES EXCEEDING THE RANGE OF THE FORMAT FIELD      MET04460
C                                                                       MET04470
        IF(L(IHR).GT.9999.) L(IHR)=9999.                                MET04480
        IF(L(IHR).LT.-999.) L(IHR)=-999.                                MET04490
        IF(ABS(L(IHR)).LT.1.0) THEN                                     MET04500
            IF(L(IHR).LT.0) L(IHR)=-1.                                  MET04510
            IF(L(IHR).GT.0) L(IHR)=1.                                   MET04520
        ENDIF                                                           MET04530
C                                                                       MET04540
C       COMPUTE ZILITINKEVICH SURFACE LAYER HEIGHTS                     MET04550
C                                                                       MET04560
        CALL ZILL(LAT,IHR)                                              MET04570
C                                                                       MET04580
        H = H + 1                                                       MET04590
        IF(H.EQ.25) H = 1                                               MET04600
        IF(H.EQ.1 .AND. MODE.GT.2) GO TO 150                            MET04610
        IF(MODE.LE.2)                                                   MET04620
     1  WRITE(ISURF,6010) Y,M,D,JUL,IHR,ZIOBS(IHR),ZIL(IHR),USTAR(IHR), MET04630
     2      L(IHR),Z0DAY(IHR)                                           MET04640
        GO TO 105                                                       MET04650
C                                                                       MET04660
C       END HOUR LOOP; READ IN UPPER AIR DATA AND COMPUTE CONVECTIVE    MET04670
C       MIXED LAYER HEIGHTS ONLY IF DOING A CONTIGUOUS HOUR RUN         MET04680
C                                                                       MET04690
C       READ IN UPPER AIR SOUNDING FOR 12Z; COMPUTE MODIFIED CARSON     MET04700
C       MIXED LAYER HEIGHTS FOR APPLICABLE HOURS                        MET04710
C                                                                       MET04720
150     READ(IRAWIN,7040) YUP,MUP,DUP,ITIME,NLEV                        MET04730
        READ(IRAWIN,7050) (PRS(I),HT(I),TMP(I),I=1,NLEV)                MET04740
        IF(ITIME.NE.12) GO TO 150                                       MET04750
        ISDATE = Y*10000 + M*100 + D                                    MET04760
        IUDATE = YUP*10000 + MUP*100 + DUP                              MET04770
        IF(ISDATE.GT.IUDATE) GO TO 150                                  MET04780
        IF(ISDATE.LT.IUDATE) THEN                                       MET04790
            WRITE(IOUT,7160) Y,M,D,YUP,MUP,DUP                          MET04800
            STOP                                                        MET04810
        ENDIF                                                           MET04820
C                                                                       MET04830
C       CALCULATE POTENTIAL TEMPERATURE PROFILE                         MET04840
C                                                                       MET04850
        BASEHT = HT(1)
        DO 160 ILEV=1,NLEV                                              MET04860
        PTMP(ILEV)=TMP(ILEV)*(1000./PRS(ILEV))**0.285714                MET04870
C        HT(ILEV)=HT(ILEV)-HT(1)  -- CHANGED 2/6/91 DJB                 MET04880
        HT(ILEV)=HT(ILEV)-BASEHT        
160     CONTINUE                                                        MET04890
C       CONVERT SOUNDING TIME (HH) TO (HHMM)                            MET04900
        ITIME=ITIME*100                                                 MET04910
        PTMPM=PTMP(1)                                                   MET04920
        AI(1)=0.0                                                       MET04930
        AI2(1)=0.0                                                      MET04940
        SAI(1)=0.0                                                      MET04950
        SAI2(1)=0.0                                                     MET04960
C                                                                       MET04970
C       COMPUTE POT TEMP INTEGRALS FOR MODIFIED CARSON MIXED LAYER HTS  MET04980
C                                                                       MET04990
        DO 170 ILVLS=2,NLEV                                             MET05000
        CALL SUMI(ILVLS,PTMPM)                                          MET05010
C                                                                       MET05020
C       COMPUTE INTEGRAL OF Z WRT THETA(POT TEMP) FOR ENTIRE PROFILE    MET05030
C                                                                       MET05040
        SAI(ILVLS)=AI(ILVLS)+SAI(ILVLS-1)                               MET05050
C                                                                       MET05060
C       COMPUTE INTEGRAL OF Z**2 WRT THETA FOR ENTIRE PROFILE           MET05070
C                                                                       MET05080
        SAI2(ILVLS)=AI2(ILVLS)+SAI2(ILVLS-1)                            MET05090
170     CONTINUE                                                        MET05100
C                                                                       MET05110
C       COMPUTE  # MINUTES FROM MIDNIGHT TO TIME OF INITIAL TEMP PROFILEMET05120
C       DETERMINE SFC TEMP (K) AT START TIME                            MET05130
C       DETERMINE MINUTES FROM MIDNIGHT OF LAST HOUR, ITLST             MET05140
C       SET TIME INCREMENT FOR ZI CALCULATIONS                          MET05150
C                                                                       MET05160
        CALL MINUTE(ITIME,ITIMM)                                        MET05170
        CALL INITT(ITFST,ITLST,ITIMM)                                   MET05180
        CALL TT(ITIMM,T0)                                               MET05190
        CALL MINUTE(ITLST*100,ITLSTM)                                   MET05200
C                                                                       MET05210
C       INTEGRATE IN 15-MINUTE INCREMENTS                               MET05220
C                                                                       MET05230
        INC=15                                                          MET05240
        ITM=ITIMM                                                       MET05250
        OLDHEAT=0.                                                      MET05260
        DO 210 II=1,100                                                 MET05270
        ITM=ITM+INC                                                     MET05280
        IF(ITM.GT.ITLSTM) GO TO 220                                     MET05290
C                                                                       MET05300
C       DETERMINE INTEGRATED SENSIBLE HEAT FLUX, HEAT (J/M**2)          MET05310
C       COMPUTE AREA UNDER USTAR**3 CURVE WRT TIME, USTR3 (M**3/S**2)   MET05320
C                                                                       MET05330
        CALL SUMHH(ITM,HEAT,OLDHEAT)                                    MET05340
        CALL SUMVV(ITIMM,ITM,USTR3)                                     MET05350
C                                                                       MET05360
C       CONVERT FROM J/M**2 TO CAL/M**2                                 MET05370
C       CONVERT RHO TIMES CP TO CAL/(M**3 K)                            MET05380
C                                                                       MET05390
        HEAT=HEAT/4.187                                                 MET05400
        RHOCP=(RHO*CP)/4.187                                            MET05410
C                                                                       MET05420
C       EQUATIONS 27 AND 28 FROM USER'S GUIDE                           MET05430
C                                                                       MET05440
        XAI=HEAT/(RHOCP)*(1.+2.*A1)                                     MET05450
        XAI2=2.*B*T0/G*USTR3                                            MET05460
C                                                                       MET05470
C       DETERMINE HEIGHTS (M) CORRESPONDING TO GIVEN AREAS UNDER        MET05480
C       POTENTIAL TEMP PROFILE; DETERMINE HOURS FROM MINUTES            MET05490
C                                                                       MET05500
        CALL ZZI(NLEV,XAI,XAI2,ZI,ZI2)                                  MET05510
C                                                                       MET05520
C       UPDATE ZIL ARRAY IF AT THE END OF AN HOUR                       MET05530
C                                                                       MET05540
        CALL HOUR(ITM,KHR)                                              MET05550
        DO 190 IHOR=1,24                                                MET05560
        IHOUR=IHOR*100                                                  MET05570
        IF(KHR.EQ.IHOUR) THEN                                           MET05580
C                                                                       MET05590
C       DETERMINE WHETHER ZI PREDICTED IS CONVECTIVE OR NEUTRAL         MET05600
C       VALUE (WHICHEVER IS GREATER)                                    MET05610
C                                                                       MET05620
            IF(ZIL(IHOR).LT.AMAX1(ZI,ZI2)) THEN                         MET05630
                IF(ZI.GE.ZI2) THEN                                      MET05640
                    ZIL(IHOR)=ZI                                        MET05650
                  ELSE                                                  MET05660
                    ZIL(IHOR)=ZI2                                       MET05670
                ENDIF                                                   MET05680
            ENDIF                                                       MET05690
        ENDIF                                                           MET05700
190     CONTINUE                                                        MET05710
210     CONTINUE                                                        MET05720
220     CONTINUE                                                        MET05730
C                                                                       MET05740
C       WRITE 24 HOURS OF DATA TO OUTPUT FILE                           MET05750
C                                                                       MET05760
        DO 230 IHOR=1,24                                                MET05770
        IF(MISS(IHOR).EQ.0) THEN                                        MET05780
            WRITE(ISURF,6010) Y,M,D,JUL,IHOR,ZIOBS(IHOR),ZIL(IHOR),     MET05790
     1                USTAR(IHOR),L(IHOR),Z0DAY(IHOR)                   MET05800
          ELSE                                                          MET05810
            WRITE(ISURF,6020) Y,M,D,JUL,IHOR                            MET05820
        ENDIF                                                           MET05830
230     CONTINUE                                                        MET05840
        GO TO 105                                                       MET05850
C                                                                       MET05860
900     STOP                                                            MET05870
C                                                                       MET05880
6010    FORMAT(3(I2,1X),I3,1X,I2,5X,2F10.0,F10.3,F10.1,E10.3)           MET05890
6020    FORMAT(3(I2,1X),I3,1X,I2,5X,2(4X,'-9999.'),'  -999.999',        MET05900
     1  '   -9999.9',' -.999E+03')                                      MET05910
7030    FORMAT(T6,I2,T8,I2,T10,I2,T12,I2,T79,A1)                        MET05920
7040    FORMAT(22X,4(I2),38X,I2)                                        MET05930
7050    FORMAT(4(3X,F6.1,1X,F5.0,1X,F5.1,8X))                           MET05940
7095    FORMAT(//,10X,'NUMBER OF WIND DIRECTION SECTORS FOR SPECIFYING',MET05950
     1  /,10X,' SURFACE CHARACTERISTICS IS OUT OF BOUNDS: ',I4)         MET05960
7110    FORMAT(//,10X,'ERROR IN WIND DIRECTION SECTOR SPECIFICATION')   MET05970
7125    FORMAT(//,10X,'DATE INCONSISTENCY BETWEEN ONSITE AND PROFILE ', MET05980
     1    'DATA,',/,10X,' OR HOUR IS OUT OF SEQUENCE FOR THIS DAY:',//, MET05990
     2    15X,'ONSITE DATE (YYMMDDHH) IS ',4I2,'; PROFILE DATE ',       MET06000
     3    '(YYMMDDHH) IS ',4I2)                                         MET06010
7130    FORMAT(//,10X,'DATE INCONSISTENCY BETWEEN ONSITE AND OFFSITE ', MET06020
     1    'DATA,',/,10X,' OR HOUR IS OUT OF SEQUENCE FOR THIS DAY:',//, MET06030
     2    15X,'ONSITE DATE (YYMMDDHH) IS ',4I2,'; OFFSITE DATE ',       MET06040
     3    '(YYMMDDHH) IS ',4I2)                                         MET06050
7135    FORMAT(//,10X,'HOUR OUT OF SEQUENCE FOR THIS DAY:',//,15X,      MET06060
     2    'ONSITE DATE (YYMMDDHH) IS ',4I2,'; HOUR EXPECTED IS ',I2)    MET06070
7140    FORMAT(/,10X,'MISSING WIND AND/OR TEMPERATURE DATA FOR ',/,15X, MET06080
     1  '(MM DD YY HH):',4(1X,I2),'; MISSING DATA WRITTEN TO "SURFACE"')MET06090
7145    FORMAT(//,10X,'MISSING CLOUD COVER DATA:',//,15X,               MET06100
     2    'DATE (YYMMDDHH) IS ',4I2)                                    MET06110
7160    FORMAT(//,10X,'DATE INCONSISTENCY BETWEEN SURFACE AND UPPER ',  MET06120
     1  'AIR DATA:',//,15X,'SURFACE DATE (YYMMDD) IS ',3I2,             MET06130
     2  ';  UPPER AIR DATE (YYMMDD) IS ',3I2)                           MET06140
8010    FORMAT(//,1X,'CTDM MET PRE-PROCESSOR PROGRAM (METPRO) ',        MET06150
     1  '      VERSION 2.1       LEVEL 871022',//,                      MET06160
     2  10X,'PROGRAM OPTIONS: ',//,15X,'MODE = ',I1,                    MET06170
     3  ' IF 0, DO NOT READ NWS SURFACE DATA NOR UPPER AIR DATA,',/,    MET06180
     4  23X,'       ASSUME CONSTANT SITE CHARACTERISTICS',/,23X,        MET06190
     5  ' IF 1, DO NOT READ NWS SURFACE DATA NOR UPPER AIR DATA,',/,    MET06200
     6  23X,'       BUT ASSUME VARIABLE SITE CHARACTERISTICS',/,23X,    MET06210
     7  ' IF 2, READ NWS SURFACE DATA, BUT NOT UPPER AIR DATA',/,23X,   MET06220
     8  ' IF 3, READ NWS SURFACE DATA AND UPPER AIR DATA',//)           MET06230
8015    FORMAT(10X,'LATITUDE (DEG NORTH) = ',F6.2,', LONGITUDE (DEG ',  MET06240
     1  'WEST) = ',F7.2,/,10X,'TIME ZONE (HOURS AFTER GMT) = ',F5.1,/,  MET06250
     2  10X,'FIXED VALUES OF SURFACE CHARACTERISTICS:',/,20X,'Z0 = ',   MET06260
     3  F6.4,'M,  ALBEDO = ',F4.2,',  BOWEN RATIO = ',F5.2,//)          MET06270
8020    FORMAT(10X,'LATITUDE (DEG NORTH) = ',F6.2,', LONGITUDE (DEG WE',MET06280
     1  'ST) = ',F7.2,/,10X,'TIME ZONE (HOURS AFTER GMT) = ',F5.1,//)   MET06290
8080    FORMAT(1X,'Z0:',T9,12F6.3,/,1X,'ALBEDO:',12F6.3,/,              MET06300
     1  1X,'BOWEN: ',12F6.3,/,1X,'(SECTOR ',I1,')',/)                   MET06310
8082    FORMAT(/,1X,'WARNING: CONVECTIVE MIXED LAYER HEIGHTS ARE NOT ', MET06320
     1   'COMPUTED IN THIS MODE;',/,1X,'MISSING VALUES WILL BE ',       MET06330
     2   'WRITTEN TO THE SURFACE FILE FOR UNSTABLE CONDITIONS.')        MET06340
8085    FORMAT(//)                                                      MET06350
8090    FORMAT(10X,'# OF WIND DIRECTION SECTORS FOR SPECIFYING',        MET06360
     1  ' SURFACE CHARACTERISTICS = ',I1,//)                            MET06370
8100    FORMAT(/,15X,'WIND DIRECTION SECTORS AND ANGLE RANGES:',//,     MET06380
     1     (15X,I1,': ',I3,'-',I3),/)                                   MET06390
8110    FORMAT(//,10X,'SECTOR VALUES FOR ',                             MET06400
     1     'SURFACE ROUGHNESS (M), ALBEDO, AND BOWEN RATIO:',//,        MET06410
     2     1X,'VARIABLE  JAN   FEB   MAR   APR   MAY   JUN   ',         MET06420
     3     'JUL   AUG   SEP   OCT   NOV   DEC',/)                       MET06430
C                                                                       MET06440
        END                                                             MET06450
