C-----------------------------------------------------------------------SEN00010
C SUBROUTINE: SENSE                                                     SEN00020
C                                                                       SEN00030
C PURPOSE: DETERMINES FIRST HOUR WHERE SENSIBLE HEAT FLUX IS POSITIVE   SEN00040
C          FOR MODIFIED CARSON MIXING HEIGHT CODE                       SEN00050
C                                                                       SEN00060
C ARGUMENTS PASSED: ITIMM     INTEGER     TIME 0                        SEN00070
C                                                                       SEN00080
C COMMON: INIT                                                          SEN00090
C         RNET                                                          SEN00100
C                                                                       SEN00110
C EXTERNAL ROUTINES: MINUTE                                             SEN00120
C-----------------------------------------------------------------------SEN00130
      SUBROUTINE SENSE(ITIMM)                                           SEN00140
C                                                                       SEN00150
      COMMON/RNET/RN(24),QS(24)                                         SEN00160
C                                                                       SEN00170
C     CHECK WHEN SENSIBLE HEAT FLUX IS POSITIVE                         SEN00180
C                                                                       SEN00190
      DO 100 IH=1,24                                                    SEN00200
      IF(QS(IH).GT.0.) GO TO 110                                        SEN00210
  100 CONTINUE                                                          SEN00220
C                                                                       SEN00230
C     SET ITIM AS HOUR WHEN SENSIBLE HEAT FLUX FIRST GOES POSITIVE      SEN00240
C     CONVERT HOUR TO TOTAL MINUTES FROM MIDNIGHT                       SEN00250
C     SUBTRACT OFF 30 MINS TO GET TO CENTER OF EACH HOUR                SEN00260
C                                                                       SEN00270
  110 ITIM=IH                                                           SEN00280
      CALL MINUTE(ITIM*100,ITIMM)                                       SEN00290
      ITIMM=ITIMM-30                                                    SEN00300
      RETURN                                                            SEN00310
      END                                                               SEN00320
