C-----------------------------------------------------------------------SMV00010
C SUBROUTINE: SUMVV                                                     SMV00020
C                                                                       SMV00030
C PURPOSE: CALCULATES THE AREA UNDER THE USTAR**3 CURVE WITH RESPECT TO SMV00040
C          TIME FROM START (RIGHT SIDE OF EQN 28)                       SMV00050
C                                                                       SMV00060
C ARGUMENTS PASSED: ITIMEM     INTEGER     TIME IN MINUTES FROM MIDNIGHTSMV00070
C                   IT         INTEGER     TIME IN MINUTES              SMV00080
C                   USTR3      REAL        AREA UNDER USTAR**3 CURVE    SMV00090
C                                                                       SMV00100
C COMMON: WIND                                                          SMV00110
C         US                                                            SMV00120
C                                                                       SMV00130
C INTRINSIC FUNCTIONS: FLOAT                                            SMV00140
C-----------------------------------------------------------------------SMV00150
      SUBROUTINE SUMVV(ITIMEM,IT,USTR3)                                 SMV00160
C                                                                       SMV00170
      COMMON/WIND/WSL(24),A(24)                                         SMV00180
      COMMON/US/USTAR(24)                                               SMV00190
C                                                                       SMV00200
C     COMPUTE AREA UNDER USTAR**3 CURVE WRT TIME FROM START TO TIME IT  SMV00210
C                                                                       SMV00220
      ITI1=ITIMEM/60                                                    SMV00230
      ITI2=ITI1+1                                                       SMV00240
      IF(ITI1.EQ.0) ITI1 = 1                                            SMV00250
      ITF1=IT/60                                                        SMV00260
      ITF2=ITF1+1                                                       SMV00270
      IF(ITF1.EQ.0) ITF1 = 1                                            SMV00280
      SPDI=USTAR(ITI1)**3+(USTAR(ITI2)**3-USTAR(ITI1)**3)/60.0*         SMV00290
     1   (FLOAT(ITIMEM)-ITI1*60.0)                                      SMV00300
      TOTA1=30.*(ITI2*60.-ITIMEM)*(SPDI+USTAR(ITI2)**3)                 SMV00310
      SPDF=USTAR(ITF1)**3+(USTAR(ITF2)**3-USTAR(ITF1)**3)/60.0*         SMV00320
     1   (FLOAT(IT)-ITF1*60.0)                                          SMV00330
      TOTA3=30.*(IT-ITF1*60.)*(USTAR(ITF1)**3+SPDF)                     SMV00340
      IDELT=ITF1-ITI2                                                   SMV00350
      TOTA2=0.0                                                         SMV00360
      IF(IDELT.LE.0) GO TO 110                                          SMV00370
      DO 100 J=1,IDELT                                                  SMV00380
 100  TOTA2=TOTA2+A(ITI2+J-1)                                           SMV00390
 110  TOTA=TOTA1+TOTA2+TOTA3                                            SMV00400
      IF(IDELT.LT.0) TOTA=TOTA-A(ITI1)                                  SMV00410
      USTR3=TOTA                                                        SMV00420
      RETURN                                                            SMV00430
      END                                                               SMV00440
