C-----------------------------------------------------------------------SUN00010
C SUBROUTINE: SUN                                                       SUN00020
C                                                                       SUN00030
C PURPOSE: THIS ROUTINE CALCULATES THE SOLAR ELEVATION ANGLE FOR EACH   SUN00040
C          HOUR OF THE DAY FROM THE DATE, LATITUDE, LONGITUDE, AND TIME SUN00050
C          ZONE                                                         SUN00060
C                                                                       SUN00070
C METHOD: CRSTER PREPROCESSOR                                           SUN00080
C                                                                       SUN00090
C ARGUMENTS PASSED: LAT     REAL     LATITUDE          (IN RADIANS)     SUN00100
C                   LONG    REAL     LONGITUDE         (IN DEGREES)     SUN00110
C                   ZONE    REAL     TIME ZONE                          SUN00120
C                   JULIAN  INTEGER  JULIAN DAY                         SUN00130
C                   TSR     REAL     HOUR OF SUNRISE                    SUN00140
C                   TSS     REAL     HOUR OF SUNSET                     SUN00150
C                                                                       SUN00160
C COMMON BLOCKS:    SOLANG                                              SUN00170
C                                                                       SUN00180
C INTRINSIC FUNCTIONS: SIN      COS     FLOAT   ASIN    ACOS            SUN00190
C-----------------------------------------------------------------------SUN00200
      SUBROUTINE SUN(LAT,LONG,ZONE,JULIAN,TSR,TSS)                      SUN00210
C                                                                       SUN00220
      REAL LAT,LONG,ZONE                                                SUN00230
      INTEGER NDAYR,JULIAN                                              SUN00240
      COMMON /SOLANG/ ANGLE(24)                                         SUN00250
      DATA CONST /57.29578/                                             SUN00260
C                                                                       SUN00270
C     ZONE 05 = EASTERN                                                 SUN00280
C     ZONE 06 = CENTRAL                                                 SUN00290
C     ZONE 07 = MOUNTAIN                                                SUN00300
C     ZONE 08 = PACIFIC                                                 SUN00310
C                                                                       SUN00320
C     ALGORITHM FOR SOLAR ELEVATION IS OBTAINED FROM CRSTER PREPROCESSORSUN00330
C                                                                       SUN00340
      SINLAT=SIN(LAT)                                                   SUN00350
      COSLAT=COS(LAT)                                                   SUN00360
      NDAYR=JULIAN                                                      SUN00370
      D=(FLOAT(NDAYR)-1.)*360./365.242                                  SUN00380
      SIND=SIN(D/CONST)                                                 SUN00390
      COSD=COS(D/CONST)                                                 SUN00400
      SIN2D=SIN(2.*D/CONST)                                             SUN00410
      COS2D=COS(2.*D/CONST)                                             SUN00420
      EM=12.+0.12357*SIND-0.004289*COSD+0.153809*SIN2D+0.060783*COS2D   SUN00430
      SIGMA=279.9348+D+1.914827*SIND-0.079525*COSD+0.019938*SIN2D       SUN00440
     1   -0.00162*COS2D                                                 SUN00450
      CAPD=ASIN(.39784989*SIN(SIGMA/CONST))                             SUN00460
      SINCD=SIN(CAPD)                                                   SUN00470
      COSCD=COS(CAPD)                                                   SUN00480
C                                                                       SUN00490
C     HOUR USED IS AT THE BEGINNING OF EACH HOUR                        SUN00500
C                                                                       SUN00510
      DO 100 IHR=1,24                                                   SUN00520
      GMT=FLOAT(IHR)-1.+ZONE                                            SUN00530
      SOLHA=15.*(GMT-EM)-LONG                                           SUN00540
C                                                                       SUN00550
C     ANGLE=SOLAR ELEVATION IN RADIANS                                  SUN00560
C                                                                       SUN00570
      ANGLE(IHR)=ASIN(SINLAT*SINCD+COSLAT*COSCD*COS(SOLHA/CONST))       SUN00580
100   CONTINUE                                                          SUN00590
C                                                                       SUN00600
C     STATEMENTS BELOW ARE USED TO COMPUTE LOCAL SUNRISE AND SUNSET     SUN00610
C                                                                       SUN00620
      CAPH=ACOS(-SINLAT*SINCD/(COSLAT*COSCD))*CONST/15.                 SUN00630
      TSR=((LONG/15.+EM)-CAPH)-ZONE                                     SUN00640
      TSS=((LONG/15.+EM)+CAPH)-ZONE                                     SUN00650
      RETURN                                                            SUN00660
      END                                                               SUN00670
