C-----------------------------------------------------------------------WNS00010
C SUBROUTINE: WNUS                                                      WNS00020
C                                                                       WNS00030
C PURPOSE: THIS ROUTINE CALCULATES USTAR FOR THE STABLE CASES (L > 0)   WNS00040
C          USING THE VENKATRAM TECHNIQUE                                WNS00050
C                                                                       WNS00060
C ARGUMENTS PASSED:     IHR     INTEGER     HOUR                        WNS00070
C                       ANEM    REAL        ANEMOMETER HEIGHT (M)       WNS00080
C                       Z0      REAL        ROUGHNESS LENGTH (M)        WNS00090
C                                                                       WNS00100
C COMMON: MONIN CVR     US      WIND    TEMP    THS                     WNS00110
C                                                                       WNS00120
C INTRINSIC FUNCTIONS: ALOG     MIN                                     WNS00130
C-----------------------------------------------------------------------WNS00140
        SUBROUTINE WNUS(IHR,ANEM,Z0)                                    WNS00150
C                                                                       WNS00160
        INTEGER IHR,CC                                                  WNS00170
        REAL THS1,THS2,CDN,ANEM,Z0,UNOT,VONK,G,L                        WNS00180
        COMMON/US/USTAR(24)                                             WNS00190
        COMMON/MONIN/L(24)                                              WNS00200
        COMMON/CVR/CC(24)                                               WNS00210
        COMMON/TEMP/T(24)                                               WNS00220
        COMMON/WIND/WSL(24),A(24)                                       WNS00230
        COMMON/THS/THSTAR(24)                                           WNS00240
C                                                                       WNS00250
C       ASSIGN CONSTANTS: VON KARMAN CONSTANT AND GRAV. ACCEL.          WNS00260
C                                                                       WNS00270
        DATA VONK/0.4/                                                  WNS00280
        DATA G/9.80655/                                                 WNS00290
C                                                                       WNS00300
C       CONST = MAXIMUM PRODUCT OF USTAR AND THETASTAR                  WNS00310
C       BETA IS USED FOR PROFILE RELATATIONSHIPS IN STABLE CONDITIONS   WNS00320
C                                                                       WNS00330
        CONST = 0.05                                                    WNS00340
        BETA = 4.7                                                      WNS00350
C                                                                       WNS00360
C       THS1: EQN 22 OF USER'S GUIDE                                    WNS00370
C       CDN AND THS2: EQN 23 OF USER'S GUIDE                            WNS00380
C       UNOT: EQN 25 OF USER'S GUIDE                                    WNS00390
C                                                                       WNS00400
        THS1=0.09*(1.-0.5*(CC(IHR)/10.)**2.)                            WNS00410
        CDN=VONK/(ALOG(ANEM/Z0))                                        WNS00420
        THS2=(T(IHR)*CDN*WSL(IHR)**2.)/(4.0*4.7*ANEM*G)                 WNS00430
        THSTAR(IHR)=MIN(THS1,THS2)                                      WNS00440
        UNOT=SQRT((4.7*ANEM*G*THSTAR(IHR))/(T(IHR)))                    WNS00450
C                                                                       WNS00460
C       CHECK CRITERIA FOR CONVERGENCE: FIRST PART OF IF-THEN STATEMENT WNS00470
C       COVERS CONVERGENCE CASE, SECOND PART NONCONVERGENCE.  FOR THE   WNS00480
C       SECOND PART, UNOT IS SPECIFIED TO EFFECT CONVERGENCE JUST BARELYWNS00490
C                                                                       WNS00500
C       IF STATEMENT IS EQN 26 OF USER'S GUIDE                          WNS00510
C       USTAR IS IN EQN 25 OF USER'S GUIDE                              WNS00520
C       L IS DERIVED FROM EQNS 1 AND 24 OF USER'S GUIDE                 WNS00530
C                                                                       WNS00540
        IF((2.*UNOT)/(SQRT(CDN)*WSL(IHR)).LE.1.0) THEN                  WNS00550
            USTAR(IHR)=(CDN*WSL(IHR)/2.)*(1.+SQRT(1.-((2.*UNOT)/        WNS00560
     1        (SQRT(CDN)*WSL(IHR)))**2.))                               WNS00570
            L(IHR)=(T(IHR)*USTAR(IHR)**2.)/(VONK*G*THSTAR(IHR))         WNS00580
          ELSE                                                          WNS00590
            UNOT=SQRT(CDN)*WSL(IHR)*0.5-0.0001                          WNS00600
            USTAR(IHR)=(CDN*WSL(IHR)/2.)*(1.+SQRT(1.-((2.*UNOT)/        WNS00610
     1        (SQRT(CDN)*WSL(IHR)))**2.))                               WNS00620
            L(IHR)=(T(IHR)*USTAR(IHR)**2.)/(VONK*G*THSTAR(IHR))         WNS00630
        ENDIF                                                           WNS00640
C                                                                       WNS00650
C      IN THIS SECTION, SOLVE EQN 25 IN USER'S GUIDE, BUT SUBSTITUTE    WNS00660
C      FOR THETA-STAR IN THE EXPRESSION FOR UNOT; GET CUBIC EQN IN U*   WNS00670
C                                                                       WNS00680
       IF(USTAR(IHR) * THSTAR(IHR).GT.CONST) THEN                       WNS00690
            AA = -CDN * WSL(IHR)                                        WNS00700
            B = 0.0                                                     WNS00710
            C = BETA * ANEM * G * CONST * CDN/T(IHR)                    WNS00720
            CALL CUBIC(AA,B,C,USTAR(IHR))                               WNS00730
            THSTAR(IHR) = CONST/USTAR(IHR)                              WNS00740
            L(IHR) = T(IHR)*USTAR(IHR)*USTAR(IHR)/(VONK*G*THSTAR(IHR))  WNS00750
        ENDIF                                                           WNS00760
        RETURN                                                          WNS00770
        END                                                             WNS00780
