C-----------------------------------------------------------------------ZIL00010
C SUBROUTINE: ZILL                                                      ZIL00020
C                                                                       ZIL00030
C PURPOSE: ROUTINE CALCULATES THE NOCTURNAL BOUNDARY LAYER HEIGHT       ZIL00040
C                                                                       ZIL00050
C ARGUMENTS PASSED: LAT      REAL        LATITUDE IN RADIANS            ZIL00060
C                   IHR      INTEGER     HOUR                           ZIL00070
C                                                                       ZIL00080
C METHOD: NIEUWSTADT INTERPOLATION OF THE ZILITINKEVICH (1972) METHOD   ZIL00090
C         USING USTAR AND L VALUES                                      ZIL00100
C         REFERENCES: NIEUWSTADT, F.T.M.,1981: THE STEADY-STATE HEIGHT  ZIL00110
C                          AND RESISTANCE LAWS OF THE NOCTURNAL BOUNDARYZIL00120
C                          LAYER: THEORY COMPARED WITH CABAUW           ZIL00130
C                          OBSERVATIONS, BOUNDARY-LAYER METEOR.,20, PP. ZIL00140
C                          3-17.                                        ZIL00150
C                     NIEUWSTADT, F.T.M.,1984: SOME ASPECTS OF THE      ZIL00160
C                          TURBULENT STABLE BOUNDARY LAYER, 29TH        ZIL00170
C                          OHOLO CONFERENCE ON BOUNDARY-LAYER           ZIL00180
C                          STRUCTURE - MODELLING AND APPLICATION TO     ZIL00190
C                          AIR POLLUTION AND WIND ENERGY, 25-28 MARCH.  ZIL00200
C                     ZILITINKEVICH, S.S,1972: ON THE DETERMINATION     ZIL00210
C                          OF THE HEIGHT OF THE EKMAN BOUNDARY LAYER,   ZIL00220
C                          BOUNDARY-LAYER METEOR., 3, PP 141-145.       ZIL00230
C                                                                       ZIL00240
C LIMITATIONS: L MUST BE POSITIVE OR ABS(L) > 100 M                     ZIL00250
C                                                                       ZIL00260
C COMMON: US                                                            ZIL00270
C         MONIN                                                         ZIL00280
C         ZILIT                                                         ZIL00290
C                                                                       ZIL00300
C CALLING ROUTINES: MAIN                                                ZIL00310
C-----------------------------------------------------------------------ZIL00320
        SUBROUTINE ZILL(LAT,IHR)                                        ZIL00330
C                                                                       ZIL00340
        INTEGER IHR                                                     ZIL00350
        REAL F,L,LAT                                                    ZIL00360
        COMMON/US/USTAR(24)                                             ZIL00370
        COMMON/MONIN/L(24)                                              ZIL00380
        COMMON/ZILIT/ZIL(24)                                            ZIL00390
C       TENDEG = 10 DEGREES IN RADIANS                                  ZIL00400
        DATA TENDEG/0.174533/                                           ZIL00410
C                                                                       ZIL00420
C       CALCULATE CORIOLIS PARAMETER AND SOLVE QUADRATIC EQN            ZIL00430
C                                                                       ZIL00440
        XLAT = ABS(LAT)                                                 ZIL00450
C                                                                       ZIL00460
C       TO AVOID BLOWUP NEAR EQUATOR, SET LATITUDE TO MINIMUM OF 10 DEG ZIL00470
C                                                                       ZIL00480
        XLAT = AMAX1(XLAT,TENDEG)                                       ZIL00490
        F=1.4584E-4 * SIN(XLAT)                                         ZIL00500
        IF(USTAR(IHR).GE.0.AND.L(IHR).GE.0) THEN                        ZIL00510
C                                                                       ZIL00520
C       QUADRATIC SOLUTION, EQN 30 OF USER'S GUIDE                      ZIL00530
C                                                                       ZIL00540
           ZIL(IHR)=(-L(IHR) + SQRT(L(IHR)*L(IHR) + 2.28*USTAR(IHR)*    ZIL00550
     1           L(IHR)/F))/3.8                                         ZIL00560
          ELSE IF(ABS(L(IHR)).GT.100.) THEN                             ZIL00570
C                                                                       ZIL00580
C       NEUTRAL APPROXIMATION                                           ZIL00590
C                                                                       ZIL00600
            ZIL(IHR) = 0.3*USTAR(IHR)/F                                 ZIL00610
          ELSE                                                          ZIL00620
            ZIL(IHR)=-999.                                              ZIL00630
        ENDIF                                                           ZIL00640
        RETURN                                                          ZIL00650
        END                                                             ZIL00660
