C-----------------------------------------------------------------------ZZI00010
C SUBROUTINE: ZZI                                                       ZZI00020
C                                                                       ZZI00030
C PURPOSE: DETERMINE HEIGHT CORRESPONDING TO A GIVEN AREA UNDER THE     ZZI00040
C          POTENTIAL TEMPERATURE PROFILE                                ZZI00050
C                                                                       ZZI00060
C ARGUMENTS PASSED: NLVLS     INTEGER     RAWINSONDE LEVEL              ZZI00070
C                   XAI       REAL        AREA UNDER THE POTENTIAL      ZZI00080
C                                         TEMPERATURE CURVE             ZZI00090
C                   XAI2      REAL                                      ZZI00100
C                   ZI        REAL        CONVECTIVE MIXED LAYER HT (M) ZZI00110
C                   ZI2       REAL        MECHANICAL MIXED LAYER HT (M) ZZI00120
C                                                                       ZZI00130
C COMMON: XSUMI HMI                                                     ZZI00140
C-----------------------------------------------------------------------ZZI00150
      SUBROUTINE ZZI(NLVLS,XAI,XAI2,ZI,ZI2)                             ZZI00160
C                                                                       ZZI00170
      COMMON/XSUMI/HT(80),AI(80),AI2(80)                                ZZI00180
      COMMON/HM1/SAI(80),SAI2(80)                                       ZZI00190
C                                                                       ZZI00200
C     DETERMINE HEIGHT CORRESPONDING TO GIVEN AREA UNDER                ZZI00210
C     'POTENTIAL TEMP PROFILE' (EQN 27 OF USER'S GUIDE)                 ZZI00220
C                                                                       ZZI00230
C     XAI IS RIGHT SIDE OF EQN 27                                       ZZI00240
C     SAI IS LEFT SIDE OF EQN 27                                        ZZI00250
C                                                                       ZZI00260
      DO 100 ILVLS=2,NLVLS                                              ZZI00270
      IF(XAI.LT.SAI(ILVLS)) GO TO 110                                   ZZI00280
 100  CONTINUE                                                          ZZI00290
      ZI=3000.                                                          ZZI00300
      GO TO 120                                                         ZZI00310
 110  IF(SAI(ILVLS).EQ.SAI(ILVLS-1)) THEN                               ZZI00320
          ZI = HT(ILVLS-1)                                              ZZI00330
          GO TO 120                                                     ZZI00340
      ENDIF                                                             ZZI00350
      ZI=HT(ILVLS-1)+(HT(ILVLS)-HT(ILVLS-1))/                           ZZI00360
     1   (SAI(ILVLS)-SAI(ILVLS-1))*(XAI-SAI(ILVLS-1))                   ZZI00370
C                                                                       ZZI00380
C     ZI IS THE CONVECTIVE MIXED LAYER HEIGHT                           ZZI00390
C                                                                       ZZI00400
C     SECTION BELOW HANDLES EQN 28 OF USER'S GUIDE                      ZZI00410
C                                                                       ZZI00420
C     XAI2 IS RIGHT SIDE OF EQN 28                                      ZZI00430
C     SAI2 IS LEFT SIDE OF EQN 28                                       ZZI00440
C                                                                       ZZI00450
 120  DO 130 ILVLS=2,NLVLS                                              ZZI00460
      IF(XAI2.LT.SAI2(ILVLS)) GO TO 140                                 ZZI00470
 130  CONTINUE                                                          ZZI00480
      ZI2=3000.                                                         ZZI00490
      GO TO 150                                                         ZZI00500
 140  IF(SAI2(ILVLS).EQ.SAI2(ILVLS-1)) THEN                             ZZI00510
          ZI2 = HT(ILVLS-1)                                             ZZI00520
          GO TO 150                                                     ZZI00530
      ENDIF                                                             ZZI00540
      ZI2=HT(ILVLS-1)+(HT(ILVLS)-HT(ILVLS-1))/                          ZZI00550
     1   (SAI2(ILVLS)-SAI2(ILVLS-1))*(XAI2-SAI2(ILVLS-1))               ZZI00560
 150  CONTINUE                                                          ZZI00570
C                                                                       ZZI00580
C     ZI2 IS THE MECHANICAL MIXED LAYER HEIGHT                          ZZI00590
C                                                                       ZZI00600
      RETURN                                                            ZZI00610
      END                                                               ZZI00620
