{$I Switches.INC }

{$F+}    {Force Far Calls for overlays}
{$O+}    {Generate Overlay code}
{$M 16384,0,8000}

Unit Drive2;

Interface

Uses
  Overlay, DrInit, Dos, Crt, Graph, MyDefs;


Procedure DoFitcon;

Implementation

  {$I Spaces.INC }
  {$I Print.INC  }
  {$I Input.INC  }
  {$I Drive1.INC }


PROCEDURE GetAnXYFile;
Begin
  HillName := '';
  MsgStr := 'contour master';
  GetAFile(XYFiles,XYNames,HillName,MsgStr,MyIdx,0);
  If FKey <= 0 then begin
    Assign(ContourFile,Path+XYNames[MyIdx+1]);
    MasterFile :=XYNames[MyIdx+1];    { MasterFile is XY File selected from dir }
   end;
End;    { GetAnXYFile }


PROCEDURE GetDefaultOptions;
Const
  X = 52;
Begin
  Path := '\CTDM\TERRAIN\';
  MasterName :='';
  I := 1;
  While MasterFile[I] <> '.' do begin               { Parse off the hill name }
    MasterName := MasterName + MasterFile[I]; { *Files have paths, *Names don't }
    Inc(I);
   end;
  Assign(OptionsFile,Path+MasterName+'.OPT');
  If Exist(Path+MasterName+'.OPT') then begin
    Reset(OptionsFile);
    Readln(OptionsFile,MasterFile);    { XY File listed in OPT file, not used }
    Readln(OptionsFile,DagFile);
    DagName:='';
    I := 1;
    While DagFile[I] <> '.' do begin                    { parse off extension }
      DagName := DagName + DagFile[I];
      Inc(I);
     end;
    Readln(OptionsFile,WrkStr); Val(WrkStr,HillID,Code);
    Readln(OptionsFile,HillName);
    Readln(OptionsFile,WrkStr); Val(WrkStr,HTop,Code);
    Readln(OptionsFile,WrkStr); Val(WrkStr,HCX,Code);
    Readln(OptionsFile,WrkStr); Val(WrkStr,HCY,Code);
    Readln(OptionsFile,AF);
    If UpCase(AF[1]) = 'Y' then begin      { Set defaults if info not in file }
      Readln(OptionsFile,WrkStr); Val(WrkStr,AFS,Code);
     end
     else AFS := 1;
    Readln(OptionsFile,WrkStr); Val(WrkStr,SelMode,Code);
    If SelMode = 2 then begin
      Readln(OptionsFile,WrkStr); Val(WrkStr,LowBnd,Code);
      Readln(OptionsFile,WrkStr); Val(WrkStr,UpperBnd,Code);
     end
     else begin
      LowBnd := 1; UpperBnd := 1;
     end;
    If SelMode = 3 then begin
      Readln(OptionsFile,IDFile);
      IDName := '';
      I := 1;
      While IDFile[I] <> '.' do begin
        IDName := IDName + IDFile[I];
        Inc(I);
       end;
     end
     else
      IDName :=  MasterName;
    Readln(OptionsFile,PltAns);
    If UpCase(PltAns[1]) = 'Y' then begin
      Readln(OptionsFile,PlotFile);
      PlotName := '';
      I := 1;
      While PlotFile[I] <> '.' do begin
        PlotName := PlotName + PlotFile[I];
        Inc(I);
       end;
     end
     else PlotName := MasterName;
    Readln(OptionsFile,FitOutFile);
    FitOutName := '';
    I := 1;
    While FitOutFile[I] <> '.' do begin
      FitOutName := FitOutName + FitOutFile[I];
      Inc(I);
     end;
    Close(OptionsFile);
   end
   else begin         {set default values}
    DagName    := MasterName;
    HillID     := 1;
    HillName   := MasterName;
    HTop       := 0;
    HCX        := 0;
    HCY        := 0;
    AF         := 'Y';
    AFS        := 1;
    SelMode    := 1;
    LowBnd     := 1;
    UpperBnd   := 1;
    IDName     := MasterName;
    PltAns     := 'Y';
    PlotName   := MasterName;
    FitOutName := MasterName;
   end;
End;    { GetDefaultOptions }


PROCEDURE DisplayField(Counter: Integer);
Begin
  GoToXY(Fields[Counter].X,Fields[Counter].Y);
  Case Counter of
    1  :  Write(MasterName, Spaces(Fields[1].L-Length(MasterName)));
    2  :  Write(DagName,    Spaces(Fields[1].L-Length(DagName)));
    3  :  Write(HillID:2);
    4  :  Write(HillName,   Spaces(Fields[1].L-Length(HillName)));
    5  :  Write(HTop:10:1);
    6  :  Write(HCX:10:1);
    7  :  Write(HCY:10:1);
    8  :  Write(AF);
    9  :  Write(AFS:4:1);
    10 :  Write(Selmode:1);
    11 :  Write(LowBnd:4);
    12 :  Write(UpperBnd:4);
    13 :  Write(IDName,     Spaces(Fields[1].L-Length(IDName)));
    14 :  Write(PltAns);
    15 :  Write(PlotName,   Spaces(Fields[1].L-Length(PlotName)));
    16 :  Write(FitOutName, Spaces(Fields[1].L-Length(FitOutName)));
   end;
End;    { DisplayFields }


PROCEDURE DisplayOptions;
Const
  X = 14;
Begin
  For I := 1 to 16 do begin     {Build Array of x,y,length for locating options}
    Case I of
      1  :  begin  Y := 6;   L := 8;   end;
      2  :  begin  Y := 7;   L := 8;   end;
      3  :  begin  Y := 8;   L := 2;   end;
      4  :  begin  Y := 9;   L := 8;   end;
      5  :  begin  Y := 10;  L := 10;  end;
      6  :  begin  Y := 11;  L := 10;  end;
      7  :  begin  Y := 12;  L := 10;  end;
      8  :  begin  Y := 13;  L :=  1;  end;
      9  :  begin  Y := 14;  L :=  4;  end;
      10 :  begin  Y := 15;  L :=  1;  end;
      11 :  begin  Y := 16;  L :=  4;  end;
      12 :  begin  Y := 17;  L :=  4;  end;
      13 :  begin  Y := 18;  L :=  8;  end;
      14 :  begin  Y := 19;  L :=  1;  end;
      15 :  begin  Y := 20;  L :=  8;  end;
      16 :  begin  Y := 21;  L :=  8;  end;
     end;
    Fields[I].X := 57;
    Fields[I].Y := Y;
    Fields[I].L := L;
   end;
  F := ' FITCON OPTIONS ';
  MenuHeading(False);
  Color(LightGray,Black);
  WriteStr(11,4,'Use the arrow keys to hightlight the option to be changed.');
  WriteStr(X,6, 'CONTOUR MASTER FILE (.XY):');
  WriteStr(X,7, 'DIAG. OUTPUT FILE (.DAG):');
  WriteStr(X,8, 'HILL ID NUMBER:');
  WriteStr(X,9, 'HILL NAME:');
  WriteStr(X,10,'HILL TOP ELEVATION:');
  WriteStr(X,11,'HILL CENTER X-COORDINATE:');
  WriteStr(X,12,'HILL CENTER Y-COORDINATE:');
  WriteStr(X,13,'ANGULAR FILTERING (Y or N):');
  WriteStr(X,14,'ANGULAR FILTER SIZE (1-22.5):');
  WriteStr(X,15,'CONTOUR SELECTION MODE (1,2, OR 3):');
  WriteStr(X,16,'LOWER BOUND OF ID NUMBERS (MODE 2 ONLY):');
  WriteStr(X,17,'UPPER BOUND OF ID NUMBERS (MODE 2 ONLY):');
  WriteStr(X,18,'CONTOUR ID NUMBER FILE (MODE 3 ONLY):');
  WriteStr(X,19,'CREATE A PLOT FILE? ? (Y or N):');
  WriteStr(X,20,'FITCON PLOT FILE(.PLT):');
  WriteStr(X,21,'FITTED OUTPUT FILE(.FO):');
  DoF9Line;
  Color(LightGray,Black);
  For I := 1 to 16 do                                  { Write default values }
    DisplayField(I);
End;    { DisplayOptions }


PROCEDURE PutOptions;     { Write .OPT file }
Begin
  Path :='\CTDM\TERRAIN\';
  Assign(OptionsFile,Path+MasterName+'.OPT');
  Rewrite(OptionsFile);
  Writeln(OptionsFile,MasterName+'.XY');     { Last value given to MasterName }
  Writeln(OptionsFile,DagName+'.DAG');  { May not be same as chosen from list }
  Writeln(OptionsFile,HillID);
  Writeln(OptionsFile,HillName);
  Writeln(OptionsFile,HTop:10:1);
  Writeln(OptionsFile,HCX:10:1);
  Writeln(OptionsFile,HCY:10:1);
  Writeln(OptionsFile,AF);
  If UpCase(AF[1]) = 'Y' then                 {Only write out the info needed}
    Writeln(OptionsFile,AFS:4:1);                            {for mode chosen}
  Writeln(OptionsFile,SelMode);
  If SelMode = 2 then begin
    Writeln(OptionsFile,LowBnd);
    Writeln(OptionsFile,UpperBnd);
   end
   else if SelMode = 3 then Writeln(OptionsFile,IDName+'.IDF');
  Writeln(OptionsFile,PltAns);
  If UpCase(PltAns[1]) = 'Y' then
    Writeln(OptionsFile,PlotName+'.PLT');
  Writeln(OptionsFile,FitOutName+'.FO');
  Close(OptionsFile);
End;    { PutOptions }


FUNCTION TestName(ID:Integer; FilName : Str12): Boolean;  { TRUE if error found }
Var
  FileExists  : Boolean;
Begin

  Trim(FilName);

  If FilName = '' then EXIT;                  { Exit NOW if the name is empty }

  If Pos('.',FilName) > 0 then begin
    EraseMsg;
    GoToXY(13,24); Msg :='File extensions not allowed.  ' + PressEnter;
    Print(4,Msg);
    Beep;
    Readln; EraseMsg; Color(LightGray,Black);
    DoF9Line;
    TestName := True;
    EXIT;
   end;

  Case ID of
     1 : Ext :='.XY';
     2 : Ext :='.DAG';
    13 : Ext :='.IDF';
    15 : Ext :='.PLT';
    16 : Ext :='.FO';
   end;

  FileExists := Exist('\CTDM\TERRAIN\'+FilName+Ext);

  If ((ID = 1) or (ID = 13)) and  (not FileExists) then begin
    EraseMsg;
    GoToXY(12,24); Msg := 'Error! File does not exist.  ' + PressEnter;
    Print(4,Msg);
    Beep;
    Readln; EraseMsg; Color(LightGray,Black);
    DoF9Line;
    TestName := True;
    EXIT;
   end;

  If ((ID =1) or (ID = 13)) and (FileExists) then begin
    TestName := False;
    EXIT;
   end;

  If FileExists then begin
    EraseMsg;
    GoToXY(10,24); Msg :=' File Exists!      F7 - Overwrite      ENTER - Change Name ';
    Print(4,Msg);
    Beep;
    WrkStr := FilName;
    FKey := Input(Fields[ID].X,Fields[ID].Y,4,Fields[ID].L,WrkStr,True);
    If FKey = F7 then begin
      Assign(TestFile,'\CTDM\TERRAIN\'+FilName+Ext);
      Erase(TestFile);
     end;
    EraseMsg; Color(LightGray,Black);
    DoF9Line;
    TestName := True;
    Exit;
   end;
  TestName :=False;
end;    { TestName }


FUNCTION ValidateField(IDField : Integer) : Boolean;
Var
  Err  :  Boolean;
Begin
  Err := False;
  Case IDField of
    1   :  If TestName(IDField,MasterName) then Err := True;

    2   :  If TestName(IDField,DagName) then Err := True;

    3   :  If not ((HillID > 0) and (HillID <= 99)) then begin
             Err := True;
             EraseMsg;
             GoToXY(16,24); Msg :='Hill ID # must be 1-99.  ' + PressENTER;
            end;

    4   :  If HillName = '' then begin
             Err := True;
             EraseMsg;
             GoToXY(13,24); Msg :='Hill Name is a required field.  ' + PressENTER;
            end;

    5   :  If (HTop <= 0.0000) then begin
             Err := True;
             EraseMsg;
             GoToXY(9,24); Msg :='Hill top elev. must be greater than 0.  ' + PressENTER;
            end;

    { Fields 6 and 7 will not be checked.  A response of ' ' becomes a 0. }

    8   :  If not (UpCase(AF[1]) in ['Y','N']) then begin
             Err := True;
             EraseMsg;
             GoToXY(17,24); Msg :='Answer must be Y or N.  ' + PressENTER;
            end;

    9   :  If not ((AFS >= 1) and (AFS <= 22.5)) then begin
             Err := True;
             EraseMsg;
             GoToXY(10,24); Msg :='Angular Filter Size must be 1 - 22.5.  ' + PressENTER;
            end;

    10  :  If not ((SelMode >= 1) and (SelMode <= 3)) then begin
             Err := True;
             EraseMsg;
             GoToXY(18,24); Msg :='Options are 1,2,or 3.  ' + PressENTER;
            end;

    11  :  If not ((LowBnd > 0) and (LowBnd <= 9999)) then begin
             Err := True;
             EraseMsg;
             GoToXY(13,24); Msg :='Lower Bnd  must be 1-9999.  ' + PressENTER;
           end;

    12  :  If not ((UpperBnd > 0) and (UpperBnd <= 9999)) or (UpperBnd < LowBnd) then begin
             Err := True;
             EraseMsg;
             GoToXY(2,24); Msg :='Upper Bnd  must be 1-9999 and greater than Lower Bnd.  ' + PressENTER;
            end;

    13  :  If (SelMode = 3) and TestName(IDField,IDName) then Err := True;

    14  :  If not (UpCase(PltAns[1]) in ['Y','N']) then begin
             Err := True;
             EraseMsg;
             GoToXY(17,24); Msg :='Answer must be Y or N.  ' + PressENTER;
            end;

    15  :  If  TestName(IDField,PlotName) then Err := True;

    16  :  If  TestName(IDField,FitOutName) then Err := True;
   end;
                                                           {TestName does its own}
  If Err and not  (IDField in [1,2,13,15,16] ) then begin  {display for error messages}
    Print(4,Msg);
    Beep; Readln; EraseMsg; Color(LightGray,Black);
    DoF9Line;
   end;
  ValidateField := not Err;
End;    { ValidateField }


PROCEDURE InvokeF9;
Var
  M : Integer;
  AllValid  : Boolean;
begin
  DisplayField(FieldID);
  M := 1 ;
  AllValid := True;
  While M < 17 do begin
    If not ValidateField(M) then begin
      AllValid := False;
      FieldID := M;
      M := 99;                        { Force exit from WHILE }
     end;
    Inc(M);
   end;
  If AllValid then Collecting := False;
End;    { InvokeF9 }


PROCEDURE ChangeOptions;
Label
  Entrypt;
Const
  MaxFields = 16;
Begin
  Collecting := True;
  DisplayOptions;
  FieldID :=1;
  While Collecting do begin
    Case FieldID of
      1  :  Begin
              WrkStr := MasterName;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              LeftTrim(WrkStr);
              Trim(WrkStr);
              If WrkStr <> '' then begin
                Case FKey of
                  CUp   : begin
                            DisplayField(FieldID); FieldID := 16;
                           end;
                  CDown : begin
                            DisplayField(FieldID); FieldID := 2;
                           end;
                  F9    : Begin
                            InvokeF9;
                            Goto Entrypt;
                           end;
                  F10   : ExittoDos;
                  Esc   : Exit;
                 end;
                If (FKey <> CUp) and (FKey <> CDown) then begin
                  MasterName := WrkStr;
                  If ValidateField(FieldID) then begin
                    DisplayField(FieldID);
                    Inc(FieldID);
                   end
                   else MasterName := WrkStr;
                 end;
               end;
             end;
      2  :  Begin
              WrkStr := DagName;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              LeftTrim(WrkStr);
              Trim(WrkStr);
              If WrkStr <> '' then begin
                Case FKey of
                  CUp   : begin
                            DisplayField(FieldID); FieldID := 1;
                           end;
                  CDown : begin
                            DisplayField(FieldID); FieldID := 3;
                           end;
                  F9    : Begin
                            InvokeF9;
                            Goto entrypt;
                           end;
                  F10   : ExittoDos;
                  Esc   : Exit;
                 end;
                If (FKey <> CUp) and (FKey <> CDown) then begin
                  DagName := WrkStr;
                  If ValidateField(FieldID) then begin;
                    DisplayField(FieldID);
                    Inc(FieldID);
                   end
                   else DagName := WrkStr;
                 end;
               end;
             end;
      3  :  Begin
              Str(HillID:2,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 2;
                         end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 4;
                         end;
                F9    : Begin
                          InvokeF9;
                          Goto Entrypt;
                         end;
                F10   : ExittoDos;
                Esc   : Exit;
               end;
              If (FKey <> CUp) and (FKey <> CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,HillID,Code);
                If ValidateField(FieldID) then begin
                  DisplayField(FieldID);
                  Inc(FieldID);
                 end
                 else begin
                  Trim(WrkStr);
                  Val(WrkStr,HillID,Code);
                 end;
               end;
             end;
      4  :  Begin
              WrkStr := HillName;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 3;
                         end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 5;
                         end;
                F9    : Begin
                          InvokeF9;
                          Goto Entrypt;
                         end;
                F10   : ExittoDos;
                Esc   : Exit;
               end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                LeftTrim(WrkStr);
                HillName := WrkStr;
                If ValidateField(FieldID) then begin
                  DisplayField(FIeldID);
                  Inc(FieldID);
                 end
                 else begin
                  Trim(WrkStr);
                  HillName := WrkStr;
                 end;
               end;
             end;
      5  :  Begin
              Str(HTop:10:1,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 4;
                         end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 6;
                         end;
                F9    : Begin
                          InvokeF9;
                          Goto Entrypt;
                         end;
                F10   : ExittoDos;
                Esc   : Exit;
               end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,HTop,Code);
                If ValidateField(FieldID) then begin
                   DisplayField(FIeldID);
                   Inc(FieldID);
                 end
                 else begin
                  Trim(WrkStr);
                  Val(WrkStr,HTop,Code);
                 end;
               end;
             end;
      6  :  Begin
              Str(HCX:10:1,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 5;
                         end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 7;
                         end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                         end;
                F10   : ExittoDos;
                Esc   : Exit;
               end;
              If (FKey <> CUp) and (FKey <> CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,HCX,Code);
                DisplayField(FIeldID);
                Inc(FieldID);
               end;
             end;
      7  :  Begin
              Str(HCY:10:1,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 6;
                        end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 8;
                        end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                        end;
                F10   : ExittoDos;
                Esc   : Exit;
              end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,HCY,Code);
                DisplayField(FIeldID);
                Inc(FieldID);
              end;
            end;
      8  :  Begin
              WrkStr := AF;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 7;
                        end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 9;
                        end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                        end;
                F10   : ExittoDos;
                Esc   : Exit;
              end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                AF := WrkStr;
                If ValidateField(FieldID) then begin
                  DisplayField(FieldID);
                  Inc(FieldID);
                end
                else AF := WrkStr;
              end;
            end;
      9  :  Begin
              Str(AFS:4:1,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 8;
                        end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 10;
                        end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                        end;
                F10   : ExittoDos;
                Esc   : Exit;
              end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,AFS,Code);
                If ValidateField(FieldID) then begin
                   DisplayField(FIeldID);
                   Inc(FieldID);
                end
                else begin
                  Trim(WrkStr);
                  Val(WrkStr,AFS,Code);
                end;
              end;
            end;
      10  :  Begin
              Str(SelMode:1,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 9;
                        end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 11;
                        end;
                F9    : begin
                          InvokeF9;
                          Goto entrypt;
                        end;
                F10   : ExittoDos;
                Esc   : Exit;
              end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,SelMode,Code);
                If ValidateField(FieldID) then begin
                   DisplayField(FIeldID);
                   Inc(FieldID);
                end
                else begin
                  Trim(WrkStr);
                  Val(WrkStr,SelMode,Code);
                end;
              end;
            end;
      11  :  Begin
              Str(LowBnd:4,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 10;
                        end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 12;
                        end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                        end;
                F10   : ExittoDos;
                Esc   : Exit;
              end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,LowBnd,Code);
                If ValidateField(FieldID) then begin
                   DisplayField(FIeldID);
                   Inc(FieldID);
                end
                else begin
                  Trim(WrkStr);
                  Val(WrkStr,LowBnd,Code);
                end;
              end;
            end;
      12  :  Begin
              Str(UpperBnd:4,WrkStr);
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 11;
                         end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 13;
                         end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                         end;
                F10   : ExittoDos;
                Esc   : Exit;
               end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                Trim(WrkStr);
                Val(WrkStr,UpperBnd,Code);
                If ValidateField(FieldID) then begin
                   DisplayField(FIeldID);
                   Inc(FieldID);
                 end
                 else begin
                  Trim(WrkStr);
                  Val(WrkStr,UpperBnd,Code);
                 end;
               end;
             end;
      13  : Begin
              WrkStr := IDName;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              LeftTrim(WrkStr);
              Trim(WrkStr);
              If WrkStr <> '' then begin
                Case FKey of
                  CUp   : begin
                            DisplayField(FieldID); FieldID := 12;
                           end;
                  CDown : begin
                            DisplayField(FieldID); FieldID := 14;
                           end;
                  F9    : begin
                            InvokeF9;
                            Goto Entrypt;
                           end;
                  F10   : ExittoDos;
                  Esc   : Exit;
                 end;
                If (FKey <> CUp) and (FKey <>CDown) then begin
                  IDName := WrkStr;
                  If ValidateField(FieldID) then begin;
                    DisplayField(FieldID);
                    Inc(FieldID);
                   end
                   else IDName := WrkStr;
                 end;
               end;
             end;
      14 :  Begin
              WrkStr := PltAns;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              Case FKey of
                CUp   : begin
                          DisplayField(FieldID); FieldID := 13;
                         end;
                CDown : begin
                          DisplayField(FieldID); FieldID := 15;
                         end;
                F9    : begin
                          InvokeF9;
                          Goto Entrypt;
                         end;
                F10   : ExittoDos;
                Esc   : Exit;
               end;
              If (FKey <> CUp) and (FKey <>CDown) then begin
                PltAns := WrkStr;
                If ValidateField(FieldID) then begin;
                  DisplayField(FieldID);
                  Inc(FieldID);
                 end
                 else PltAns := WrkStr;
               end;
             end;
      15  : Begin
              WrkStr := PlotName;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              LeftTrim(WrkStr);
              Trim(WrkStr);
              If WrkStr <> '' then begin
                Case FKey of
                  CUp   : begin
                           DisplayField(FieldID); FieldID := 14;
                           end;
                  CDown : begin
                            DisplayField(FieldID); FieldID := 16;
                           end;
                  F9    : begin
                            InvokeF9;
                            Goto entrypt;
                           end;
                  F10   : ExittoDos;
                  Esc   : Exit;
                 end;
                If (FKey <> CUp) and (FKey <>CDown) then begin
                  PlotName := WrkStr;
                  If ValidateField(FieldID) then begin;
                    DisplayField(FieldID);
                    Inc(FieldID);
                   end
                   else PlotName := WrkStr;
                 end;
               end;
             end;
      16  : Begin
              WrkStr := FitOutName;
              FKey := Input(Fields[FieldID].X,Fields[FieldID].Y,4,Fields[FieldID].L,WrkStr,True);
              LeftTrim(WrkStr);
              Trim(WrkStr);
              If WrkStr <> '' then begin
                Case FKey of
                  CUp   : begin
                            DisplayField(FieldID); FieldID := 15;
                           end;
                  CDown : begin
                            DisplayField(FieldID); FieldID := 1;
                           end;
                  F9    : begin
                            InvokeF9;
                            Goto Entrypt;
                           end;
                  F10   : ExittoDos;
                  Esc   : Exit;
                 end;
                If (FKey <> CUp) and (FKey <>CDown) then begin
                  FitOutName := WrkStr;
                  If ValidateField(FieldID) then begin;
                    DisplayField(FieldID);
                    FieldID := 1;
                   end
                   else FitOutName := WrkStr;
                 end;
               end;
             end;
     end;
Entrypt:
   end;
End;    { ChangeOptions }


PROCEDURE RunFitcon;   {Execute Dos calls to run Fitcon from the correct dir}
Begin
  Exec(Comm,'/C CD\CTDM\TERRAIN');
  Exec(Comm,'/C COPY '+MasterName+'.OPT'+' '+'FOPTIONS');
  ClrScr;
  MyExec('\CTDM\EXE\FITCON.EXE','');
  If not AbEnd then begin
    WrkStr :='';
    ClrScr;
    WriteStr(19,12,'FITCON run completed. Do you want to look');
    WriteStr(19,14,'at the diagnostic output file? (Y or N)');
    FKey := Input(62,14,1,0,WrkStr,False);
    If UpCase(WrkStr[1]) = 'Y' then begin
      FileToType := '\CTDM\TERRAIN\'+DagName+'.DAG';
      TypeFile(FileToType);
    end;
    WriteStr(29,24,PressENTER);
    Readln;
    FKey := 0;
  end;
  Exec(Comm,'/C CD\CTDM\EXE');
End;    { RunFitCon }


Procedure DoFitcon;
Begin
  LoadNames('\CTDM\TERRAIN\','*.XY',XYFiles,XYNames);
  MasterFile :='';
  ModeIsText := True;

  While Masterfile = '' do begin
    F := ' FITCON ';
    MenuHeading(False);
    WrkStr :='';
    FKey := 0;
    GetAnXYFile;
    If FKey = F10 then ExittoDos;
    If FKey = Esc then begin
      MasterFile := ' ';        {ends the while loop}
      FKey := 0;            {keeps you in the menu loop}
     end
     else begin
      GetDefaultOptions;
      ChangeOptions;
      If FKey = F9 then begin
        PutOptions;
        Clrscr;
        If Exist('\CTDM\TERRAIN\PSCRAT') then begin
          Assign(TestFile,'\CTDM\TERRAIN\PSCRAT');
          Erase(TestFile);
        end;
        RunFitcon;
      end
      else If FKey = Esc then
        WrkStr := '1';
    end;
  end;
END;
begin
end.