{$I Switches.INC }

{$F+}    {Force Far Calls for overlays}
{$O+}    {Generate Overlay code}
{$M 16384,0,8000}

Unit Drive3;

Interface

Uses
  Overlay, DrInit, Dos, Crt, Graph, MyDefs;

Procedure DoHcrit;

Implementation

  {$I Spaces.INC }
  {$I Print.INC  }
  {$I Input.INC  }
  {$I Drive1.INC }

PROCEDURE GetAFOFile;
Var
  ZR, ZC, I  :Integer;
Begin
  MsgStr := 'FITCON output file';
  GetAFile(FOFiles,FONames,HillName,MsgStr,MyIdx,0);
  If FKey <= 0 then begin
    Assign(ContourFile,Path+FONames[MyIdx+1]);
    FittedOutFile := FONames[MyIdx+1];         { FO File selected from dir }
   end;
End;    { GetAFOFile }


PROCEDURE GetHcritOptions;
Begin
  Path := '\CTDM\TERRAIN\';
  FittedOutName :='';           { FittedOutName is 1st part of name from list }
  I := 1;
  While FittedOutFile[I] <> '.' do begin            { Parse off the hill name }
    FittedOutName := FittedOutName +  FittedOutFile[I];
    Inc(I);
   end;
  Assign(HcOptionsFile,Path+FittedOutName+'.HOP');
  If Exist(Path+FittedOutName+'.HOP') then begin
    Reset(HcOptionsFile);
    Readln(HcOptionsFile,FittedOutFile);  { Read FO name, but use one selected from dir }
    HCOFile := '';
    Readln(HcOptionsFile,HCOFile);
    HCOName := '';
    I := 1;
    While HCOFile[I] <> '.' do begin
      HCOName := HCOName + HCOFile[I];
      Inc(I);
     end;
    Readln(HcOptionsFile,HPTAns);
    If UpCase(HPTAns[1]) = 'Y' then begin
      Readln(HcOptionsFile,HPTFile);
      HPTName := '';
      I := 1;
      While HPTFile[I] <> '.' do begin
        HPTName := HPTName + HPTFile[I];
        Inc(I);
       end;
     end
     else HPTName := FittedOutName;
    Readln(HcOptionsFile,WrkStr);  Val(Wrkstr,HcritMode,Code);
    If HcritMode = 2 then begin
      Readln(HcOptionsFile,WrkStr); Val(WrkStr,NumCritElev,Code);
      Readln(HcOptionsFile,WrkStr); Val(WrkStr,LowCritElev,Code);
     end
     else begin
      NumCritElev := 1;  LowCritElev := 0;
     end;
    Close(HcOptionsFile);
   end
   else begin                                             { Set default values }
    HCOName     := FittedOutName;
    HPTAns      := 'Y';
    HPTName     := FittedOutName;
    HcritMode   := 1;
    NumCritElev := 1;
    LowCritElev := 0;
   end;
End;    { GetHcritOptions }


PROCEDURE DisplayHcField(IDNumber : Integer);
Begin
  GoToXY(HcFields[IDNumber].X, HcFields[IDNumber].Y); Color(LightGray,Black);
  Case IDNumber of
    1 : Write(FittedOutName, Spaces(HcFields[1].L-Length(FittedOutName)));
    2 : Write(HCOName,       Spaces(HcFields[1].L-Length(HCOName)));
    3 : Write(HPTAns);
    4 : Write(HPTName,       Spaces(HcFields[1].L-Length(HPTName)));
    5 : Write(HcritMode:1);
    6 : Write(NumCritElev:3);
    7 : Write(LowCritElev:10:4);
   end;
End;    { Display HcField }


PROCEDURE DisplayHcOptions;
Begin
  For I := 1 to 7 do begin     {Build array of x,y,length for writing options}
    Case I of
      1  : begin  Y := 11;  L := 8;  end;
      2  : begin  Y := 12;  L := 8;  end;
      3  : begin  Y := 13;  L := 1;  end;
      4  : begin  Y := 14;  L := 8;  end;
      5  : begin  Y := 15;  L := 1;  end;
      6  : begin  Y := 16;  L := 3;  end;
      7  : begin  Y := 17;  L := 10; end;
     end;
    HcFields[I].X := 57;
    HcFields[I].Y := Y;
    HcFields[I].L := L;
   end;
  F := 'HCRIT OPTIONS';
  X := 14;
  MenuHeading(False);
  Color(LightGray,Black);
  WriteStr(11,4,'Use the arrow keys to highlight the option to be changed.');
  WriteStr(X,11,'FITCON OUTPUT FILE (.FO):');
  WriteStr(X,12,'HCRIT OUTPUT FILE (.HCO):');
  WriteStr(X,13,'CREATE A PLOT FILE? (Y or N):');
  WriteStr(X,14,'HCRIT PLOT FILE (.HPT):');
  WriteStr(X,15,'SELECTION MODE FOR CRIT. ELEV.:');
  WriteStr(X,16,'NUMBER OF CRIT. ELEV. (MODE 2 ONLY):');
  WriteStr(X,17,'LOWEST CRIT. ELEV. (MODE 2 ONLY):');
  DoF9Line;
  For I := 1 to 7 do
    DisplayHcField(I);
End;    { DisplayHcOptions }


PROCEDURE PutHcOptions;
Begin                                          {Write .HOP file}
  Path := '\CTDM\TERRAIN\';
  Assign(HcOptionsFile,Path+FittedOutName+'.HOP');
  Rewrite(HcOptionsFile);
  Writeln(HcOptionsFile,FittedOutName+'.FO');
  Writeln(HcOptionsFile,HCOName+'.HCO');
  Writeln(HcOptionsFile,HPTAns);
  If UpCase(HPTAns[1]) = 'Y' then
    Writeln(HcOptionsFile,HPTName+'.HPT');
  Writeln(HcOptionsFile,HcritMode);
  If HcritMode =2 then begin
    Writeln(HcOptionsFile,NumCritElev);
    Writeln(HcOptionsFile,LowCritElev:10:4);
   end;
  Close(HcOptionsFile);
End;    { PutHcOptions }


FUNCTION TestHcName(ID:Integer; FilName : Str12) : Boolean;  {True if error found}
Var
  FileExists : Boolean;
Begin
  Trim(FilName);

  If FilName = '' then EXIT;                   {Exit now if the name is empty}

  If Pos('.',FilName) > 0 then begin
    EraseMsg;
    GoToXY(14,24); Msg :='File extensions not allowed.  ' + PressENTER;
    Print(4,Msg);
    Beep;
    Readln; EraseMsg; Color(LightGray,Black);
    DoF9Line;
    TestHcName := True;
    EXIT;
   end;

  Case ID of
    1 : Ext :='.FO';
    2 : Ext :='.HCO';
    4 : Ext :='.HPT';
   end;

  If ID = 2 then
    FileExists := Exist('\CTDM\FILES\'+FilName+Ext)
   else
    FileExists := Exist('\CTDM\TERRAIN\'+FilName+Ext);

  If (ID = 1)  and  (not FileExists) then begin
    EraseMsg;
    GoToXY(15,24); Msg := 'Error! File does not exist.  ' + PressENTER;
    Print(4,Msg);
    Beep;
    Readln; EraseMsg; Color(LightGray,Black);
    DoF9Line;
    TestHcName := True;
    Exit;
   end;

  If (ID = 1) and (FileExists) then begin
    TestHcName := False;
    EXIT;
   end;

  If ID <> 1 then begin
    If FileExists then begin
      EraseMsg;
      GoToXY(12,24); Msg :='File Exists!      F7 - Overwrite      ENTER - Change Name';
      Print(4,Msg);
      Beep;
      WrkStr := FilName;
      FKey := Input(HcFields[ID].X,HcFields[ID].Y,4,HcFields[ID].L,WrkStr,True);
      If FKey = F7 then begin
        If ID = 2 then
          Assign(TestFile,'\CTDM\FILES\'+FilName+Ext)
         else
          Assign(TestFile,'\CTDM\TERRAIN\'+FilName+Ext);
        Erase(TestFile);
       end;
      EraseMsg; Color(LightGray,Black);
      DoF9Line;
      TestHcName := True;
      Exit;
     end;
   end;
  TestHcName :=False;
End;    { TestHcName }

FUNCTION ValidateHcField(IDField  :  Integer)  :  Boolean;
Var
  Err  :  Boolean;
Begin
  Err := False;
  Case IDField of
    1  :  If TestHcName(IDField,FittedOutName) then Err := True;

    2  :  If TestHcName(IDField,HCOName) then Err := True;

    3  :  If not (UpCase(HPTAns[1]) in ['Y','N']) then begin
            Err := True;
            EraseMsg;
            GoToXY(17,24); Msg :='Please enter Y or N.  Hit Return to Continue.';
           end;

    4  :  If TestHcName(IDField,HPTName) then Err := True;

    5  :  If not ((HcritMode = 1) or (HcritMode = 2)) then begin
            Err := True;
            EraseMsg;
            GoToXY(19,24); Msg :='Options are 1 or 2. Hit RETURN to Continue.';
           end;

    6  :  If not ((NumCritElev >= 1) and (NumCritElev <= 20)) then begin
            Err := True;
            EraseMsg;
            GoToXY(18,24); Msg :='Number must be 1 - 20. Hit RETURN to Continue.';
           end;
   end;

  If Err and not (IDField in [1,2,4])  then begin
    Print(4,Msg);
    Beep;
    Readln; EraseMsg; Color(LightGray,Black);
    DoF9Line;
   end;
  ValidateHcField := not Err;
end;   {ValidateHcField}


PROCEDURE InvokeHcF9;
Var
  M : Integer;
  AllHcValid   :  Boolean;
Begin
  DisplayHcField(FieldID);
  M := 1;
  AllHcValid := True;
  While M < 8 do begin
    If not ValidateHcField(M) then begin
      AllHcValid := False;
      FieldID := M;
      M := 99;
     end;
    Inc(M);
   end;
  If AllHcValid then Collecting := False;
End;  {InvokeHcF9}


PROCEDURE ChangeHcOptions;
Label
  Entrypt2;
Begin
  Collecting := True;
  DisplayHcOptions;
  FieldID := 1;
  While Collecting do begin
    Case FieldID of
      1  : Begin
             WrkStr := FittedOutName;
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             LeftTrim(WrkStr);
             Trim(WrkStr);
             If WrkStr <> '' then begin
               Case FKey of
                 CUp   : begin
                           DisplayHcField(FieldID);  FieldID := 7;
                          end;
                 CDown : begin
                           DisplayHcField(FieldID);  FieldID := 2;
                          end;
                 F9    : begin
                           InvokeHcF9;
                           Goto Entrypt2;
                          end;
                 F10   : ExittoDos;
                 Esc   : EXIT;
                end;
               If (FKey <> CUp) and (FKey <> CDown) then begin
                 FittedOutName := WrkStr;
                 If ValidateHcField(FieldID) then begin
                   DisplayHcField(FieldID);
                   Inc(FieldID);
                  end
                  else FittedOutName := WrkStr;
                end;
              end;
            end;
      2:   Begin
             WrkStr := HCOName;
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             LeftTrim(WrkStr);
             Trim(WrkStr);
             If WrkStr <> '' then begin
               Case FKey of
                 CUp   : begin
                           DisplayHcField(FieldID);  FieldID := 1;
                          end;
                 CDown : begin
                           DisplayHcField(FieldID);  FieldID := 3;
                          end;
                 F9    : begin
                           InvokeHcF9;
                           Goto Entrypt2;
                          end;
                 F10   : ExittoDos;
                 Esc   : EXIT;
                end;
               If (FKey <> CUp) and (FKey <> CDown) then begin
                 HCOName := WrkStr;
                 If ValidateHcField(FieldID) then begin
                   DisplayHcField(FieldID);
                   Inc(FieldID);
                  end
                  else HCOName := WrkStr;
                end;
              end;
            end;

      3  : Begin
             WrkStr := HPTAns;
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             Case FKey of
               CUp   : begin
                         DisplayHcField(FieldID);    FieldID := 2;
                        end;
               CDown : begin
                         DisplayHcField(FieldID);    FieldID := 4;
                        end;
               F9    : begin
                         InvokeHcF9;
                         Goto Entrypt2;
                        end;
               F10   : ExittoDos;
               Esc   : EXIT;
              end;
             If (FKey <> CUp) and (FKey <>CDown) then begin
               HPTAns := WrkStr;
               If ValidateHcField(FieldID) then begin
                 DisplayHcField(FieldID);
                 Inc(FieldID);
                end
                else HPTAns := WrkStr;
              end;
            end;

      4:   Begin
             WrkStr := HPTName;
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             LeftTrim(WrkStr);
             Trim(WrkStr);
             If WrkStr <> '' then begin
               Case FKey of
                 CUp   : begin
                           DisplayHcField(FieldID);  FieldID := 3;
                          end;
                 CDown : begin
                           DisplayHcField(FieldID);  FieldID := 5;
                          end;
                 F9    : begin
                           InvokeHcF9;
                           Goto Entrypt2;
                          end;
                 F10   : ExittoDos;
                 Esc   : EXIT;
                end;
               If (FKey <> CUp) and (FKey <> CDown) then begin
                 HPTName := WrkStr;
                 If ValidateHcField(FieldID) then begin
                   DisplayHcField(fieldID);
                   Inc(FieldID);
                  end
                  else HPTName := WrkStr;
                end;
              end;
            end;
      5:   Begin
             Str(HcritMode:1,WrkStr);
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             Case FKey of
               CUp   : begin
                         DisplayHcField(FieldID);    FieldID := 4;
                        end;
               CDown : begin
                         DisplayHcField(FieldID);    FieldID := 6;
                        end;
               F9    : begin
                         InvokeHcF9;
                         Goto Entrypt2;
                        end;
               F10   : ExittoDos;
               Esc   : EXIT;
              end;
             If (FKey <> CUp) and (FKey <> CDown) then begin
               Trim(WrkStr);
               Val(WrkStr,HcritMode,Code);
               If ValidateHcField(FieldID) then begin
                 DisplayHcField(FieldID);
                 Inc(FieldID);
                end
                else  begin
                 Trim(WrkStr);
                 Val(WrkStr,HcritMode,Code);
                end;
              end;
            end;
      6:   Begin
             Str(NumCritElev:3,WrkStr);
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             Case FKey of
               CUp   : begin
                         DisplayHcField(FieldID);    FieldID := 5;
                        end;
               CDown : begin
                         DisplayHcField(FieldID);    FieldID := 7;
                        end;
               F9    : begin
                         InvokeHcF9;
                         Goto Entrypt2;
                        end;
               F10   : ExittoDos;
               Esc   : EXIT;
              end;
             If (FKey <> CUp) and (FKey <> CDown) then begin
               Trim(WrkStr);
               Val(WrkStr,NumCritElev,Code);
               If ValidateHcField(FieldID) then begin
                 DisplayHcField(FieldID);
                 Inc(FieldID);
                end
                else begin
                 Trim(WrkStr);
                 Val(WrkStr,NumCritElev,Code);
                end;
              end;
            end;
      7:   Begin
             Str(LowCritElev:10:4,WrkStr);
             FKey := Input(HcFields[FieldID].X,HcFields[FieldID].Y,4,HcFields[FieldID].L,WrkStr,True);
             Case FKey of
               CUp   : begin
                         DisplayHcField(FieldID);    FieldID := 6;
                        end;
               CDown : begin
                         DisplayHcField(FieldID);    FieldID := 1;
                        end;
               F9    : begin
                         InvokeHcF9;
                         Goto Entrypt2;
                        end;
               F10   : ExittoDos;
               Esc   : EXIT;
              end;
             If (FKey <> CUp) and (FKey <> CDown) then begin
               Trim(WrkStr);
               Val(WrkStr,LowCritElev,Code);
               DisplayHcField(FieldId);
               FieldId := 1;
              end;
            end;
     end;
entrypt2:
   end;
End;    { ChangeHcOptions }

PROCEDURE RunHcrit;   {Exec Dos calls to run Hcrit from the correct dir}
Begin
  Exec(Comm,'/C CD\CTDM\TERRAIN');
  Exec(Comm,'/C COPY '+FittedOutName+'.HOP'+' '+'HOPTIONS');
  ClrScr;
  MyExec('\CTDM\EXE\HCRIT.EXE','');
  If not AbEnd then begin
    Exec(Comm,'/C COPY \CTDM\TERRAIN\'+HCOName+'.HCO'+' \CTDM\FILES\'+HCOName+'.HCO');
    Exec(Comm,'/C DEL \CTDM\TERRAIN\'+HCOName+'.HCO');
    ClrScr;
    MenuHeading(False);
    GoToXY(13,12); Writeln('The TERRAIN file for use with CTDMPLUS has been created.');
    GoToXy(28,14); Writeln(PressENTER);
    Readln;
    FKey := 0;
  end;
  Exec(Comm,'/C CD\CTDM\EXE');
End;    { RunHcrit }


Procedure DoHcrit;
Begin
  FittedOutFile :='';
  F             := ' HCRIT ';

  ModeIsText    := True;

  LoadNames('\CTDM\TERRAIN\','*.FO',FOFiles,FONames);

  While FittedOutFile = '' do begin
    MenuHeading(False);
    WrkStr :='';
    GetAFOFile;
    If FKey = F10 then ExittoDos;
    If FKey = Esc then begin
      FittedOutFile := ' ';         {get out of the while loop}
      FKey := 0;                 {stay in the menu loop}
    end
    else begin
      GetHcritOptions;
      ChangeHcOptions;
      If FKey = F9 then begin
        PutHcOptions;
        RunHcrit;
      end
      else If FKey = Esc then
        WrkStr :='2'
    end;
  end;
END;

begin
end.
