{$I Switches.INC }

{$F+}    {Force Far Calls for overlays}
{$O+}    {Generate Overlay code}
{$M 16384,0,8000}

Unit Drive4;

Interface

Uses
  Overlay, DrInit, Dos, Crt, Graph, MyDefs;

Procedure GetPflFile;
Procedure GetRctFile;
Procedure GetSFCFile;
Procedure GetRAWFile;
Procedure DoCtdm;

Implementation

  {$I Spaces.INC }
  {$I Print.INC  }
  {$I Input.INC  }
  {$I Drive1.INC }


PROCEDURE GetCtdmInFile;
Var
  DumChr    : Char;
  CtInErr   : Boolean;
  DumStr    : Str80;
Begin
  LoadNames('\CTDM\FILES\','*.CIN',CINFiles,CINNames);
  Indicator := '';
  While Indicator = '' do begin
    DumChr := ' ';
    CtInErr := False;
    MenuHeading(False);
    WrkStr := '';
    HillName := '';
    MsgStr := 'CTDM.IN';
    GetAFile(CINFiles,CINNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(CtdmIn,'\CTDM\FILES\'+CINNames[MyIdx+1]);
      TheCINFile := CINNames[MyIdx+1];
       HillName := '';                               {parse off the hill Name}
      I := 1;
      While TheCINFile[I] <> '.' do begin
        HillName := HillName + TheCINFile[I];
        Inc(I);
      end;
      Reset(CtdmIn);            {open file to read emission and rawin flag}
      Readln(CtdmIn);
      For I := 1 to 2  do
         Read(CtdmIn,Dummy);
      Read(CtdmIn,IConc);         {get the value of iconc}
      For I := 1 to 5 do          {skip the next 5 switches}
         Read(CtdmIn,Dummy);
      Read(CtdmIn,Isor);          {get the value of isor}
      Read(CtdmIn,RawFlag);
      Read(CtdmIn, Dummy);        {skip the istktp switch}
      If IScrn <> 0 then begin
        RawFlag := 0;                     {CTSCREEN doesn't need a RAWIN file}
        If Eoln(CtdmIn) then begin
          CtInErr := True;
          Msg := 'This CTDM.IN file cannot be used with CTSCREEN. ' + PressENTER;
        end
        else begin
          While DumChr = ' ' do begin
            Read(CtdmIn,DumChr);     {Read the actual Iscrn switch from file}
          end;
          If DumChr = Chr(13) then begin    {not enough switches}
            CtInErr := True;
            Msg := 'This CTDM.IN file cannot be used with CTSCREEN. ' + PressENTER;
          end
          else begin
            If DumChr = '0' then begin   {switch is set to 0 in file}
              Iscrn := 0;
              CtInErr := True;
              Msg := 'ISCRN switch not set properly in CTDM.IN file. ' + PressENTER;
            end
            else begin            {get value of the switch}
              Val(Dumchr,Iscrn,Code);
              Exit;
            end;
          end;
        end;
        If CtInErr then begin
          EraseMsg;
          GoToXY(5,24);
          Print(4,Msg);
          Beep;
          Readln; EraseMsg; Color(LightGray,Black);
          DoEscorF10;
          Indicator := '';
        end;
      end
      else begin                                     {CTDMPLUS run}
        Readln(CtdmIn);                              { finish switch line}
        Readln(CtdmIn);                                     { skip params}
        Readln(CtdmIn);                                      { skip tower}
        Readln(CtdmIn,DumStr);   {read whole line to get EmisFlag}
        For I := 80 downto 75 do begin
          If DumStr[I] in ['0','1'] then
            Val(DumStr[I],EmisFlag,Code);
        end;
        Close(CtdmIn);
        Exit;
      end;
    end
    else
      If FKey in [F10,F8,Esc] then Exit;
  end;
End;       {GetCtdmInFile}


PROCEDURE GetEmsFile;
Begin
  LoadNames('\CTDM\FILES\','*.EMS',EMSFiles,EMSNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'EMISSION';
    GetAFile(EMSFiles,EMSNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Emission,'\CTDM\FILES\'+EMSNames[MyIdx+1]);
      TheEMSFile := EMSNames[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetEmsFile}


PROCEDURE GetSFCFile;
Begin
  LoadNames('\CTDM\FILES\','*.SFC',SFCFiles,SFCNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'SURFACE';
    GetAFile(SFCFiles,SFCNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Surface,'\CTDM\FILES\'+SFCNames[MyIdx+1]);
      TheSFCFile := SFCNames[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetSFCFile}


PROCEDURE GetPFLFile;
Begin
  LoadNames('\CTDM\FILES\','*.PFL',PFLFiles,PFLNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'PROFILE';
    GetAFile(PFLFiles,PFLNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Profile,'\CTDM\FILES\'+PFLNames[MyIdx+1]);
      ThePFLFile := PFLNames[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetPFLFile}


PROCEDURE GetHCOFile;
Begin
  LoadNames('\CTDM\FILES\','*.HCO',HCOFiles,HCONames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'TERRAIN';
    GetAFile(HCOFiles,HCONames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Terrain,'\CTDM\FILES\'+HCONames[MyIdx+1]);
      TheHCOFile := HCONames[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetHCOFile}


PROCEDURE GetRCTFile;
Begin
  LoadNames('\CTDM\FILES\','*.RCT',RCTFiles,RCTNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'RECEPTOR';
    GetAFile(RCTFiles,RCTNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Receptor,'\CTDM\FILES\'+RCTNames[MyIdx+1]);
      TheRCTFile := RCTNames[MyIdx+1];
      Exit;
    end
    else
      If FKey in [F10,F8,Esc] then Exit;
  end;
end;     {GetRCTFile}


PROCEDURE GetRAWFile;
Begin
  LoadNames('\CTDM\FILES\','*.RAW',RAWFiles,RAWNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'RAWIN';
    GetAFile(RAWFiles,RAWNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Rawin,'\CTDM\FILES\'+RAWNames[MyIdx+1]);
      TheRAWFile := RAWNames[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetRAWFile}


PROCEDURE CtdmError(J: Integer);
Begin
  Case J of
    1  : WrkStr := 'CTDM.IN';
    2  : WrkStr := 'EMISSION';
    3  : WrkStr := 'SURFACE';
    4  : WrkStr := 'PROFILE';
    5  : WrkStr := 'TERRAIN';
    6  : WrkStr := 'RECEPTOR';
    7  : WrkStr := 'RAWIN';
   end;
  EraseMsg;
  GoToXY(11,24); Msg := 'You must select a file for '+WrkStr+'. ' + PressENTER;
  Print(4,Msg);
  Beep;
  Readln; EraseMsg; Color(LightGray,Black);
  DoEscorF10;
end;  {CtdmError}


FUNCTION CheckCtdmNames: Boolean;      {True if check OK}
Begin
  CheckCtdmNames := False;
  If TheCINFile = '' then CtdmError(1)
   else If (EmisFlag = 1) and (TheEMSFile = '') then CtdmError(2)
   else If TheSFCFile = '' then CtdmError(3)
   else If ThePFLFile = '' then CtdmError(4)
   else If TheHCOFile = '' then CtdmError(5)
   else If TheRCTFile = '' then CtdmError(6)
   else If (RawFlag > 0) and (TheRAWFile = '') then CtdmError(7)
   else CheckCtdmNames := True;
end;  {CheckCtdmNames}


PROCEDURE DisplayCtdmFiles;
Begin
  Color(LightGray,Black);
  ClrScr;
  MenuHeading(False);
  WrkStr :=  '';
  X := 24;
  WriteStr(14,5,'The following files have been selected.  Type a');
  WriteStr(14,6,'number to change a file name or ');
  Color(White,Cyan); Write('F9');
  Color(LightGray,Black);
  Write(' to run'+ F);
  MenuLine(X,8,One, '  -  CTDM.IN  =   ' + TheCINFile);
  MenuLine(X,10,Two,'  -  EMISSION =   ');
  If Emisflag = 1 then Write(TheEMSFile)
   else                Write('N/A');
  MenuLine(X,12,' 3 ','  -  SURFACE  =   ' + TheSFCFile);
  MenuLine(X,14,' 4 ','  -  PROFILE  =   ' + ThePFLFile);
  MenuLine(X,16,' 5 ','  -  TERRAIN  =   ' + TheHCOFile);
  MenuLine(X,18,' 6 ','  -  RECEPTOR =   ' + TheRCTFile);
  MenuLine(X,20,' 7 ','  -  RAWIN    =   ');
  If (RawFlag > 0) and (Iscrn = 0) then Write(TheRAWFile)
   else               Write('N/A');
  DoEscorF10;
end; {DisplayCtdmFiles}


PROCEDURE ChooseCTDMFiles;
Var
  CLooping  :  Boolean;
Begin
  If IScrn = 0 then
    F := ' CTDMPLUS '
  else
    F := ' CTSCREEN ';
  TheCINFile := ''; TheEMSFile := ''; TheSFCFile := ''; ThePFLFile := '';
  TheHCOFile := ''; TheRCTFile := ''; TheRAWFile := '';
  CID := 1;
  CLooping := True;
  MenuHeading(False);
  While CLooping do begin
    Case CID of
      1 : begin
            GetCtdminFile;
            Case FKey of
              Esc  : Exit;
              F10  : ExittoDos;
              F8   : CID := 8;
             end;
            If FKey <> F8 then
              If IScrn <> 0 then CID := 5
               else If EmisFlag = 1 then CID := 2
               else If EmisFlag = 0 then CID := 3;
           end;

      2 : begin
            GetEMSFile;
            Case FKey of
              Esc : CID := 1;
              F10 : ExittoDos;
              F8  : CID := 8;
             end;
            If (FKey <> F8) and (FKey <> Esc) then CID := 3;
           end;

      3 : begin
            GetSFCFile;
            Case FKey of
              Esc : If EmisFlag = 1 then CID := 2 else CID := 1;
              F8  : CID := 8;
              F10 : ExittoDos;
             end;
            If (FKey <> F8) and (FKey <> Esc) then CID := 4;
           end;

      4 : begin
            GetPFLFile;
            Case FKey of
              Esc : CID := 3;
              F8  : CID := 8;
              F10 : ExittoDos;
             end;
            If (FKey <> F8) and (FKey <> Esc) then CID := 5;
           end;

      5 : begin
            GetHCOFile;
            Case FKey of
              Esc : If IScrn = 0 then CID := 4 else CID := 1;
              F8  : CID := 8;
              F10 : ExittoDos;
             end;
            If (FKey <> F8) and (FKey <> Esc) then CID := 6;
           end;

      6 : begin
            GetRCTFile;
            Case FKey of
              Esc  : CID := 5;
              F8   : CID := 8;
              F10  : ExittoDos;
             end;
            If (FKey <> F8) and (FKey <> Esc) and (IScrn <> 0) then CID := 8
            else If (FKey <> F8) and (FKey <> Esc) and (RawFlag > 0) then CID := 7
            else If (FKey <> F8) and (FKey <> Esc) and (RawFlag = 0) then CID := 8;
           end;

      7:  begin
            GetRAWFile;
            Case FKey of
              Esc  : CID := 6;
              F10  : ExittoDos;
              F8,0 : CID := 8;                        { 0 = a return is hit}
             end;
           end;

      8 : begin
            If IScrn <> 0 then begin
              TheSFCFile := 'CTSCREEN.SFC';
              ThePFLFile := 'CTSCREEN.PFL';
            end;
            DisplayCtdmFiles;                         {list the chosen files}
            FKey := Input(40,22,1,0,WrkStr,True);
            Case FKey of
              Esc : begin
                     If (RawFlag > 0) then CID := 7
                      else CID := 6;
                     end;
              F10 : ExittoDos;
              F9  : If CheckCtdmNames then CLooping := False;  {exit while to run CTDMPLUS}
             end;
            If (FKey <> Esc) and (FKey <> 9) then begin
              Val(WrkStr,CID,Code);
              If CID in [3,4] then begin
                EraseMsg; GoToXY(11,24);
                Msg := 'File name cannot be changed. '+ PressENTER;
                Print(4,Msg);
                Beep;
                Readln; EraseMsg; Color(LightGray,Black);
                DoEscorF10;
                CID := 8;
              end;
            end;
          end;
      else CID := 8;
     end;   {case}
   end;     {while}

  If (Iconc > 0) and (IScrn = 0) then begin       {CTSCREEN doesn't use conc}
    If Exist('\CTDM\FILES\'+HillName+'.CON') then begin   {note: the conc}
      Assign(ConFile,'\CTDM\FILES\'+HillName+'.CON');     {file can't exist}
      Color(LightGray,Black); ClrScr; WrkStr := ''; DoEscorF10;
      WriteStr(23,10,HillName+'.CON exists. Do you want to:');
      WriteStr(13,14,'1  -  Overwrite the existing file');
      WriteStr(13,16,'2  -  Create a backup copy of the existing file (*.&CN)');
      FKey := Input(40,20,1,0,WrkStr,True);
      If FKey = Esc then Exit;
      If FKey = F10 then ExittoDos;
      If WrkStr = '1' then Erase(ConFile);
      If WrkStr = '2' then begin
        Exec(Comm,'/C COPY \CTDM\FILES\'+HillName+'.CON '+'\CTDM\FILES\'+HillName+'.&CN');
        Erase(ConFile);
      end;
    end;
  end;
end;  {ChooseCtdmFiles}


PROCEDURE RunCtdm;
Begin
  GoToXY(25,12); Writeln('Copying input files');
  Exec(Comm,'/C CD\CTDM\FILES');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheCINFile+' CTDM.IN');
  If (Iscrn = 0) and (EmisFlag = 1) then
     Exec(Comm,'/C COPY \CTDM\FILES\'+TheEMSFile+' EMISSION');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheSFCFile+' SURFACE');
  Exec(Comm,'/C COPY \CTDM\FILES\'+ThePFLFile+' PROFILE');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheHCOFile+' TERRAIN');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheRCTFile+' RECEPTOR');
  If (Iscrn = 0) and (RawFlag > 0) then
     Exec(Comm,'/C COPY \CTDM\FILES\'+TheRAWFile+' RAWIN');
  ClrScr;
  GoToXY(25,12); Writeln('Deleting old output files');
  If (Exist('\CTDM\FILES\CTDM.OUT')) then Exec(Comm,'/C DEL CTDM.OUT');
  If (Exist('\CTDM\FILES\SOURCES')) then Exec(Comm,'/C DEL SOURCES');
  If (Iscrn = 1) then
    If (Exist('\CTDM\FILES\CONC')) then Exec(Comm,'/C DEL CONC')
  else begin
    If (Exist('\CTDM\FILES\STCONC')) then Exec(Comm,'/C DEL STCONC');
    If (Exist('\CTDM\FILES\UNCONC')) then Exec(Comm,'/C DEL UNCONC');
    If (Exist('\CTDM\FILES\METDAT')) then Exec(Comm,'/C DEL METDAT');
    If (Exist('\CTDM\FILES\METDAT')) then Exec(Comm,'/C DEL SUMRE');
  end;
  ClrScr;
  GoToXY(18,12);
  If Iscrn = 0 then  begin
    Writeln('Executing the CTDMPLUS model. Please wait.');
    MyExec('\CTDM\EXE\CTDMPLUS.EXE','');
  end
  else begin
    Writeln('Executing the CTSCREEN model. Please wait.');
    MyExec('\CTDM\EXE\CTSCREEN.EXE','');
  end;
  If not AbEnd then begin
    WrkStr :='';
    ClrScr;
    Exec(Comm,'/C COPY CTDM.OUT \CTDM\FILES\'+HillName+'.OUT');
    If (Iscrn = 0) then begin
      If (Iconc > 0) then begin
        If (Exist('\CTDM\FILES\CONC')) then begin
          Exec(Comm,'/C COPY CONC \CTDM\FILES\'+HillName+'.CON');
          ClrScr;
          GoToXY(29,12);  Write('CTDMPLUS run completed');
        end
        else begin
          ClrScr;
          Color(Yellow,Black);
          GoToXY(20,12);  Write('NOTE: CTDMPLUS did not run to completion.');
          Color(LightGray,Black);
        end;
        GoToXY(10,14);  Write('Do you want to look at the diagnostic output file? (Y or N)');
        FKey := Input(40,16,1,0,WrkStr,False);
        If UpCase(WrkStr[1]) = 'Y' then begin
          FiletoType := '\CTDM\FILES\'+HillName+'.OUT';
          TypeFile(FiletoType);
        end;
      end
      else begin
        ClrScr;
        GoToXY(29,12);  Write('CTDMPLUS run completed');
        GoToXY(10,14);  Write('Do you want to look at the diagnostic output file? (Y or N)');
        FKey := Input(40,16,1,0,WrkStr,False);
        If UpCase(WrkStr[1]) = 'Y' then begin
          FiletoType := '\CTDM\FILES\'+HillName+'.OUT';
          TypeFile(FiletoType);
        end;
      end;
      If (ISor > 0) and (Exist('\CTDM\FILES\SOURCES')) then
        Exec(Comm,'/C COPY SOURCES \CTDM\FILES\'+HillName+'.SRC');
    end
    else begin
      If (Exist('\CTDM\FILES\METDAT')) then begin
        If (IConc > 0) and (Iscrn in [1,3]) then
          Exec(Comm,'/C COPY STCONC \CTDM\FILES\'+HillName+'.STC');
        If (IConc > 0) and (Iscrn > 1) then
          Exec(Comm,'/C COPY UNCONC \CTDM\FILES\'+HillName+'.UNC');
        Exec(Comm,'/C COPY SUMRE    \CTDM\FILES\'+HillName+'.SUM');
        Exec(Comm,'/C COPY METDAT   \CTDM\FILES\'+HillName+'.MET');
        If ISor > 0 then
          Exec(Comm,'/C COPY SOURCES \CTDM\FILES\'+HillName+'.SRC');
        ClrScr;
        GoToXY(24,12); Write('CTSCREEN run completed. Do you want');
        GoToXY(24,14); Write('to look at the SUMRE file? (Y or N)');
        FKey := Input(62,14,1,0,WrkStr,False);
        If UpCase(WrkStr[1]) = 'Y' then begin
          FiletoType := '\CTDM\FILES\'+HillName+'.SUM';
          TypeFile(FileToType);
        end;
      end
      else begin
        ClrScr;
        Color(Yellow,Black);
        GoToXY(20,12);  Write('NOTE: CTSCREEN did not run to completion.');
        Color(LightGray,Black);
        GoToXY(10,14);  Write('Do you want to look at the diagnostic output file? (Y or N)');
        FKey := Input(40,16,1,0,WrkStr,False);
        If UpCase(WrkStr[1]) = 'Y' then begin
          FiletoType := '\CTDM\FILES\'+HillName+'.OUT';
          TypeFile(FiletoType);
        end;
      end;
      GoToXY(29,24); Write(PressENTER);
      Readln;
      FKey :=0;
    end;
  end;
  Exec(Comm,'/C CD\CTDM\EXE');
end;  {RunCtdm}

PROCEDURE DoCtdm;
Begin
  FKey       := 0;
  ModeIsText := True;

  ChooseCtdmFiles;

  If Fkey <> Esc then begin
    ClrScr;
    RunCtdm;
  end;
End;

begin
end.