{$I Switches.INC }

{$F+}    {Force Far Calls for overlays}
{$O+}    {Generate Overlay code}
{$M 16384,0,8000}

Unit Drive5;

Interface

Uses
  Overlay, DrInit, Dos, Crt, Graph, MyDefs, Drive4;

Procedure DoMetpro;
Procedure DoR62;

Implementation

  {$I Spaces.INC }
  {$I Print.INC  }
  {$I Input.INC  }
  {$I Drive1.INC }

PROCEDURE GetMOPFile;
Begin
  LoadNames('\CTDM\FILES\','*.MOP',MOPFiles,MOPNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    HillName := '';
    MsgStr := 'OPTIONS';
    GetAFile(MOPFiles,MOPNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Mop,'\CTDM\FILES\'+MOPNames[MyIdx+1]);
      TheMOPFile := MOPNames[MyIdx+1];

      HillName := '';                                {parse off the hill Name}
      I := 1;
      While TheMOPFile[I] <> '.' do begin
        HillName := HillName + TheMOPFile[I];
        Inc(I);
       end;

      Reset(Mop);                          {open file to read mode switch}
      Readln(Mop,ModeSwitch);
      Close(Mop);
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
End;       {GetMOPFile}

PROCEDURE GetSF1File;
Begin
  LoadNames('\CTDM\FILES\','*.SF1',SF1Files,SF1Names);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'SURF1';
    GetAFile(SF1Files,SF1Names,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Surf1,'\CTDM\FILES\'+SF1Names[MyIdx+1]);
      TheSF1File := SF1Names[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetSF1File}


PROCEDURE GetSF2File;
Begin
  LoadNames('\CTDM\FILES\','*.SF2',SF2Files,SF2Names);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'SURF2';
    GetAFile(SF2Files,SF2Names,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(Surf2,'\CTDM\FILES\'+SF2Names[MyIdx+1]);
      TheSF2File := SF2Names[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetSF2File}


PROCEDURE MetError(J : Integer);
Begin
  Case J of
    1  :  WrkStr := 'OPTIONS';
    2  :  WrkStr := 'PROFILE';
    3  :  WrkStr := 'SURF1';
    4  :  WrkStr := 'SURF2';
    5  :  WrkStr := 'RAWIN';
   end;
  EraseMsg;
  GoToXY(11,24); Msg := 'You must select a file for '+WrkStr+'. ' + PressENTER;
  Print(4,Msg);  Beep;
  Readln; EraseMsg; Color(LightGray,Black);
  DoEscorF10;
end;  {MetError}

FUNCTION CheckMetNames :  Boolean;   {True if check OK}
Begin
  CheckMetNames := False;
  If TheMOPFile = '' then MetError(1)
   else If ThePFLFile = '' then MetError(2)
   else If TheSF1File = '' then MetError(3)
   else If (ModeSwitch > 1) and (TheSF2File = '') then MetError(4)
   else If (ModeSwitch = 3) and (TheRAWFile = '') then MetError(4)
   else CheckMetNames := True;
end;


PROCEDURE DisplayMetFiles;
Begin
  Color(LightGray,Black);
  ClrScr;
  MenuHeading(False);
  WrkStr :=  '';
  X := 24;
  WriteStr(16,5,'The following files have been selected.  Type a');
  WriteStr(16,6,'number to change a file name or ');
  Color(White,Cyan); Write('F9');
  Color(LightGray,Black); Write(' to run Metpro.');
  MenuLine(X,10,One,  '  -  OPTIONS  =   ' + TheMOPFile);
  MenuLine(X,12,Two,  '  -  PROFILE  =   ' + ThePFLFile);
  MenuLine(X,14,Three,'  -  SURF1    =   ' + TheSF1File);
  MenuLine(X,16,Four, '  -  SURF2    =   ');
  If ModeSwitch >1 then Write(TheSF2File)
   else Write('N/A');
  MenuLine(X,18,Five, '  -  RAWIN    =   ');
  If ModeSwitch = 3 then Write(TheRAWFile)
   else Write('N/A');
  DoEscorF10;
end; {DisplayMetFiles}


PROCEDURE ChooseMetFiles;
Var
  MLooping  :  Boolean;
Begin
  F := ' METPRO ';
  TheMOPFile := ''; ThePFLFile := ''; TheSF1File := '';   {initialize to blank}
  TheSF2File := '';TheRAWFile := '';                 { in case F8 is hit too soon}
  MID := 1;
  MLooping := True;
  MenuHeading(False);
  While MLooping do begin
    Case MID of
      1 : begin
            GetMOPFile;
            Case FKey of
              Esc : Exit;
              F10 : ExittoDos;
              F8  : MID := 8;
             end;
            If (FKey <> F8) and (FKey <> Esc) then MID := 2;
           end;
      2 : begin
            GetPFLFile;
            Case FKey of
              Esc : MID := 1;
              F10 : ExittoDos;
              F8  : MID := 8;
             end;
            If (FKey <> F8) and (FKey <> Esc) then MID := 3;
           end;
      3 : begin
            GetSF1File;
            Case FKey of
              Esc : MID := 2;
              F8  : MID := 8;
              F10 : ExittoDos;
             end;
            If (FKey <> F8) and (FKey <> Esc) and (ModeSwitch > 1) then MID := 4;
            If (FKey <> F8) and (FKey <> Esc) and (Modeswitch <= 1) then MID := 8;
           end;
      4 : begin
            GetSF2File;
            Case FKey of
              Esc : MID := 3;
              F8  : MID := 8;
              F10 : ExittoDos;
             end;
            If (FKey <> F8) and (FKey <> Esc) and (ModeSwitch = 3) then MID := 5;
            If (FKey <> F8) and (FKey <> Esc) and (Modeswitch < 3) then MID := 8;
           end;
      5 : begin
            GetRAWFile;
            Case FKey of
              Esc  : MID := 4;
              F8,0 : MID := 8;
              F10  : ExittoDos;
             end;
           end;
      8 : begin
            DisplayMetFiles;                         {list the chosen files}
            FKey := Input(40,22,1,0,WrkStr,True);
            Case FKey of
              Esc : MID := 5;                      {go back to start of input}
              F10 : ExittoDos;
              F9  : If CheckMetNames then MLooping := False;                {exit while to run METPRO}
             end;
            If (FKey <> Esc) and (FKey <> 9) then Val(WrkStr,MID,Code);
           end;
      else MID := 8;
     end;
   end;     {while}
  If Exist('\CTDM\FILES\'+HillName+'.SFC') then begin   {note: the surface}
    Assign(SurfFile,'\CTDM\FILES\'+HillName+'.SFC');     {file can't exist}
    Color(LightGray,Black); ClrScr; WrkStr := ''; DoEscorF10;
    WriteStr(23,10,HillName+'.SFC exists. Do you want to:');
    WriteStr(13,14,'1  -  Overwrite the existing file');
    WriteStr(13,16,'2  -  Create a backup copy of the existing file (*.&SF)');
    FKey := Input(40,20,1,0,WrkStr,True);
    If FKey = Esc then Exit;
    If FKey = F10 then ExittoDos;
    If WrkStr = '1' then Erase(SurfFile);
    If WrkStr = '2' then  begin
      Exec(Comm,'/C COPY \CTDM\FILES\'+HillName+'.SFC '+HillName+'.&SF');
      Erase(SurfFile);
     end;
   end;
end;  {ChooseMetFiles}

PROCEDURE RunMetpro;
Begin
  Exec(Comm,'/C CD\CTDM\FILES');
  Exec(Comm,'/C DEL SURFACE');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheMOPFile+' OPTIONS');
  Exec(Comm,'/C COPY \CTDM\FILES\'+ThePFLFile+' PROFILE');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheSF1File+' SURF1');
  If ModeSwitch > 1 then
    Exec(Comm,'/C COPY \CTDM\FILES\'+TheSF2File+' SURF2');
  If ModeSwitch = 3 then
    Exec(Comm,'/C COPY \CTDM\FILES\'+TheRAWFile+' RAWIN');
  MyExec('\CTDM\EXE\METPRO.EXE','');
  If not AbEnd then begin
    WrkStr :='';
    ClrScr;
    Exec(Comm,'/C COPY SURFACE \CTDM\FILES\'+HillName+'.SFC');
    Exec(Comm,'/C COPY OUTPUT \CTDM\FILES\'+HillName+'.MOF');
    WriteStr(19,12,'METPRO run completed. Do you want to look');
    WriteStr(19,14,'at the diagnostic output file? (Y or N)');
    FKey := Input(62,14,1,0,WrkStr,False);
    If UpCase(WrkStr[1]) = 'Y' then begin
      FiletoType := '\CTDM\FILES\'+HillName+'.MOF';
      TypeFile(FileToType);
    end;
    GoToXY(29,24); Write(PressEnter);
    Readln;
    ClrScr;
    WrkStr := '';
    GoToXY(15,12); Write('Do you want to look at the SURFACE file? (Y or N)');
    FKey := Input(65,12,1,0,WrkStr,False);
    If UpCase(WrkStr[1]) = 'Y' then begin
      FiletoType := '\CTDM\FILES\'+HillName+'.SFC';
      TypeFile(FiletoType);
    end;
    GoToXY(29,24); Write(PressENTER);
    Readln;
    FKey :=0;
  end;
  Exec(Comm,'/C CD\CTDM\EXE');
end;  {RunMetpro}


PROCEDURE GetR62File;
Begin
  LoadNames('\CTDM\FILES\','*.R62',R62Files,R62Names);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    HillName := '';
    MsgStr := 'OPT62';
    GetAFile(R62Files,R62Names,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      TheR62File := R62Names[MyIdx+1];
      Assign(Opt62,'\CTDM\FILES\'+R62Names[MyIdx+1]);

      HillName := '';                                {parse off the hill Name}
      I := 1;
      While TheR62File[I] <> '.' do begin
        HillName := HillName + TheR62File[I];
        Inc(I);
       end;
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
End;       {GetR62File}

PROCEDURE GetTDFile;
Begin
  LoadNames('\CTDM\FILES\','*.TD',TDFiles,TDNames);
  Indicator := '';
  While Indicator = '' do begin
    MenuHeading(False);
    WrkStr := '';
    MsgStr := 'TD6201';
    GetAFile(TDFiles,TDNames,HillName,MsgStr,MyIdx,1);
    If FKey = 0  then begin
      Assign(TD6201,'\CTDM\FILES\'+TDNames[MyIdx+1]);
      TheTDFile := TDNames[MyIdx+1];
      Exit;
     end
     else
      If FKey in [F10,F8,Esc] then Exit;
   end;
end;     {GetTDFile}


PROCEDURE R62Error(J : Integer);
Begin
  Case J of
    1  :  WrkStr := 'OPT62';
    2  :  WrkStr := 'TD6201';
   end;
  EraseMsg;
  GoToXY(11,24); Msg := 'You must select a file for '+WrkStr+'. ' + PressENTER;
  Print(4,Msg);  Beep;
  Readln; EraseMsg; Color(LightGray,Black);
  DoEscorF10;
end;  {R62Error}

FUNCTION CheckR62Names :  Boolean;   {True if check OK}
Begin
  CheckR62Names := False;
  If TheR62File = '' then R62Error(1)
   else If TheTDFile = '' then R62Error(2)
   else CheckR62Names := True;
end;      {CheckR62Names}


PROCEDURE DisplayR62Files;
Begin
  Color(LightGray,Black);
  ClrScr;
  MenuHeading(False);
  WrkStr :=  '';
  X := 25;
  WriteStr(16,5,'The following files have been selected.  Type a');
  WriteStr(16,6,'number to change a file name or F9 to run READ62.');
  MenuLine(X,10,One,'  -  OPT62   =   ' + TheR62File);
  MenuLine(X,12,Two,'  -  TD6201  =   ' + TheTDFile);
  DoEscorF10;
end; {DisplayMetFiles}


PROCEDURE ChooseR62Files;
Var
  MLooping  :  Boolean;                  {use the same counter as before}
Begin
  F := ' READ62 ';
  TheR62File := ''; TheTDFile := '';
  MID := 1;
  MLooping := True;
  MenuHeading(False);
  While MLooping do begin
    Case MID of
      1 : begin
            GetR62File;
            Case FKey of
              Esc  : Exit;
              F10  : ExittoDos;
              F8   : MID := 8;
             end;
            If (FKey <> F8) and (FKey <> Esc) then MID := 2;
           end;
      2 : begin
            GetTDFile;
            Case FKey of
              Esc : MID := 1;
              F10 : ExittoDos;
              F8  : MID := 8;
             end;
            If (FKey <> F8) and (FKey <> Esc) then MID := 3;
           end;
      8 : begin
            DisplayR62Files;                          {list the chosen files}
            FKey := Input(40,22,1,0,WrkStr,True);
            Case FKey of
              Esc : MID := 2;                      {go back to start of input}
              F10 : ExittoDos;
              F9  : If CheckR62Names then MLooping := False;               {exit while to run READ62}
             end;
            If (FKey <> Esc) and (FKey <> 9) then Val(WrkStr,MID,Code);
           end;
        else MID := 8;
     end;
   end;     {while}
  If Exist('\CTDM\FILES\'+HillName+'.RAW') then begin   {do they wan't to}
    Assign(RawinFile,'\CTDM\FILES\'+HillName+'.RAW');    {overwrite the file?}
    Color(LightGray,Black); ClrScr; WrkStr := ''; DoEscorF10;
    WriteStr(23,10,HillName+'.RAW exists. Do you want to:');
    WriteStr(15,14,'1  -  Overwrite the existing file');
    WriteStr(15,16,'2  -  Create a backup copy of the existing file (*.&RW)');
    FKey := Input(40,20,1,0,WrkStr,True);
    If FKey = Esc then Exit;
    If FKey = F10 then ExittoDos;
    If WrkStr = '1' then Erase(RawinFile);
    If WrkStr = '2' then begin
      Exec(Comm,'/C COPY \CTDM\FILES\'+HillName+'.RAW '+HillName+'.&RW');
      Erase(RawinFile);
     end;
   end;
end;  {ChooseR62Files}

PROCEDURE RunRead62;
Begin
  Exec(Comm,'/C CD\CTDM\FILES');
  Exec(Comm,'/C DEL RAWIN');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheR62File+' OPT62');
  Exec(Comm,'/C COPY \CTDM\FILES\'+TheTDFile+' TD6201');
  MyExec('\CTDM\EXE\READ62.EXE',' /R 2876');
  If not AbEnd then begin
    WrkStr :='';
    ClrScr;
    Exec(Comm,'/C COPY RAWIN \CTDM\FILES\'+HillName+'.RAW');
    Exec(Comm,'/C COPY R62OUT \CTDM\FILES\'+HillName+'.ROF');
    WriteStr(19,12,'READ62 run completed. Do you want to look');
    WriteStr(19,14,'at the diagnostic output file? (Y or N)');
    FKey := Input(62,14,1,0,WrkStr,False);
    If UpCase(WrkStr[1]) = 'Y' then begin
      FiletoType := '\CTDM\FILES\'+HillName+'.ROF';
      TypeFile(FileToType);
    end;
    WriteStr(29,24,PressENTER);
    Readln;
    FKey :=0;
  end;
  Exec(Comm,'/C CD\CTDM\EXE');
end;  {RunRead62}


PROCEDURE DoR62;
Begin
  ModeIsText := True;

  ChooseR62Files;
  If Fkey <> Esc then begin
    ClrScr;
    RunRead62;
  end;
END;

PROCEDURE DoMetpro;
Begin
  ModeIsText := True;

  ChooseMetFiles;
  If Fkey <> Esc then begin
    ClrScr;
    RunMetpro;
  end;
END;

begin
end.

