      PROGRAM CHIRET                                                    CHI00010
C***PROGRAM TO RETRIEVE CTDM CALCULATED CONCENTRATIONS BY RECEPTOR FOR  CHI00020
C***A SPECIFIC RANGE OF HOURS SPECIFIED BY THE USER. FOR A GIVEN HILL,  CHI00030
C***THE NUMBER AND LOCATION OF RECEPTORS IS ASSUMED TO BE CONSTANT FOR  CHI00040
C***THE RANGE OF HOURS SPECIFIED. FOR EACH HOUR, THE CONCENTRATIONS ARE CHI00050
C***SORTED FROM THE HIGHEST TO THE LOWEST OVER THE FIELD OF RECEPTORS.  CHI00060
C***THESE SORTED CONCENTRATIONS ARE THEN OUTPUT TO A FILE FOR INPUT TO  CHI00070
C***THE PROGRAM CHIDIS FOR DISPLAY OF THE CONCENTRATIONS ON A MAP OF    CHI00080
C***UNEDITED CONTOURS AND FOR USE WITH THE CONTOURING ROUTINE.          CHI00090
C***                                                                    CHI00100
C***                                                                    CHI00110
C   GLOSSARY OF TERMS                                                   CHI00120
C***                                                                    CHI00130
C***                                                                    CHI00140
C   CHIFL=NAME OF THE CTDM OUTPUT FILE CONTAINING THE CALCULATED        CHI00150
C         CONCENTRATIONS                                                CHI00160
C   CHISRT=NAME OF THE OUTPUT FILE CONTAINING THE HOURLY CONCENTRATIONS CHI00170
C          AND RECEPTOR COORDINATES SORTED BY CONCENTRATION             CHI00180
C   CHOUR=SUBROUTINE CALLED TO CALCULATE THE ELAPSED NUMBER OF HOURS    CHI00190
C         FROM 00/01/01:00 TO THE YY/MM/DD:HH IN QUESTION               CHI00200
C   CONC(I)=CONCENTRATION FOR RECEPTOR I FOR A PARTICULAR HOUR          CHI00210
C   DAY=TWO DIGIT INTEGER SPECIFYING THE DAY(01-31)                     CHI00220
C   HOUR=TWO DIGIT INTEGER SPECIFYING THE HOUR(01-24)                   CHI00250
C   ID=HILL IDENTIFICATION NUMBER FOR A PARTICULAR RECEPTOR IN THE      CHI00260
C      RECEPTOR FILE                                                    CHI00270
C   IDHILL=HILL IDENTIFICATION NUMBER INPUT BY THE USER                 CHI00280
C   IEND=END OF DATA FLAG FOR THE PLOT FILE USED BY THE CONCENTRATION   CHI00290
C        PLOTTING PROGRAM                                               CHI00300
C       =0(MORE PLOT FILE DATA TO FOLLOW)                               CHI00310
C       =1(NO MORE PLOT FILE DATA TO FOLLOW)                            CHI00320
C   IEF=COMPLETION CODE RETURNED BY SUBROUTINE READIT                   CHI00330
C      =0(END OF CTDM CONCENTRATION OUTPUT FILE NOT REACHED)            CHI00340
C      =1(END OF CTDM CONCENTRATION OUTPUT FILE REACHED)                CHI00350
C   IFLAG=COMPLETION FLAG FOR SUBROUTINE CHOUR                          CHI00360
C        =0(DAY-MONTH ASSIGNMENT WITHIN RANGE)                          CHI00370
C        =1(DAY-MONTH ASSIGNMENT OUT OF RANGE)                          CHI00380
C   IHRT=HOUR FOR A PARTICULAR RECORD FROM THE CTDM CONCENTRATION OUTPUTCHI00420
C        FILE(WITH RESPECT TO 00/01/01:01)                              CHI00430
C   IHRTS=STARTING HOUR(WITH RESPECT TO 00/01/01:01) FOR SELECTION OF   CHI00440
C         CONCENTRATION RECORDS FROM THE CTDM OUTPUT FILE               CHI00450
C   IHRTF=ENDING HOUR(WITH RESPECT TO 00/01/01:01) FOR SELECTION OF     CHI00460
C         CONCENTRATION RECORDS FROM THE CTDM OUTPUT FILE               CHI00470
C   INCHI=UNIT NUMBER FOR THE CTDM CONCENTRATION OUTPUT FILE            CHI00480
C   INREC=UNIT NUMBER FOR THE CTDM INPUT RECEPTOR FILE CONTAINING RECEPTCHI00490
C         COORDINATES                                                   CHI00500
C   ISEL=SELECTION MODE FOR RECORDS FROM THE CTDM CONCENTRATION OUTPUT  CHI00510
C        FILE                                                           CHI00520
C       =1(ONLY THE FIRST RECORD FROM THE FILE IS SELECTED)             CHI00530
C       =2(ALL RECORDS FOR THE FILE ARE SELECTED)                       CHI00540
C       =3(ALL RECORDS SELECTED BETWEEN A USER SPECIFIED STARTING AND   CHI00550
C          ENDING TIME)                                                 CHI00560
C   ITIME=ARRAY CONTAINING THE YEAR,MONTH,DAY,HOUR, AND NUMBER OF THE   CHI00570
C         RECEPTOR WITH THE MAXIMUM CONCENTRATION                       CHI00580
C   IUSE(I)=FLAG INDICATING WHETHER RECEPTOR I BELONGS TO THE HILL IN   CHI00600
C           QUESTION                                                    CHI00610
C          =0(RECEPTOR NOT ON HILL)                                     CHI00620
C          =1(RECEPTOR IS ON THE HILL)                                  CHI00630
C   IZERO=INTEGER VALUE OF ZERO                                         CHI00640
C   LPTR=ARRAY REQUIRED BY THE POINTER SORT SUBROUTINE PSORTR           CHI00650
C   MONTH=TWO DIGIT INTEGER SPECIFYING THE MONTH(01-12)                 CHI00660
C   NPTR(I)=RECEPTOR I RANK IN ASCENDING ORDER OF CONCENTRATION         CHI00670
C   NR=NUMBER OF RECEPTORS IN THE CTDM INPUT RECEPTOR FILE BELONGING    CHI00680
C      TO HILL IDHILL                                                   CHI00690
C   NRMAX=MAXIMUM NUMBER OF RECEPTORS ALLOWED(CURRENTLY SET AT 1000)    CHI00700
C   NRT=TOTAL NUMBER OF RECEPTORS IN THE CTDM RECEPTOR FILE             CHI00710
C   OUTCHI=UNIT NUMBER OF THE FILE OF SORTED CONCENTRATIONS TO BE PLOTTECHI00720
C   READIT=SUBROUTINE USED TO READ THE RECORDS FROM THE CTDM OUTPUT FILECHI00730
C   RECFIL=NAME OF THE CTDM INPUT RECEPTOR FILE CONTAINING RECEPTOR     CHI00740
C          COORDINATES                                                  CHI00750
C   XMIN,XMAX,YMIN,YMAX=BOUNDARIES OF THE RECTANGLE ENCLOSING THE RECEPTCHI00760
C       POINTS ON HILL IDHILL                                           CHI00770
C   XREC(I)=X-COORDINATE FOR RECEPTOR I                                 CHI00780
C   YEAR=TWO DIGIT INTEGER SPECIFYING THE YEAR(00-99)                   CHI00790
C   YREC(I)=Y-COORDINATE FOR RECEPTOR I                                 CHI00800
C***                                                                    CHI00810
C***                                                                    CHI00820
      CHARACTER*30 CHIFL,RECFIL,CHISRT                                  CHI00830
      INTEGER OUTCHI,YEAR,DAY,HOUR                                      CHI00840
      DIMENSION XREC(1000),YREC(1000),NPTR(1000),LPTR(1000),IUSE(1000), CHI00850
     &ITIME(4),CONC(1000)                                               CHI00860
C***SET THE ELEMENTS OF THE IUSE ARRAY TO ZERO.                         CHI00870
      DATA IUSE/1000*0/                                                 CHI00880
C***SET THE MAXIMUM NUMBER OF ALLOWABLE RECEPTORS                       CHI00890
      NRMAX=1000                                                        CHI00900
C***SET END OF DATA FLAG FOR PLOT FILE INITIALLY TO ZERO.               CHI00910
      IEND=0                                                            CHI00920
C***SET ZERO INTEGER                                                    CHI00930
      IZERO=0                                                           CHI00940
C***SPECIFY FILE UNIT NUMBERS                                           CHI00950
      INCHI=14                                                          CHI00960
      OUTCHI=15                                                         CHI00970
      INREC=16                                                          CHI00980
C***                                                                    CHI00990
C***                                                                    CHI01000
C   SPECIFY INPUT FILE NAMES AND OPEN FILES.                            CHI01010
C***                                                                    CHI01020
C***                                                                    CHI01030
C***OPEN A FORMATTED CONCENTRATION FILE.                                CHI01180
      OPEN(INCHI,ERR=30,FILE='CONC',STATUS='OLD',FORM='FORMATTED',      CHI01190
     &ACCESS='SEQUENTIAL')                                              CHI01200
      GO TO 200                                                         CHI01210
   30 WRITE(*,40) CHIFL                                                 CHI01220
   40 FORMAT(//,1X,'***ERROR***FILE ',A30,' DOES NOT EXIST',/,          CHI01230
     &1X,'OR IS NOT IN ASCII FORMAT')                                   CHI01240
      GO TO 2000                                                        CHI01260
  200 CONTINUE                                                          CHI01300
C***INPUT THE HILL IDENTIFICATION NUMBER.                               CHI01310
  205 WRITE(*,210)                                                      CHI01320
  210 FORMAT(/,1X,'ENTER THE HILL IDENTIFICATION NUMBER(1-99) -> ')     CHI01330
      READ(*,*,ERR=205) IDHILL                                          CHI01340
      IF(IDHILL.LT.1.OR.IDHILL.GT.99) GO TO 205                         CHI01350
C***OPEN RECEPTOR FILE                                                  CHI01380
      OPEN(INREC,FILE='RECEPTOR',STATUS='OLD',ERR=230)                  CHI01440
      GO TO 240                                                         CHI01450
  230 WRITE(*,40) RECFIL                                                CHI01460
      GO TO 2000                                                        CHI01470
C***SET THE COUNTER OF TOTAL RECEPTORS TO ZERO.                         CHI01480
  240 NRT=0                                                             CHI01490
C***SET THE COUNTER OF SELECTED HILL RECEPTORS TO 0(THE FILE RECFIL MAY CHI01500
C***HAVE RECEPTORS FOR HILLS OTHER THAN THE HILL SELECTED).             CHI01510
      NR=0                                                              CHI01520
C***INITIALIZE VALUES FOR XMIN,XMAX,YMIN, AND YMAX. THESE PARAMETERS    CHI01530
C***WILL EVENTUALLY BE USED TO DETERMINE THE BOUNDARIES OF THE          CHI01540
C***CONCENTRATION PLOT.                                                 CHI01550
      XMIN=1.0E+15                                                      CHI01560
      XMAX=-1.0E+15                                                     CHI01570
      YMIN=1.0E+15                                                      CHI01580
      YMAX=-1.0E+15                                                     CHI01590
C***                                                                    CHI01600
C***                                                                    CHI01610
C   READ IN RECEPTOR INFORMATION.                                       CHI01620
C***                                                                    CHI01630
C***                                                                    CHI01640
  250 CONTINUE                                                          CHI01650
      NRT=NRT+1                                                         CHI01660
      IF(NRT.GT.NRMAX) GO TO 270                                        CHI01670
      READ(INREC,260,END=290) XREC(NRT),YREC(NRT),ID                    CHI01680
  260 FORMAT(20X,2F10.0,20X,I5)                                         CHI01690
C***DETERMINE WHETHER THE HILL IDENTIFICATION NUMBER FOR THE RECEPTOR   CHI01700
C***MATCHES THE HILL IDENTIFICATION NUMBER INPUT BY THE USER.           CHI01710
      IF(ID.NE.IDHILL) GO TO 250                                        CHI01720
      NR=NR+1                                                           CHI01730
      IUSE(NRT)=1                                                       CHI01740
C***UPDATE PLOT BOUNDARIES FOR THE RECEPTOR FIELD.                      CHI01750
      IF(XREC(NRT).LT.XMIN) XMIN=XREC(NRT)                              CHI01760
      IF(XREC(NRT).GT.XMAX) XMAX=XREC(NRT)                              CHI01770
      IF(YREC(NRT).LT.YMIN) YMIN=YREC(NRT)                              CHI01780
      IF(YREC(NRT).GT.YMAX) YMAX=YREC(NRT)                              CHI01790
      GO TO 250                                                         CHI01800
  270 WRITE(*,280) NRMAX                                                CHI01810
  280 FORMAT(/,1X,'***WARNING***ONLY THE FIRST',I5,1X,'RECEPTORS WILL BECHI01820
     & ANALYZED')                                                       CHI01830
  290 IF(NR.EQ.0) GO TO 1000                                            CHI01840
      NRT=NRT-1                                                         CHI01850
      WRITE(*,300) NR,NRT,IDHILL                                        CHI01860
  300 FORMAT(/,1X,I4,1X,'OUT OF',I4,1X,'RECEPTORS WERE FOUND TO BE ON HICHI01870
     &LL',I4)                                                           CHI01880
C***CLOSE THE RECEPTOR FILE.                                            CHI01890
      CLOSE(INREC)                                                      CHI01900
C***                                                                    CHI01910
C***                                                                    CHI01920
C***SPECIFY THE SELECTION MODE FOR CONCENTRATION RECORDS.               CHI01930
C***                                                                    CHI01940
C***                                                                    CHI01950
C***THREE MODES ARE AVAILABLE FOR THE SELECTION OF CONCENTRATION        CHI01960
C***RECORDS FOR PLOTTING.                                               CHI01970
C***MODE 1-ONLY THE FIRST RECORD IN THE CONCENTRATION FILE IS USED.     CHI01980
C***MODE 2-ALL CONCENTRATION FILE RECORDS ARE USED.                     CHI01990
C***MODE 3-ALL RECORDS USED BETWEEN STARTING AND ENDING TIMES SPECIFIED CHI02000
C***       BY THE USER.                                                 CHI02010
  330 WRITE(*,340)                                                      CHI02020
  340 FORMAT(//,18X,'SPECIFY CONCENTRATION RECORD SELECTION MODE',/,    CHI02030
     &22X,'1.) ONLY THE FIRST RECORD IS SELECTED',/,                    CHI02040
     &22X,'2.) ALL RECORDS SELECTED',/,                                 CHI02050
     &22X,'3.) ALL RECORDS SELECTED BETWEEN A START AND END TIME',/,    CHI02060
     &26X,'CHOICE?(1,2 OR 3) -> ')                                      CHI02070
      READ(*,*,ERR=330) ISEL                                            CHI02080
      IF(ISEL.LT.1.OR.ISEL.GT.3) GO TO 330                              CHI02090
      IF(ISEL.NE.3) GO TO 500                                           CHI02100
C***INPUT THE START TIME(YEAR,MONTH,DAY,HOUR) FOR SELECTION OF          CHI02110
C***CONCENTRATIONS.                                                     CHI02120
  400 WRITE(*,410)                                                      CHI02130
  410 FORMAT(/,22X,'INPUT START TIME(YEAR,MONTH,DAY,HOUR)',/,           CHI02140
     &22X,'EXACTLY AS SHOWN(YY/MM/DD:HH) -> ')                          CHI02150
      READ(*,420) YEAR,MONTH,DAY,HOUR                                   CHI02160
  420 FORMAT(3(I2,1X),I2)                                               CHI02170
      IF(YEAR.LT.0) GO TO 400                                           CHI02180
      IF(MONTH.LT.1.OR.MONTH.GT.12) GO TO 400                           CHI02190
      IF(DAY.LT.1.OR.DAY.GT.31) GO TO 400                               CHI02200
      IF(HOUR.LT.1.OR.HOUR.GT.24) GO TO 400                             CHI02210
C***CALCULATE THE STARTING HOUR WITH RESPECT TO 00/01/01:00             CHI02220
      CALL CHOUR(YEAR,MONTH,DAY,HOUR,IHRTS,IFLAG)                       CHI02230
      IF(IFLAG.EQ.0) GO TO 430                                          CHI02240
      WRITE(*,425)                                                      CHI02250
  425 FORMAT(/,1X,'DAY OF THE MONTH OUT OF RANGE--TRY AGAIN')           CHI02260
      GO TO 400                                                         CHI02270
C***INPUT THE END TIME(YEAR,MONTH,DAY,HOUR) FOR SELECTION OF            CHI02280
C***CONCENTRATIONS.                                                     CHI02290
  430 WRITE(*,440)                                                      CHI02300
  440 FORMAT(/,22X,'INPUT END TIME(YEAR,MONTH,DAY,HOUR)',/,             CHI02310
     &22X,'EXACTLY AS SHOWN(YY/MM/DD:HH) ->')                           CHI02320
      READ(*,420) YEAR,MONTH,DAY,HOUR                                   CHI02330
      IF(YEAR.LT.0) GO TO 430                                           CHI02340
      IF(MONTH.LT.1.OR.MONTH.GT.12) GO TO 430                           CHI02350
      IF(DAY.LT.1.OR.DAY.GT.31) GO TO 430                               CHI02360
      IF(HOUR.LT.1.OR.HOUR.GT.24) GO TO 430                             CHI02370
C***CALCULATE THE ENDING HOUR WITH RESPECT TO 00/01/01:00               CHI02380
      CALL CHOUR(YEAR,MONTH,DAY,HOUR,IHRTF,IFLAG)                       CHI02390
      IF(IFLAG.EQ.0) GO TO 455                                          CHI02400
      WRITE(*,450)                                                      CHI02410
  450 FORMAT(/,1X,'DAY OF THE MONTH OUT OF RANGE--TRY AGAIN')           CHI02420
      GO TO 430                                                         CHI02430
  455 IF(IHRTF.GE.IHRTS) GO TO 500                                      CHI02440
      WRITE(*,460)                                                      CHI02450
  460 FORMAT(/,1X,'STARTING TIME GREATER THAN ENDING TIME--TRY AGAIN')  CHI02460
      GO TO 400                                                         CHI02470
  500 CONTINUE                                                          CHI02480
C***                                                                    CHI02490
C***                                                                    CHI02500
C   READ AND SORT(BY RECEPTOR) 1-HOUR CONCENTRATIONS AND WRITE THEM     CHI02510
C   TO A FILE FOR PLOTTING.                                             CHI02520
C***                                                                    CHI02530
C***                                                                    CHI02540
C***OPEN THE PLOT FILE.                                                 CHI02610
      OPEN(OUTCHI,FILE='CHIOUT',STATUS='UNKNOWN')                       CHI02620
C***WRITE THE HILL NUMBER AND NUMBER OF RECEPTORS TO THE PLOT FILE.     CHI02630
      WRITE(OUTCHI,530) IDHILL,NR                                       CHI02640
  530 FORMAT(2I5)                                                       CHI02650
C***WRITE THE BOUNDARIES OF THE RECEPTOR FIELD TO THE PLOT FILE.        CHI02660
      WRITE(OUTCHI,540) XMIN,XMAX,YMIN,YMAX                             CHI02670
  540 FORMAT(4E15.4)                                                    CHI02680
C***READ A SET OF CONCENTRATIONS FROM THE CONCENTRATION FILE.           CHI02690
  550 CONTINUE                                                          CHI02700
      CALL READIT(ITIME,CONC,NRT,INCHI,IEF)                             CHI02710
C***DECODE THE ITIME ARRAY TO OBTAIN YEAR,MONTH,DAY,HOUR
      YEAR = ITIME(1)
      MONTH  = ITIME(2)
      DAY = ITIME(3)
      HOUR = ITIME(4)
      IF(IEF.EQ.1) GO TO 800                                            CHI02720
C***DETERMINE WHETHER ANY OF THE CONCENTRATIONS FOR THE HOUR ARE LESS   CHI02730
C***THAN ZERO. IF SO, THEN SKIP THE HOUR.                               CHI02740
      DO 555 I=1,NRT                                                    CHI02750
      IF(CONC(I).LT.0.) GO TO 550                                       CHI02760
  555 CONTINUE                                                          CHI02770
      IF(ISEL.NE.3) GO TO 600                                           CHI02800
C***CALCULATE THE HOUR WITH RESPECT TO 00/01/01:00                      CHI02810
      CALL CHOUR(YEAR,MONTH,DAY,HOUR,IHRT,IFLAG)                        CHI02820
      IF(IFLAG.EQ.0) GO TO 570                                          CHI02830
      WRITE(*,560) DAY,MONTH,YEAR                                       CHI02840
  560 FORMAT(/,1X,'DAY',I3,1X,'NOT CONSISTENT WITH MONTH',I3,1X,'IN YEARCHI02850
     &',I3,/,1X,'--HOUR NOT PROCESSED')                                 CHI02860
      GO TO 550                                                         CHI02870
  570 IF(IHRT.LT.IHRTS) GO TO 550                                       CHI02880
      IF(IHRT.GT.IHRTF) GO TO 800                                       CHI02890
C***CONCENTRATION RECORD ACCEPTED FOR PROCESSING.                       CHI02900
  600 CONTINUE                                                          CHI02910
C***WRITE THE DATE AND TIME TO THE PLOT FILE.                           CHI02920
      WRITE(OUTCHI,620) IEND,YEAR,MONTH,DAY,HOUR                        CHI02930
  620 FORMAT(5I5)                                                       CHI02940
C***SORT RECEPTORS BY CONCENTRATION.                                    CHI02950
      CALL PSORTR(CONC,NRT,NPTR,LPTR)                                   CHI02960
C***WRITE OUT THE SORTED CONCENTRATIONS WITH THE ASSOCIATED RECEPTOR    CHI02970
C***LOCATIONS.                                                          CHI02980
      DO 700 I=NRT,1,-1                                                 CHI02990
C***SKIP OVER RECEPTORS FROM UNWANTED HILLS.                            CHI03000
      IF(IUSE(NPTR(I)).EQ.0) GO TO 700                                  CHI03010
      WRITE(OUTCHI,630) NPTR(I),XREC(NPTR(I)),YREC(NPTR(I)),CONC(NPTR(I)CHI03020
     &)                                                                 CHI03030
  630 FORMAT(I5,3E15.4)                                                 CHI03040
  700 CONTINUE                                                          CHI03050
      IF(ISEL.EQ.1) GO TO 800                                           CHI03060
      GO TO 550                                                         CHI03070
  800 IEND=1                                                            CHI03080
C***WRITE THE END OF DATA FLAG TO THE PLOT FILE.                        CHI03090
      WRITE(OUTCHI,620) IEND,IZERO,IZERO,IZERO,IZERO                    CHI03100
      GO TO 2000                                                        CHI03110
 1000 WRITE(*,1010)                                                     CHI03120
 1010 FORMAT(/,1X,'***ERROR***NO RECEPTORS FOUND FOR THE HILL')         CHI03130
 2000 CONTINUE                                                          CHI03140
      STOP                                                              CHI03150
      END                                                               CHI03160

