C***********************************************************************R6200010
C                                                                       R6200020
C       READ62 - PREPROCESSOR FOR UPPER AIR DATA                        R6200030
C                                                                       R6200040
C       THIS PROGRAM READS A TD-6201 UPPER AIR FILE, EXTRACTS DATA      R6200050
C       FOR PRESSURE LEVELS REQUESTED, AND CREATES A FORMATTED FILE     R6200060
C       FOR EDITING AND INPUT TO THE HPDM MET PREPROCESSOR              R6200070
C                                                                       R6200080
C       NOTE: FORMAT ASSUMED IS FIXED BLOCK RECORDS OF 2876 BYTES       R6200090
C             EACH (79 LEVELS PER RECORD)                               R6200100
C                                                                       R6200110
C I/O:                                                                  R6200120
C     UNIT 0 - CONSOLE OUTPUT (WRITES CURRENT SOUNDING BEING READ)      R6200130
C     UNIT 5 - CARD-IMAGE INPUT DATA:  'OPT62'                          R6200140
C     UNIT 6 - PRINTER OUTPUT: 'OUTPUT'                                 R6200150
C     UNIT 8 - INPUT TD-6201 (UPPER AIR) DATA FILE:  'TD6201'           R6200160
C     UNIT 9 - OUTPUT FORMATTED UPPER AIR DATA FILE: 'RAWIN'            R6200170
C                                                                       R6200180
C                                                                       R6200190
C DETAILS OF CARD-IMAGE INPUT DATA (FREE FORMAT):                       R6200200
C                                                                       R6200210
C                                                                       R6200220
C      FIRST LINE:                                                      R6200230
C                                                                       R6200240
C      IBYR, IBDAY, IBHR:  YEAR, JULIAN DAY, AND HOUR (GMT) TO BEGIN    R6200250
C                             EXTRACTING DATA FROM INPUT TD-6201 FILE   R6200260
C      IEYR, IEDAY, IEHR:  YEAR, JULIAN DAY, AND HOUR (GMT) AFTER WHICH R6200270
C                             TO STOP EXTRACTING DATA FROM INPUT TD-6201R6200280
C                             FILE                                      R6200290
C      PSTOP:              LOWEST PRESSURE FOR WHICH INFORMATION IS TO  R6200300
C                             BE EXTRACTED                              R6200310
C      SECOND LINE:                                                     R6200320
C                                                                       R6200330
C      LHT,LTEMP,LWD,LWS: CORRESPONDS TO HEIGHT, TEMPERATURE, WIND      R6200340
C                         DIRECTION AND WIND SPEED DATA: IF THE VALUE   R6200350
C                         IS MISSING, DISCARD THE DATA LEVEL IF THE     R6200360
C                         SWITCH IS 1, DO NOT DISCARD IF THE SWITCH IS 0R6200370
C                                                                       R6200380
C DETAILS OF TD-6201 CONTENT:                                           R6200390
C                                                                       R6200400
C       HEADER INFORMATION FOR EACH SOUNDING TIME:                      R6200410
C                                                                       R6200420
C      STNID          STATION IDENTIFICATION                            R6200430
C      LAT            LATITUDE -- THE STATION LATITUDE IN DEG AND MIN,  R6200440
C                       FOLLOWED BY 'N' OR 'S'                          R6200450
C      LON            LONGITUDE-- THE STATION LONGITUDE IN DEG AND MIN, R6200460
C                       FOLLOWED BY 'E' OR 'W'                          R6200470
C      YEAR, MONTH, DAY, HOUR  -- THE SCHEDULED TIME OF THE OBSERVATION R6200480
C      NUMLEV         NUMBER OF REPEATING GROUPS -- THIS REPRESENTS     R6200490
C                       THE NUMBER OF DATA LEVELS FOUND IN THE CURRENT  R6200500
C                       OBSERVATION (79 IS THE MAXIMUM NUMBER STORED)   R6200510
C                                                                       R6200520
C       DATA FOR EACH NUMLEV PRESSURE LEVEL:                            R6200530
C                                                                       R6200540
C      QIND           LEVEL-QUALITY-INDICATOR -- DENOTES THE RESULTS OF R6200550
C                       ANY QUALITY CONTROLS APPLIED TO THIS LEVEL (THISR6200560
C                       IS USED IN THIS PROGRAM)                        R6200570
C      ETIME          THE ELAPSED TIME SINCE THE RELEASE OF THE SOUNDINGR6200580
C                       IN MINUTES AND TENTHS (IGNORED HERE)            R6200590
C      PRES           ATMOSPHERIC PRESSURE AT THE CURRENT LEVEL (READ INR6200600
C                       AS MILLIBARS)                                   R6200610
C      HGT            GEOPOTENTIAL HEIGHT OF THE CURRENT LEVEL IN METERSR6200620
C      TEMP           THE FREE AIR TEMPERATURE AT THE CURRENT LEVEL IN  R6200630
C                       DEGREES AND TENTHS CELSIUS.                     R6200640
C      RH             THE RELATIVE HUMIDITY AT THE CURRENT LEVEL IN %   R6200650
C      WD             DIRECTION OF THE WIND AT THE CURRENT LEVEL IN DEG R6200660
C      WS             SPEED OF THE WIND IN WHOLE METERS PER SECOND.     R6200670
C      TIMEF,PRESF,HGTF,TEMPF,RHF,WINDF  --  QUALITY CONTROL FLAGS      R6200680
C                       (USED HERE)                                     R6200690
C      TYPLEV         TYPE OF LEVEL FLAG (IGNORED HERE)                 R6200700
C                                                                       R6200710
C                                                                       R6200720
C      EXTERNAL FUNCTION: GOOD (INTEGER)                                R6200730
C                                                                       R6200740
C***********************************************************************R6200750
C                                                                       R6200760
      REAL HEIGHT(79),HIGHT(79),ETIME                                   R6200770
      REAL APRES(79),ATEMP(79),PRES(79),TEMP(79)                        R6200780
      INTEGER MON(12),LMON(12),YEAR,MONTH,DAY,HOUR,GOOD                 R6200790
      INTEGER WS(79),AWS(79),WD(79),AWD(79),RH                          R6200800
      INTEGER LHT,LTEMP,LWD,LWS                                         R6200810
      CHARACTER*1 LATA,LONA,QIND(79),TIMEF(79),PRESF(79),               R6200820
     1  HGTF(79),TEMPF(79),RHF,WINDF(79),TYPLEV                         R6200830
      CHARACTER*5 STNID                                                 R6200840
      CHARACTER*32 JUNK                                                 R6200850
C                                                                       R6200860
      DATA MON/0,31,59,90,120,151,181,212,243,273,304,334/              R6200870
      DATA LMON/0,31,60,91,121,152,182,213,244,274,305,335/             R6200880
C                                                                       R6200890
C-----OPEN FILES                                                        R6200900
C                                                                       R6200910
      IN = 5                                                            R6200920
      IOUT = 6                                                          R6200930
      ITD = 8                                                           R6200940
      IRAWIN = 9                                                        R6200950
      OPEN(IN,FILE='OPT62',STATUS='OLD')                                R6200960
      OPEN(IOUT,FILE='R62OUT',STATUS='UNKNOWN')                         R6200970
      OPEN(ITD,FILE='TD6201',STATUS='OLD',FORM='FORMATTED')             R6200980
      OPEN(IRAWIN,FILE='RAWIN',STATUS='UNKNOWN')                        R6200990
C                                                                       R6201000
      WRITE(IOUT,6010)                                                  R6201010
C                                                                       R6201020
C-----READ CARD-IMAGE INPUTS FROM UNIT 5 (FREE FORMAT)                  R6201030
C                                                                       R6201040
      READ(IN,*)IBYR,IBDAY,IBHR,IEYR,IEDAY,IEHR,PSTOP                   R6201050
      WRITE(IOUT,6020)IBYR,IEYR,IBDAY,IEDAY,IBHR,IEHR                   R6201060
      WRITE(IOUT,6030)PSTOP                                             R6201070
C                                                                       R6201080
      READ(IN,*)LHT,LTEMP,LWD,LWS                                       R6201090
      WRITE(IOUT,6040)LHT,LTEMP,LWD,LWS                                 R6201100
C                                                                       R6201110
      WRITE(IOUT,6050)                                                  R6201120
C                                                                       R6201130
C       INITIALIZE PREVIOUS GOOD SOUNDING TIME                          R6201140
C                                                                       R6201150
      IF(IBHR.EQ.0)GO TO 100                                            R6201160
C-----STARTING HOUR = 12                                                R6201170
      JDAY2=IBDAY                                                       R6201180
      ISAV2=0                                                           R6201190
      GO TO 200                                                         R6201200
100   CONTINUE                                                          R6201210
C-----STARTING HOUR = 00                                                R6201220
      JDAY2=IBDAY-1                                                     R6201230
      ISAV2=12                                                          R6201240
200   CONTINUE                                                          R6201250
C                                                                       R6201260
1000  CONTINUE                                                          R6201270
C                                                                       R6201280
C-----READ TD-6201 SOUNDING FROM UNIT ITD                               R6201290
C                                                                       R6201300
        READ(ITD,6100,END=2000) STNID,LAT,LATA,LON,LONA,YEAR,MONTH,     R6201310
     1  DAY,HOUR,NUMLEV,(QIND(I),ETIME,PRES(I),HEIGHT(I),               R6201320
     2  TEMP(I),RH,WD(I),WS(I),TIMEF(I),PRESF(I),HGTF(I),TEMPF(I),      R6201330
     3  RHF,WINDF(I),TYPLEV,I=1,79)                                     R6201340
        WRITE(0,6220) MONTH, DAY, HOUR                                  R6201350
        ALAT = LAT/100 + (LAT-(LAT/100*100))/60.                        R6201360
        ALON = LON/100 + (LON-(LON/100*100))/60.                        R6201370
C                                                                       R6201380
C     IF CONTINUATION OF LAST SOUNDING, IGNORE AND READ NEXT SOUNDING   R6201390
C                                                                       R6201400
1050  IF(NUMLEV.LE.79) GO TO 1100                                       R6201410
      READ(ITD,6150,END=2000) JUNK                                      R6201420
      NUMLEV = MAX(NUMLEV-79,79)                                        R6201430
      GO TO 1050                                                        R6201440
1100  CONTINUE                                                          R6201450
C                                                                       R6201460
C*******ROUTINE TO CONVERT DATES TO JULIAN                              R6201470
C                                                                       R6201480
        JDAY=MON(MONTH)+DAY                                             R6201490
        IF(MOD(YEAR,4).EQ.0)JDAY=LMON(MONTH)+DAY                        R6201500
C                                                                       R6201510
      IF(HOUR.NE.0 .AND. HOUR.NE.12) GO TO 1000                         R6201520
C                                                                       R6201530
C       CHECK FOR BEGINNING AND ENDING TIMES                            R6201540
C                                                                       R6201550
      IF(YEAR.LT.IBYR) GO TO 1000                                       R6201560
      IF(YEAR.GT.IEYR) GO TO 5000                                       R6201570
      IF(YEAR.EQ.IBYR.AND.JDAY.LT.IBDAY) GO TO 1000                     R6201580
      IF(YEAR.EQ.IEYR.AND.JDAY.GT.IEDAY) GO TO 5000                     R6201590
      IF(YEAR.EQ.IBYR.AND.JDAY.EQ.IBDAY.AND.HOUR.LT.IBHR) GO TO 1000    R6201600
      IF(YEAR.EQ.IEYR.AND.JDAY.EQ.IEDAY.AND.HOUR.GT.IEHR) GO TO 5000    R6201610
C                                                                       R6201620
C       COMPRESS ARRAYS IF MISSING VALUES ARE FOUND                     R6201630
C                                                                       R6201640
      KK=0                                                              R6201650
      DO 1200 JJ=1,NUMLEV                                               R6201660
      IF(GOOD(QIND(JJ)).EQ.0) GO TO 1200                                R6201670
      IF(LHT.EQ.1 .AND. (HEIGHT(JJ).GE.9999.9 .OR. GOOD(HGTF).EQ.0))    R6201680
     1   GO TO 1200                                                     R6201690
      IF(LTEMP.EQ.1 .AND. (ABS(TEMP(JJ)).GE.99.9 .OR. GOOD(TEMPF).EQ.0))R6201700
     1   GO TO 1200                                                     R6201710
      IF(LWD.EQ.1 .AND. (WD(JJ).GE.999 .OR. GOOD(WINDF).EQ.0))GO TO 1200R6201720
      IF(LWS.EQ.1 .AND. (WS(JJ).GE.999 .OR. GOOD(WINDF).EQ.0))GO TO 1200R6201730
      KK=KK+1                                                           R6201740
      APRES(KK)=PRES(JJ)                                                R6201750
      ATEMP(KK)=TEMP(JJ)                                                R6201760
      AWS(KK)=WS(JJ)                                                    R6201770
      AWD(KK)=WD(JJ)                                                    R6201780
      HIGHT(KK)=HEIGHT(JJ)                                              R6201790
1200  CONTINUE                                                          R6201800
      NLEV=KK                                                           R6201810
      DO 1300 LL=1,NLEV                                                 R6201820
      PRES(LL)=APRES(LL)                                                R6201830
      TEMP(LL)=ATEMP(LL)                                                R6201840
      WD(LL)=AWD(LL)                                                    R6201850
      WS(LL)=AWS(LL)                                                    R6201860
      HEIGHT(LL)=HIGHT(LL)                                              R6201870
1300  CONTINUE                                                          R6201880
C                                                                       R6201890
C-----DETERMINE LEVELS UP TO PSTOP                                      R6201900
C                                                                       R6201910
      KSTOP = 0                                                         R6201920
      DO 1500 I = 1,NLEV                                                R6201930
      IF(PRES(I).LE.PSTOP) THEN                                         R6201940
          ISTOP = I - 1                                                 R6201950
          GO TO 1600                                                    R6201960
      ENDIF                                                             R6201970
1500  CONTINUE                                                          R6201980
      ISTOP = NLEV                                                      R6201990
      IF(ABS(PRES(NLEV)-PSTOP).GT.1.0) KSTOP = 1                        R6202000
1600  CONTINUE                                                          R6202010
C                                                                       R6202020
C-----WRITE TO LINE PRINTER AND UPPER AIR OUTPUT FILE                   R6202030
C                                                                       R6202040
      IF(KSTOP.EQ.0) THEN                                               R6202050
          WRITE(IOUT,6060)YEAR,MONTH,DAY,JDAY,HOUR,ISTOP                R6202060
          WRITE(IRAWIN,6200) STNID,YEAR,MONTH,DAY,HOUR,NLEV,ISTOP       R6202070
        ELSE                                                            R6202080
          WRITE(IOUT,6065)YEAR,MONTH,DAY,JDAY,HOUR,ISTOP,PSTOP          R6202090
          WRITE(IRAWIN,6205) STNID,YEAR,MONTH,DAY,HOUR,NLEV,ISTOP,PSTOP R6202100
      ENDIF                                                             R6202110
      WRITE(IRAWIN,6210) (PRES(I),HEIGHT(I),TEMP(I)+273.2,WD(I),WS(I),  R6202120
     1 I=1,ISTOP)                                                       R6202130
C                                                                       R6202140
C-----CHECK FOR MISSING DAYS                                            R6202150
C                                                                       R6202160
      IF(JDAY.EQ.JDAY2) GO TO 1700                                      R6202170
      JDAY1=JDAY2                                                       R6202180
      JDAY2=JDAY                                                        R6202190
      IF(JDAY1.EQ.(JDAY2-1)) GO TO 1700                                 R6202200
      WRITE(IOUT,6070)                                                  R6202210
      WRITE(IRAWIN,6070)                                                R6202220
1700  CONTINUE                                                          R6202230
C                                                                       R6202240
C-----CHECK FOR MISSING/DUPLICATE SOUNDINGS                             R6202250
C                                                                       R6202260
      ISAV1=ISAV2                                                       R6202270
      ISAV2=HOUR                                                        R6202280
      IF(ISAV1.EQ.0) GO TO 1800                                         R6202290
      IF(ISAV1.EQ.12.AND.ISAV2.EQ.0) GO TO 1900                         R6202300
      WRITE(IOUT,6080)                                                  R6202310
      WRITE(IRAWIN,6080)                                                R6202320
      GO TO 1900                                                        R6202330
1800  CONTINUE                                                          R6202340
      IF(ISAV2.EQ.12)GO TO 1900                                         R6202350
      WRITE(IOUT,6080)                                                  R6202360
      WRITE(IRAWIN,6080)                                                R6202370
1900  CONTINUE                                                          R6202380
C                                                                       R6202390
      GO TO 1000                                                        R6202400
2000  WRITE(IOUT,6090)YEAR,JDAY                                         R6202410
C                                                                       R6202420
5000  CONTINUE                                                          R6202430
      STOP                                                              R6202440
C                                                                       R6202450
C       FORMAT STATEMENTS                                               R6202460
C                                                                       R6202470
6010  FORMAT('1',20X,'READ62',3X,'VERSION 2.0      LEVEL 870731',//)    R6202480
6020  FORMAT('0','STARTING DATE:',16X,'ENDING DATE:'/'0',15X,'YEAR = ', R6202490
     1 I4,18X,'YEAR = ',I4/10X,'JULIAN DAY = ',I3,12X,'JULIAN DAY = ',  R6202500
     2 I3/16X,'HOUR = ',I3,18X,'HOUR = ',I3)                            R6202510
6030  FORMAT(/'0','PRESSURE LEVELS EXTRACTED:'/'0',20X,'SURFACE',       R6202520
     1 ' TO  ',F5.0,' MB')                                              R6202530
6040  FORMAT(/,'0','SWITCHES FOR DISCARDING PRESSURE LEVELS: 0=NO, ',   R6202540
     1 '1=YES',/,'0','DATA LEVEL ELIMINATED IF HEIGHT MISSING ? ',8X,I1,R6202550
     1 /,'0','DATA LEVEL ELIMINATED IF TEMPERATURE MISSING ? ',3X,I1,/, R6202560
     2 '0','DATA LEVEL ELIMINATED IF WIND DIRECTION MISSING ? ',I1,/,   R6202570
     3 '0','DATA LEVEL ELIMINATED IF WIND SPEED MISSING ? ',4X,I1,/)    R6202580
6050  FORMAT(/'0','THE FOLLOWING SOUNDINGS HAVE BEEN PROCESSED:'/       R6202590
     1 '0',6X,'YEAR',3X,'MONTH',3X,'DAY',3X,'JULIAN DAY',3X,            R6202600
     2 'HOUR (GMT)',3X,'NO. LEVELS EXTRACTED'/)                         R6202610
6060  FORMAT(8X,I2,5X,I2,6X,I2,7X,I3,9X,I2,15X,I4)                      R6202620
6065  FORMAT(8X,I2,5X,I2,6X,I2,7X,I3,9X,I2,15X,I4,/,10X,'  TOP OF ',    R6202630
     1 'SOUNDING LISTED ABOVE IS BELOW THE ',F6.1,'-MB LEVEL ')         R6202640
6070  FORMAT(1X,'->->->MISSING DAY(S)')                                 R6202650
6080  FORMAT(1X,'->->->MISSING/DUPLICATE SOUNDING')                     R6202660
6090  FORMAT(20X,'EOF ON INPUT',/,20X,'LAST DAY READ =  ',I2,I3)        R6202670
6100  FORMAT(3X,A5,I4,A1,I5,A1,2X,4(I2),I3,                             R6202680
     1      (79(A1,F4.1,F5.1,F6.0,F4.1,3(I3),7A1)))                     R6202690
6150  FORMAT(A32,79(36X))                                               R6202700
6200  FORMAT(3X,'6201',5X,A5,5X,4I2,5X,I2,T69,I2)                       R6202710
6205  FORMAT(3X,'6201',5X,A5,5X,4I2,5X,I2,T69,I2,/,'TOP OF SOUNDING ',  R6202720
     1 'BELOW ',F6.1,'-MB LEVEL ')                                      R6202730
6210  FORMAT(4(3X,F6.1,'/',F5.0,'/',F5.1,'/',I3,'/',I3))                R6202740
6220  FORMAT(' MONTH = ',I2,',   DAY = ',I2,',   HOUR = ',I2)           R6202750
                                                                        R6202760
      END                                                               R6202770
