
C.........................................................................
C Version "@(#)$Header$"
C EDSS/Models-3 I/O API.
C Copyright (C) 1992-2002 MCNC and Carlie J. Coats, Jr., and
C (C) 2003-2004 Baron Advanced Meteorological Systems
C Distributed under the GNU LESSER GENERAL PUBLIC LICENSE version 2.1
C See file "LGPL.txt" for conditions of use.
C.........................................................................

      LOGICAL FUNCTION READ3(FNAME, VNAME, LAYER, JDATE, JTIME, BUFFER)

C***********************************************************************
C  function body starts at line  136
C
C  FUNCTION:
C       reads data from Models-3 data file with logical name FNAME for
C       variable with name VNAME and layer LAYER, for the date and time
C       JDATE (coded YYYYDDD) and time JTIME (HHMMSS).
C
C       For time-independent files, JDATE:JTIME are ignored.
C
C       If VNAME is 'ALL', reads all variables; if LAYER is -1,
C       reads all layers.
C
C       If FNAME is a dictionary file, READ3() treats VNAME as a
C       dictionary index, and returns  RDDICT3( FNAME, VNAME ).
C
C  RETURN VALUE
C       TRUE iff the operation succeeds (and the data is available)
C
C  PRECONDITIONS REQUIRED:
C       FNAME is a Models-3 data file already opened by OPEN3()
C
C  REVISION  HISTORY:  
C       prototype 3/1992 by CJC
C
C       Modified  7/1994 by CJC to handle restart files (tstep < 0)
C
C       Modified  8/1994 by CJC to handle BUFFERED "files", and pass
C       VID argument to new RD*() routines (instead of VNAME)
C
C       Modified 10/1994 by CJC to handle new files with write granularity
C       at the level of individual variables.
C
C       Modified  2/1995 by CJC to handle files of type SMATRX3
C
C       Modified  2/1995 by CJC to handle files of type TSRIES3
C
C       Modified  5/1998 by CJC for OpenMP thread-safety
C
C       Modified  5/1999 by ALT for coupling-mode operation
C
C       Modified  1/2002 by CJC:  check TRIMLEN() of FNAME
C
C       Modified  3/2002 by CJC:  STATE3V changes; uses RDTFLAG().
C
C       Modified 7/2003 by CJC:  bugfix -- clean up critical sections
C       associated with INIT3()
C
C       Modified 10/2003 by CJC for I/O API version 3:  support for
C       native-binary BINFIL3 file type; uses INTEGER NAME2FID
C
C       Modified 9/2004 by CJC for virtual INTERP bug-fix: change to
C       READ3V interface
C
C       Modified 11/2004 by CJC:  remove "timestep-not-available"
C       message (now redundant:  generated by RDTFLAG())
C
C       Modified 11/2004 by CJC:  new "verbose-flag" argument to RDTFLAG
C***********************************************************************

      IMPLICIT NONE

C...........   INCLUDES:

        INCLUDE 'PARMS3.EXT'
        INCLUDE 'STATE3.EXT'
        INCLUDE 'NETCDF.EXT'
#ifdef IOAPICPL
        INCLUDE 'STATE3V.EXT'
#endif


C...........   ARGUMENTS and their descriptions:

        CHARACTER*(*)   FNAME           !  logical file name
        CHARACTER*(*)   VNAME           !  variable name, or 'ALL'
        INTEGER         LAYER           !  layer number, or 0
        INTEGER         JDATE           !  date, formatted YYYYDDD
        INTEGER         JTIME           !  time, formatted HHMMSS
        REAL            BUFFER(*)       !  input buffer array


C...........   EXTERNAL FUNCTIONS and their descriptions:

        INTEGER         INIT3      !  initialize I/O API
        INTEGER         INDEX1     !  look up names in name tables
        INTEGER         NAME2FID   !  fname~~> fid lookup
        LOGICAL         RDDICT3    !  read records for    DCTNRY3  files
        LOGICAL         RDBUF3     !  read time steps for BUFFERED files
        LOGICAL         RDCUSTOM   !  read time steps for CUSTOM3  files
        LOGICAL         RDGRDDED   !  read time steps for GRDDED3  files
        LOGICAL         RDBNDARY   !  read time steps for BNDARY3  files
        LOGICAL         RDIDDATA   !  read time steps for IDDATA3  files
        LOGICAL         RDPROFIL   !  read time steps for PROFIL3  files
        LOGICAL         RDGRNEST   !  read time steps for GRNEST3  files
        LOGICAL         RDSMATRX   !  read time steps for SMATRX33  files
        LOGICAL         RDTFLAG    !  check time step record availability
        INTEGER         TRIMLEN    !  trimmed string length

        EXTERNAL        INIT3, INDEX1, NAME2FID, RDDICT3, RDBUF3,
     &                  RDGRDDED, RDBNDARY, RDIDDATA, RDGRNEST,
     &                  RDSMATRX, RDTFLAG, TRIMLEN
        EXTERNAL        INITBLK3   !  block data: initialize I/O state


C...........   SCRATCH LOCAL VARIABLES and their descriptions:

        INTEGER         FID             !  subscript  for STATE3 arrays
        INTEGER         VID, VAR        !  subscripts for STATE3 arrays
        INTEGER         FLEN, VLEN      !  name lengths for file, vble
        INTEGER         V               !  loop counters
        INTEGER         STEP            !  record number
        CHARACTER*256   MESG
        LOGICAL         EFLAG

#ifdef IOAPICPL
        INTEGER       COUNT, SKIP, TYPE
        INTEGER       F1, F2
        LOGICAL       VFLAG
        LOGICAL       READ3V
        EXTERNAL      READ3V
#endif

C***********************************************************************
C   begin body of function  READ3
C......,....   Check that Models-3 I/O has been initialized; get STATE3
C......,....   subscript for FNAME; check length of vname argument

        FLEN  = TRIMLEN( FNAME )
        VLEN  = TRIMLEN( VNAME )
        FID   = NAME2FID( FNAME )

        EFLAG = ( FID .LE. 0 )

        IF ( VLEN .GT. NAMLEN3 ) THEN
            EFLAG = .TRUE.
            WRITE( MESG, '( A, I10 )'  )
     &          'Max vble name length 16; actual:', VLEN
            CALL M3MSG2( MESG )
        END IF          !  if len( vname ) > 16
        
        IF ( EFLAG ) THEN
            MESG  = 'File "'// FNAME// '" Variable "'// VNAME//'"'
            CALL M3MSG2( MESG )
            MESG = 'Invalid variable or file name arguments'
            CALL M3WARN( 'READ3', JDATE, JTIME, MESG )
	    READ3 = .FALSE.
            RETURN
        END IF          !  if len( fname ) > 16, or if len( vname ) > 16

C.......   Check availability of requested  layer, variable:

        IF ( FTYPE3( FID ) .EQ. DCTNRY3 ) THEN

            READ3 = RDDICT3( FID, VNAME )
            RETURN
        
        ELSE IF ( VNAME .EQ. ALLVAR3 ) THEN
            
            VID = ALLAYS3
        
        ELSE 
            
            VID = INDEX1 ( VNAME, NVARS3( FID ), VLIST3( 1,FID ) )
            
            IF ( VID .EQ. 0 ) THEN
                 MESG = 'File ' // FNAME( 1:FLEN ) //' contains vbles'
                 CALL M3MSG2( MESG )
                 DO  VAR=1,NVARS3( FID ), 3
                    WRITE( MESG,91040 )
     &              (VLIST3( V,FID ),V=VAR,MIN( VAR+2, NVARS3( FID ) ) )
                    CALL M3MSG2( MESG )
                 END DO
                 MESG = 'Requested variable "' //  VNAME( 1: VLEN ) // 
     &                  '" not available'
                CALL M3WARN( 'READ3', JDATE, JTIME, MESG )
                READ3 = .FALSE.
                RETURN
            END IF

        END IF          !  end check on VNAME

        IF ( ( LAYER .NE. ALLAYS3 ) 
     &      .AND. ( LAYER .LT. 1  .OR.  
     &              LAYER .GT. NLAYS3( FID ) ) ) THEN

            WRITE( MESG,91010 ) 'Requested layer:', LAYER
            CALL M3MSG2( MESG )
	    WRITE( MESG,91010 )
     &          'Layers in the file:  1 ...', NLAYS3( FID )
            CALL M3MSG2( MESG )
            MESG = 'LAYER not available in file ' // FNAME
            CALL M3WARN( 'READ3', JDATE, JTIME, MESG )
            READ3 = .FALSE.
            RETURN

        END IF          !  end check on layer-number

                
C.......   If buffered file, use RDBUF3():

        IF ( CDFID3( FID ) .EQ. BUFFIL3 ) THEN     !  BUFFERED "file"

            READ3 = RDBUF3( FID, VID, LAYER, JDATE, JTIME, BUFFER )
            RETURN
        
#ifdef IOAPICPL

C.......   If virtual file, use READ3V():

        ELSE IF ( CDFID3( FID ) .EQ. VIRFIL3 ) THEN     !  virtual "file"
           
            IF ( TSTEP3( FID ) .NE. 0 ) THEN
                F1    = JDATE
                F2    = JTIME
            ELSE
                F1    = 0
                F2    = 0
            END IF

            IF ( LAYER .EQ. ALLAYS3 ) THEN
               COUNT = BSIZE3(FID)*NLAYS3(FID)
               SKIP = 0
            ELSE
               COUNT = BSIZE3(FID)
               SKIP = (LAYER - 1) * BSIZE3(FID)
            ENDIF

            IF ( VID .EQ. ALLAYS3 ) THEN
                EFLAG = .TRUE.
                DO VID = 1, NVARS3(FID)
                    VFLAG = READ3V( FID, VID, SKIP, COUNT, F1, F2,
     &                       BUFFER(1+(VID-1)*BSIZE3(FID)*NLAYS3(FID)) )
                    EFLAG = ( EFLAG .AND. VFLAG )
                END DO
                READ3 = EFLAG
            ELSE
                TYPE  = VTYPE3(VID,FID)
                READ3 = READ3V( FID, VID, SKIP, COUNT, F1, F2, BUFFER )
            END IF

            RETURN
        
#endif

        END IF                  !  if buffered, or virtual, or volatile


C...........   Compute record number, and check availability:
C...........   Note:  rdtflag() calls NCSNC()

        IF ( .NOT. RDTFLAG( FID,VID, JDATE,JTIME, STEP, .TRUE. ) ) THEN

            !! warning now generated by RDTFLAG():
            !! MESG = 'Time step not available for file:  ' // FNAME
            !! CALL M3WARN( 'READ3', JDATE, JTIME, MESG )
            READ3 = .FALSE.
            RETURN

        END IF


C...........   Read data from file into BUFFER()

        IF ( FTYPE3( FID ) .EQ. CUSTOM3 ) THEN

            READ3 = RDCUSTOM( FID, VID, LAYER, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. GRDDED3 ) THEN

            READ3 = RDGRDDED( FID, VID, LAYER, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. BNDARY3 ) THEN

            READ3 = RDBNDARY( FID, VID, LAYER, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. IDDATA3 ) THEN

            READ3 = RDIDDATA( FID, VID, LAYER, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. PROFIL3 ) THEN

            READ3 = RDPROFIL( FID, VID, LAYER, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. GRNEST3 ) THEN

            READ3 = RDGRNEST( FID, VID, LAYER, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. SMATRX3 ) THEN

            READ3 = RDSMATRX( FID, VID, STEP, BUFFER )

        ELSE IF ( FTYPE3( FID ) .EQ. TSRIES3 ) THEN
 
            READ3 = RDGRDDED( FID, VID, LAYER, STEP, BUFFER )
 
        ELSE IF ( FTYPE3( FID ) .EQ. PTRFLY3 ) THEN

            READ3 = RDGRDDED( FID, VID, LAYER, STEP, BUFFER )

        ELSE    !  illegal file type

            WRITE( MESG, "( 3A, I5 )" )
     &      'File:  ', FNAME( 1:FLEN ),
     &      ' of unknown type:', FTYPE3( FID )
            CALL M3WARN( 'READ3', JDATE, JTIME, MESG )
            READ3 = .FALSE.

        END IF          !  if file type dictionary, custom, gridded, ...


        RETURN

C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx

91000   FORMAT ( 5A )

91010   FORMAT ( 3 ( A , :, I5, :, 2X ) )

91020   FORMAT ( A , I9, ':' , I6.6, :, A )

91030   FORMAT ( A , I6.6 )

91040   FORMAT ( 3 ( '"', A16, '"', :, 4X ) )

        END

