
        PROGRAM  M3MERGE

C***********************************************************************
C Version "@(#)$Header$"
C EDSS/Models-3 M3TOOLS.
C Copyright (C) 1992-2002 MCNC and Carlie J. Coats, Jr., and
C (C) 2002-2005 Baron Advanced Meteorological Systems. LLC.
C Distributed under the GNU GENERAL PUBLIC LICENSE version 2
C See file "GPL.txt" for conditions of use.
C.........................................................................
C  program body starts at line  132
C
C  FUNCTION:
C       Merges selected variables from a set of input files for a 
C       specified time period, and writes them to the output file,
C       with optional renaming in the process.
C
C  PRECONDITIONS REQUIRED:
C       Merges selected layers of selected variables from a set of 
C       gridded, boundary, or custom  files over a common time period,
C	with optional renaming.
C       Horizontal and vertical grid structures must tbe the same for
C	all files.
C	Files have a common time period including the duration of the
C	merge.
C       setenv <logical names>  <path-names>
C
C  SUBROUTINES AND FUNCTIONS CALLED:
C       Models-3 I/O API.
C
C  REVISION  HISTORY:
C      Prototype  6/2001 by CJC
C       Version  11/2001 by CJC for I/O API Version 2.1
C       Version  11/2005 by CJC:  eliminate unused vbles
C       Version   9/2008 by CJC:  fix VDESC as CHAR*80 instead of CHAR*16
C***********************************************************************

      IMPLICIT NONE

C...........   INCLUDES:

      INCLUDE 'PARMS3.EXT'      ! I/O API constants
      INCLUDE 'FDESC3.EXT'      ! I/O API file description data structure
      INCLUDE 'IODECL3.EXT'     ! I/O API function declarations


C...........   EXTERNAL FUNCTIONS and their descriptions:

        INTEGER      ENVINT, GETNUM, INDEX1, SEC2TIME, TIME2SEC
        LOGICAL      GETYN
        CHARACTER*16 PROMPTMFILE
        REAL         GETREAL

        EXTERNAL     ENVINT, GETNUM, GETREAL, GETYN, INDEX1,
     &               PROMPTMFILE, SEC2TIME, TIME2SEC

C...........   PARAMETERS and their descriptions:

        CHARACTER*80 PROGVER
        DATA PROGVER /
     &'$Id:: m3merge.f 326 2008-09-23 16:59:35Z coats@borel          $'
     &  /


C...........   LOCAL VARIABLES and their descriptions:

        CHARACTER*16    INNAMES( MXFILE3 )

        CHARACTER*16    ANAME, FNAME
        INTEGER         VTYPE( MXVARS3 ) ! variable type:  M3(INT|REAL|DBLE)
        CHARACTER*16    VFILE( MXVARS3 )
        CHARACTER*16    VNAMI( MXVARS3 )
        CHARACTER*16    VNAMO( MXVARS3 )
        CHARACTER*16    UNITS( MXVARS3 )
        CHARACTER*80    VDESC( MXVARS3 )

        INTEGER         NCOLS
        INTEGER         NROWS
        INTEGER         NLAYS
        INTEGER         NTHIK
        INTEGER         NVARS
        INTEGER		FTYPE
        INTEGER		FSIZE
        REAL*8          P_ALP      ! first, second, third map
        REAL*8          P_BET      ! projection descriptive
        REAL*8          P_GAM      ! parameters.

        REAL*8          XCENT      ! lon for coord-system X=0
        REAL*8          YCENT      ! lat for coord-system Y=0
        REAL*8          XORIG      ! X-coordinate origin of grid (map units)
        REAL*8          YORIG      ! Y-coordinate origin of grid
        REAL*8          XCELL      ! X-coordinate cell dimension
        REAL*8          YCELL      ! Y-coordinate cell dimension

        INTEGER         VGTYP      !  vertical coordinate type (VGSIGP3, ...)
        REAL            VGTOP      !  model-top, for sigma coord types.
        REAL            VGLVS( MXLAYS3 + 1 )  !  vertical coord values.

        CHARACTER*16    GDNAM      ! grid name             (length NAMLEN3=16)

        INTEGER         SDATE, STIME, TSTEP, DURATN, NSTEPS
        INTEGER         JDATE, JTIME
        
        INTEGER         I, N, L, V, F, STEP
        INTEGER         STATUS
        
        REAL,    ALLOCATABLE::   INBUF( : )
        
        LOGICAL         EFLAG
        CHARACTER*256   MESG


C...........   STATEMENT FUNCTION:  REAL, REAL*8 "definitely unequal"
        
        LOGICAL         FLTERR
        REAL            PP, QQ

        FLTERR( PP, QQ ) = 
     &      ( (PP - QQ)**2  .GT.  1.0E-10*( PP*PP + QQ*QQ + 1.0E-5 ) )

        LOGICAL         DBLERR
        REAL*8          P, Q

        DBLERR( P, Q ) = 
     &      ( (P - Q)**2  .GT.  1.0E-10*( P*P + Q*Q + 1.0E-5 ) )


C***********************************************************************
C   begin body of program M3MERGE

        EFLAG = .FALSE.         !  no errors yet
        I     = INIT3()
        WRITE( *,92000 )
     &' ',
     &'Program M3MERGE to merge selected variables from a set of ',
     &'gridded, boundary, or custom files over a commmon grid and',
     &'time period.',
     &' ',
     &'THE PROGRAM WILL PROMPT YOU for the logical names of the input',
     &'input files and the output file, the variables and layers to',
     &'extract, the names by which they should be called in the ',
     &'output file, and the time step sequence to be processed.',
     &'Default responses are indicated in square brackets',
     &'[LIKE THIS], and may be accepted by hitting the RETURN key.',
     &' ',
     &'PRECONDITIONS REQUIRED:',
     &' ',
     &'    setenv <first input name>    <path-names>',
     &'    ...',
     &'    setenv <last  input name>    <path-names>',
     &'    setenv <output name>         <path-names>',
     &' ',
     &'Program copyright (C) 1992-2002 MCNC and Carlie J. Coats, Jr.',
     &'and (C) 2002-2008 Baron Advanced Meteorological Systems, LLC',
     &'Released under Version 2 of the GNU General Public License.',
     &'See enclosed GPL.txt, or URL',
     &'http://www.gnu.org/copyleft/gpl.html',
     &' ',
     &'Comments and questions are welcome and can be sent to',
     &' ',
     &'    Carlie J. Coats, Jr.    coats@baronams.com',
     &'    Baron Advanced Meteorological Systems, LLC.',
     &'    920 Main Campus Drive, Suite 101',
     &'    Raleigh, NC 27606',
     &' ',
     &'See URL  http://www.baronams.com/products/ioapi/AA.html#tools',
     &' ',
     &'Program version: ',
     &PROGVER, 
     &'Program release tag: $Name$', 
     &' '

        IF ( .NOT. GETYN( 'Continue with program?', .TRUE. ) ) THEN
            CALL M3EXIT( 'M3MERGE', 0, 0, 
     &                   'Program terminated at user request', 2 )
        END IF
        
        DO  F = 1, 9
            WRITE( INNAMES( F ), '( A, I1 )' ) 'INFILE', F
        END DO

        DO  F = 10, MIN( MXFILE3, 99 )
            WRITE( INNAMES( F ), '( A, I2 )' ) 'INFILE', F
        END DO

        DO  F = 100, MXFILE3
            WRITE( INNAMES( F ), '( A, I3 )' ) 'INFILE', F
        END DO

C...............  Open/Process the first input file

        INNAMES( 1 ) = PROMPTMFILE(  'Enter first input file', FSREAD3,
     &                                INNAMES( 1 ), 'M3MERGE' )
        
        IF ( .NOT. DESC3( INNAMES( 1 ) ) ) THEN
            MESG = 'Could not get file description for ' // INNAMES(1)
            CALL M3EXIT( 'M3MERGE', 0, 0, MESG, 2 )
        END IF
        
        NCOLS = NCOLS3D
        NROWS = NROWS3D
        NLAYS = NLAYS3D
        NTHIK = NTHIK3D
        P_ALP = P_ALP3D
        P_BET = P_BET3D
        P_GAM = P_GAM3D
        XCENT = XCENT3D
        YCENT = YCENT3D
        XORIG = XORIG3D
        YORIG = YORIG3D
        XCELL = XCELL3D
        YCELL = YCELL3D
        VGTYP = VGTYP3D
        VGTOP = VGTOP3D
        GDNAM = GDNAM3D
        
        FTYPE = FTYPE3D
        IF ( FTYPE .EQ. GRDDED3 ) THEN
            FSIZE = NCOLS * NROWS * NLAYS
        ELSE IF ( FTYPE .EQ. BNDARY3 ) THEN
            FSIZE = 2*ABS( NTHIK )*NLAYS*( NCOLS + NROWS + 2*NTHIK )
        ELSE IF ( FTYPE .EQ. CUSTOM3 ) THEN
            FSIZE = NCOLS * NLAYS
        ELSE
            WRITE( MESG, '( A, I3 )' ) 'Unsupported file type', FTYPE
            CALL M3EXIT( 'M3MERGE', 0, 0, MESG, 2 )
        END IF

        SDATE  = SDATE3D
        STIME  = STIME3D
        TSTEP  = TSTEP3D
        NSTEPS = MXREC3D
        DO  L = 1, NLAYS + 1
           VGLVS( L ) = VGLVS3D( L )
        END DO

        WRITE( *, '( /5X, A, 120( /5X, I2, 6A, : ) )' )   
     &      'Variables in this file are:',   
     &      (  V, ':  ',     
     &         VNAME3D(V), ' (',     
     &         TRIM( UNITS3D(V) ), '): ',    
     &         TRIM( VDESC3D(V) ), V=1, NVARS3D )
        WRITE( *,* )
        
        F = 1
        N = 0
        IF ( GETYN( 'Incorporate all variables, without renaming?',
     &              .TRUE. ) ) THEN
            DO  I = 1, NVARS3D
                VNAMI(N+I) = VNAME3D(I)
                VNAMO(N+I) = VNAME3D(I)
                VDESC(N+I) = VDESC3D(I)
                VTYPE(N+I) = VTYPE3D( I )
                UNITS(N+I) = UNITS3D( I )
                VFILE(N+I) = INNAMES( F )
            END DO
            N = N + NVARS3D
            GO TO  22
        END IF

        F = 1
        N = 0
        I = 1
11      CONTINUE

            I = GETNUM( 0, NVARS3D, I,  
     &          'Enter # for next variable to extract (0 to quit)' )

            IF ( I .EQ. 0 ) GO TO 12

            N = N + 1
            VNAMI(N) = VNAME3D(I)
            ANAME    = VNAME3D(I)
            VDESC(N) = VDESC3D(I)
            VTYPE(N) = VTYPE3D( I )
            UNITS(N) = UNITS3D( I )
            VFILE(N) = INNAMES( 1 )
            CALL GETSTR( 'Enter output name for this variable',   
     &                   ANAME, VNAMO(N) )
            
            IF ( N .LT. MXVARS3 ) GO TO 11
            MESG = 'I/O API max number of variables now selected'
            CALL M3MSG2( MESG )
            GO TO 44

12      CONTINUE        !  exit from get-variables loop


C...............  Open/Process the rest of the input data files

22      CONTINUE        !  get rest of the input files

            F = F + 1
            INNAMES( F ) = PROMPTMFILE(  
     &                        'Enter next input file, or "NONE"', 
     &                        FSREAD3, INNAMES( F ), 'M3MERGE' )
        
            IF ( INNAMES( F ) .EQ. 'NONE' ) GO TO 44

            IF ( .NOT. DESC3( INNAMES( F ) ) ) THEN
                MESG = 'Could not get file description for ' // 
     &                 INNAMES(F)
                CALL M3EXIT( 'M3MERGE', 0, 0, MESG, 2 )
            END IF

            IF ( NCOLS .NE. NCOLS3D ) THEN
                MESG = 'NCOLS mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( NROWS .NE. NROWS3D ) THEN
                MESG = 'NROWS mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( NLAYS .NE. NLAYS3D ) THEN
                MESG = 'NLAYS mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( NTHIK .NE. NTHIK3D ) THEN
                MESG = 'NTHIK mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( P_ALP, P_ALP3D ) ) THEN
                MESG = 'P_ALP mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( P_BET, P_BET3D ) ) THEN
                MESG = 'P_BET mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( P_GAM, P_GAM3D ) ) THEN
                MESG = 'P_GAM mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( XCENT, XCENT3D ) ) THEN
                MESG = 'XCENT mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( YCENT, YCENT3D ) ) THEN
                MESG = 'YCENT mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( XORIG, XORIG3D ) ) THEN
                MESG = 'XORIG mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( YORIG, YORIG3D ) ) THEN
                MESG = 'YORIG mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( XCELL, XCELL3D ) ) THEN
                MESG = 'XCELL mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
             
            IF ( DBLERR( YCELL, YCELL3D ) ) THEN
                MESG = 'YCELL mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
            
            IF ( FTYPE .NE. FTYPE3D ) THEN
                MESG = 'FTYPE mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
            
            IF ( VGTYP .NE. VGTYP3D ) THEN
                MESG = 'VGTYP mismatch, file ' // INNAMES(F)
                CALL M3MSG2( MESG )
                EFLAG = .TRUE.
            END IF
            
            DO  L = 1, NLAYS+1
                IF ( FLTERR( VGLVS(L), VGLVS3D(L) ) ) THEN
                    WRITE( MESG, '( A, I4, 1X, A, A )' )  
     &              'Layer', L, 'mismatch, file ', INNAMES(F)
                    CALL M3MSG2( MESG )
                    EFLAG = .TRUE.
                END IF
            END DO

            WRITE( *, '( /5X, A, 120( /5X, I2, 6A, : ) )' )   
     &          'Variables in this file are:',   
     &          (  V, ':  ',     
     &             VNAME3D(V), ' (',     
     &             TRIM( UNITS3D(V) ), '): ',    
     &             TRIM( VDESC3D(V) ), V=1, NVARS3D )
            WRITE( *,* )

            I = 1
            L = 1
            IF ( N + NVARS3D .LE. MXVARS3 ) THEN
                IF ( GETYN( 'Merge all variables, without renaming?',
     &                      .TRUE. ) ) THEN
                    DO  I = 1, NVARS3D
                        VNAMI(N+I) = VNAME3D(I)
                        VNAMO(N+I) = VNAME3D(I)
                        VDESC(N+I) = VDESC3D(I)
                        VTYPE(N+I) = VTYPE3D( I )
                        UNITS(N+I) = UNITS3D( I )
                        VFILE(N+I) = INNAMES( F )
                    END DO
                    N = N + NVARS3D
                    GO TO  34
                END IF
            END IF

33          CONTINUE

                I = GETNUM( 0, NVARS3D, I,  
     &          'Enter # for next variable to extract (0 to quit)' )

                IF ( I .EQ. 0 ) GO TO 34

                N = N + 1
                VNAMI(N) = VNAME3D(I)
                ANAME    = VNAME3D(I)
                VDESC(N) = VDESC3D(I)
                VTYPE(N) = VTYPE3D( I )
                UNITS(N) = UNITS3D( I )
                VFILE(N) = INNAMES( F )
                CALL GETSTR(  
     &              'Enter output name for this variable/layer', 
     &               ANAME, VNAMO(N) )
            
                IF ( N .LT. MXVARS3 ) GO TO 33
                MESG = 'I/O API max number of variables now selected'
                CALL M3MSG2( MESG )
                GO TO 44

34          CONTINUE        !  exit from get-variables loop

            IF ( N .EQ. MXVARS3 ) THEN
                MESG = 'I/O API max number of variables now selected'
                CALL M3MSG2( MESG )
            GO TO 44
            END IF

            GO TO 22    !  to head of get-files loop

44      CONTINUE        !  exit from get-files loop
        
        IF ( EFLAG ) THEN
            MESG = 'Fatal input-setup/configuraton errors'
            CALL M3EXIT( 'M3MERGE', 0, 0, MESG, 2 )
        END IF

        NVARS = N

        SDATE = GETNUM( 0, 9999999, SDATE, 
     &                  'Enter starting DATE for the run (HHMMSS)' ) 

        STIME = GETNUM( 0, 235959, STIME, 
     &                  'Enter starting TIME (HHMMSS)' ) 

        TSTEP = GETNUM( 0, 999999999, TSTEP, 
     &                  'Enter OUTPUT TIME STEP (HHMMSS)' ) 

        I = SEC2TIME( NSTEPS * TIME2SEC( TSTEP ) )
        DURATN = GETNUM( 0,999999999,I, 'Enter RUN DURATION (HHMMSS)' )


C...............  Build the output file:

        NCOLS3D = NCOLS
        NROWS3D = NROWS
        NLAYS3D = NLAYS
        P_ALP3D = P_ALP
        P_BET3D = P_BET
        P_GAM3D = P_GAM
        XCENT3D = XCENT
        YCENT3D = YCENT
        XORIG3D = XORIG
        YORIG3D = YORIG
        XCELL3D = XCELL
        YCELL3D = YCELL
        VGTYP3D = VGTYP
        VGTOP3D = VGTOP
        GDNAM3D = GDNAM
        DO  L = 1, NLAYS+1
            VGLVS3D( L ) = VGLVS( L )
        END DO

        NVARS3D = NVARS
        DO  V = 1, NVARS3D
            VNAME3D( V ) = VNAMO( V )
            VTYPE3D( V ) = VTYPE( V )
            UNITS3D( V ) = UNITS( V )
            VDESC3D( V ) = VDESC( V )
        END DO

        FNAME = PROMPTMFILE(  'Enter output file', FSUNKN3,
     &                        'OUTFILE', 'M3MERGE' )
        
        ALLOCATE( INBUF ( FSIZE ), STAT = STATUS )

        IF ( STATUS .NE. 0 ) THEN
            WRITE( MESG, '( A, I10)' )  
     &           'Buffer allocation failed:  STAT=', STATUS
            CALL M3EXIT( 'M3MERGE', 0, 0, MESG, 2 )
        END IF
        

C...............  Perform the merge

        NSTEPS = TIME2SEC( DURATN ) / TIME2SEC( TSTEP )
        JDATE  = SDATE
        JTIME  = STIME
        
        DO  STEP = 1, NSTEPS
        
            DO  V = 1, NVARS
            
               IF ( .NOT. READ3( VFILE( V ), VNAMI( V ), ALLAYS3,
     &                            JDATE, JTIME, INBUF ) ) THEN
                   MESG = 'Could not read "' // TRIM( VNAMI(V) ) // 
     &                    '" from "' // TRIM( VFILE( V ) ) // '"'
                   CALL M3EXIT( 'M3MERGE', JDATE, JTIME, MESG, 2 )
               END IF  !  if read failed

               IF ( .NOT. WRITE3( FNAME, VNAMO( V ),  
     &                            JDATE, JTIME, INBUF ) ) THEN
                    MESG = 'Could not write "' // TRIM( VNAMO(V) ) // 
     &                     '" to "' // TRIM( FNAME ) // '"'
                    CALL M3EXIT( 'M3MERGE', JDATE, JTIME, MESG, 2 )
                END IF  !  if write failed

            END DO              !  end loop on variables V for this time step

            CALL NEXTIME( JDATE, JTIME, TSTEP )
        
        END DO          !  end loop on output time steps


        CALL M3EXIT( 'M3MERGE', 0, 0, 
     &               'Successful completion of program M3MERGE', 0 )
C      STOP

C******************  FORMAT  STATEMENTS   ******************************

C...........   Error and warning message formats..... 91xxx
C...........   Informational (LOG) message formats... 92xxx

92000   FORMAT ( 5X, A )


C...........   Formatted file I/O formats............ 93xxx
C...........   Internal buffering formats............ 94xxx
C...........   Miscellaneous formats................. 95xxx


        END


