      SUBROUTINE CONCALC(OLDAY,SVGOOD,SWGOOD)
C*******************************************************************
C      THIS SUBROUTINE CONTAINS THE STACK LOOP.  IT CALLS NITCALC 
C      TO CALCULATE THE CONCENTRATIONS FOR STABLE/NEUTRAL CONDITIONS
C      OR CALLS DAYCALC TO CALCULATE CONCENTRATIONS FOR 
C      UNSTABLE/CONVECTIVE CONDITIONS
C ******************************************************************

      INCLUDE 'PARAMS.INC'
      INCLUDE 'CONST.CMN'
      INCLUDE 'IO.CMN'
      INCLUDE 'PARAMS.CMN'
      INCLUDE 'PASVAL.CMN'
      INCLUDE 'RECEPT.CMN'
      INCLUDE 'SCREN.CMN'
      INCLUDE 'SFCMET.CMN'
      INCLUDE 'STACK.CMN'
      INCLUDE 'STACKS.CMN'
      INCLUDE 'TIME.CMN'
      INCLUDE 'VARS.CMN'

      REAL  BSTKTP, CHIMAX1, DELH, DELT, GETDTH, GETWS, QS

      INTEGER  IFLAG, IRISE, OLDAY, NRMAX1, NS, SVGOOD, SWGOOD

100     CONTINUE

C   IN SCREENING MODE, RECALCULATE WSTAR USING MIXING HEIGHT DETERMINED
C   AS A FUNCTION OF HILL HEIGHT
        IF (EL .LT. 0.0 .AND. ISCRN .GT. 0)
     &         WSTAR0 = USTAR0 * (XMH/(-0.4*EL))**0.33333

C       START LOOP ON STACKS ------------------------------------------

        DO  300  NS=1,NSTACK

C       SET UP STACK COMMON VARIABLES; SEE STACKS.CMN FOR DEFINITIONS

          QS = SOURCE(8,NS)
          IF (ICHIQ .EQ. YES .AND. QS .GT. 0.0) THEN
            QS = 1.0
          ELSE IF (ICHIQ .EQ. YES .AND. QS .LT. 0.0) THEN
            QS = -1.0
          ENDIF
          XS = SOURCE(1,NS)
          YS = SOURCE(2,NS)
          HS = SOURCE(4,NS)
          DS = SOURCE(5,NS)
          TS = SOURCE(6,NS)
          VS = SOURCE(7,NS)
          IF(TS .LT. TA) TS = TA
          DELT = (TS-TA) / TS

C       IF NO EMISSIONS, SKIP CALCULATIONS FOR THIS STACK

C          IF (QS .LE. 0.0) THEN
          IF (QS .EQ. 0.0) THEN
            IF (ICASE .GT. 0) WRITE(IOUT,6125) NS
            GO TO 300
          ENDIF

C       FOR SCREEN CASES, IF STACK IS ABOVE ZI, CONSIDER IT TO TOTALLY
C       PENETRATE.  NO CONTRIBUTION FROM THIS SOURCE, SO SKIP IT.
          IF (ISCRN .GT. 0 .AND. EL .LT. 0 .AND. HS .GE. XMH) THEN
            DO 110 NR = 1,NRECPT
              SCONC(NR,NS) = 0.0
110         CONTINUE
            WRITE(IOUT,6126) NS,ISIM+1
            GO TO 300
          ENDIF

          FB = SOURCE(10,NS) * DELT
          FM = SOURCE(11,NS) * TA / TS

          USTKTP = GETWS(HS)

C       FOR UNSTABLE HOURS, SET WSTAR/US TO A MIN OF 0.167
          IF (EL .LT. 0 .AND. EL .GT. -100) THEN
            WSTAR = AMAX1(0.167*USTKTP,WSTAR0)
          ENDIF

C   CALCULATE THE FOLLOWING FOR PLUME RISE SUBROUTINES
          IF (FB .LE. 55.0) THEN
            XSTAR = 14.0 * FB**0.625
          ELSE
            XSTAR = 34.0 * FB**0.40
          ENDIF
          XFIN = 3.5 * XSTAR

C       CALCULATE FINAL PLUME RISE

C           STABLE SECTION
          IF (EL .GT. 0.0  .OR.  HS .GT. XMH) THEN
            IFLAG = NO
            CALL SRISE(IFLAG, DELH, IRISE)

C       NOTE: XSZS IS DISTANCE TO WHERE TURBULENCE DOMINATES SOURCE-
C       INDUCED EFFECTS.  FOR STABLE CONDITIONS, THIS IS ASSUMED TO BE
C       THE DISTANCE TO FINAL RISE; FOR NONSTABLE CONDITIONS, THIS
C       DISTANCE IS ASSUMED TO BE NEARLY ZERO.

            IF (IRISE .LE. 9) THEN
              XSZS = 0.0
            ELSE
              BSTKTP = SQRT((9.8/TA) * GETDTH(HS,XMH))
              XSZS = 2.07 * USTKTP/BSTKTP
            ENDIF

          ELSE

C           UNSTABLE SECTION
            CALL URISE(DELH, IRISE, USTKTP, US)
            XSZS = 0.0
          ENDIF

C       COMPUTE PLUME HEIGHT
          HPL = DELH + HS

C       SAVE THE PLUME HEEIGHT
          PLMHTS(NS) = HPL

C   DETERMINE WHETHER THIS SOURCE SHOULD BE MODELED AS STABLE OR.
C   UNSTABLE.  CALL DAYCALC OR NITCALC TO DETERMINE CONCENTRATIONS

          IF (HS.LE.XMH .AND. ((EL.LT.0.0 .AND. EL.GT. -100) .OR.
     $                                -XMH/EL .GT. 10)) THEN

C   ZERO DTH BECAUSE IT IS NOT USED IN UNSTABLE CALCULATIONS
            DTH = 0.0

C   IF IUNSTA = NO, SKIP THIS HOUR AND WRITE -999 TO CONC FILE
            IF (IUNSTA .EQ. NO) THEN
              DO 585 NR=1,NRECPT
                CONC(NR) = -999.
585           CONTINUE
              GO TO 999
            ENDIF

C   WRITE WARNING MESSAGE IF UNSTABLE DURING NIGHTTIME
            IF (KHR .GT. TSS  .OR. KHR .LT. TSR)
     $        WRITE(IOUT,6104) NS,KYR,KMO,KDY,KHR

C   IF BOTH MIXING HEIGHTS ARE MISSING IN DAYTIME, SKIP THIS HOUR

            IF (XMH .EQ. 99999.) THEN
              IF (ICASE .EQ. 1 .OR. ICASE .EQ. 3)
     $          WRITE(IOUT,9385) KYR, KMO, KDY, KJCD, KHR
              GOTO 390
            ENDIF

            CALL DAYCALC(NS,OLDAY,DELH,QS)

          ELSE

C   IF IUNSTA = 2, SKIP THIS STABLE HOUR AND WRITE -999 TO CONC FILE
            IF (IUNSTA .EQ. 2) GO TO 390

C    CHECK IF WE HAVE AT LEAST ONE VALUE OF SIGMA-V AND SIGMA-W
C    FOR STABLE/NEUTRAL HOURS
            IF (SVGOOD.EQ.NO  .OR. SWGOOD .EQ. NO ) GO TO 350

            CALL NITCALC(NS,DELH,QS,IFLOW)

C    IF FLOW > 0 THERE WAS A PROBLEM, GO ON TO THE NEXT WIND DIRECTION
            IF (IFLOW .GT. 0) GOTO 999

          ENDIF

C       END OF SOURCE LOOP --------------------------------------------
300     CONTINUE

C      IF REGULAR VERSION, SKIP THE NEXT PART
        IF (ISCRN .EQ. NO) GOTO 999

C       IF HPL-HC < SIGMA-Z/3 AND THIS IS THE FIRST PASS, GO BACK
C       AND USE THE SECOND WIND DIRECTION (IF DIFFERENT FROM WDABVE)

        IF ((ISIGZ .EQ. YES) .AND. (THTA .EQ. WDABVE)) THEN
            THTA = WDBL
            GO TO 100
        ENDIF

C   FIND THE MAX CONCENTRATION FOR EACH ARRAY
        IF (ISIGZ .EQ. YES .AND. THTA .EQ. WDBL) THEN
          CHIMAX1 = 0.0
          NRMAX1 = 0
          DO 307 NR = 1,NRECPT
            IF (CONC1(NR) .GT. CHIMAX1) THEN
              CHIMAX1 = CONC1(NR)
              NRMAX1 = NR
            ENDIF
307       CONTINUE
        ENDIF

        CHIMAX = 0.0
        NRMAX = 0
        DO 306 NR = 1,NRECPT
          IF (CONC(NR) .GT. CHIMAX) THEN
            CHIMAX = CONC(NR)
            NRMAX = NR
          ENDIF
306     CONTINUE

C   FIND WHICH WIND DIRECTION GAVE THE HIGHEST CONCENTRATION AND
C   KEEP THOSE CONCENTRATIONS
        IF (ISIGZ .EQ. YES) THEN
          IF (CHIMAX .GT. CHIMAX1) THEN
            THTA = WDABVE
          ELSE
            THTA = WDBL
            CHIMAX = CHIMAX1
            NRMAX = NRMAX1
            DO 311 NR = 1,NRECPT
              CONC(NR) = CONC1(NR)
              DO 313 NS=1,NSTACK
                SCONC(NR,NS) = SCONC1(NR,NS)
313           CONTINUE
311         CONTINUE
          ENDIF
        ENDIF

         GO TO 999

C       MISSING MET DATA: EITHER WD, WS, SIGV, OR SIGW

350      IF(ICASE .EQ. 1 .OR. ICASE .EQ. 3) 
     $         WRITE(IOUT,9355) KYR, KMO, KDY, KJCD, KHR

C       SET CONCENTRATIONS TO MISSING FOR THIS HOUR
390      DO 395 NR=1,NRECPT
           CONC(NR) = -999.
           DO 396 NS=1,NSTACK
            SCONC(NR,NS) = -999.
396        CONTINUE
395     CONTINUE

999     CONTINUE

        RETURN

6104    FORMAT(/,3X,'WARNING!! SOURCE ',I3,' IS IN UNSTABLE LAYER',
     1     ' IN NIGHTTIME ON ',I2,'/',I2,'/',I2,' HR ',I2,'.',/,
     2    3X,'INTERPRET RESULTS WITH CAUTION.')
6125    FORMAT(/,10X,'NO EMISSIONS FROM SOURCE # ',I2,/)
6126    FORMAT(/,' SOURCE ',I2,' IS ABOVE THE MIXING HEIGHT.',
     *  /,'  SIMULATION = ',I6)
9355    FORMAT(/' MISSING MET. INPUT, NO PREDICTIONS THIS HOUR',
     *  /'   YEAR=',I2,' MONTH=',I2,' DAY=',I2,' JCD=',I3,' HOUR=',I2/)
9385    FORMAT(/' MISSING MIXING HEIGHT, NO PREDICTIONS THIS HOUR',
     *  /'   YEAR=',I2,' MONTH=',I2,' DAY=',I2,' JCD=',I3,' HOUR=',I2/)


        END
