        REAL FUNCTION DELWD( WD1,    WD2)
C-----------------------------------------------------------------------
C PURPOSE: THIS FUNCTION COMPUTES THE DIFFERENCE BETWEEN TWO WIND
C               DIRECTIONS.
C
C ASSUMPTIONS: THE RETURNED DIFFERENCE BETWEEN THE TWO DIRECTIONS CANNOT
C               BE GREATER THAN 180 DEGREES IN MAGNITUDE.
C
C ARGUMENTS
C  PASSED:
C       WD1     REAL    LOWER WIND DIRECTION
C       WD2     REAL    UPPER WIND DIRECTION
C  RETURNED FUNCTION VALUE:
C       DELWD   REAL    DELWD=WD2-WD1
C
C CALLING ROUTINES:
C       SEQMOD  WDPRO
C
C INTRINSIC FUNCTIONS:
C       ABS
C
C COMMON BLOCKS: NONE
C
C-----------------------------------------------------------------------
C
C       DEFINE ARGUMENTS
        REAL    WD1,    WD2
C
        DELWD=WD2-WD1
        IF(ABS(DELWD) .GT. 180.0) THEN
            IF(DELWD .GT. 0.0) THEN
                DELWD=DELWD-360.0
              ELSE
                DELWD=DELWD+360.0
            ENDIF
        ENDIF
C
        RETURN
        END
