        REAL FUNCTION GETUV(    Z2, US2, SV2,XMH)
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE COMPUTES THE VECTOR WIND SPEED AT HEIGHT Z2.
C
C ARGUMENTS
C  PASSED:
C       Z2      REAL    HEIGHT (M)
C       US2     REAL    SCALAR WIND SPEED AT HEIGHT Z2, M/SEC
C       SV2     REAL    SIGMA-V AT HEIGHT Z2, M/SEC
C  RETURNED FUNCTION VALUE:
C       GETUV   REAL    WIND SPEED (M/S)
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: KLOSE  GETSV  GETSW
C
C INTRINSIC FUNCTIONS: SIN  SQRT
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS: SFCMET PROFIL
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
C      INCLUDE   'SFCMET.CMN'
      INCLUDE   'PROFIL.CMN'
C
C       DEFINE ARGUMETS
        REAL    Z2, US2, SV2, XMH
C
C       DEFINE LOCAL VARIABLES
        REAL    UV1, Z1, UVNEW(MAXLEV), SV1, US1, SIGTH1,
     1          SIGTH2, EPS,
     2          HTNEW(MAXLEV),  UV3, UVMISS, Z3, DX, DZ, Z4
        INTEGER LEV, N, NNEW
        DATA    UVMISS/ 0.0/
C
        IF(US2 .EQ. UVMISS ) THEN
            GETUV = 0.0
            RETURN
        ENDIF
C
C       EXAMINE DATA AND SELECT ONLY NONMISSING VALUES
C
        NNEW = 0
        DO 100 N = 1,NHT
           IF(UVHR(N) .LT. UVMISS ) GO TO 100
           NNEW = NNEW + 1
           UVNEW(NNEW) = UVHR(N)
           HTNEW(NNEW) = HT(N)
100     CONTINUE
        IF(NNEW.EQ.0) THEN
            GETUV = US2
            RETURN
        ENDIF
        LEV=KLOSE(HTNEW,NNEW,Z2)
        IF(LEV .EQ. 0) THEN
            Z1 = HTNEW(1)
            UV1 = UVNEW(1)
          ELSE
            Z1=HTNEW(LEV)
            UV1=UVNEW(LEV)
        ENDIF
C
C       Z1 IS MEASUREMENT HEIGHT CLOSEST TO BUT LESS THAN Z2.
C       USE INTERPOLATION IF POSSIBLE; OTHERWISE, USE PROFILING.
C
        IF(LEV.GE.1 .AND. LEV.LT.NNEW) THEN
            UV3 = UVNEW(LEV+1)
            Z3 = HTNEW(LEV+1)
            DX = UV3 - UV1
            DZ = Z3 - Z1
            GETUV = UV1 + (Z2-Z1)*(DX/DZ)
            RETURN
        ENDIF
C
C       IF BOTH Z1 AND Z2 ARE ABOVE XMH, USE THE MEASUREMENT WITHOUT
C       SCALING.
C
        IF(Z1 .GT. XMH .AND. Z2 .GT. XMH) THEN
            GETUV = UV1
            RETURN
        ENDIF
C
C       IN THIS SECTION, SCALE UV WITHIN MIXED LAYER (ADJUST Z1 AND Z2
C       TO BE NO MORE THAN XMH).
C
C       SCALE UV(Z1) TO UV(Z2) BY FIRST SCALING SIGMA-THETA TO Z2
C
        Z3 = Z1
        Z4 = Z2
        IF(Z3 .GT. XMH) Z3 = XMH
        IF(Z4 .GT. XMH) Z4 = XMH
        SV1 = GETSV(Z3)
        US1 = GETWS(Z3)
        SIGTH1 = SV1/UV1
        SIGTH2 = SIGTH1 * SV2/SV1 * US1/US2
C
C       COMPUTE SIGMA-V FROM SIGMA-THETA USING VECTOR WIND SPEED.
C       GET VECTOR SPEED FROM SCALAR SPEED AND SIGMA-THETA USING
C       YAMARTINO'S (1984) RELATIONSHIP.
C
        EPS = SIN(SIGTH2 * (1.0 - 0.073864*SIGTH2))
        GETUV = US2 * SQRT(1.0 - EPS*EPS)
        RETURN
        END
