        SUBROUTINE INPEMS
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE READS VARIABLE EMISSIONS PARAMETERS AND UPDATES
C               THE STACKS COMMON BLOCK.
C
C LIMITATIONS: NO CHECKING FOR VALID INPUT DATA IS DONE IN THIS ROUTINE.
C              HOWEVER, A TIME AND STACK NUMBER CHECK IS MADE FOR
C              CONSISTENCY WITH WHAT THE MODEL EXPECTS TO BE READ IN.
C
C ARGUMENTS: NONE
C
C I/O:
C  INPUT:
C       UNIT=INEMIS  (FREE FORMAT)
C             VARIABLE             DESCRIPTION
C                 JYR              YEAR (00-99)
C                 JMO              MONTH
C                 JDY              DAY OF THE MONTH
C                 JHR              HOUR (TIME AT END OF THE HOUR)
C                  IS              STACK NUMBER
C                  TS              STACK GAS TEMPERATURE (DEG K)
C                  VS              STACK GAS EXIT VELOCITY (M/SEC)
C                  QS(1)           EMISSION RATE FOR POLL. #1 (G/S)
C                  QS(2)           EMISSION RATE FOR POLL. #2 (G/S)
C                  QS(3)           EMISSION RATE FOR POLL. #3 (G/S)
C                  QS(4)           EMISSION RATE FOR POLL. #4 (G/S)
C
C       LINE 2 IS REPEATED FOR EACH STACK WHOSE EMISSIONS PARAMETERS
C       CHANGE IN THIS HOUR. A BLANK LINE OR IS=0 TERMINATES THE READING
C       OF EMISSIONS DATA FOR THIS HOUR.
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNALS ROUTINES: NONE
C
C INCLUDE FILES: PARAMS.INC
C
C
C COMMON BLOCKS: IO  STACKS  TIME  PARAMS  VARS
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
      INCLUDE   'STACKS.CMN'
      INCLUDE   'TIME.CMN'
      INCLUDE   'PARAMS.CMN'
C      INCLUDE   'VARS.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL    DS, QS(4), TS, VS
        INTEGER I, J, IS, JYR, JMO, JDY, JHR, NO
        DATA    NO/0/
C
        DO 100 I = 1,KEMIS
            READ(INEMIS, *)JYR,JMO,JDY,JHR,IS,TS,VS,(QS(J),J=1,IPOL)
C
C           CHECK TIME AND SOURCE # FOR CONSISTENCY
            IF(JYR .NE. KYR  .OR.  JMO .NE. KMO  .OR.  JDY .NE. KDY
     *                          .OR.  JHR .NE. KHR) THEN
                WRITE(IOUT,510) KMO,KDY,KYR,KHR,JMO,JDY,JYR,JHR,IS
                STOP
            ENDIF
C
C           CHECK SOURCE # TO SEE IF VARIABLE EMISSIONS ARE EXPECTED
            IF( IVAR(IS) .EQ. NO ) THEN
                WRITE(IOUT,520) IS
                STOP
            ENDIF
            DS = SOURCE(5,IS)
            SOURCE(6,IS)=TS
            SOURCE(7,IS)=VS
            SOURCE(8,IS)=AMAX1(QS(IPOL),0.0)
            SOURCE(10,IS)=2.45154*VS*DS*DS
            SOURCE(11,IS)=0.25*VS*VS*DS*DS
100     CONTINUE
C
        RETURN
C
510     FORMAT(//,5X,'PROGRAM EXECUTION TERMINATED DUE TO A DATE/TIME ',
     1  /,5X,'INCONSISTENCY IN THE VARIABLE EMISSIONS FILE.',//,5X,
     2  'DATE/TIME EXPECTED WAS ',I2,'/',I2,'/',I2,':',I2,', AND ',/,5X,
     3  'DATE/TIME READ WAS ',I2,'/',I2,'/',I2,':',I2,', FOR STACK ',I2)
520     FORMAT(//,5X,'PROGRAM EXECUTION TERMINATED DUE TO AN ',/,5X,
     1  'UNEXPECTED STACK # (',I3,') READ IN THE VARIABLE EMISSIONS ',
     2  'FILE')
        END
