        SUBROUTINE INPTOW
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE IS RESPONSIBLE FOR READING THE MET TOWER
C          POSITION INFORMATION. THE HEIGHTS READ FROM THE PROFILE DATA
C          FILE ARE REFERENCED TO THE TOWER BASE HEIGHT AND ARE ADJUSTED
C          HEIGHT CANNOT BE NEGATIVE.
C
C LIMITATIONS:
C       ONLY ONE TOWER POSITION IS CONSIDERED.
C
C ARGUMENTS
C  PASSED: NONE
C  RETURNED: NONE
C
C I/O:
C  INPUT: UNIT=IN  (CTDM.IN, LINE 4)
C
C       THE FOLLOWING INDICATE THE GROUP OF INPUT LINES EXPECTED
C       FOR EACH HILL.
C
C       LINE  VARIABLE  COLUMNS FORMAT  DESCRIPTION
C         1      LABEL    1-20   A20    LABEL FOR THIS TOWER
C                                         FOR THIS RECEPTOR GROUP
C                XT      21-30   F10.0  X COORDINATE OF TOWER, USER
C                                         UNITS
C                YT      31-40   F10.0  Y COORDINATE OF TOWER, USER
C                                         UNITS
C                ZT      41-50   F10.0  HEIGHT OF TOWER BASE, USER
C                                               UNITS
C
C  OUTPUT: UNIT=IOUT
C       PRINTOUT OF INPUT TOWER DATA
C
C CALLING ROUTINES: CTDMPLUS (MAIN)
C
C EXTERNAL ROUTINES: LINES
C
C INCLUDE FILES: PARAMS.INC
C
C COMMON BLOCKS:
C       IO  PARAMS  TOWER
C
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'IO.CMN'
      INCLUDE   'PARAMS.CMN'
      INCLUDE   'TOWER.CMN'
C
C       DEFINE LOCAL VARIABLES
        REAL XTIN, YTIN, ZTIN
        INTEGER YES, NEWPGE
        CHARACTER*20 LABEL
        DATA YES/1/
C
        READ(IN, 5010, ERR=9000) LABEL,XTIN,YTIN,ZTIN
        CALL LINES(4, YES, NEWPGE)
C
C       CONVERT TO MODEL COORDINATE SYSTEM
C
        XT = XTIN * HORIZ
        YT = YTIN * HORIZ
        ZT = ZTIN * VERT
        WRITE(IOUT, 6010) XTIN,HORIZ,XT,YTIN,HORIZ,YT,ZTIN,VERT,ZT
        RETURN
9000    WRITE(IOUT, 6900)
        STOP
5010    FORMAT(A20,3F10.0)
6010    FORMAT(/,
     &  '     METEOROLOGICAL TOWER COORDINATE INFORMATION:',/,5X,
     &  '     X-COORD:   ',F9.3,' (USER UNITS) * ',F10.4,' = ',F12.1,
     &  ' (METERS)',/,5X,
     &  '     Y-COORD:   ',F9.3,' (USER UNITS) * ',F10.4,' = ',F12.1,
     &  ' (METERS)',/,5X,
     &  '     ELEVATION: ',F9.3,' (USER UNITS) * ',F10.4,' = ',F12.1,
     &  ' (METERS)')
6900    FORMAT(//' * READ ERROR FROM INPTOW,  PROGRAM TERMINATING *')
        END
                                      

