       SUBROUTINE LINES( NLINC, IFLAG, NEWPGE )
C-----------------------------------------------------------------------
C
C   PURPOSE:
C       THIS ROUTINE KEEPS TRACK OF THE NUMBER OF USED PRINTOUT LINES.
C       IF A NEW PAGE IS NEEDED THE PAGE ROUTINE WILL BE CALLED.
C
C   LIMITATIONS:
C       MAX LINES PER PAGE IS 57
C
C   ARGUMENTS:
C    PASSED:
C       NLINC   INT     NUMBER OF LINES
C       IFLAG   INT     FLAG INDICATING WHETHER RUN TITLE IS PRINTED
C                               0=NO, 1=YES
C    RETURNED:
C       NEWPGE  INT     FLAG INDICATING IF NEW PAGE  0=NO, 1=YES
C
C   COMMON BLOCKS: HEAD
C
C   INPUT: NONE
C
C   OUTPUT: PAGE HEADER IF NLINES EXCEEDS MAXLIN
C
C   CALLING PROGRAMS: CTDMPLUS (MAIN), INPSOR, INPREC, MAP
C
C   EXTERNAL ROUTINES CALLED: PAGE
C
C-----------------------------------------------------------------------
C
      INCLUDE   'PARAMS.INC'
      INCLUDE   'HEAD.CMN'
C
C       DEFINE ARGUMENTS
        INTEGER NLINC,  IFLAG,  NEWPGE
C
C       DEFINE LOCAL VARIABLES
        INTEGER NO, YES
        DATA    NO/ 0/
        DATA    YES/ 1/
C
        NLINES = NLINES + NLINC
        IF( NLINES .GT. MAXLIN ) THEN
                NEWPGE = YES
                CALL PAGE( IFLAG )
                NLINES = 2 + 2*IFLAG + NLINC
         ELSE
                NEWPGE = NO
        ENDIF
        RETURN
C
       END
