        INTEGER FUNCTION LSTAB( EL,     ZR0)
C-----------------------------------------------------------------------
C FUNCTION: LSTAB
C
C PURPOSE: THIS FUNCTION CALCULATES A P-G STABILITY CLASS GIVEN THE
C               MONIN-OBUKHOV LENGTH (L) AND THE SURFACE ROUGHNESS
C               LENGTH (Z0).
C
C ASSUMPTIONS: THE DIVIDING LINES BETWEEN CATEGORIES ARE ASSUMED TO BE
C               LINEAR.
C
C LIMITATIONS: THIS FUNCTION IS ONLY VALID FOR 0.01 <= Z0 <= 0.5(M).
C              HOWEVER, RESULTS ARE EXTENDED TO OTHER VALUES OF Z0 BY
C              USING Z0 = 0.01 IF Z0 < 0.01 M, AND BY USING Z0 = 0.5
C              IF Z0 > 0.5 M.
C
C ARGUMENTS
C  PASSED:
C       EL      REAL    MONIN-OBUKHOV LENGHT (M)
C       ZR0     REAL    SURFACE ROUGHNESS LENGTH (M)
C  RETURNED FUNCTION VALUE:
C       LSTAB   INT     P-G STABILITY CATEGORY 1=A, 2=B, ETC.
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES: NONE
C
C INTERNAL FUNCTIONS:
C       XL - EQUATION OF DIVIDING LINE BETWEEN P-G STABILITY CLASSES
C
C INTRINSIC FUNCTIONS: ALOG
C
C REFERENCES:
C       GOLDER, D. (1972): RELATIONS AMONG STABILITY PARAMETERS IN THE
C                       SURFACE LAYER, BOUNDARY-LAYER METEOROLOGY, 3:56.
C
C-----------------------------------------------------------------------
C
        REAL            EL, XEL, XL, Z0, ZR0
C
C
        XL(Y,XM,B)=XM/(ALOG(Y)-B)
C
        Z0 = ZR0
        IF(Z0 .GT. 0.5) Z0 = 0.5
        IF(Z0 .LT. 0.01) Z0 = 0.01
        IF(EL .LT. 0.0) THEN
            XEL = -EL
            IF(XEL .LE. XL(Z0,-70.0,4.35)) THEN
C               STABILITY A
                LSTAB=1
              ELSE IF(XEL .LE. XL(Z0,-85.2,0.502)) THEN
C               STABILITY B
                LSTAB=2
              ELSE IF(XEL .LE. XL(Z0,-245.,0.050)) THEN
C               STABILITY C
                LSTAB=3
              ELSE
C               STABILITY D
                LSTAB=4
            ENDIF
          ELSE
            IF(EL .GE. XL(Z0,-327.,0.627)) THEN
C               STABILITY D
                LSTAB=4
              ELSE IF(EL .GE. XL(Z0,-70.0,0.295)) THEN
C               STABILITY E
                LSTAB=5
              ELSE
C               STABILITY F
                LSTAB=6
            ENDIF
        ENDIF
C
        RETURN
        END
