        SUBROUTINE PLAVG(Z, UAVG,   WDAVG,  DTHDZA,  XMH )
C-----------------------------------------------------------------------
C PURPOSE: THIS ROUTINE COMPUTES AVERAGE VALUES OF WIND SPEED, WIND
C               DIRECTION AND POTENTIAL TEMPERATURE LAPSE RATE IN THE
C               PLUME RISE LAYER.
C
C ARGUMENTS:
C   PASSED:
C       Z       REAL    HEIGHT AT WHICH INFORMATION IS DESIRED (M)
C
C   RETURNED:
C       UAVG    REAL    WIND SPEED AT HEIGHT Z, M/SEC
C       WDAVG   REAL    WIND DIRECTION AT HEIGHT Z, DEG
C       DTHDZA  REAL    POTENTIAL TEMPERATURE LAPSE RATE AT HEIGHT Z,
C                          DEG K PER METER
C
C I/O: NONE
C
C CALLING ROUTINES: SEQMOD
C
C EXTERNAL ROUTINES:
C       GETWS   FUNCTION WHICH RETURNS THE WIND SPEED AT HEIGHT Z
C       GETWD   FUNCTION WHICH RETURNS THE WIND DIRECTION AT HEIGHT Z
C       GETDTH  FUNCTION WHICH RETURNS DTHETA/DZ AT HEIGHT Z
C
C INTRINSIC FUCTIONS:
C
C INCLUDE FILES:
C
C COMMON: STACK
C
C-----------------------------------------------------------------------
C
C      INCLUDE   'STACK.CMN'
C
        REAL            Z, UAVG,   WDAVG,  DTHDZA, XMH
C
C       CALCULATE WIND SPEED AT HEIGHT Z
        UAVG = GETWS(Z)
C
C       CALCULATE WIND DIRECTION AT HEIGHT Z
        WDAVG = GETWD(Z)
C
C       CALCULATE VPTG AT HEIGHT Z
        DTHDZA = GETDTH(Z,XMH)
C
        RETURN
        END
