
        SUBROUTINE SIGMAY(DTHETA,XP,Y,RISE,SIGY,HDF,X)
C
C********************************************************************
C
C       THIS ROUTINE COMPUTES SIGMA-Y AND THE HORIZONTAL DISTRIBUTION
C       FUNCTION.
C 
C       U       - WIND SPEED 1/2 WAY BTWN STACKTOP AND HPL
C       DTHETA  - WIND DIRECTION SHEAR, IN DEGREES PER METER
C       XP      - DOWNWIND DISTANCE (METERS)
C       Y       - CROSSWIND DISTANCE (METERS)
C       RISE    - PLUME RISE (METERS)
C       SIGY    - SIGMA-Y
C       HDF     - HORIZONTAL DISTRIBUTION FUNCTION IN GAUSSIAN EQUATION
C
C
C********************************************************************

        INCLUDE 'SFCMET.CMN'

        REAL  ALPHA, ARG, DTHETA, HDF, RISE, SHCOEF, SIGY, 
     &        SIGYA, SIGYB, SIGYC, X, XP, Y

        ALPHA = 3.1622777
        SHCOEF = 0.17

C       CALCULATE ATMOSHERIC DISPERSION COMPONENT
        SIGYA = 0.0
        IF (FSTAR .GE. 0.06) THEN 
          IF (X .GT. 1.0 .OR. X/FSTAR .GT.17.0) THEN
            SIGYA = 0.6 * XMH * X
          ELSE
            SIGYA = 1.6 * XMH * (X**.66667) * (FSTAR**.33333)       
          ENDIF
        ELSE
          SIGYA = 0.6 * XMH * X/(1+2*X)**0.5
        ENDIF

C       CONSIDER BUOYANCY-ENHANCED DISPERSION 
C          FOR PASSIVE PLUMES ONLY

        SIGYB = 0.0
        IF (FSTAR .LT. 0.06) SIGYB = RISE/ALPHA

C       CONSIDER ENHANCEMENT OF SIGMA-Y BY WIND DIRECTION SHEAR

        SIGYC = 0.0
        SIGYC = SHCOEF * DTHETA * 0.01745 * RISE * XP
      
        SIGY=SQRT(SIGYA*SIGYA + SIGYB*SIGYB + SIGYC*SIGYC)

C       COMPUTE HDF ( 1/ROOT(2*PI) = .3989423 )

        HDF = 0.3989423/SIGY 
        ARG=.5*(Y/SIGY)**2
        IF (ARG .GT. 30.0) THEN 
          HDF = 0.0
        ELSE
          HDF = HDF*EXP(-ARG)
        ENDIF
                                      
        RETURN
        END

