* CALC.PRG
* A calculator program

*PARAMETERS infield
PARAMETER st
PUBLIC CalcTotal, CalcWork, Operator, CalcVal, OldOp, new, num

ON KEY LABEL F1
ON KEY LABEL F3
ON KEY LABEL F5
ON KEY LABEL F9 
ON KEY LABEL F10  

*ON KEY LABEL F3 = 1
*
*ON KEY LABEL F1 = 1
*ON KEY LABEL F5 = 1
*ON KEY LABEL F9 = 1
*ON KEY LABEL F10 = 1 

**LOAD CURSOFF
**LOAD CURSON
**CALL CURSOFF
SET ESCAPE OFF
SET TALK OFF
*SET DECIMAL TO 2
*SET FIXED ON

* ON ERROR CalcVal = "*******************"

*WSET WINDOW Calc     TO  3, 24, 21, 54;
*   COLOR GR+/RB,B/W,GR+/RB
*WSET WINDOW CalcHelp TO  3, 21, 21, 58;
*   COLOR W+/RB,B/W,GR+/RB
**WSET WINDOW Calc     TO  3, 25, 21, 53;
**   COLOR GR+/RB,B/W,GR+/RB
**WSET WINDOW CalcHelp TO  3, 21, 21, 58;
**   COLOR W+/RB,B/W,GR+/RB

*DEFINE WINDOW Calc FROM 3,21 TO 23,53    COLOR GR+/RB,B/W,GR+/RB TITLE "[ Calculator ]" SHADOW
*DEFINE WINDOW CalcHelp FROM 3,23 TO 23,57    COLOR GR+/RB,B/W,GR+/RB TITLE "[ Calculator Help ]" 
DEFINE WINDOW Calc FROM 2,20 TO 22,57    COLOR SCHEME 8 TITLE "[ Calculator ]" SHADOW
DEFINE WINDOW CalcHelp FROM 2,20 TO 22,57 COLOR SCHEME 8 TITLE "[ Calculator Help ]" 



CalcVal   = SPACE(19)
CalcTotal = 0
CalcWork  = 0
Operator  = " "
OldOp     = " "
mcontents = ""

**WSELECT 30
**WUSE Calc TITLE "[ Calculator ]" LEFT
ACTIVATE WINDOW Calc


@  0,0 SAY "       Ŀ    "
@  1,0 SAY "                              "
@  2,0 SAY "           "
@  3,0 SAY " Ŀ  Ŀ Ŀ Ŀ   Ŀ  "
@  4,0 SAY "  F1    7   8   9     +   "
@  5,0 SAY " HELP         "
@  6,0 SAY "   Ŀ Ŀ Ŀ   Ŀ  "
@  7,0 SAY " Ŀ   4   5   6     -   "
@  8,0 SAY "  F2          "
@  9,0 SAY "  MC   Ŀ Ŀ Ŀ   Ŀ  "
@ 10,0 SAY "    1   2   3     *   "
@ 11,0 SAY " Ŀ         "
@ 12,0 SAY "  F3   Ŀ Ŀ Ŀ   Ŀ  "
@ 13,0 SAY "  MS    0   .   =     /   "
@ 14,0 SAY "          "
@ 15,0 SAY " Ŀ Ŀ Ŀ Ŀ Ŀ "
@ 16,0 SAY "  F4   F5   F6   F7   E "
@ 17,0 SAY "  MR   SQ   SR   PI  "
@ 18,0 SAY "     "





@ 1,8 GET CalcVal
CLEAR GETS
CalcEnd = " "
new = .t.
*num = .t.
num = .F.
DO WHILE CalcEnd <> "=" .AND. CalcEnd <> "Esc"

   Calc = 0
   DO WHILE Calc = 0
      Calc = INKEY()
   ENDDO

   DO CASE

      CASE (Calc > 47 .AND. Calc < 58) .OR. Calc = 101 .OR. Calc = 69      && 0 through 9
         IF new
            CalcVal = SPACE(19)          
            new = .f.
            IF Operator = "E"
               CalcWork  = 0
               CalcTotal = 0
               Operator  = " "
               OldOp     = " "
               num = .t.
            ENDIF
         ELSE
             num = .f.
         ENDIF
         IF LEN(LTRIM(CalcVal)) < 19
            CalcVal  = LTRIM(CalcVal) + CHR(Calc)
            CalcWork = VAL(CalcVal)
         ENDIF

      CASE Calc = 46                      && .
         IF new
            CalcVal = SPACE(18) + "0"
            new = .f.
            num = .t.
         ELSE
             num = .f.
         ENDIF
         IF AT(CalcVal,".") = 0 .AND. LEN(LTRIM(CalcVal)) < 19
            CalcVal = LTRIM(CalcVal) + CHR(Calc)
            CalcWork = VAL(CalcVal)
         ENDIF

*      CASE Calc = 75 .OR. Calc = 107      && K or k
*         @ 12,23 SAY " T "
*         temp = " K "
*         @  9,23 GET temp
*         CLEAR GETS

*      CASE Calc = 84 .OR. Calc = 116      && T or t
*         @  9,23 SAY " K "
*         temp = " T "
*         @ 12,23 GET temp
*         CLEAR GETS

      CASE Calc = 67 .OR. Calc = 99       && C or c
         CalcVal   = SPACE(19)
         CalcWork  = 0
         CalcTotal = 0
         OldOp     = " "
         Operator  = " "
         new       = .t.

      CASE Calc = 32                      && Space Bar
         CalcVal = SPACE(19)
         CalcWork  = 0
         new = .t.
         num = .t.

      CASE Calc = 13                      && Enter
         IF Operator <> " "
            DO CASE
               CASE Operator = "*"
*                  @ 4,27 SAY "*"
                  @ 10,31 SAY "*"
                  CalcTotal = CalcTotal * CalcWork
               CASE Operator = "/"
*                  @ 4,21 SAY "/"
                  @ 13,31 SAY "/"
                  IF CalcWork <> 0
                     CalcTotal = CalcTotal / CalcWork
                  ENDIF
               CASE Operator = "+"
*                  @ 7,27 SAY "+"
                  @ 4,31 SAY "+"
                  CalcTotal = CalcTotal + CalcWork
               CASE Operator = "-"
*                  @ 7,21 SAY "-"
                  @ 7,31 SAY "-"
                  CalcTotal = CalcTotal - CalcWork
               CASE Operator = "E"
*                  CalcTotal = CalcWork
            ENDCASE
            IF num
               CalcTotal = CalcWork
            ENDIF
            CalcVal = RTRIM(LTRIM(CalcConv(CalcTotal)))
         ENDIF
         CalcEnd = " "
         OldOp = Operator
         Operator = "E"
         CalcWork = 0
         new = .t.
         num = .f.

      CASE Calc = 61                      && =
         IF Operator <> " "
            DO CASE
               CASE Operator = "*"
                  CalcTotal = CalcTotal * CalcWork
               CASE Operator = "/" .AND. CalcWork <> 0
                  CalcTotal = CalcTotal / CalcWork
               CASE Operator = "+"
                  CalcTotal = CalcTotal + CalcWork
               CASE Operator = "-"
                  CalcTotal = CalcTotal - CalcWork
               CASE Operator = "E"
*                  CalcTotal = CalcWork
            ENDCASE
            IF .NOT. num
               CalcVal = RTRIM(LTRIM(CalcConv(CalcTotal)))
            ELSE
               CalcVal = RTRIM(LTRIM(CalcConv(CalcWork)))
               CalcTotal = CalcWork
            ENDIF
         ENDIF
         CalcEnd = "="
         infield = LTRIM(CalcVal)
         IF LEN(ALLTRIM(infield)) > 0 
           &st = convert(VAL(infield))   && Return value to field St
         ENDIF
         EXIT

      CASE Calc = 42                      && *
         DO CalcProc
         Operator = "*"

      CASE Calc = 43                      && +
         DO CalcProc
         Operator = "+"

      CASE Calc = 45                      && -
         DO CalcProc
         Operator = "-"

      CASE Calc = 47                      && /
         DO CalcProc
         Operator = "/"

      CASE Calc = 27                      && Esc
         CalcEnd = "Esc"
         EXIT

      CASE Calc = 28                      && F1
**         WSELECT 31
**         WUSE CalcHelp TITLE "[ Calculator Help ]" LEFT
         ACTIVATE WINDOW CalcHelp
         @  0,0 SAY"       F1 - This help screen         "
         @  1,0 SAY"       F2 - Clears memory            "
         @  2,0 SAY"       F3 - Stores displayed value   "
         @  3,0 SAY"            to memory                "
         @  4,0 SAY"       F4 - Recalls value stored in  "
         @  5,0 SAY"            memory                   "
         @  6,0 SAY"       F5 - Square displayed value   "
         @  7,0 SAY"       F6 - Square root of displayed "
         @  8,0 SAY"            value                    "
         @  9,0 SAY"       F7 - PI = 3.14159             "
         @  10,0 SAY"        C - Clear Calculator         "
         @  11,0 SAY"        = - End Calculator & return  "
         @  12,0 SAY"            value to data field      "
         @  13,0 SAY"      Esc - Abort Calculator         "
         @  14,0 SAY"    Enter - Complete calculation     "
         @  15,0 SAY"            & remain in calculator   "
         @  16,0 SAY"Space bar - Clear current entry      "
         @  17,0 SAY REPLICATE("",38)
         @  18,0 SAY"     Press any key to exit help      "
         SET CONSOLE OFF
         WAIT
         SET CONSOLE ON
         DEACTIVATE WINDOW CalcHelp
**         WCLOSE 31
**         WSELECT 30

      CASE Calc = -1                      && F2
         mcontents = ""

      CASE Calc = -2                      && F3
         mcontents = CalcVal

      CASE Calc = -3                      && F4
         CalcVal = mcontents
         CalcWork = VAL(mcontents)

      CASE Calc = -4                      && F5
         CalcWork = VAL(CalcVal) * VAL(CalcVal)
         CalcVal = ALLTRIM(CalcConv(CalcWork))
         CalcTotal = CalcWork
         num = .F.
 
      CASE Calc = -5                      && F6
         CalcWork = SQRT(VAL(CalcVal))
         CalcVal = ALLTRIM(CalcConv(CalcWork))
         CalcTotal = CalcWork
         num = .F.
         
      CASE Calc = -6                       && F7   
         CalcWork = 3.14159
         CalcVal = "3.14159"
      
      OTHERWISE
         CalcEnd = " "

   ENDCASE

   DO CASE
      CASE OldOp = "*"
         @ 10,31 SAY "*"
      CASE OldOp = "/"
         @ 13,31 SAY "/"
      CASE OldOp = "+"
         @  4,31 SAY "+"
      CASE OldOp = "-"
         @  7,31 SAY "-"
      OTHERWISE
   ENDCASE

   DO CASE
      CASE OPERATOR = "*"
         @ 10,31 GET OPERATOR
      CASE Operator = "/"
         @ 13,31 GET OPERATOR
      CASE Operator = "+"
         @  4,31 GET OPERATOR
      CASE Operator = "-"
         @  7,31 GET OPERATOR
      OTHERWISE
   ENDCASE

   CalcVal = SPACE(19 - LEN(CalcVal)) + CalcVal
   @ 1,8 GET CalcVal
   CLEAR GETS

ENDDO

**WCLOSE 30
DEACTIVATE WINDOW Calc
RELEASE WINDOW Calc
RELEASE WINDOW CalcHelp
**CALL CURSON

ON KEY LABEL F1 DO helpsys WITH VARREAD(), scenario, model 
ON KEY LABEL F3 DO Calculat WITH SYS(18)
ON KEY LABEL F9 DO previous

********************************** CALCPROC ***********************************
PROCEDURE CalcProc

IF Operator <> " "
   DO CASE
      CASE Operator = "*"
         CalcTotal = CalcTotal * CalcWork
      CASE Operator = "/" .AND. CalcWork <> 0
         CalcTotal = CalcTotal / CalcWork
      CASE Operator = "+"
         CalcTotal = CalcTotal + CalcWork
      CASE Operator = "-"
         CalcTotal = CalcTotal - CalcWork
      CASE Operator = "E"
*        CalcTotal = CalcWork
   ENDCASE
   IF .NOT. num
      CalcVal = RTRIM(LTRIM(CalcConv(CalcTotal)))
   ELSE
      CalcVal = RTRIM(LTRIM(CalcConv(CalcWork)))
      CalcTotal = CalcWork
   ENDIF
ELSE
*   CalcVal = SPACE(19)
   CalcTotal = CalcWork
ENDIF
CalcWork = 0
OldOp = Operator
new = .t.
RETURN

***************************** Calc Convert *********************************
FUNCTION CalcConv
PARAMETER numb
numb = STR(numb,19,10)
IF VAL(numb) = 0
   numb = '0'   
   RETURN numb
ENDIF
IF .NOT. '.'$numb
   RETURN numb
ENDIF
DO WHILE .T.
   IF RIGHT(numb,1) = '0'
      numb = LEFT(numb,LEN(numb)-1)
   ELSE
      IF RIGHT(numb,1) = '.'
         numb = LEFT(numb,LEN(numb)-1)  
      ENDIF
      RETURN numb
   ENDIF
ENDDO
RETURN numb
